/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.bootstrap;

import java.io.IOException;
import java.util.Iterator;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.avro.model.HoodieFileStatus;
import org.apache.hudi.common.model.HoodieAvroIndexedRecord;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.util.AvroOrcUtils;
import org.apache.hudi.common.util.queue.HoodieConsumer;
import org.apache.hudi.common.util.queue.HoodieExecutor;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.io.HoodieBootstrapHandle;
import org.apache.hudi.io.hadoop.OrcReaderIterator;
import org.apache.hudi.keygen.KeyGeneratorInterface;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.bootstrap.BaseBootstrapMetadataHandler;
import org.apache.hudi.table.action.bootstrap.BootstrapRecordConsumer;
import org.apache.hudi.util.ExecutorFactory;
import org.apache.orc.OrcFile;
import org.apache.orc.Reader;
import org.apache.orc.RecordReader;
import org.apache.orc.TypeDescription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OrcBootstrapMetadataHandler
extends BaseBootstrapMetadataHandler {
    private static final Logger LOG = LoggerFactory.getLogger(OrcBootstrapMetadataHandler.class);

    public OrcBootstrapMetadataHandler(HoodieWriteConfig config, HoodieTable table, HoodieFileStatus srcFileStatus) {
        super(config, table, srcFileStatus);
    }

    @Override
    Schema getAvroSchema(StoragePath sourceFilePath) throws IOException {
        Reader orcReader = OrcFile.createReader((Path)new Path(sourceFilePath.toUri()), (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)((Configuration)this.table.getStorageConf().unwrap())));
        TypeDescription orcSchema = orcReader.getSchema();
        return AvroOrcUtils.createAvroSchema((TypeDescription)orcSchema);
    }

    @Override
    void executeBootstrap(HoodieBootstrapHandle<?, ?, ?, ?> bootstrapHandle, StoragePath sourceFilePath, KeyGeneratorInterface keyGenerator, String partitionPath, Schema avroSchema) throws Exception {
        if (this.config.getRecordMerger().getRecordType() == HoodieRecord.HoodieRecordType.SPARK) {
            throw new UnsupportedOperationException();
        }
        Reader orcReader = OrcFile.createReader((Path)new Path(sourceFilePath.toUri()), (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)((Configuration)this.table.getStorageConf().unwrap())));
        TypeDescription orcSchema = AvroOrcUtils.createOrcSchema((Schema)avroSchema);
        HoodieExecutor executor = null;
        RecordReader reader = orcReader.rows(new Reader.Options((Configuration)this.table.getStorageConf().unwrap()).schema(orcSchema));
        try {
            executor = ExecutorFactory.create((HoodieWriteConfig)this.config, (Iterator)new OrcReaderIterator(reader, avroSchema, orcSchema), (HoodieConsumer)new BootstrapRecordConsumer(bootstrapHandle), inp -> {
                String recKey = keyGenerator.getKey(inp).getRecordKey();
                GenericData.Record gr = new GenericData.Record(HoodieBootstrapHandle.METADATA_BOOTSTRAP_RECORD_SCHEMA);
                gr.put(HoodieRecord.RECORD_KEY_METADATA_FIELD, (Object)recKey);
                HoodieAvroIndexedRecord rec = new HoodieAvroIndexedRecord(new HoodieKey(recKey, partitionPath), (IndexedRecord)gr);
                return rec;
            }, (Runnable)this.table.getPreExecuteRunnable());
            executor.execute();
        }
        catch (Exception e) {
            throw new HoodieException((Throwable)e);
        }
        finally {
            if (executor != null) {
                executor.shutdownNow();
                executor.awaitTermination();
            } else {
                reader.close();
                bootstrapHandle.close();
            }
        }
    }
}

