/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.commit;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.index.bucket.BucketIdentifier;
import org.apache.hudi.table.action.commit.BucketInfo;
import org.apache.hudi.table.action.commit.BucketType;
import org.apache.hudi.table.action.commit.SparkBucketInfoGetter;

public abstract class BaseSparkBucketIndexBucketInfoGetter
implements SparkBucketInfoGetter {
    private final Map<String, Set<String>> updatePartitionPathFileIds;
    private final boolean isOverwrite;
    private final boolean isNonBlockingConcurrencyControl;

    public BaseSparkBucketIndexBucketInfoGetter(Map<String, Set<String>> updatePartitionPathFileIds, boolean isOverwrite, boolean isNonBlockingConcurrencyControl) {
        if (isOverwrite) {
            ValidationUtils.checkArgument((!isNonBlockingConcurrencyControl ? 1 : 0) != 0, (String)"Insert overwrite is not supported with non-blocking concurrency control");
        }
        this.updatePartitionPathFileIds = updatePartitionPathFileIds;
        this.isOverwrite = isOverwrite;
        this.isNonBlockingConcurrencyControl = isNonBlockingConcurrencyControl;
    }

    protected BucketInfo getBucketInfo(int bucketId, String partitionPath) {
        String bucketIdStr = BucketIdentifier.bucketIdStr((int)bucketId);
        if (this.isOverwrite) {
            return new BucketInfo(BucketType.INSERT, BucketIdentifier.newBucketFileIdPrefix((String)bucketIdStr), partitionPath);
        }
        Option fileIdOption = Option.fromJavaOptional(this.updatePartitionPathFileIds.getOrDefault(partitionPath, Collections.emptySet()).stream().filter(e -> e.startsWith(bucketIdStr)).findFirst());
        if (fileIdOption.isPresent()) {
            return new BucketInfo(BucketType.UPDATE, (String)fileIdOption.get(), partitionPath);
        }
        if (this.isNonBlockingConcurrencyControl) {
            return new BucketInfo(BucketType.UPDATE, BucketIdentifier.newBucketFileIdForNBCC((String)bucketIdStr), partitionPath);
        }
        return new BucketInfo(BucketType.INSERT, BucketIdentifier.newBucketFileIdPrefix((String)bucketIdStr), partitionPath);
    }
}

