/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.commit;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieIndexConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.index.bucket.BucketIdentifier;
import org.apache.hudi.index.bucket.partition.NumBucketsFunction;
import org.apache.hudi.io.storage.row.HoodieRowCreateHandle;
import org.apache.hudi.keygen.BuiltinKeyGenerator;
import org.apache.hudi.keygen.constant.KeyGeneratorOptions;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.commit.BulkInsertDataInternalWriterHelper;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.unsafe.types.UTF8String;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BucketBulkInsertDataInternalWriterHelper
extends BulkInsertDataInternalWriterHelper {
    private static final Logger LOG = LoggerFactory.getLogger(BucketBulkInsertDataInternalWriterHelper.class);
    private Pair<UTF8String, Integer> lastFileId;
    private final Map<Pair<UTF8String, Integer>, HoodieRowCreateHandle> handles;
    protected final String indexKeyFields;
    protected final int bucketNum;
    private final boolean isNonBlockingConcurrencyControl;
    private final NumBucketsFunction numBucketsFunction;

    public BucketBulkInsertDataInternalWriterHelper(HoodieTable hoodieTable, HoodieWriteConfig writeConfig, String instantTime, int taskPartitionId, long taskId, long taskEpochId, StructType structType, boolean populateMetaFields, boolean arePartitionRecordsSorted) {
        this(hoodieTable, writeConfig, instantTime, taskPartitionId, taskId, taskEpochId, structType, populateMetaFields, arePartitionRecordsSorted, false);
    }

    public BucketBulkInsertDataInternalWriterHelper(HoodieTable hoodieTable, HoodieWriteConfig writeConfig, String instantTime, int taskPartitionId, long taskId, long taskEpochId, StructType structType, boolean populateMetaFields, boolean arePartitionRecordsSorted, boolean shouldPreserveHoodieMetadata) {
        super(hoodieTable, writeConfig, instantTime, taskPartitionId, taskId, taskEpochId, structType, populateMetaFields, arePartitionRecordsSorted, shouldPreserveHoodieMetadata);
        this.indexKeyFields = writeConfig.getStringOrDefault(HoodieIndexConfig.BUCKET_INDEX_HASH_FIELD, writeConfig.getString(KeyGeneratorOptions.RECORDKEY_FIELD_NAME.key()));
        this.bucketNum = writeConfig.getInt(HoodieIndexConfig.BUCKET_INDEX_NUM_BUCKETS);
        this.handles = new HashMap<Pair<UTF8String, Integer>, HoodieRowCreateHandle>();
        this.isNonBlockingConcurrencyControl = writeConfig.isNonBlockingConcurrencyControl();
        this.numBucketsFunction = NumBucketsFunction.fromWriteConfig((HoodieWriteConfig)writeConfig);
    }

    @Override
    public void write(InternalRow row) throws IOException {
        try {
            UTF8String partitionPath = this.extractPartitionPath(row);
            UTF8String recordKey = this.extractRecordKey(row);
            int bucketId = BucketIdentifier.getBucketId((String)String.valueOf(recordKey), (String)this.indexKeyFields, (int)this.numBucketsFunction.getNumBuckets(partitionPath.toString()));
            if (this.lastFileId == null || !Objects.equals(this.lastFileId.getKey(), partitionPath) || !Objects.equals(this.lastFileId.getValue(), bucketId)) {
                Pair fileId = Pair.of((Object)partitionPath.clone(), (Object)bucketId);
                this.handle = this.getBucketRowCreateHandle((Pair<UTF8String, Integer>)fileId, bucketId);
                this.lastFileId = fileId;
            }
            this.handle.write(row);
        }
        catch (Throwable t) {
            LOG.error("Global error thrown while trying to write records in HoodieRowCreateHandle ", t);
            throw new IOException(t);
        }
    }

    protected UTF8String extractRecordKey(InternalRow row) {
        if (this.populateMetaFields) {
            return row.getUTF8String(HoodieRecord.RECORD_KEY_META_FIELD_ORD);
        }
        if (this.keyGeneratorOpt.isPresent()) {
            return ((BuiltinKeyGenerator)this.keyGeneratorOpt.get()).getRecordKey(row, this.structType);
        }
        return UTF8String.EMPTY_UTF8;
    }

    protected HoodieRowCreateHandle getBucketRowCreateHandle(Pair<UTF8String, Integer> fileId, int bucketId) throws Exception {
        if (!this.handles.containsKey(fileId)) {
            if (this.arePartitionRecordsSorted.booleanValue()) {
                this.close();
            }
            String partitionPath = String.valueOf(fileId.getLeft());
            LOG.info("Creating new file for partition path {}", (Object)partitionPath);
            HoodieRowCreateHandle rowCreateHandle = new HoodieRowCreateHandle(this.hoodieTable, this.writeConfig, partitionPath, this.getNextBucketFileId(bucketId), this.instantTime, this.taskPartitionId, this.taskId, this.taskEpochId, this.structType, this.shouldPreserveHoodieMetadata);
            this.handles.put(fileId, rowCreateHandle);
        }
        return this.handles.get(fileId);
    }

    @Override
    public void close() throws IOException {
        for (HoodieRowCreateHandle handle : this.handles.values()) {
            LOG.info("Closing bulk insert file {}", (Object)handle.getFileName());
            this.writeStatusList.add(handle.close());
        }
        this.handles.clear();
        this.handle = null;
    }

    protected String getNextBucketFileId(int bucketInt) {
        return BucketIdentifier.newBucketFileIdPrefix((int)bucketInt, (boolean)this.isNonBlockingConcurrencyControl);
    }
}

