/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.commit;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.hudi.client.common.HoodieSparkEngineContext;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.model.HoodieFileGroupId;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.WorkloadProfile;
import org.apache.hudi.table.WorkloadStat;
import org.apache.hudi.table.action.commit.BucketInfo;
import org.apache.hudi.table.action.commit.BucketType;
import org.apache.hudi.table.action.commit.SparkMetadataTableUpsertPartitioner;
import org.apache.hudi.table.action.deltacommit.SparkUpsertPreppedDeltaCommitActionExecutor;
import org.apache.spark.Partitioner;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.storage.StorageLevel;

public class SparkMetadataTableFirstDeltaCommitActionExecutor<T>
extends SparkUpsertPreppedDeltaCommitActionExecutor<T> {
    private static final WorkloadStat PLACEHOLDER_GLOBAL_STAT = new WorkloadStat();
    private final List<HoodieFileGroupId> mdtFileGroupIdList;

    public SparkMetadataTableFirstDeltaCommitActionExecutor(HoodieSparkEngineContext context, HoodieWriteConfig config, HoodieTable table, String instantTime, HoodieData<HoodieRecord<T>> preppedRecords, List<HoodieFileGroupId> mdtFileGroupIdList) {
        super(context, config, table, instantTime, preppedRecords);
        this.mdtFileGroupIdList = mdtFileGroupIdList;
    }

    @Override
    protected boolean shouldPersistInputRecords(JavaRDD<HoodieRecord<T>> inputRDD) {
        return inputRDD.getStorageLevel() == StorageLevel.NONE();
    }

    @Override
    protected WorkloadProfile prepareWorkloadProfile(HoodieData<HoodieRecord<T>> inputRecordsWithClusteringUpdate) {
        WorkloadProfile workloadProfile = new WorkloadProfile(Pair.of(Collections.emptyMap(), (Object)PLACEHOLDER_GLOBAL_STAT));
        return workloadProfile;
    }

    @Override
    protected Partitioner getPartitioner(WorkloadProfile profile) {
        ArrayList<BucketInfo> bucketInfoList = new ArrayList<BucketInfo>();
        HashMap<String, Integer> fileIdToSparkPartitionIndexMap = new HashMap<String, Integer>();
        for (int counter = 0; counter < this.mdtFileGroupIdList.size(); ++counter) {
            HoodieFileGroupId fileGroupId = this.mdtFileGroupIdList.get(counter);
            fileIdToSparkPartitionIndexMap.put(fileGroupId.getFileId(), counter);
            bucketInfoList.add(new BucketInfo(BucketType.UPDATE, fileGroupId.getFileId(), fileGroupId.getPartitionPath()));
        }
        return new SparkMetadataTableUpsertPartitioner(bucketInfoList, fileIdToSparkPartitionIndexMap);
    }

    @Override
    protected HoodieData<HoodieRecord<T>> clusteringHandleUpdate(HoodieData<HoodieRecord<T>> inputRecords) {
        return inputRecords;
    }
}

