/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.commit;

import java.util.List;
import java.util.Map;
import org.apache.hudi.common.model.HoodieRecordLocation;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.table.action.commit.BucketInfo;
import org.apache.hudi.table.action.commit.ListBasedSparkBucketInfoGetter;
import org.apache.hudi.table.action.commit.SparkBucketInfoGetter;
import org.apache.hudi.table.action.commit.SparkHoodiePartitioner;
import scala.Tuple2;

public class SparkMetadataTableUpsertPartitioner<T>
extends SparkHoodiePartitioner<T> {
    private final List<BucketInfo> bucketInfoList;
    private final int totalPartitions;
    private final Map<String, Integer> fileIdToSparkPartitionIndexMap;

    public SparkMetadataTableUpsertPartitioner(List<BucketInfo> bucketInfoList, Map<String, Integer> fileIdToSparkPartitionIndexMap) {
        super(null, null);
        this.bucketInfoList = bucketInfoList;
        this.totalPartitions = bucketInfoList.size();
        this.fileIdToSparkPartitionIndexMap = fileIdToSparkPartitionIndexMap;
    }

    public int numPartitions() {
        return this.totalPartitions;
    }

    public int getPartition(Object key) {
        Tuple2 keyLocation = (Tuple2)key;
        HoodieRecordLocation location = (HoodieRecordLocation)((Option)keyLocation._2()).get();
        return this.fileIdToSparkPartitionIndexMap.get(location.getFileId());
    }

    @Override
    public SparkBucketInfoGetter getSparkBucketInfoGetter() {
        return new ListBasedSparkBucketInfoGetter(this.bucketInfoList);
    }
}

