/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.commit;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecordLocation;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.index.bucket.BucketIdentifier;
import org.apache.hudi.index.bucket.HoodieBucketIndex;
import org.apache.hudi.index.bucket.partition.NumBucketsFunction;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.WorkloadProfile;
import org.apache.hudi.table.WorkloadStat;
import org.apache.hudi.table.action.commit.SparkBucketInfoGetter;
import org.apache.hudi.table.action.commit.SparkHoodiePartitioner;
import org.apache.hudi.table.action.commit.SparkPartitionBucketIndexBucketInfoGetter;
import scala.Tuple2;

public class SparkPartitionBucketIndexPartitioner<T>
extends SparkHoodiePartitioner<T> {
    private final int totalPartitions;
    private final NumBucketsFunction numBucketsFunction;
    private final String indexKeyField;
    private final int totalPartitionPaths;
    private final List<String> partitionPaths;
    private final Map<String, Integer> partitionPathOffset;
    private final boolean isOverwrite;
    private Map<String, Set<String>> updatePartitionPathFileIds;
    private final boolean isNonBlockingConcurrencyControl;
    private final String[] partitionNumberToPath;
    private final Integer[] partitionNumberToLocalBucketId;

    public SparkPartitionBucketIndexPartitioner(WorkloadProfile profile, HoodieEngineContext context, HoodieTable table, HoodieWriteConfig config) {
        super(profile, table);
        if (!(table.getIndex() instanceof HoodieBucketIndex)) {
            throw new HoodieException(" Bucket index partitioner should only be used by BucketIndex other than " + table.getIndex().getClass().getSimpleName());
        }
        HoodieWriteConfig writeConfig = table.getConfig();
        this.numBucketsFunction = NumBucketsFunction.fromWriteConfig((HoodieWriteConfig)writeConfig);
        this.indexKeyField = config.getBucketIndexHashField();
        this.totalPartitionPaths = profile.getPartitionPaths().size();
        this.partitionPaths = new ArrayList<String>(profile.getPartitionPaths());
        this.partitionPathOffset = new HashMap<String, Integer>();
        int i = 0;
        for (Object partitionPath : profile.getPartitionPaths()) {
            this.partitionPathOffset.put(partitionPath.toString(), i);
            i += this.numBucketsFunction.getNumBuckets(partitionPath.toString());
        }
        this.totalPartitions = i;
        this.assignUpdates(profile);
        WriteOperationType operationType = profile.getOperationType();
        this.isOverwrite = WriteOperationType.INSERT_OVERWRITE.equals((Object)operationType) || WriteOperationType.INSERT_OVERWRITE_TABLE.equals((Object)operationType);
        this.isNonBlockingConcurrencyControl = config.isNonBlockingConcurrencyControl();
        this.partitionNumberToPath = new String[this.totalPartitions];
        this.partitionNumberToLocalBucketId = new Integer[this.totalPartitions];
        for (String partitionPath : this.partitionPaths) {
            int offset = this.partitionPathOffset.get(partitionPath);
            int numBuckets = this.numBucketsFunction.getNumBuckets(partitionPath);
            for (int j = 0; j < numBuckets; ++j) {
                int partitionNumber = offset + j;
                this.partitionNumberToPath[partitionNumber] = partitionPath;
                this.partitionNumberToLocalBucketId[partitionNumber] = j;
            }
        }
    }

    private void assignUpdates(WorkloadProfile profile) {
        this.updatePartitionPathFileIds = new HashMap<String, Set<String>>();
        Set partitionStatEntries = profile.getInputPartitionPathStatMap().entrySet();
        for (Map.Entry partitionStat : partitionStatEntries) {
            if (!this.updatePartitionPathFileIds.containsKey(partitionStat.getKey())) {
                this.updatePartitionPathFileIds.put((String)partitionStat.getKey(), new HashSet());
            }
            for (Map.Entry updateLocEntry : ((WorkloadStat)partitionStat.getValue()).getUpdateLocationToCount().entrySet()) {
                this.updatePartitionPathFileIds.get(partitionStat.getKey()).add((String)updateLocEntry.getKey());
            }
        }
    }

    @Override
    public SparkBucketInfoGetter getSparkBucketInfoGetter() {
        return new SparkPartitionBucketIndexBucketInfoGetter(this.partitionNumberToLocalBucketId, this.partitionNumberToPath, this.updatePartitionPathFileIds, this.isOverwrite, this.isNonBlockingConcurrencyControl);
    }

    public int numPartitions() {
        return this.totalPartitions;
    }

    public int getPartition(Object key) {
        Tuple2 keyLocation = (Tuple2)key;
        String partitionPath = ((HoodieKey)keyLocation._1).getPartitionPath();
        Option location = (Option)keyLocation._2;
        int bucketId = location.isPresent() ? BucketIdentifier.bucketIdFromFileId((String)((HoodieRecordLocation)location.get()).getFileId()) : BucketIdentifier.getBucketId((String)((HoodieKey)keyLocation._1).getRecordKey(), (String)this.indexKeyField, (int)this.numBucketsFunction.getNumBuckets(partitionPath));
        return this.partitionPathOffset.get(partitionPath) + bucketId;
    }
}

