/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.deltacommit;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.hudi.client.common.HoodieSparkEngineContext;
import org.apache.hudi.common.model.FileSlice;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.model.HoodieRecordLocation;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.WorkloadProfile;
import org.apache.hudi.table.action.commit.SmallFile;
import org.apache.hudi.table.action.commit.UpsertPartitioner;

public class SparkUpsertDeltaCommitPartitioner<T>
extends UpsertPartitioner<T> {
    public SparkUpsertDeltaCommitPartitioner(WorkloadProfile profile, HoodieSparkEngineContext context, HoodieTable table, HoodieWriteConfig config, WriteOperationType operationType) {
        super(profile, context, table, config, operationType);
    }

    @Override
    protected List<SmallFile> getSmallFiles(String partitionPath) {
        HoodieTimeline commitTimeline = this.table.getCompletedCommitsTimeline();
        if (commitTimeline.empty()) {
            return Collections.emptyList();
        }
        HoodieInstant latestCommitTime = (HoodieInstant)commitTimeline.lastInstant().get();
        List<FileSlice> smallFileSlicesCandidates = this.getSmallFileCandidates(partitionPath, latestCommitTime);
        ArrayList<SmallFile> smallFileLocations = new ArrayList<SmallFile>();
        for (FileSlice smallFileSlice : smallFileSlicesCandidates) {
            SmallFile sf = new SmallFile();
            if (smallFileSlice.getBaseFile().isPresent()) {
                HoodieBaseFile baseFile = (HoodieBaseFile)smallFileSlice.getBaseFile().get();
                sf.location = new HoodieRecordLocation(baseFile.getCommitTime(), baseFile.getFileId());
                sf.sizeBytes = smallFileSlice.getTotalFileSizeAsParquetFormat(this.config.getLogFileToParquetCompressionRatio());
                smallFileLocations.add(sf);
                continue;
            }
            HoodieLogFile logFile = (HoodieLogFile)smallFileSlice.getLogFiles().findFirst().get();
            sf.location = new HoodieRecordLocation(logFile.getDeltaCommitTime(), logFile.getFileId());
            sf.sizeBytes = smallFileSlice.getTotalFileSizeAsParquetFormat(this.config.getLogFileToParquetCompressionRatio());
            smallFileLocations.add(sf);
        }
        return smallFileLocations;
    }

    @Nonnull
    private List<FileSlice> getSmallFileCandidates(String partitionPath, HoodieInstant latestCommitInstant) {
        if (this.table.getIndex().canIndexLogFiles()) {
            return this.table.getSliceView().getLatestFileSlicesBeforeOrOn(partitionPath, latestCommitInstant.requestedTime(), false).filter(this::isSmallFile).collect(Collectors.toList());
        }
        if (this.config.getParquetSmallFileLimit() <= 0) {
            return Collections.emptyList();
        }
        return this.table.getSliceView().getLatestFileSlicesBeforeOrOn(partitionPath, latestCommitInstant.requestedTime(), false).filter(fileSlice -> fileSlice.getLogFiles().count() < 1L && ((HoodieBaseFile)fileSlice.getBaseFile().get()).getFileSize() < (long)this.config.getParquetSmallFileLimit()).sorted(Comparator.comparing(fileSlice -> ((HoodieBaseFile)fileSlice.getBaseFile().get()).getFileSize())).limit(this.config.getSmallFileGroupCandidatesLimit()).collect(Collectors.toList());
    }

    public List<String> getSmallFileIds() {
        return this.smallFiles.stream().map(smallFile -> smallFile.location.getFileId()).collect(Collectors.toList());
    }

    private boolean isSmallFile(FileSlice fileSlice) {
        long totalSize = fileSlice.getTotalFileSizeAsParquetFormat(this.config.getLogFileToParquetCompressionRatio());
        return totalSize < this.config.getParquetMaxFileSize();
    }
}

