/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.util;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.avro.LogicalType;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.hudi.AvroConversionUtils;
import org.apache.hudi.SparkAdapterSupport$;
import org.apache.hudi.avro.AvroSchemaUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.ArrayComparable;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.TimestampType;
import org.apache.spark.unsafe.types.UTF8String;

public class OrderingValueEngineTypeConverter {
    private final List<Function<Comparable, Comparable>> converters;

    private OrderingValueEngineTypeConverter(Schema dataSchema, List<String> orderingFieldNames) {
        this.converters = OrderingValueEngineTypeConverter.createConverters(dataSchema, orderingFieldNames);
    }

    public Comparable convert(Comparable value) {
        return value instanceof ArrayComparable ? ((ArrayComparable)value).apply(this.converters) : this.converters.get(0).apply(value);
    }

    public static OrderingValueEngineTypeConverter create(Schema dataSchema, List<String> orderingFieldNames) {
        return new OrderingValueEngineTypeConverter(dataSchema, orderingFieldNames);
    }

    private static List<Function<Comparable, Comparable>> createConverters(Schema dataSchema, List<String> orderingFieldNames) {
        if (orderingFieldNames.isEmpty()) {
            return Collections.singletonList(Function.identity());
        }
        return orderingFieldNames.stream().map(f -> {
            Option fieldSchemaOpt = AvroSchemaUtils.findNestedFieldSchema((Schema)dataSchema, (String)f, (boolean)true);
            if (fieldSchemaOpt.isEmpty()) {
                return Function.identity();
            }
            DataType fieldType = AvroConversionUtils.convertAvroSchemaToDataType((Schema)fieldSchemaOpt.get());
            return OrderingValueEngineTypeConverter.createConverter(fieldType, (Schema)fieldSchemaOpt.get());
        }).collect(Collectors.toList());
    }

    public static Function<Comparable, Comparable> createConverter(DataType fieldType, Schema fieldSchema) {
        if (fieldType instanceof TimestampType) {
            LogicalType logicalType = fieldSchema.getLogicalType();
            if (logicalType == null || logicalType instanceof LogicalTypes.TimestampMillis) {
                return comparable -> Long.valueOf(OrderingValueEngineTypeConverter.formatAsMicros((Long)comparable));
            }
        } else {
            if (fieldType instanceof StringType) {
                return comparable -> comparable instanceof String ? SparkAdapterSupport$.MODULE$.sparkAdapter().getUTF8StringFactory().wrapUTF8String(UTF8String.fromString((String)((String)((Object)comparable)))) : comparable;
            }
            if (fieldType instanceof DecimalType) {
                return comparable -> comparable instanceof BigDecimal ? Decimal.apply((BigDecimal)((BigDecimal)comparable)) : comparable;
            }
        }
        return comparable -> comparable;
    }

    private static long formatAsMicros(long value) {
        if (value <= 9999999999999L) {
            return value * 1000L;
        }
        return value;
    }
}

