/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql;

import java.io.Serializable;
import org.apache.hudi.SparkAdapterSupport;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.table.view.FileSystemViewStorageConfig;
import org.apache.hudi.common.util.Functions;
import org.apache.hudi.common.util.RemotePartitionHelper;
import org.apache.hudi.common.util.hash.BucketIndexUtil;
import org.apache.hudi.index.bucket.BucketIdentifier;
import org.apache.hudi.index.bucket.partition.NumBucketsFunction;
import org.apache.spark.Partitioner;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.hudi.SparkAdapter;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class BucketPartitionUtils$
implements SparkAdapterSupport {
    public static BucketPartitionUtils$ MODULE$;
    private SparkAdapter sparkAdapter;
    private volatile boolean bitmap$0;

    static {
        new BucketPartitionUtils$();
    }

    private SparkAdapter sparkAdapter$lzycompute() {
        BucketPartitionUtils$ bucketPartitionUtils$ = this;
        synchronized (bucketPartitionUtils$) {
            if (!this.bitmap$0) {
                this.sparkAdapter = SparkAdapterSupport.sparkAdapter$(this);
                this.bitmap$0 = true;
            }
        }
        return this.sparkAdapter;
    }

    @Override
    public SparkAdapter sparkAdapter() {
        if (!this.bitmap$0) {
            return this.sparkAdapter$lzycompute();
        }
        return this.sparkAdapter;
    }

    public Dataset<Row> createDataFrame(Dataset<Row> df, String indexKeyFields, NumBucketsFunction numBucketsFunction, Partitioner partitioner) {
        Function1 getPartitionKey = BucketPartitionUtils$.getPartitionKeyExtractor$1(indexKeyFields, numBucketsFunction);
        RDD reRdd = RDD$.MODULE$.rddToPairRDDFunctions(RDD$.MODULE$.rddToOrderedRDDFunctions(df.queryExecution().toRdd().keyBy((Function1 & Serializable & scala.Serializable)row -> (Tuple2)getPartitionKey.apply(row)), Ordering$.MODULE$.Tuple2((Ordering)Ordering.String$.MODULE$, (Ordering)Ordering.Int$.MODULE$), ClassTag$.MODULE$.apply(Tuple2.class), ClassTag$.MODULE$.apply(InternalRow.class)).repartitionAndSortWithinPartitions(partitioner), ClassTag$.MODULE$.apply(Tuple2.class), ClassTag$.MODULE$.apply(InternalRow.class), Ordering$.MODULE$.Tuple2((Ordering)Ordering.String$.MODULE$, (Ordering)Ordering.Int$.MODULE$)).values();
        return this.sparkAdapter().internalCreateDataFrame(df.sparkSession(), (RDD<InternalRow>)reRdd, df.schema(), this.sparkAdapter().internalCreateDataFrame$default$4());
    }

    public Partitioner getRemotePartitioner(FileSystemViewStorageConfig viewConf, NumBucketsFunction numBucketsFunction, int partitionNum) {
        return new Partitioner(viewConf, partitionNum, numBucketsFunction){
            private final RemotePartitionHelper helper;
            private final int partitionNum$1;
            private final NumBucketsFunction numBucketsFunction$2;

            private RemotePartitionHelper helper() {
                return this.helper;
            }

            public int numPartitions() {
                return this.partitionNum$1;
            }

            public int getPartition(Object value) {
                Tuple2 partitionKeyPair = (Tuple2)value;
                return this.helper().getPartition(this.numBucketsFunction$2.getNumBuckets((String)partitionKeyPair._1()), (String)partitionKeyPair._1(), partitionKeyPair._2$mcI$sp(), this.partitionNum$1);
            }
            {
                this.partitionNum$1 = partitionNum$1;
                this.numBucketsFunction$2 = numBucketsFunction$2;
                this.helper = new RemotePartitionHelper(viewConf$1);
            }
        };
    }

    public Partitioner getLocalePartitioner(NumBucketsFunction numBucketsFunction, int partitionNum) {
        return new Partitioner(partitionNum, numBucketsFunction){
            private final Functions.Function3<Integer, String, Integer, Integer> partitionIndexFunc;
            private final int partitionNum$2;
            private final NumBucketsFunction numBucketsFunction$3;

            private Functions.Function3<Integer, String, Integer, Integer> partitionIndexFunc() {
                return this.partitionIndexFunc;
            }

            public int numPartitions() {
                return this.partitionNum$2;
            }

            public int getPartition(Object value) {
                Tuple2 partitionKeyPair = (Tuple2)value;
                return Predef$.MODULE$.Integer2int((Integer)this.partitionIndexFunc().apply((Object)Predef$.MODULE$.int2Integer(this.numBucketsFunction$3.getNumBuckets((String)partitionKeyPair._1())), partitionKeyPair._1(), (Object)Predef$.MODULE$.int2Integer(partitionKeyPair._2$mcI$sp())));
            }
            {
                this.partitionNum$2 = partitionNum$2;
                this.numBucketsFunction$3 = numBucketsFunction$3;
                this.partitionIndexFunc = BucketIndexUtil.getPartitionIndexFunc((int)partitionNum$2);
            }
        };
    }

    private static final Function1 getPartitionKeyExtractor$1(String indexKeyFields$1, NumBucketsFunction numBucketsFunction$1) {
        return (Function1 & Serializable & scala.Serializable)row -> {
            String partition = row.getString(HoodieRecord.PARTITION_PATH_META_FIELD_ORD);
            int kb = BucketIdentifier.getBucketId((String)row.getString(HoodieRecord.RECORD_KEY_META_FIELD_ORD), (String)indexKeyFields$1, (int)numBucketsFunction$1.getNumBuckets(partition));
            if (partition == null || partition.trim().isEmpty()) {
                return new Tuple2((Object)"", (Object)BoxesRunTime.boxToInteger((int)kb));
            }
            return new Tuple2((Object)partition, (Object)BoxesRunTime.boxToInteger((int)kb));
        };
    }

    private BucketPartitionUtils$() {
        MODULE$ = this;
        SparkAdapterSupport.$init$(this);
    }
}

