/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql;

import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Date;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.avro.Schema;
import org.apache.hudi.AvroConversionUtils$;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.exception.HoodieException;
import org.apache.spark.sql.HoodieCatalystExpressionUtils$;
import org.apache.spark.sql.HoodieInternalRowUtils;
import org.apache.spark.sql.HoodieUnsafeRowUtils;
import org.apache.spark.sql.HoodieUnsafeRowUtils$;
import org.apache.spark.sql.catalyst.CatalystTypeConverters$;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.SpecializedGetters;
import org.apache.spark.sql.catalyst.expressions.SpecificInternalRow;
import org.apache.spark.sql.catalyst.expressions.UnsafeArrayData;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection$;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.catalyst.util.ArrayBasedMapData;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.catalyst.util.MapData;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.ShortType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashMap;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.StructuralCallSite;

public final class HoodieInternalRowUtils$ {
    public static HoodieInternalRowUtils$ MODULE$;
    private final ThreadLocal<HashMap<Tuple4<StructType, StructType, Map<String, String>, Map<Integer, Object>>, Function1<InternalRow, UnsafeRow>>> unsafeWriterThreadLocal;
    private final ThreadLocal<HashMap<Tuple2<StructType, StructType>, UnsafeProjection>> unsafeProjectionThreadLocal;
    private final ThreadLocal<HashMap<Schema, UnsafeProjection>> identicalUnsafeProjectionThreadLocal;
    private final ConcurrentHashMap<Schema, StructType> schemaMap;
    private final ConcurrentHashMap<Tuple2<StructType, String>, Option<HoodieUnsafeRowUtils.NestedFieldPath>> orderPosListMap;

    static {
        new HoodieInternalRowUtils$();
    }

    public static Method reflMethod$Method1(Class x$1) {
        CallSite methodCache1 = StructuralCallSite.bootstrap("apply", ()Ljava/lang/Object;);
        Method method1 = methodCache1.find(x$1);
        if (method1 != null) {
            return method1;
        }
        method1 = ScalaRunTime$.MODULE$.ensureAccessible(x$1.getMethod("value", methodCache1.parameterTypes()));
        methodCache1.add(x$1, method1);
        return method1;
    }

    public static Method reflMethod$Method2(Class x$1) {
        CallSite methodCache2 = StructuralCallSite.bootstrap("apply", ()Ljava/lang/Object;);
        Method method2 = methodCache2.find(x$1);
        if (method2 != null) {
            return method2;
        }
        method2 = ScalaRunTime$.MODULE$.ensureAccessible(x$1.getMethod("value", methodCache2.parameterTypes()));
        methodCache2.add(x$1, method2);
        return method2;
    }

    public static Method reflMethod$Method3(Class x$1) {
        CallSite methodCache3 = StructuralCallSite.bootstrap("apply", ()Ljava/lang/Object;);
        Method method3 = methodCache3.find(x$1);
        if (method3 != null) {
            return method3;
        }
        method3 = ScalaRunTime$.MODULE$.ensureAccessible(x$1.getMethod("value", methodCache3.parameterTypes()));
        methodCache3.add(x$1, method3);
        return method3;
    }

    private ThreadLocal<HashMap<Tuple4<StructType, StructType, Map<String, String>, Map<Integer, Object>>, Function1<InternalRow, UnsafeRow>>> unsafeWriterThreadLocal() {
        return this.unsafeWriterThreadLocal;
    }

    private ThreadLocal<HashMap<Tuple2<StructType, StructType>, UnsafeProjection>> unsafeProjectionThreadLocal() {
        return this.unsafeProjectionThreadLocal;
    }

    private ThreadLocal<HashMap<Schema, UnsafeProjection>> identicalUnsafeProjectionThreadLocal() {
        return this.identicalUnsafeProjectionThreadLocal;
    }

    private ConcurrentHashMap<Schema, StructType> schemaMap() {
        return this.schemaMap;
    }

    private ConcurrentHashMap<Tuple2<StructType, String>, Option<HoodieUnsafeRowUtils.NestedFieldPath>> orderPosListMap() {
        return this.orderPosListMap;
    }

    public UnsafeProjection getCachedUnsafeProjection(StructType from, StructType to) {
        return (UnsafeProjection)this.unsafeProjectionThreadLocal().get().getOrElseUpdate((Object)new Tuple2((Object)from, (Object)to), (Function0 & Serializable & scala.Serializable)() -> HoodieCatalystExpressionUtils$.MODULE$.generateUnsafeProjection(from, to));
    }

    public UnsafeProjection getCachedUnsafeProjection(Schema schema) {
        return (UnsafeProjection)this.identicalUnsafeProjectionThreadLocal().get().getOrElseUpdate((Object)schema, (Function0 & Serializable & scala.Serializable)() -> UnsafeProjection$.MODULE$.create(MODULE$.getCachedSchema(schema)));
    }

    public Function1<InternalRow, UnsafeRow> getCachedUnsafeRowWriter(StructType from, StructType to, Map<String, String> renamedColumnsMap, Map<Integer, Object> updatedValuesMap) {
        return (Function1)this.unsafeWriterThreadLocal().get().getOrElseUpdate((Object)new Tuple4((Object)from, (Object)to, renamedColumnsMap, updatedValuesMap), (Function0 & Serializable & scala.Serializable)() -> MODULE$.genUnsafeRowWriter(from, to, renamedColumnsMap, updatedValuesMap));
    }

    public Map<String, String> getCachedUnsafeRowWriter$default$3() {
        return Collections.emptyMap();
    }

    public Map<Integer, Object> getCachedUnsafeRowWriter$default$4() {
        return Collections.emptyMap();
    }

    public Option<HoodieUnsafeRowUtils.NestedFieldPath> getCachedPosList(StructType structType, String field) {
        Option<HoodieUnsafeRowUtils.NestedFieldPath> nestedFieldPathOpt = this.orderPosListMap().get(new Tuple2((Object)structType, (Object)field));
        if (nestedFieldPathOpt != null) {
            return nestedFieldPathOpt;
        }
        return this.orderPosListMap().computeIfAbsent((Tuple2<StructType, String>)new Tuple2((Object)structType, (Object)field), new Function<Tuple2<StructType, String>, Option<HoodieUnsafeRowUtils.NestedFieldPath>>(structType, field){
            private final StructType structType$1;
            private final String field$1;

            public <V> Function<V, Option<HoodieUnsafeRowUtils.NestedFieldPath>> compose(Function<? super V, ? extends Tuple2<StructType, String>> x$1) {
                return Function.super.compose(x$1);
            }

            public <V> Function<Tuple2<StructType, String>, V> andThen(Function<? super Option<HoodieUnsafeRowUtils.NestedFieldPath>, ? extends V> x$1) {
                return Function.super.andThen(x$1);
            }

            public Option<HoodieUnsafeRowUtils.NestedFieldPath> apply(Tuple2<StructType, String> t) {
                return HoodieUnsafeRowUtils$.MODULE$.composeNestedFieldPath(this.structType$1, this.field$1);
            }
            {
                this.structType$1 = structType$1;
                this.field$1 = field$1;
            }
        });
    }

    public StructType getCachedSchema(Schema schema) {
        StructType structType = this.schemaMap().get(schema);
        if (structType != null) {
            return structType;
        }
        return this.schemaMap().computeIfAbsent(schema, new Function<Schema, StructType>(schema){
            private final Schema schema$2;

            public <V> Function<V, StructType> compose(Function<? super V, ? extends Schema> x$1) {
                return Function.super.compose(x$1);
            }

            public <V> Function<Schema, V> andThen(Function<? super StructType, ? extends V> x$1) {
                return Function.super.andThen(x$1);
            }

            public StructType apply(Schema t) {
                return AvroConversionUtils$.MODULE$.convertAvroSchemaToStructType(this.schema$2);
            }
            {
                this.schema$2 = schema$2;
            }
        });
    }

    public Function1<InternalRow, UnsafeRow> genUnsafeRowWriter(StructType prevSchema, StructType newSchema, Map<String, String> renamedColumnsMap, Map<Integer, Object> updatedValuesMap) {
        UnsafeProjection unsafeProjection = HoodieCatalystExpressionUtils$.MODULE$.generateUnsafeProjection(newSchema, newSchema);
        if (prevSchema.equals((Object)newSchema) && renamedColumnsMap.isEmpty() && updatedValuesMap.isEmpty()) {
            return (Function1 & Serializable & scala.Serializable)oldRow -> unsafeProjection.apply(oldRow);
        }
        Function3<HoodieInternalRowUtils.CatalystDataUpdater, Object, Object, BoxedUnit> writer = newSchema.equals((Object)prevSchema) ? this.modifiableRowWriter(prevSchema, newSchema, renamedColumnsMap, new ArrayDeque<String>()) : this.newWriterRenaming((DataType)prevSchema, (DataType)newSchema, renamedColumnsMap, new ArrayDeque<String>());
        HoodieInternalRowUtils.CatalystDataUpdater phonyUpdater = new HoodieInternalRowUtils.CatalystDataUpdater(){
            private InternalRow value;

            public void setNullAt(int ordinal) {
                HoodieInternalRowUtils.CatalystDataUpdater.setNullAt$(this, ordinal);
            }

            public void setBoolean(int ordinal, boolean value) {
                HoodieInternalRowUtils.CatalystDataUpdater.setBoolean$(this, ordinal, value);
            }

            public void setByte(int ordinal, byte value) {
                HoodieInternalRowUtils.CatalystDataUpdater.setByte$(this, ordinal, value);
            }

            public void setShort(int ordinal, short value) {
                HoodieInternalRowUtils.CatalystDataUpdater.setShort$(this, ordinal, value);
            }

            public void setInt(int ordinal, int value) {
                HoodieInternalRowUtils.CatalystDataUpdater.setInt$(this, ordinal, value);
            }

            public void setLong(int ordinal, long value) {
                HoodieInternalRowUtils.CatalystDataUpdater.setLong$(this, ordinal, value);
            }

            public void setDouble(int ordinal, double value) {
                HoodieInternalRowUtils.CatalystDataUpdater.setDouble$(this, ordinal, value);
            }

            public void setFloat(int ordinal, float value) {
                HoodieInternalRowUtils.CatalystDataUpdater.setFloat$(this, ordinal, value);
            }

            public void setDecimal(int ordinal, Decimal value) {
                HoodieInternalRowUtils.CatalystDataUpdater.setDecimal$(this, ordinal, value);
            }

            public InternalRow value() {
                return this.value;
            }

            public void value_$eq(InternalRow x$1) {
                this.value = x$1;
            }

            public void set(int ordinal, Object value) {
                this.value_$eq((InternalRow)value);
            }
            {
                HoodieInternalRowUtils.CatalystDataUpdater.$init$(this);
            }
        };
        return (Function1 & Serializable & scala.Serializable)oldRow -> {
            Object object;
            writer.apply((Object)phonyUpdater, (Object)BoxesRunTime.boxToInteger((int)0), oldRow);
            updatedValuesMap.forEach((index, value) -> {
                Object object;
                HoodieInternalRowUtils.CatalystDataUpdater qual1 = phonyUpdater;
                try {
                    object = HoodieInternalRowUtils$.reflMethod$Method1(qual1.getClass()).invoke((Object)qual1, new Object[0]);
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw invocationTargetException.getCause();
                }
                if (((SpecializedGetters)((InternalRow)object)).isNullAt(Predef$.MODULE$.Integer2int(index))) {
                    Object object2;
                    HoodieInternalRowUtils.CatalystDataUpdater qual2 = phonyUpdater;
                    try {
                        object2 = HoodieInternalRowUtils$.reflMethod$Method2(qual2.getClass()).invoke((Object)qual2, new Object[0]);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        throw invocationTargetException.getCause();
                    }
                    ((InternalRow)object2).update(Predef$.MODULE$.Integer2int(index), value);
                    return;
                }
            });
            HoodieInternalRowUtils.CatalystDataUpdater qual3 = phonyUpdater;
            try {
                object = HoodieInternalRowUtils$.reflMethod$Method3(qual3.getClass()).invoke((Object)qual3, new Object[0]);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw invocationTargetException.getCause();
            }
            return unsafeProjection.apply((InternalRow)object);
        };
    }

    private Function2<HoodieInternalRowUtils.CatalystDataUpdater, Object, BoxedUnit> genUnsafeStructWriter(StructType prevStructType, StructType newStructType, Map<String, String> renamedColumnsMap, Deque<String> fieldNamesStack) {
        ArrayBuffer fieldWriters = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        ArrayBuffer positionMap = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])newStructType.fields())).foreach((Function1 & Serializable & scala.Serializable)newField -> {
            Tuple2 tuple2;
            fieldNamesStack.push(newField.name());
            Option option = prevStructType.getFieldIndex(MODULE$.lookupRenamedField(newField.name(), HoodieAvroUtils.createFullName((Deque)fieldNamesStack), renamedColumnsMap));
            if (option instanceof Some) {
                Some some = (Some)option;
                int prevFieldPos = BoxesRunTime.unboxToInt((Object)some.value());
                StructField prevField = prevStructType.apply(prevFieldPos);
                tuple2 = new Tuple2(MODULE$.newWriterRenaming(prevField.dataType(), newField.dataType(), renamedColumnsMap, fieldNamesStack), (Object)BoxesRunTime.boxToInteger((int)prevFieldPos));
            } else if (None$.MODULE$.equals(option)) {
                Function3 & Serializable & scala.Serializable updater = (Function3 & Serializable & scala.Serializable)(fieldUpdater, ordinal, x$1) -> {
                    fieldUpdater.setNullAt(BoxesRunTime.unboxToInt((Object)ordinal));
                    return BoxedUnit.UNIT;
                };
                tuple2 = new Tuple2((Object)updater, (Object)BoxesRunTime.boxToInteger((int)-1));
            } else {
                throw new MatchError((Object)option);
            }
            Tuple2 tuple22 = tuple2;
            if (tuple22 == null) {
                throw new MatchError((Object)tuple22);
            }
            Function3 fieldWriter = (Function3)tuple22._1();
            int prevFieldPos = tuple22._2$mcI$sp();
            Tuple2 tuple23 = new Tuple2((Object)fieldWriter, (Object)BoxesRunTime.boxToInteger((int)prevFieldPos));
            Function3 fieldWriter2 = (Function3)tuple23._1();
            int prevFieldPos2 = tuple23._2$mcI$sp();
            fieldWriters.$plus$eq((Object)fieldWriter2);
            positionMap.$plus$eq((Object)BoxesRunTime.boxToInteger((int)prevFieldPos2));
            return (String)fieldNamesStack.pop();
        });
        return (Function2 & Serializable & scala.Serializable)(fieldUpdater, row) -> {
            HoodieInternalRowUtils$.$anonfun$genUnsafeStructWriter$3(fieldWriters, positionMap, prevStructType, fieldUpdater, row);
            return BoxedUnit.UNIT;
        };
    }

    private Function3<HoodieInternalRowUtils.CatalystDataUpdater, Object, Object, BoxedUnit> modifiableRowWriter(StructType prevStructType, StructType newStructType, Map<String, String> renamedColumnsMap, Deque<String> fieldNameStack) {
        Function2<HoodieInternalRowUtils.CatalystDataUpdater, Object, BoxedUnit> writer = this.genUnsafeStructWriter(prevStructType, newStructType, renamedColumnsMap, fieldNameStack);
        SpecificInternalRow newRow = new SpecificInternalRow((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])newStructType.fields())).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.dataType(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(DataType.class)))));
        HoodieInternalRowUtils.RowUpdater rowUpdater = new HoodieInternalRowUtils.RowUpdater((InternalRow)newRow);
        return (Function3 & Serializable & scala.Serializable)(fieldUpdater, ordinal, value) -> {
            HoodieInternalRowUtils$.$anonfun$modifiableRowWriter$2(writer, rowUpdater, newRow, fieldUpdater, BoxesRunTime.unboxToInt((Object)ordinal), value);
            return BoxedUnit.UNIT;
        };
    }

    private Function3<HoodieInternalRowUtils.CatalystDataUpdater, Object, Object, BoxedUnit> newWriterRenaming(DataType prevDataType, DataType newDataType, Map<String, String> renamedColumnsMap, Deque<String> fieldNameStack) {
        DataType newDecimal;
        Tuple2 tuple2 = new Tuple2((Object)newDataType, (Object)prevDataType);
        if (tuple2 != null) {
            DataType newType = (DataType)tuple2._1();
            DataType prevType = (DataType)tuple2._2();
            String string = prevType.sql();
            String string2 = newType.sql();
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                return (Function3 & Serializable & scala.Serializable)(fieldUpdater, ordinal, value) -> {
                    fieldUpdater.set(BoxesRunTime.unboxToInt((Object)ordinal), value);
                    return BoxedUnit.UNIT;
                };
            }
        }
        if (tuple2 != null) {
            DataType newStructType = (DataType)tuple2._1();
            DataType prevStructType = (DataType)tuple2._2();
            if (newStructType instanceof StructType) {
                StructType structType = (StructType)newStructType;
                if (prevStructType instanceof StructType) {
                    StructType structType2 = (StructType)prevStructType;
                    return this.modifiableRowWriter(structType2, structType, renamedColumnsMap, fieldNameStack);
                }
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            DataType dataType2 = (DataType)tuple2._2();
            if (dataType instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)dataType;
                DataType newElementType = arrayType.elementType();
                if (dataType2 instanceof ArrayType) {
                    ArrayType arrayType2 = (ArrayType)dataType2;
                    DataType prevElementType = arrayType2.elementType();
                    boolean containsNull = arrayType2.containsNull();
                    fieldNameStack.push("element");
                    Function3<HoodieInternalRowUtils.CatalystDataUpdater, Object, Object, BoxedUnit> elementWriter = this.newWriterRenaming(prevElementType, newElementType, renamedColumnsMap, fieldNameStack);
                    fieldNameStack.pop();
                    return (Function3 & Serializable & scala.Serializable)(fieldUpdater, ordinal, value) -> {
                        HoodieInternalRowUtils$.$anonfun$newWriterRenaming$2(prevElementType, newElementType, containsNull, fieldNameStack, elementWriter, fieldUpdater, BoxesRunTime.unboxToInt((Object)ordinal), value);
                        return BoxedUnit.UNIT;
                    };
                }
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            DataType dataType3 = (DataType)tuple2._2();
            if (dataType instanceof MapType) {
                MapType mapType = (MapType)dataType;
                DataType newValueType = mapType.valueType();
                if (dataType3 instanceof MapType) {
                    MapType mapType2 = (MapType)dataType3;
                    DataType prevValueType = mapType2.valueType();
                    boolean valueContainsNull = mapType2.valueContainsNull();
                    fieldNameStack.push("value");
                    Function3<HoodieInternalRowUtils.CatalystDataUpdater, Object, Object, BoxedUnit> valueWriter = this.newWriterRenaming(prevValueType, newValueType, renamedColumnsMap, fieldNameStack);
                    fieldNameStack.pop();
                    return (Function3 & Serializable & scala.Serializable)(updater, ordinal, value) -> {
                        HoodieInternalRowUtils$.$anonfun$newWriterRenaming$3(prevValueType, newValueType, valueContainsNull, fieldNameStack, valueWriter, updater, BoxesRunTime.unboxToInt((Object)ordinal), value);
                        return BoxedUnit.UNIT;
                    };
                }
            }
        }
        if (tuple2 != null && (newDecimal = (DataType)tuple2._1()) instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)newDecimal;
            DataType dataType = prevDataType;
            if (IntegerType$.MODULE$.equals(dataType) ? true : (LongType$.MODULE$.equals(dataType) ? true : (FloatType$.MODULE$.equals(dataType) ? true : (DoubleType$.MODULE$.equals(dataType) ? true : StringType$.MODULE$.equals(dataType))))) {
                return (Function3 & Serializable & scala.Serializable)(fieldUpdater, ordinal, value) -> {
                    HoodieInternalRowUtils$.$anonfun$newWriterRenaming$4(decimalType, fieldUpdater, BoxesRunTime.unboxToInt((Object)ordinal), value);
                    return BoxedUnit.UNIT;
                };
            }
            if (dataType instanceof DecimalType) {
                return (Function3 & Serializable & scala.Serializable)(fieldUpdater, ordinal, value) -> {
                    fieldUpdater.setDecimal(BoxesRunTime.unboxToInt((Object)ordinal), Decimal$.MODULE$.fromDecimal((Object)((Decimal)value).toBigDecimal().setScale(decimalType.scale())));
                    return BoxedUnit.UNIT;
                };
            }
            throw new IllegalArgumentException(new StringBuilder(22).append(prevDataType).append(" and ").append(newDataType).append(" are incompatible").toString());
        }
        if (tuple2 != null && tuple2._1() instanceof ShortType) {
            DataType dataType = prevDataType;
            if (dataType instanceof ByteType) {
                return (Function3 & Serializable & scala.Serializable)(fieldUpdater, ordinal, value) -> {
                    fieldUpdater.setShort(BoxesRunTime.unboxToInt((Object)ordinal), BoxesRunTime.unboxToByte((Object)value));
                    return BoxedUnit.UNIT;
                };
            }
            throw new IllegalArgumentException(new StringBuilder(22).append(prevDataType).append(" and ").append(newDataType).append(" are incompatible").toString());
        }
        if (tuple2 != null && tuple2._1() instanceof IntegerType) {
            DataType dataType = prevDataType;
            if (dataType instanceof ShortType) {
                return (Function3 & Serializable & scala.Serializable)(fieldUpdater, ordinal, value) -> {
                    fieldUpdater.setInt(BoxesRunTime.unboxToInt((Object)ordinal), BoxesRunTime.unboxToShort((Object)value));
                    return BoxedUnit.UNIT;
                };
            }
            if (dataType instanceof ByteType) {
                return (Function3 & Serializable & scala.Serializable)(fieldUpdater, ordinal, value) -> {
                    fieldUpdater.setInt(BoxesRunTime.unboxToInt((Object)ordinal), BoxesRunTime.unboxToByte((Object)value));
                    return BoxedUnit.UNIT;
                };
            }
            throw new IllegalArgumentException(new StringBuilder(22).append(prevDataType).append(" and ").append(newDataType).append(" are incompatible").toString());
        }
        if (tuple2 != null && tuple2._1() instanceof LongType) {
            DataType dataType = prevDataType;
            if (dataType instanceof IntegerType) {
                return (Function3 & Serializable & scala.Serializable)(fieldUpdater, ordinal, value) -> {
                    fieldUpdater.setLong(BoxesRunTime.unboxToInt((Object)ordinal), BoxesRunTime.unboxToInt((Object)value));
                    return BoxedUnit.UNIT;
                };
            }
            if (dataType instanceof ShortType) {
                return (Function3 & Serializable & scala.Serializable)(fieldUpdater, ordinal, value) -> {
                    fieldUpdater.setLong(BoxesRunTime.unboxToInt((Object)ordinal), BoxesRunTime.unboxToShort((Object)value));
                    return BoxedUnit.UNIT;
                };
            }
            if (dataType instanceof ByteType) {
                return (Function3 & Serializable & scala.Serializable)(fieldUpdater, ordinal, value) -> {
                    fieldUpdater.setLong(BoxesRunTime.unboxToInt((Object)ordinal), BoxesRunTime.unboxToByte((Object)value));
                    return BoxedUnit.UNIT;
                };
            }
            throw new IllegalArgumentException(new StringBuilder(22).append(prevDataType).append(" and ").append(newDataType).append(" are incompatible").toString());
        }
        if (tuple2 != null && tuple2._1() instanceof FloatType) {
            DataType dataType = prevDataType;
            if (dataType instanceof LongType) {
                return (Function3 & Serializable & scala.Serializable)(fieldUpdater, ordinal, value) -> {
                    fieldUpdater.setFloat(BoxesRunTime.unboxToInt((Object)ordinal), BoxesRunTime.unboxToLong((Object)value));
                    return BoxedUnit.UNIT;
                };
            }
            if (dataType instanceof IntegerType) {
                return (Function3 & Serializable & scala.Serializable)(fieldUpdater, ordinal, value) -> {
                    fieldUpdater.setFloat(BoxesRunTime.unboxToInt((Object)ordinal), BoxesRunTime.unboxToInt((Object)value));
                    return BoxedUnit.UNIT;
                };
            }
            if (dataType instanceof ShortType) {
                return (Function3 & Serializable & scala.Serializable)(fieldUpdater, ordinal, value) -> {
                    fieldUpdater.setFloat(BoxesRunTime.unboxToInt((Object)ordinal), BoxesRunTime.unboxToShort((Object)value));
                    return BoxedUnit.UNIT;
                };
            }
            if (dataType instanceof ByteType) {
                return (Function3 & Serializable & scala.Serializable)(fieldUpdater, ordinal, value) -> {
                    fieldUpdater.setFloat(BoxesRunTime.unboxToInt((Object)ordinal), BoxesRunTime.unboxToByte((Object)value));
                    return BoxedUnit.UNIT;
                };
            }
            throw new IllegalArgumentException(new StringBuilder(22).append(prevDataType).append(" and ").append(newDataType).append(" are incompatible").toString());
        }
        if (tuple2 != null && tuple2._1() instanceof DoubleType) {
            DataType dataType = prevDataType;
            if (dataType instanceof FloatType) {
                return (Function3 & Serializable & scala.Serializable)(fieldUpdater, ordinal, value) -> {
                    fieldUpdater.setDouble(BoxesRunTime.unboxToInt((Object)ordinal), new StringOps(Predef$.MODULE$.augmentString(Float.toString(BoxesRunTime.unboxToFloat((Object)value)))).toDouble());
                    return BoxedUnit.UNIT;
                };
            }
            if (dataType instanceof LongType) {
                return (Function3 & Serializable & scala.Serializable)(fieldUpdater, ordinal, value) -> {
                    fieldUpdater.setDouble(BoxesRunTime.unboxToInt((Object)ordinal), BoxesRunTime.unboxToLong((Object)value));
                    return BoxedUnit.UNIT;
                };
            }
            if (dataType instanceof IntegerType) {
                return (Function3 & Serializable & scala.Serializable)(fieldUpdater, ordinal, value) -> {
                    fieldUpdater.setDouble(BoxesRunTime.unboxToInt((Object)ordinal), BoxesRunTime.unboxToInt((Object)value));
                    return BoxedUnit.UNIT;
                };
            }
            if (dataType instanceof ShortType) {
                return (Function3 & Serializable & scala.Serializable)(fieldUpdater, ordinal, value) -> {
                    fieldUpdater.setDouble(BoxesRunTime.unboxToInt((Object)ordinal), BoxesRunTime.unboxToShort((Object)value));
                    return BoxedUnit.UNIT;
                };
            }
            if (dataType instanceof ByteType) {
                return (Function3 & Serializable & scala.Serializable)(fieldUpdater, ordinal, value) -> {
                    fieldUpdater.setDouble(BoxesRunTime.unboxToInt((Object)ordinal), BoxesRunTime.unboxToByte((Object)value));
                    return BoxedUnit.UNIT;
                };
            }
            throw new IllegalArgumentException(new StringBuilder(22).append(prevDataType).append(" and ").append(newDataType).append(" are incompatible").toString());
        }
        if (tuple2 != null && tuple2._1() instanceof BinaryType && tuple2._2() instanceof StringType) {
            return (Function3 & Serializable & scala.Serializable)(fieldUpdater, ordinal, value) -> {
                fieldUpdater.set(BoxesRunTime.unboxToInt((Object)ordinal), ((UTF8String)value).getBytes());
                return BoxedUnit.UNIT;
            };
        }
        if (tuple2 != null && tuple2._1() instanceof StringType) {
            DataType dataType = prevDataType;
            if (BinaryType$.MODULE$.equals(dataType)) {
                return (Function3 & Serializable & scala.Serializable)(fieldUpdater, ordinal, value) -> {
                    fieldUpdater.set(BoxesRunTime.unboxToInt((Object)ordinal), UTF8String.fromBytes((byte[])((byte[])value)));
                    return BoxedUnit.UNIT;
                };
            }
            if (DateType$.MODULE$.equals(dataType)) {
                return (Function3 & Serializable & scala.Serializable)(fieldUpdater, ordinal, value) -> {
                    fieldUpdater.set(BoxesRunTime.unboxToInt((Object)ordinal), UTF8String.fromString((String)HoodieAvroUtils.toJavaDate((int)Predef$.MODULE$.Integer2int((Integer)value)).toString()));
                    return BoxedUnit.UNIT;
                };
            }
            if (IntegerType$.MODULE$.equals(dataType) ? true : (LongType$.MODULE$.equals(dataType) ? true : (FloatType$.MODULE$.equals(dataType) ? true : (DoubleType$.MODULE$.equals(dataType) ? true : dataType instanceof DecimalType)))) {
                return (Function3 & Serializable & scala.Serializable)(fieldUpdater, ordinal, value) -> {
                    fieldUpdater.set(BoxesRunTime.unboxToInt((Object)ordinal), UTF8String.fromString((String)value.toString()));
                    return BoxedUnit.UNIT;
                };
            }
            throw new IllegalArgumentException(new StringBuilder(22).append(prevDataType).append(" and ").append(newDataType).append(" are incompatible").toString());
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            DataType dataType4 = (DataType)tuple2._2();
            if (DateType$.MODULE$.equals(dataType) && StringType$.MODULE$.equals(dataType4)) {
                return (Function3 & Serializable & scala.Serializable)(fieldUpdater, ordinal, value) -> {
                    fieldUpdater.set(BoxesRunTime.unboxToInt((Object)ordinal), CatalystTypeConverters$.MODULE$.convertToCatalyst((Object)Date.valueOf(value.toString())));
                    return BoxedUnit.UNIT;
                };
            }
        }
        if (tuple2 != null) {
            throw new IllegalArgumentException(new StringBuilder(22).append(prevDataType).append(" and ").append(newDataType).append(" are incompatible").toString());
        }
        throw new MatchError((Object)tuple2);
    }

    private String lookupRenamedField(String newFieldName, String newFieldQualifiedName, Map<String, String> renamedColumnsMap) {
        String renamed = renamedColumnsMap.get(newFieldQualifiedName);
        if (renamed == null) {
            return newFieldName;
        }
        String[] prevFieldQualifiedNameParts = renamed.split("\\.");
        String prevFieldName = prevFieldQualifiedNameParts[prevFieldQualifiedNameParts.length - 1];
        return prevFieldName;
    }

    private ArrayData createArrayData(DataType elementType, int length) {
        DataType dataType = elementType;
        if (BooleanType$.MODULE$.equals(dataType)) {
            return UnsafeArrayData.fromPrimitiveArray((boolean[])new boolean[length]);
        }
        if (ByteType$.MODULE$.equals(dataType)) {
            return UnsafeArrayData.fromPrimitiveArray((byte[])new byte[length]);
        }
        if (ShortType$.MODULE$.equals(dataType)) {
            return UnsafeArrayData.fromPrimitiveArray((short[])new short[length]);
        }
        if (IntegerType$.MODULE$.equals(dataType)) {
            return UnsafeArrayData.fromPrimitiveArray((int[])new int[length]);
        }
        if (LongType$.MODULE$.equals(dataType)) {
            return UnsafeArrayData.fromPrimitiveArray((long[])new long[length]);
        }
        if (FloatType$.MODULE$.equals(dataType)) {
            return UnsafeArrayData.fromPrimitiveArray((float[])new float[length]);
        }
        if (DoubleType$.MODULE$.equals(dataType)) {
            return UnsafeArrayData.fromPrimitiveArray((double[])new double[length]);
        }
        return new GenericArrayData(new Object[length]);
    }

    public static final /* synthetic */ void $anonfun$genUnsafeStructWriter$3(ArrayBuffer fieldWriters$1, ArrayBuffer positionMap$1, StructType prevStructType$1, HoodieInternalRowUtils.CatalystDataUpdater fieldUpdater, Object row) {
        for (int pos = 0; pos < fieldWriters$1.length(); ++pos) {
            Object object;
            Object prevValue;
            int prevPos = BoxesRunTime.unboxToInt((Object)positionMap$1.apply(pos));
            Object object2 = prevValue = prevPos >= 0 ? ((InternalRow)row).get(prevPos, prevStructType$1.fields()[prevPos].dataType()) : null;
            if (prevValue == null) {
                fieldUpdater.setNullAt(pos);
                object = BoxedUnit.UNIT;
                continue;
            }
            object = ((Function3)fieldWriters$1.apply(pos)).apply((Object)fieldUpdater, (Object)BoxesRunTime.boxToInteger((int)pos), prevValue);
        }
    }

    public static final /* synthetic */ void $anonfun$modifiableRowWriter$2(Function2 writer$2, HoodieInternalRowUtils.RowUpdater rowUpdater$1, SpecificInternalRow newRow$1, HoodieInternalRowUtils.CatalystDataUpdater fieldUpdater, int ordinal, Object value) {
        writer$2.apply((Object)rowUpdater$1, value);
        fieldUpdater.set(ordinal, newRow$1);
    }

    public static final /* synthetic */ void $anonfun$newWriterRenaming$2(DataType prevElementType$1, DataType newElementType$1, boolean containsNull$1, Deque fieldNameStack$1, Function3 elementWriter$1, HoodieInternalRowUtils.CatalystDataUpdater fieldUpdater, int ordinal, Object value) {
        ArrayData prevArrayData = (ArrayData)value;
        Object[] prevArray = prevArrayData.toObjectArray(prevElementType$1);
        ArrayData newArrayData = MODULE$.createArrayData(newElementType$1, prevArrayData.numElements());
        HoodieInternalRowUtils.ArrayDataUpdater elementUpdater = new HoodieInternalRowUtils.ArrayDataUpdater(newArrayData);
        for (int i = 0; i < prevArray.length; ++i) {
            Object object;
            Object element = prevArray[i];
            if (element == null) {
                if (!containsNull$1) {
                    throw new HoodieException(new StringBuilder(48).append("Array value at path '").append(((TraversableOnce)JavaConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)fieldNameStack$1).asScala()).mkString(".")).append("' is not allowed to be null").toString());
                }
                elementUpdater.setNullAt(i);
                object = BoxedUnit.UNIT;
                continue;
            }
            object = elementWriter$1.apply((Object)elementUpdater, (Object)BoxesRunTime.boxToInteger((int)i), element);
        }
        fieldUpdater.set(ordinal, newArrayData);
    }

    public static final /* synthetic */ void $anonfun$newWriterRenaming$3(DataType prevValueType$1, DataType newValueType$1, boolean valueContainsNull$1, Deque fieldNameStack$1, Function3 valueWriter$1, HoodieInternalRowUtils.CatalystDataUpdater updater, int ordinal, Object value) {
        MapData mapData = (MapData)value;
        ArrayData prevKeyArrayData = mapData.keyArray();
        ArrayData prevValueArrayData = mapData.valueArray();
        Object[] prevValueArray = prevValueArrayData.toObjectArray(prevValueType$1);
        ArrayData newValueArray = MODULE$.createArrayData(newValueType$1, mapData.numElements());
        HoodieInternalRowUtils.ArrayDataUpdater valueUpdater = new HoodieInternalRowUtils.ArrayDataUpdater(newValueArray);
        for (int i = 0; i < prevValueArray.length; ++i) {
            Object object;
            Object value2 = prevValueArray[i];
            if (value2 == null) {
                if (!valueContainsNull$1) {
                    throw new HoodieException(new StringBuilder(44).append("Map value at path ").append(((TraversableOnce)JavaConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)fieldNameStack$1).asScala()).mkString(".")).append(" is not allowed to be null").toString());
                }
                valueUpdater.setNullAt(i);
                object = BoxedUnit.UNIT;
                continue;
            }
            object = valueWriter$1.apply((Object)valueUpdater, (Object)BoxesRunTime.boxToInteger((int)i), value2);
        }
        updater.set(ordinal, new ArrayBasedMapData(prevKeyArrayData, newValueArray));
    }

    public static final /* synthetic */ void $anonfun$newWriterRenaming$4(DecimalType x35$1, HoodieInternalRowUtils.CatalystDataUpdater fieldUpdater, int ordinal, Object value) {
        int scale = x35$1.scale();
        fieldUpdater.setDecimal(ordinal, Decimal$.MODULE$.fromDecimal((Object)package$.MODULE$.BigDecimal().apply(value.toString()).setScale(scale, Decimal$.MODULE$.ROUND_HALF_UP())));
    }

    private HoodieInternalRowUtils$() {
        MODULE$ = this;
        this.unsafeWriterThreadLocal = ThreadLocal.withInitial(new Supplier<HashMap<Tuple4<StructType, StructType, Map<String, String>, Map<Integer, Object>>, Function1<InternalRow, UnsafeRow>>>(){

            public HashMap<Tuple4<StructType, StructType, Map<String, String>, Map<Integer, Object>>, Function1<InternalRow, UnsafeRow>> get() {
                return new HashMap();
            }
        });
        this.unsafeProjectionThreadLocal = ThreadLocal.withInitial(new Supplier<HashMap<Tuple2<StructType, StructType>, UnsafeProjection>>(){

            public HashMap<Tuple2<StructType, StructType>, UnsafeProjection> get() {
                return new HashMap();
            }
        });
        this.identicalUnsafeProjectionThreadLocal = ThreadLocal.withInitial(new Supplier<HashMap<Schema, UnsafeProjection>>(){

            public HashMap<Schema, UnsafeProjection> get() {
                return new HashMap();
            }
        });
        this.schemaMap = new ConcurrentHashMap();
        this.orderPosListMap = new ConcurrentHashMap();
    }
}

