/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.ZoneId;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.spark.internal.ReflectUtil;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.catalog.ExternalCatalogUtils$;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.util.DateFormatter;
import org.apache.spark.sql.catalyst.util.TimestampFormatter;
import org.apache.spark.sql.catalyst.util.TimestampFormatter$;
import org.apache.spark.sql.execution.datasources.PartitioningUtils$;
import org.apache.spark.sql.execution.datasources.SparkParsePartitionUtil;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TimestampType;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.runtime.BoxesRunTime;
import scala.util.Try;
import scala.util.Try$;
import scala.util.control.NonFatal$;

public final class SparkParsePartitionUtil$
implements scala.Serializable {
    public static SparkParsePartitionUtil$ MODULE$;
    private final ConcurrentHashMap<ZoneId, Tuple2<DateFormatter, TimestampFormatter>> cache;

    static {
        new SparkParsePartitionUtil$();
    }

    private ConcurrentHashMap<ZoneId, Tuple2<DateFormatter, TimestampFormatter>> cache() {
        return this.cache;
    }

    public InternalRow parsePartition(Path path, boolean typeInference, Set<Path> basePaths, Map<String, DataType> userSpecifiedDataTypes, TimeZone tz, boolean validatePartitionValues) {
        Tuple2 tuple2 = this.cache().computeIfAbsent(tz.toZoneId(), zoneId -> {
            DateFormatter dateFormatter = ReflectUtil.getDateFormatter(zoneId);
            TimestampFormatter timestampFormatter = TimestampFormatter$.MODULE$.apply(PartitioningUtils$.MODULE$.timestampPartitionPattern(), zoneId, true);
            return new Tuple2((Object)dateFormatter, (Object)timestampFormatter);
        });
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        DateFormatter dateFormatter = (DateFormatter)tuple2._1();
        TimestampFormatter timestampFormatter = (TimestampFormatter)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)dateFormatter, (Object)timestampFormatter);
        DateFormatter dateFormatter2 = (DateFormatter)tuple22._1();
        TimestampFormatter timestampFormatter2 = (TimestampFormatter)tuple22._2();
        Tuple2<Option<SparkParsePartitionUtil.PartitionValues>, Option<Path>> tuple23 = this.parsePartition(path, typeInference, basePaths, userSpecifiedDataTypes, validatePartitionValues, tz.toZoneId(), dateFormatter2, timestampFormatter2);
        if (tuple23 == null) {
            throw new MatchError(tuple23);
        }
        Option partitionValues = (Option)tuple23._1();
        Option partitionValues2 = partitionValues;
        return (InternalRow)partitionValues2.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            SparkParsePartitionUtil.PartitionValues partitionValues = x0$1;
            if (partitionValues != null) {
                Seq<String> columnNames = partitionValues.columnNames();
                Seq<SparkParsePartitionUtil.TypedPartValue> typedValues = partitionValues.typedValues();
                if (columnNames != null) {
                    Seq<String> seq = columnNames;
                    if (typedValues != null) {
                        Seq<SparkParsePartitionUtil.TypedPartValue> seq2 = typedValues;
                        Seq rowValues = (Seq)((TraversableLike)seq.zip(seq2, Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                            Tuple2 tuple2 = x0$2;
                            if (tuple2 != null) {
                                Object object;
                                String columnName = (String)tuple2._1();
                                SparkParsePartitionUtil.TypedPartValue typedValue = (SparkParsePartitionUtil.TypedPartValue)tuple2._2();
                                try {
                                    object = MODULE$.castPartValueToDesiredType(typedValue.dataType(), typedValue.value(), tz.toZoneId());
                                }
                                catch (Throwable throwable) {
                                    Throwable throwable2 = throwable;
                                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                                    if (!option.isEmpty()) {
                                        if (validatePartitionValues) {
                                            throw new RuntimeException(new StringBuilder(53).append("Failed to cast value `").append(typedValue.value()).append("` to ").append("`").append(typedValue.dataType()).append("` for partition column `").append(columnName).append("`").toString());
                                        }
                                        object = null;
                                    }
                                    throw throwable;
                                }
                                return object;
                            }
                            throw new MatchError((Object)tuple2);
                        }, Seq$.MODULE$.canBuildFrom());
                        return InternalRow$.MODULE$.fromSeq(rowValues);
                    }
                }
            }
            throw new MatchError((Object)partitionValues);
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> InternalRow$.MODULE$.empty());
    }

    private Tuple2<Option<SparkParsePartitionUtil.PartitionValues>, Option<Path>> parsePartition(Path path, boolean typeInference, Set<Path> basePaths, Map<String, DataType> userSpecifiedDataTypes, boolean validatePartitionColumns, ZoneId zoneId, DateFormatter dateFormatter, TimestampFormatter timestampFormatter) {
        ArrayBuffer columns = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        boolean finished = path.getParent() == null;
        Path currentPath = path;
        while (!finished) {
            String string = currentPath.getName().toLowerCase(Locale.ROOT);
            String string2 = "_temporary";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                return new Tuple2((Object)None$.MODULE$, (Object)None$.MODULE$);
            }
            if (basePaths.contains((Object)currentPath)) {
                finished = true;
                continue;
            }
            Option<Tuple2<String, SparkParsePartitionUtil.TypedPartValue>> maybeColumn = this.parsePartitionColumn(currentPath.getName(), typeInference, userSpecifiedDataTypes, validatePartitionColumns, zoneId, dateFormatter, timestampFormatter);
            maybeColumn.foreach((Function1 & Serializable & scala.Serializable)x$2 -> columns.$plus$eq(x$2));
            finished = maybeColumn.isEmpty() && !columns.isEmpty() || currentPath.getParent() == null;
            if (finished) continue;
            currentPath = currentPath.getParent();
        }
        if (columns.isEmpty()) {
            return new Tuple2((Object)None$.MODULE$, (Object)new Some((Object)path));
        }
        Tuple2 tuple2 = ((GenericTraversableTemplate)columns.reverse()).unzip((Function1)Predef$.MODULE$.$conforms());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        ArrayBuffer columnNames = (ArrayBuffer)tuple2._1();
        ArrayBuffer values = (ArrayBuffer)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)columnNames, (Object)values);
        ArrayBuffer columnNames2 = (ArrayBuffer)tuple22._1();
        ArrayBuffer values2 = (ArrayBuffer)tuple22._2();
        return new Tuple2((Object)new Some((Object)new SparkParsePartitionUtil.PartitionValues((Seq<String>)columnNames2.toSeq(), (Seq<SparkParsePartitionUtil.TypedPartValue>)values2.toSeq())), (Object)new Some((Object)currentPath));
    }

    public boolean parsePartition$default$6() {
        return false;
    }

    private Option<Tuple2<String, SparkParsePartitionUtil.TypedPartValue>> parsePartitionColumn(String columnSpec, boolean typeInference, Map<String, DataType> userSpecifiedDataTypes, boolean validatePartitionColumns, ZoneId zoneId, DateFormatter dateFormatter, TimestampFormatter timestampFormatter) {
        int equalSignIndex = columnSpec.indexOf(61);
        if (equalSignIndex == -1) {
            return None$.MODULE$;
        }
        String columnName = ExternalCatalogUtils$.MODULE$.unescapePathName((String)new StringOps(Predef$.MODULE$.augmentString(columnSpec)).take(equalSignIndex));
        Predef$.MODULE$.assert(new StringOps(Predef$.MODULE$.augmentString(columnName)).nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Empty partition column name in '").append(columnSpec).append("'").toString());
        String rawColumnValue = (String)new StringOps(Predef$.MODULE$.augmentString(columnSpec)).drop(equalSignIndex + 1);
        Predef$.MODULE$.assert(new StringOps(Predef$.MODULE$.augmentString(rawColumnValue)).nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("Empty partition column value in '").append(columnSpec).append("'").toString());
        DataType dataType = userSpecifiedDataTypes.contains((Object)columnName) ? (DataType)userSpecifiedDataTypes.apply((Object)columnName) : this.inferPartitionColumnValue(rawColumnValue, typeInference, zoneId, dateFormatter, timestampFormatter);
        return new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)columnName), (Object)new SparkParsePartitionUtil.TypedPartValue(rawColumnValue, dataType)));
    }

    private DataType inferPartitionColumnValue(String raw, boolean typeInference, ZoneId zoneId, DateFormatter dateFormatter, TimestampFormatter timestampFormatter) {
        Try decimalTry = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            BigDecimal bigDecimal = new BigDecimal(raw);
            Predef$.MODULE$.require(bigDecimal.scale() <= 0);
            return MODULE$.fromDecimal(Decimal$.MODULE$.apply(bigDecimal));
        });
        Try dateTry = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            dateFormatter.parse(raw);
            Cast qual$1 = new Cast((Expression)Literal$.MODULE$.apply((Object)raw), (DataType)DateType$.MODULE$, (Option)new Some((Object)zoneId.getId()), Cast$.MODULE$.apply$default$4());
            InternalRow x$1 = qual$1.eval$default$1();
            Object dateValue = qual$1.eval(x$1);
            Predef$.MODULE$.require(dateValue != null);
            return DateType$.MODULE$;
        });
        Try timestampTry = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            String unescapedRaw = ExternalCatalogUtils$.MODULE$.unescapePathName(raw);
            TimestampType$ timestampType = TimestampType$.MODULE$;
            timestampFormatter.parse(unescapedRaw);
            Cast qual$2 = new Cast((Expression)Literal$.MODULE$.apply((Object)unescapedRaw), (DataType)timestampType, (Option)new Some((Object)zoneId.getId()), Cast$.MODULE$.apply$default$4());
            InternalRow x$2 = qual$2.eval$default$1();
            Object timestampValue = qual$2.eval(x$2);
            Predef$.MODULE$.require(timestampValue != null);
            return timestampType;
        });
        if (typeInference) {
            return (DataType)Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
                Integer.parseInt(raw);
                return IntegerType$.MODULE$;
            }).orElse((Function0 & Serializable & scala.Serializable)() -> Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
                Long.parseLong(raw);
                return LongType$.MODULE$;
            })).orElse((Function0 & Serializable & scala.Serializable)() -> decimalTry).orElse((Function0 & Serializable & scala.Serializable)() -> Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
                Double.parseDouble(raw);
                return DoubleType$.MODULE$;
            })).orElse((Function0 & Serializable & scala.Serializable)() -> timestampTry).orElse((Function0 & Serializable & scala.Serializable)() -> dateTry).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                String string = raw;
                String string2 = "__HIVE_DEFAULT_PARTITION__";
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    return NullType$.MODULE$;
                }
                return StringType$.MODULE$;
            });
        }
        String string = raw;
        String string2 = "__HIVE_DEFAULT_PARTITION__";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            return NullType$.MODULE$;
        }
        return StringType$.MODULE$;
    }

    public Object castPartValueToDesiredType(DataType desiredType, String value, ZoneId zoneId) {
        DataType dataType = desiredType;
        String string = value;
        String string2 = "__HIVE_DEFAULT_PARTITION__";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            return null;
        }
        if (NullType$.MODULE$.equals(dataType)) {
            return null;
        }
        if (StringType$.MODULE$.equals(dataType)) {
            return UTF8String.fromString((String)ExternalCatalogUtils$.MODULE$.unescapePathName(value));
        }
        if (ByteType$.MODULE$.equals(dataType)) {
            return BoxesRunTime.boxToByte((byte)((byte)Integer.parseInt(value)));
        }
        if (ShortType$.MODULE$.equals(dataType)) {
            return BoxesRunTime.boxToShort((short)((short)Integer.parseInt(value)));
        }
        if (IntegerType$.MODULE$.equals(dataType)) {
            return BoxesRunTime.boxToInteger((int)Integer.parseInt(value));
        }
        if (LongType$.MODULE$.equals(dataType)) {
            return BoxesRunTime.boxToLong((long)Long.parseLong(value));
        }
        if (FloatType$.MODULE$.equals(dataType)) {
            return BoxesRunTime.boxToFloat((float)((float)Double.parseDouble(value)));
        }
        if (DoubleType$.MODULE$.equals(dataType)) {
            return BoxesRunTime.boxToDouble((double)Double.parseDouble(value));
        }
        if (dataType instanceof DecimalType) {
            return Literal$.MODULE$.apply((Object)new BigDecimal(value)).value();
        }
        if (DateType$.MODULE$.equals(dataType)) {
            Cast qual$1 = new Cast((Expression)Literal$.MODULE$.apply((Object)value), (DataType)DateType$.MODULE$, (Option)new Some((Object)zoneId.getId()), Cast$.MODULE$.apply$default$4());
            InternalRow x$1 = qual$1.eval$default$1();
            return qual$1.eval(x$1);
        }
        if (dataType instanceof TimestampType) {
            TimestampType timestampType = (TimestampType)dataType;
            return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
                Cast qual$2 = new Cast((Expression)Literal$.MODULE$.apply((Object)ExternalCatalogUtils$.MODULE$.unescapePathName(value)), (DataType)timestampType, (Option)new Some((Object)zoneId.getId()), Cast$.MODULE$.apply$default$4());
                InternalRow x$2 = qual$2.eval$default$1();
                return qual$2.eval(x$2);
            }).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                Cast qual$3 = new Cast((Expression)new Cast((Expression)Literal$.MODULE$.apply((Object)value), (DataType)DateType$.MODULE$, (Option)new Some((Object)zoneId.getId()), Cast$.MODULE$.apply$default$4()), (DataType)timestampType, Cast$.MODULE$.apply$default$3(), Cast$.MODULE$.apply$default$4());
                InternalRow x$3 = qual$3.eval$default$1();
                return qual$3.eval(x$3);
            });
        }
        if (BinaryType$.MODULE$.equals(dataType)) {
            return value.getBytes();
        }
        if (BooleanType$.MODULE$.equals(dataType)) {
            return BoxesRunTime.boxToBoolean((boolean)new StringOps(Predef$.MODULE$.augmentString(value)).toBoolean());
        }
        throw new IllegalArgumentException(new StringBuilder(16).append("Unexpected type ").append(dataType).toString());
    }

    private DecimalType fromDecimal(Decimal d) {
        return new DecimalType(d.precision(), d.scale());
    }

    private Object readResolve() {
        return MODULE$;
    }

    private SparkParsePartitionUtil$() {
        MODULE$ = this;
        this.cache = new ConcurrentHashMap(1);
    }
}

