/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.parquet;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.parquet.hadoop.metadata.FileMetaData;
import org.apache.spark.sql.HoodieSchemaUtils;
import org.apache.spark.sql.catalyst.expressions.ArrayTransform;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.CreateNamedStruct;
import org.apache.spark.sql.catalyst.expressions.CreateStruct$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.GetStructField;
import org.apache.spark.sql.catalyst.expressions.GetStructField$;
import org.apache.spark.sql.catalyst.expressions.LambdaFunction;
import org.apache.spark.sql.catalyst.expressions.LambdaFunction$;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.MapEntries;
import org.apache.spark.sql.catalyst.expressions.MapFromEntries;
import org.apache.spark.sql.catalyst.expressions.NamedLambdaVariable;
import org.apache.spark.sql.catalyst.expressions.NamedLambdaVariable$;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection;
import org.apache.spark.sql.catalyst.expressions.codegen.GenerateUnsafeProjection$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetToSparkSchemaConverter;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.MapType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampNTZType$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.GenSeq;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashMap$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyBoolean;
import scala.runtime.java8.JFunction0;

public final class HoodieParquetFileFormatHelper$ {
    public static HoodieParquetFileFormatHelper$ MODULE$;

    static {
        new HoodieParquetFileFormatHelper$();
    }

    public Tuple2<Map<Integer, Pair<DataType, DataType>>, StructType> buildImplicitSchemaChangeInfo(Configuration hadoopConf, FileMetaData parquetFileMetaData, StructType requiredSchema) {
        ParquetToSparkSchemaConverter convert = new ParquetToSparkSchemaConverter(hadoopConf);
        StructType fileStruct = convert.convert(parquetFileMetaData.getSchema());
        return this.buildImplicitSchemaChangeInfo(fileStruct, requiredSchema);
    }

    public Tuple2<Map<Integer, Pair<DataType, DataType>>, StructType> buildImplicitSchemaChangeInfo(StructType fileStruct, StructType requiredSchema) {
        HashMap implicitTypeChangeInfo = new HashMap();
        scala.collection.immutable.Map fileStructMap = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fileStruct.fields())).map((Function1 & Serializable & scala.Serializable)f -> new Tuple2((Object)f.name(), (Object)f.dataType()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms());
        Seq sparkRequestStructFields = (Seq)requiredSchema.map((Function1 & Serializable & scala.Serializable)f -> {
            DataType requiredType = f.dataType();
            if (fileStructMap.contains((Object)f.name()) && !MODULE$.isDataTypeEqual(requiredType, (DataType)fileStructMap.apply((Object)f.name()))) {
                DataType readerType = MODULE$.addMissingFields(requiredType, (DataType)fileStructMap.apply((Object)f.name()));
                implicitTypeChangeInfo.put(new Integer(requiredSchema.fieldIndex(f.name())), Pair.of((Object)requiredType, (Object)readerType));
                return new StructField(f.name(), readerType, f.nullable(), StructField$.MODULE$.apply$default$4());
            }
            return f;
        }, Seq$.MODULE$.canBuildFrom());
        return new Tuple2(implicitTypeChangeInfo, (Object)StructType$.MODULE$.apply(sparkRequestStructFields));
    }

    public boolean isDataTypeEqual(DataType requiredType, DataType fileType) {
        Tuple2 tuple2;
        block11: {
            while (true) {
                if ((tuple2 = new Tuple2((Object)requiredType, (Object)fileType)) != null) {
                    DataType requiredType2 = (DataType)tuple2._1();
                    DataType fileType2 = (DataType)tuple2._2();
                    DataType dataType = requiredType2;
                    DataType dataType2 = fileType2;
                    if (!(dataType != null ? !dataType.equals(dataType2) : dataType2 != null)) {
                        return true;
                    }
                }
                if (tuple2 != null) {
                    DataType dataType = (DataType)tuple2._1();
                    DataType dataType3 = (DataType)tuple2._2();
                    if (TimestampNTZType$.MODULE$.equals(dataType) && LongType$.MODULE$.equals(dataType3)) {
                        return true;
                    }
                }
                if (tuple2 != null) {
                    DataType dataType = (DataType)tuple2._1();
                    DataType dataType4 = (DataType)tuple2._2();
                    if (dataType instanceof ArrayType) {
                        ArrayType arrayType = (ArrayType)dataType;
                        DataType rt = arrayType.elementType();
                        if (dataType4 instanceof ArrayType) {
                            DataType ft;
                            ArrayType arrayType2 = (ArrayType)dataType4;
                            fileType = ft = arrayType2.elementType();
                            requiredType = rt;
                            continue;
                        }
                    }
                }
                if (tuple2 == null) break block11;
                DataType dataType = (DataType)tuple2._1();
                DataType dataType5 = (DataType)tuple2._2();
                if (!(dataType instanceof MapType)) break block11;
                MapType mapType = (MapType)dataType;
                DataType requiredKey = mapType.keyType();
                DataType requiredValue = mapType.valueType();
                if (!(dataType5 instanceof MapType)) break block11;
                MapType mapType2 = (MapType)dataType5;
                DataType fileKey = mapType2.keyType();
                DataType fileValue = mapType2.valueType();
                if (!this.isDataTypeEqual(requiredKey, fileKey)) break;
                fileType = fileValue;
                requiredType = requiredValue;
            }
            return false;
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            DataType dataType6 = (DataType)tuple2._2();
            if (dataType instanceof StructType) {
                StructType structType = (StructType)dataType;
                StructField[] requiredFields = structType.fields();
                if (dataType6 instanceof StructType) {
                    StructType structType2 = (StructType)dataType6;
                    StructField[] fileFields = structType2.fields();
                    String[] commonFieldNames = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])requiredFields)).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.name(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).intersect((GenSeq)Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fileFields)).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.name(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))));
                    StructField[] fileFilteredFields = (StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fileFields)).filter((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)HoodieParquetFileFormatHelper$.$anonfun$isDataTypeEqual$3(commonFieldNames, f))))).sortWith((Function2 & Serializable & scala.Serializable)(x$3, x$4) -> BoxesRunTime.boxToBoolean((boolean)HoodieParquetFileFormatHelper$.$anonfun$isDataTypeEqual$4(x$3, x$4)));
                    StructField[] requiredFilteredFields = (StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])requiredFields)).filter((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)HoodieParquetFileFormatHelper$.$anonfun$isDataTypeEqual$5(commonFieldNames, f))))).sortWith((Function2 & Serializable & scala.Serializable)(x$5, x$6) -> BoxesRunTime.boxToBoolean((boolean)HoodieParquetFileFormatHelper$.$anonfun$isDataTypeEqual$6(x$5, x$6)));
                    return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])requiredFilteredFields)).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])fileFilteredFields), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).forall((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)HoodieParquetFileFormatHelper$.$anonfun$isDataTypeEqual$7(x0$1)));
                }
            }
        }
        return false;
    }

    public DataType addMissingFields(DataType requiredType, DataType fileType) {
        Tuple2 tuple2 = new Tuple2((Object)requiredType, (Object)fileType);
        if (tuple2 != null) {
            DataType requiredType2 = (DataType)tuple2._1();
            DataType fileType2 = (DataType)tuple2._2();
            DataType dataType = requiredType2;
            DataType dataType2 = fileType2;
            if (!(dataType != null ? !dataType.equals(dataType2) : dataType2 != null)) {
                return fileType2;
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            DataType dataType3 = (DataType)tuple2._2();
            if (dataType instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)dataType;
                DataType rt = arrayType.elementType();
                if (dataType3 instanceof ArrayType) {
                    ArrayType arrayType2 = (ArrayType)dataType3;
                    DataType ft = arrayType2.elementType();
                    return ArrayType$.MODULE$.apply(this.addMissingFields(rt, ft));
                }
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            DataType dataType4 = (DataType)tuple2._2();
            if (dataType instanceof MapType) {
                MapType mapType = (MapType)dataType;
                DataType requiredKey = mapType.keyType();
                DataType requiredValue = mapType.valueType();
                if (dataType4 instanceof MapType) {
                    MapType mapType2 = (MapType)dataType4;
                    DataType fileKey = mapType2.keyType();
                    DataType fileValue = mapType2.valueType();
                    return MapType$.MODULE$.apply(this.addMissingFields(requiredKey, fileKey), this.addMissingFields(requiredValue, fileValue));
                }
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            DataType dataType5 = (DataType)tuple2._2();
            if (dataType instanceof StructType) {
                StructType structType = (StructType)dataType;
                StructField[] requiredFields = structType.fields();
                if (dataType5 instanceof StructType) {
                    StructType structType2 = (StructType)dataType5;
                    StructField[] fileFields = structType2.fields();
                    scala.collection.immutable.Map fileFieldMap = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fileFields)).map((Function1 & Serializable & scala.Serializable)f -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)f.name()), f), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms());
                    return new StructType((StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])requiredFields)).map((Function1 & Serializable & scala.Serializable)f -> {
                        Option option = fileFieldMap.get((Object)f.name());
                        if (option instanceof Some) {
                            Some some = (Some)option;
                            StructField ff = (StructField)some.value();
                            return new StructField(ff.name(), MODULE$.addMissingFields(f.dataType(), ff.dataType()), ff.nullable(), ff.metadata());
                        }
                        if (None$.MODULE$.equals(option)) {
                            return f;
                        }
                        throw new MatchError((Object)option);
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class))));
                }
            }
        }
        return fileType;
    }

    public UnsafeProjection generateUnsafeProjection(Seq<Attribute> fullSchema, Option<String> timeZoneId, Map<Integer, Pair<DataType, DataType>> typeChangeInfos, StructType requiredSchema, StructType partitionSchema, HoodieSchemaUtils schemaUtils) {
        scala.collection.mutable.HashMap addedCastCache = HashMap$.MODULE$.empty();
        if (typeChangeInfos.isEmpty()) {
            return (UnsafeProjection)GenerateUnsafeProjection$.MODULE$.generate(fullSchema, fullSchema);
        }
        StructType newSchema = new StructType((StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])requiredSchema.fields())).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                StructField f = (StructField)tuple2._1();
                int i = tuple2._2$mcI$sp();
                if (typeChangeInfos.containsKey(BoxesRunTime.boxToInteger((int)i))) {
                    return new StructField(f.name(), (DataType)((Pair)typeChangeInfos.get(BoxesRunTime.boxToInteger((int)i))).getRight(), f.nullable(), f.metadata());
                }
                return f;
            }
            throw new MatchError((Object)tuple2);
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class))));
        Seq newFullSchema = (Seq)schemaUtils.toAttributes(newSchema).$plus$plus(schemaUtils.toAttributes(partitionSchema), Seq$.MODULE$.canBuildFrom());
        Seq castSchema = (Seq)((TraversableLike)newFullSchema.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                Attribute attr = (Attribute)tuple2._1();
                int i = tuple2._2$mcI$sp();
                if (typeChangeInfos.containsKey(BoxesRunTime.boxToInteger((int)i))) {
                    DataType srcType = (DataType)((Pair)typeChangeInfos.get(BoxesRunTime.boxToInteger((int)i))).getRight();
                    DataType dstType = (DataType)((Pair)typeChangeInfos.get(BoxesRunTime.boxToInteger((int)i))).getLeft();
                    return HoodieParquetFileFormatHelper$.recursivelyCastExpressions$1((Expression)attr, srcType, dstType, timeZoneId, addedCastCache);
                }
                return attr;
            }
            throw new MatchError((Object)tuple2);
        }, Seq$.MODULE$.canBuildFrom());
        return (UnsafeProjection)GenerateUnsafeProjection$.MODULE$.generate((Object)castSchema, newFullSchema);
    }

    public static final /* synthetic */ boolean $anonfun$isDataTypeEqual$3(String[] commonFieldNames$1, StructField f) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])commonFieldNames$1)).contains((Object)f.name());
    }

    public static final /* synthetic */ boolean $anonfun$isDataTypeEqual$4(StructField x$3, StructField x$4) {
        return new StringOps(Predef$.MODULE$.augmentString(x$3.name())).$less((Object)x$4.name());
    }

    public static final /* synthetic */ boolean $anonfun$isDataTypeEqual$5(String[] commonFieldNames$1, StructField f) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])commonFieldNames$1)).contains((Object)f.name());
    }

    public static final /* synthetic */ boolean $anonfun$isDataTypeEqual$6(StructField x$5, StructField x$6) {
        return new StringOps(Predef$.MODULE$.augmentString(x$5.name())).$less((Object)x$6.name());
    }

    public static final /* synthetic */ boolean $anonfun$isDataTypeEqual$7(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            StructField requiredField = (StructField)tuple2._1();
            StructField fileFilteredField = (StructField)tuple2._2();
            return MODULE$.isDataTypeEqual(requiredField.dataType(), fileFilteredField.dataType());
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$generateUnsafeProjection$2(scala.collection.mutable.HashMap addedCastCache$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            StructField sf = (StructField)tuple2._1();
            StructField df = (StructField)tuple2._2();
            return HoodieParquetFileFormatHelper$.hasUnsupportedConversion$1(sf.dataType(), df.dataType(), addedCastCache$1);
        }
        throw new MatchError((Object)tuple2);
    }

    private static final boolean hasUnsupportedConversion$1(DataType src, DataType dst, scala.collection.mutable.HashMap addedCastCache$1) {
        return BoxesRunTime.unboxToBoolean((Object)addedCastCache$1.getOrElseUpdate((Object)new Tuple2((Object)src, (Object)dst), (Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            Tuple2 tuple2 = new Tuple2((Object)src, (Object)dst);
            if (tuple2 != null) {
                DataType dataType = (DataType)tuple2._1();
                DataType dataType2 = (DataType)tuple2._2();
                if (FloatType$.MODULE$.equals(dataType) && DoubleType$.MODULE$.equals(dataType2)) {
                    return true;
                }
            }
            if (tuple2 != null) {
                DataType dataType = (DataType)tuple2._1();
                DataType dataType3 = (DataType)tuple2._2();
                if (IntegerType$.MODULE$.equals(dataType) && DecimalType$.MODULE$.unapply(dataType3)) {
                    return true;
                }
            }
            if (tuple2 != null) {
                DataType dataType = (DataType)tuple2._1();
                DataType dataType4 = (DataType)tuple2._2();
                if (LongType$.MODULE$.equals(dataType) && DecimalType$.MODULE$.unapply(dataType4)) {
                    return true;
                }
            }
            if (tuple2 != null) {
                DataType dataType = (DataType)tuple2._1();
                DataType dataType5 = (DataType)tuple2._2();
                if (FloatType$.MODULE$.equals(dataType) && DecimalType$.MODULE$.unapply(dataType5)) {
                    return true;
                }
            }
            if (tuple2 != null) {
                DataType dataType = (DataType)tuple2._1();
                DataType dataType6 = (DataType)tuple2._2();
                if (DoubleType$.MODULE$.equals(dataType) && DecimalType$.MODULE$.unapply(dataType6)) {
                    return true;
                }
            }
            if (tuple2 != null) {
                DataType dataType = (DataType)tuple2._1();
                DataType dataType7 = (DataType)tuple2._2();
                if (StringType$.MODULE$.equals(dataType) && DecimalType$.MODULE$.unapply(dataType7)) {
                    return true;
                }
            }
            if (tuple2 != null) {
                DataType dataType = (DataType)tuple2._1();
                DataType dataType8 = (DataType)tuple2._2();
                if (StringType$.MODULE$.equals(dataType) && DateType$.MODULE$.equals(dataType8)) {
                    return true;
                }
            }
            if (tuple2 != null) {
                DataType dataType = (DataType)tuple2._1();
                DataType dataType9 = (DataType)tuple2._2();
                if (dataType instanceof StructType) {
                    StructType structType = (StructType)dataType;
                    StructField[] srcFields = structType.fields();
                    if (dataType9 instanceof StructType) {
                        StructType structType2 = (StructType)dataType9;
                        StructField[] dstFields = structType2.fields();
                        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])srcFields)).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])dstFields), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).exists((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)HoodieParquetFileFormatHelper$.$anonfun$generateUnsafeProjection$2(addedCastCache$1, x0$1)));
                    }
                }
            }
            if (tuple2 != null) {
                DataType dataType = (DataType)tuple2._1();
                DataType dataType10 = (DataType)tuple2._2();
                if (dataType instanceof ArrayType) {
                    ArrayType arrayType = (ArrayType)dataType;
                    DataType sElem = arrayType.elementType();
                    if (dataType10 instanceof ArrayType) {
                        ArrayType arrayType2 = (ArrayType)dataType10;
                        DataType dElem = arrayType2.elementType();
                        return HoodieParquetFileFormatHelper$.hasUnsupportedConversion$1(sElem, dElem, addedCastCache$1);
                    }
                }
            }
            if (tuple2 != null) {
                DataType dataType = (DataType)tuple2._1();
                DataType dataType11 = (DataType)tuple2._2();
                if (dataType instanceof MapType) {
                    MapType mapType = (MapType)dataType;
                    DataType sKey = mapType.keyType();
                    DataType sVal = mapType.valueType();
                    if (dataType11 instanceof MapType) {
                        MapType mapType2 = (MapType)dataType11;
                        DataType dKey = mapType2.keyType();
                        DataType dVal = mapType2.valueType();
                        return HoodieParquetFileFormatHelper$.hasUnsupportedConversion$1(sKey, dKey, addedCastCache$1) || HoodieParquetFileFormatHelper$.hasUnsupportedConversion$1(sVal, dVal, addedCastCache$1);
                    }
                }
            }
            return false;
        }));
    }

    private static final /* synthetic */ boolean needTimeZone$lzycompute$1(LazyBoolean needTimeZone$lzy$1, DataType srcType$1, DataType dstType$1) {
        boolean bl;
        LazyBoolean lazyBoolean = needTimeZone$lzy$1;
        synchronized (lazyBoolean) {
            bl = needTimeZone$lzy$1.initialized() ? needTimeZone$lzy$1.value() : needTimeZone$lzy$1.initialize(Cast$.MODULE$.needsTimeZone(srcType$1, dstType$1));
        }
        return bl;
    }

    private static final boolean needTimeZone$1(LazyBoolean needTimeZone$lzy$1, DataType srcType$1, DataType dstType$1) {
        if (needTimeZone$lzy$1.initialized()) {
            return needTimeZone$lzy$1.value();
        }
        return HoodieParquetFileFormatHelper$.needTimeZone$lzycompute$1(needTimeZone$lzy$1, srcType$1, dstType$1);
    }

    private static final Expression recursivelyCastExpressions$1(Expression expr, DataType srcType, DataType dstType, Option timeZoneId$1, scala.collection.mutable.HashMap addedCastCache$1) {
        LazyBoolean needTimeZone$lzy = new LazyBoolean();
        Tuple2 tuple2 = new Tuple2((Object)srcType, (Object)dstType);
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            DataType dataType2 = (DataType)tuple2._2();
            if (FloatType$.MODULE$.equals(dataType) && DoubleType$.MODULE$.equals(dataType2)) {
                Cast toStr = new Cast(expr, (DataType)StringType$.MODULE$, (Option)(HoodieParquetFileFormatHelper$.needTimeZone$1(needTimeZone$lzy, srcType, dstType) ? timeZoneId$1 : None$.MODULE$), Cast$.MODULE$.apply$default$4());
                return new Cast((Expression)toStr, dstType, (Option)(HoodieParquetFileFormatHelper$.needTimeZone$1(needTimeZone$lzy, srcType, dstType) ? timeZoneId$1 : None$.MODULE$), Cast$.MODULE$.apply$default$4());
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            DataType dec = (DataType)tuple2._2();
            if ((IntegerType$.MODULE$.equals(dataType) ? true : (LongType$.MODULE$.equals(dataType) ? true : (FloatType$.MODULE$.equals(dataType) ? true : DoubleType$.MODULE$.equals(dataType)))) && dec instanceof DecimalType) {
                DecimalType decimalType = (DecimalType)dec;
                Cast toStr = new Cast(expr, (DataType)StringType$.MODULE$, (Option)(HoodieParquetFileFormatHelper$.needTimeZone$1(needTimeZone$lzy, srcType, dstType) ? timeZoneId$1 : None$.MODULE$), Cast$.MODULE$.apply$default$4());
                return new Cast((Expression)toStr, (DataType)decimalType, (Option)(HoodieParquetFileFormatHelper$.needTimeZone$1(needTimeZone$lzy, srcType, dstType) ? timeZoneId$1 : None$.MODULE$), Cast$.MODULE$.apply$default$4());
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            DataType dec = (DataType)tuple2._2();
            if (StringType$.MODULE$.equals(dataType) && dec instanceof DecimalType) {
                DecimalType decimalType = (DecimalType)dec;
                return new Cast(expr, (DataType)decimalType, (Option)(HoodieParquetFileFormatHelper$.needTimeZone$1(needTimeZone$lzy, srcType, dstType) ? timeZoneId$1 : None$.MODULE$), Cast$.MODULE$.apply$default$4());
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            DataType dataType3 = (DataType)tuple2._2();
            if (StringType$.MODULE$.equals(dataType) && DateType$.MODULE$.equals(dataType3)) {
                return new Cast(expr, (DataType)DateType$.MODULE$, (Option)(HoodieParquetFileFormatHelper$.needTimeZone$1(needTimeZone$lzy, srcType, dstType) ? timeZoneId$1 : None$.MODULE$), Cast$.MODULE$.apply$default$4());
            }
        }
        if (tuple2 != null) {
            DataType s = (DataType)tuple2._1();
            DataType d = (DataType)tuple2._2();
            if (s instanceof StructType) {
                StructType structType;
                StructType structType2 = (StructType)s;
                if (d instanceof StructType && HoodieParquetFileFormatHelper$.hasUnsupportedConversion$1((DataType)structType2, (DataType)(structType = (StructType)d), addedCastCache$1)) {
                    Expression[] structFields = (Expression[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])structType2.fields())).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])structType.fields()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                        Tuple2 tuple2 = x0$1;
                        if (tuple2 != null) {
                            Tuple2 tuple22 = (Tuple2)tuple2._1();
                            int i = tuple2._2$mcI$sp();
                            if (tuple22 != null) {
                                StructField srcField = (StructField)tuple22._1();
                                StructField dstField = (StructField)tuple22._2();
                                GetStructField child = new GetStructField(expr, i, (Option)new Some((Object)dstField.name()));
                                return HoodieParquetFileFormatHelper$.recursivelyCastExpressions$1((Expression)child, srcField.dataType(), dstField.dataType(), timeZoneId$1, addedCastCache$1);
                            }
                        }
                        throw new MatchError((Object)tuple2);
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Expression.class)));
                    return new CreateNamedStruct((Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])structType.fields())).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])structFields), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).flatMap((Function1 & Serializable & scala.Serializable)x0$2 -> {
                        Tuple2 tuple2 = x0$2;
                        if (tuple2 != null) {
                            StructField f = (StructField)tuple2._1();
                            Expression c = (Expression)tuple2._2();
                            return (Seq)new .colon.colon((Object)Literal$.MODULE$.apply((Object)f.name()), (List)new .colon.colon((Object)c, (List)Nil$.MODULE$));
                        }
                        throw new MatchError((Object)tuple2);
                    }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit())));
                }
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            DataType dataType4 = (DataType)tuple2._2();
            if (dataType instanceof ArrayType) {
                ArrayType arrayType;
                DataType dElementType;
                ArrayType arrayType2 = (ArrayType)dataType;
                DataType sElementType = arrayType2.elementType();
                boolean containsNull = arrayType2.containsNull();
                if (dataType4 instanceof ArrayType && HoodieParquetFileFormatHelper$.hasUnsupportedConversion$1(sElementType, dElementType = (arrayType = (ArrayType)dataType4).elementType(), addedCastCache$1)) {
                    NamedLambdaVariable lambdaVar = new NamedLambdaVariable("element", sElementType, containsNull, NamedLambdaVariable$.MODULE$.apply$default$4(), NamedLambdaVariable$.MODULE$.apply$default$5());
                    Expression body = HoodieParquetFileFormatHelper$.recursivelyCastExpressions$1((Expression)lambdaVar, sElementType, dElementType, timeZoneId$1, addedCastCache$1);
                    LambdaFunction func = new LambdaFunction(body, (Seq)new .colon.colon((Object)lambdaVar, (List)Nil$.MODULE$), LambdaFunction$.MODULE$.apply$default$3());
                    return new ArrayTransform(expr, (Expression)func);
                }
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            DataType dataType5 = (DataType)tuple2._2();
            if (dataType instanceof MapType) {
                MapType mapType = (MapType)dataType;
                DataType sKeyType = mapType.keyType();
                DataType sValType = mapType.valueType();
                boolean vnull = mapType.valueContainsNull();
                if (dataType5 instanceof MapType) {
                    MapType mapType2 = (MapType)dataType5;
                    DataType dKeyType = mapType2.keyType();
                    DataType dValType = mapType2.valueType();
                    if (HoodieParquetFileFormatHelper$.hasUnsupportedConversion$1(sKeyType, dKeyType, addedCastCache$1) || HoodieParquetFileFormatHelper$.hasUnsupportedConversion$1(sValType, dValType, addedCastCache$1)) {
                        NamedLambdaVariable kv = new NamedLambdaVariable("kv", (DataType)new StructType().add("key", sKeyType, false).add("value", sValType, vnull), false, NamedLambdaVariable$.MODULE$.apply$default$4(), NamedLambdaVariable$.MODULE$.apply$default$5());
                        Expression newKey = HoodieParquetFileFormatHelper$.recursivelyCastExpressions$1((Expression)new GetStructField((Expression)kv, 0, GetStructField$.MODULE$.apply$default$3()), sKeyType, dKeyType, timeZoneId$1, addedCastCache$1);
                        Expression newVal = HoodieParquetFileFormatHelper$.recursivelyCastExpressions$1((Expression)new GetStructField((Expression)kv, 1, GetStructField$.MODULE$.apply$default$3()), sValType, dValType, timeZoneId$1, addedCastCache$1);
                        CreateNamedStruct entry = CreateStruct$.MODULE$.apply((Seq)new .colon.colon((Object)newKey, (List)new .colon.colon((Object)newVal, (List)Nil$.MODULE$)));
                        LambdaFunction func = new LambdaFunction((Expression)entry, (Seq)new .colon.colon((Object)kv, (List)Nil$.MODULE$), LambdaFunction$.MODULE$.apply$default$3());
                        ArrayTransform transformed = new ArrayTransform((Expression)new MapEntries(expr), (Expression)func);
                        return new MapFromEntries((Expression)transformed);
                    }
                }
            }
        }
        return new Cast(expr, dstType, (Option)(HoodieParquetFileFormatHelper$.needTimeZone$1(needTimeZone$lzy, srcType, dstType) ? timeZoneId$1 : None$.MODULE$), Cast$.MODULE$.apply$default$4());
    }

    private HoodieParquetFileFormatHelper$() {
        MODULE$ = this;
    }
}

