/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.parquet;

import java.util.List;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.Type;
import org.apache.parquet.schema.Types;
import scala.Function1;
import scala.None$;
import scala.Serializable;
import scala.Some;
import scala.collection.JavaConverters$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxesRunTime;

public final class HoodieParquetReadSupport$ {
    public static HoodieParquetReadSupport$ MODULE$;

    static {
        new HoodieParquetReadSupport$();
    }

    public Option<MessageType> $lessinit$greater$default$6() {
        return Option.empty();
    }

    public MessageType trimParquetSchema(MessageType requestedSchema, MessageType fileSchema) {
        Type[] trimmedFields = (Type[])((TraversableOnce)((TraversableLike)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(requestedSchema.getFields()).asScala()).map((Function1 & java.io.Serializable & Serializable)field -> {
            if (fileSchema.containsField(field.getName())) {
                return MODULE$.trimParquetType((Type)field, fileSchema.asGroupType().getType(field.getName()));
            }
            return new Some(field);
        }, Buffer$.MODULE$.canBuildFrom())).filter((Function1 & java.io.Serializable & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.isDefined()))).map((Function1 & java.io.Serializable & Serializable)x$2 -> (Type)x$2.get(), Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Type.class));
        return (MessageType)Types.buildMessage().addFields(trimmedFields).named(requestedSchema.getName());
    }

    private scala.Option<Type> trimParquetType(Type requestedType, Type fileType) {
        if (requestedType.equals((Object)fileType)) {
            return new Some((Object)requestedType);
        }
        Type type = requestedType;
        if (type instanceof GroupType) {
            GroupType groupType = (GroupType)type;
            ValidationUtils.checkState((!fileType.isPrimitive() ? 1 : 0) != 0, (String)"Group type provided by requested schema but existing type in the file is a primitive");
            GroupType fileTypeGroup = fileType.asGroupType();
            BooleanRef hasMatchingField = BooleanRef.create((boolean)false);
            List fields = (List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(groupType.getFields()).asScala()).map((Function1 & java.io.Serializable & Serializable)field -> {
                if (fileTypeGroup.containsField(field.getName())) {
                    hasMatchingField$1.elem = true;
                    return MODULE$.trimParquetType((Type)field, fileType.asGroupType().getType(field.getName()));
                }
                return new Some(field);
            }, Buffer$.MODULE$.canBuildFrom())).filter((Function1 & java.io.Serializable & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.isDefined()))).map((Function1 & java.io.Serializable & Serializable)x$4 -> (Type)x$4.get(), Buffer$.MODULE$.canBuildFrom())).asJava();
            if (hasMatchingField.elem && !fields.isEmpty()) {
                return new Some((Object)groupType.withNewFields(fields));
            }
            return None$.MODULE$;
        }
        return new Some((Object)requestedType);
    }

    private HoodieParquetReadSupport$() {
        MODULE$ = this;
    }
}

