/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi;

import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.SparkAdapterSupport;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.internal.schema.InternalSchema;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.storage.StoragePath;
import org.apache.parquet.schema.MessageType;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.execution.datasources.SparkColumnarFileReader;
import org.apache.spark.sql.hudi.SparkAdapter;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.types.StructType;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005=a\u0001B\u0003\u0007\u0001EA\u0001\"\n\u0001\u0003\u0002\u0003\u0006I\u0001\u0007\u0005\tM\u0001\u0011\t\u0011)A\u00051!)q\u0005\u0001C\u0001Q!)Q\u0006\u0001C!]\t\u0001S*\u001e7uSBdWmQ8mk6t\u0017M\u001d$jY\u00164uN]7biJ+\u0017\rZ3s\u0015\t9\u0001\"\u0001\u0003ik\u0012L'BA\u0005\u000b\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u00171\tQa\u001d9be.T!!\u0004\b\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005y\u0011aA8sO\u000e\u00011\u0003\u0002\u0001\u00131\u0001\u0002\"a\u0005\f\u000e\u0003QQ\u0011!F\u0001\u0006g\u000e\fG.Y\u0005\u0003/Q\u0011a!\u00118z%\u00164\u0007CA\r\u001f\u001b\u0005Q\"BA\u000e\u001d\u0003-!\u0017\r^1t_V\u00148-Z:\u000b\u0005uA\u0011!C3yK\u000e,H/[8o\u0013\ty\"DA\fTa\u0006\u00148nQ8mk6t\u0017M\u001d$jY\u0016\u0014V-\u00193feB\u0011\u0011eI\u0007\u0002E)\u0011q\u0001D\u0005\u0003I\t\u00121c\u00159be.\fE-\u00199uKJ\u001cV\u000f\u001d9peR\fQ\u0002]1scV,GOU3bI\u0016\u0014\u0018!C8sGJ+\u0017\rZ3s\u0003\u0019a\u0014N\\5u}Q\u0019\u0011f\u000b\u0017\u0011\u0005)\u0002Q\"\u0001\u0004\t\u000b\u0015\u001a\u0001\u0019\u0001\r\t\u000b\u0019\u001a\u0001\u0019\u0001\r\u0002\tI,\u0017\r\u001a\u000b\t_\u00053e\n\u00152n{B\u0019\u0001\u0007O\u001e\u000f\u0005E2dB\u0001\u001a6\u001b\u0005\u0019$B\u0001\u001b\u0011\u0003\u0019a$o\\8u}%\tQ#\u0003\u00028)\u00059\u0001/Y2lC\u001e,\u0017BA\u001d;\u0005!IE/\u001a:bi>\u0014(BA\u001c\u0015!\tat(D\u0001>\u0015\tq\u0004\"\u0001\u0005dCR\fG._:u\u0013\t\u0001UHA\u0006J]R,'O\\1m%><\b\"\u0002\"\u0005\u0001\u0004\u0019\u0015\u0001\u00024jY\u0016\u0004\"!\u0007#\n\u0005\u0015S\"a\u0004)beRLG/[8oK\u00124\u0015\u000e\\3\t\u000b\u001d#\u0001\u0019\u0001%\u0002\u001dI,\u0017/^5sK\u0012\u001c6\r[3nCB\u0011\u0011\nT\u0007\u0002\u0015*\u00111\nC\u0001\u0006if\u0004Xm]\u0005\u0003\u001b*\u0013!b\u0015;sk\u000e$H+\u001f9f\u0011\u0015yE\u00011\u0001I\u0003=\u0001\u0018M\u001d;ji&|gnU2iK6\f\u0007\"B)\u0005\u0001\u0004\u0011\u0016!E5oi\u0016\u0014h.\u00197TG\",W.Y(qiB\u00191\u000b\u0017.\u000e\u0003QS!!\u0016,\u0002\tU$\u0018\u000e\u001c\u0006\u0003/\n\naaY8n[>t\u0017BA-U\u0005\u0019y\u0005\u000f^5p]B\u00111\fY\u0007\u00029*\u0011QLX\u0001\u0007g\u000eDW-\\1\u000b\u0005}\u0013\u0013\u0001C5oi\u0016\u0014h.\u00197\n\u0005\u0005d&AD%oi\u0016\u0014h.\u00197TG\",W.\u0019\u0005\u0006G\u0012\u0001\r\u0001Z\u0001\bM&dG/\u001a:t!\r\u0001TmZ\u0005\u0003Mj\u00121aU3r!\tA7.D\u0001j\u0015\tQ\u0007\"A\u0004t_V\u00148-Z:\n\u00051L'A\u0002$jYR,'\u000fC\u0003o\t\u0001\u0007q.A\u0006ti>\u0014\u0018mZ3D_:4\u0007c\u00019tk6\t\u0011O\u0003\u0002sE\u000591\u000f^8sC\u001e,\u0017B\u0001;r\u0005Q\u0019Fo\u001c:bO\u0016\u001cuN\u001c4jOV\u0014\u0018\r^5p]B\u0011ao_\u0007\u0002o*\u0011\u00010_\u0001\u0005G>tgM\u0003\u0002{\u0019\u00051\u0001.\u00193p_BL!\u0001`<\u0003\u001b\r{gNZ5hkJ\fG/[8o\u0011\u001dqH\u0001%AA\u0002}\fa\u0002^1cY\u0016\u001c6\r[3nC>\u0003H\u000f\u0005\u0003T1\u0006\u0005\u0001\u0003BA\u0002\u0003\u0017i!!!\u0002\u000b\u0007u\u000b9AC\u0002\u0002\n1\tq\u0001]1scV,G/\u0003\u0003\u0002\u000e\u0005\u0015!aC'fgN\fw-\u001a+za\u0016\u0004")
public class MultipleColumnarFileFormatReader
implements SparkColumnarFileReader,
SparkAdapterSupport {
    private final SparkColumnarFileReader parquetReader;
    private final SparkColumnarFileReader orcReader;
    private SparkAdapter sparkAdapter;
    private volatile boolean bitmap$0;

    @Override
    public Option<MessageType> read$default$7() {
        return SparkColumnarFileReader.read$default$7$(this);
    }

    private SparkAdapter sparkAdapter$lzycompute() {
        MultipleColumnarFileFormatReader multipleColumnarFileFormatReader = this;
        synchronized (multipleColumnarFileFormatReader) {
            if (!this.bitmap$0) {
                this.sparkAdapter = SparkAdapterSupport.sparkAdapter$(this);
                this.bitmap$0 = true;
            }
        }
        return this.sparkAdapter;
    }

    @Override
    public SparkAdapter sparkAdapter() {
        if (!this.bitmap$0) {
            return this.sparkAdapter$lzycompute();
        }
        return this.sparkAdapter;
    }

    @Override
    public Iterator<InternalRow> read(PartitionedFile file, StructType requiredSchema, StructType partitionSchema, Option<InternalSchema> internalSchemaOpt, Seq<Filter> filters, StorageConfiguration<Configuration> storageConf, Option<MessageType> tableSchemaOpt) {
        StoragePath filePath = this.sparkAdapter().getSparkPartitionedFileUtils().getPathFromPartitionedFile(file);
        HoodieFileFormat fileFormat = HoodieFileFormat.fromFileExtension((String)filePath.getFileExtension());
        HoodieFileFormat hoodieFileFormat = fileFormat;
        if (HoodieFileFormat.PARQUET.equals(hoodieFileFormat)) {
            return this.parquetReader.read(file, requiredSchema, partitionSchema, internalSchemaOpt, filters, storageConf, tableSchemaOpt);
        }
        if (HoodieFileFormat.ORC.equals(hoodieFileFormat)) {
            return this.orcReader.read(file, requiredSchema, partitionSchema, internalSchemaOpt, filters, storageConf, tableSchemaOpt);
        }
        throw new IllegalArgumentException(new StringBuilder(34).append("Unsupported file format for file: ").append(filePath).toString());
    }

    public MultipleColumnarFileFormatReader(SparkColumnarFileReader parquetReader, SparkColumnarFileReader orcReader) {
        this.parquetReader = parquetReader;
        this.orcReader = orcReader;
        SparkAdapterSupport.$init$(this);
    }
}

