/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.execution;

import java.io.Serializable;
import org.apache.hudi.SparkAdapterSupport;
import org.apache.spark.rdd.PartitionPruningRDD;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection$;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.hudi.SparkAdapter;
import org.apache.spark.sql.hudi.execution.RangeSample$;
import org.apache.spark.util.random.SamplingUtils$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product2;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t=a\u0001\u0002\u000b\u0016\u0001\tB\u0001B\r\u0001\u0003\u0002\u0003\u0006Ia\r\u0005\tm\u0001\u0011\t\u0011)A\u0005o!A!\u000b\u0001BA\u0002\u0013%1\u000b\u0003\u0005X\u0001\t\u0005\r\u0011\"\u0003Y\u0011!q\u0006A!A!B\u0013!\u0006\u0002C0\u0001\u0005\u000b\u0007I\u0011\u00011\t\u0011\u0005\u0004!\u0011!Q\u0001\nMB\u0001B\u0019\u0001\u0003\u0004\u0003\u0006Ya\u0019\u0005\u0006S\u0002!\tA\u001b\u0005\u0006o\u0002!\t\u0001\u001f\u0005\b\u0003\u001f\u0001A\u0011AA\t\u0011\u001d\t\u0019\u0006\u0001C\u0001\u0003+Bq!!(\u0001\t\u0003\tyjB\u0005\u0002JV\t\t\u0011#\u0001\u0002L\u001aAA#FA\u0001\u0012\u0003\ti\r\u0003\u0004j\u001f\u0011\u0005\u0011q\u001a\u0005\n\u0003#|\u0011\u0013!C\u0001\u0003'D\u0011\"a<\u0010#\u0003%\t!!=\t\u0013\u0005mx\"!A\u0005\n\u0005u(a\u0003*b]\u001e,7+Y7qY\u0016T!AF\f\u0002\u0013\u0015DXmY;uS>t'B\u0001\r\u001a\u0003\u0011AW\u000fZ5\u000b\u0005iY\u0012aA:rY*\u0011A$H\u0001\u0006gB\f'o\u001b\u0006\u0003=}\ta!\u00199bG\",'\"\u0001\u0011\u0002\u0007=\u0014xm\u0001\u0001\u0016\u0007\rJ\u0005k\u0005\u0003\u0001I)j\u0003CA\u0013)\u001b\u00051#\"A\u0014\u0002\u000bM\u001c\u0017\r\\1\n\u0005%2#AB!osJ+g\r\u0005\u0002&W%\u0011AF\n\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\t\u0003]Aj\u0011a\f\u0006\u00031uI!!M\u0018\u0003'M\u0003\u0018M]6BI\u0006\u0004H/\u001a:TkB\u0004xN\u001d;\u0002\u0015i,enY8eK:+X\u000e\u0005\u0002&i%\u0011QG\n\u0002\u0004\u0013:$\u0018a\u0001:eIB\u0012\u0001h\u0010\t\u0004smjT\"\u0001\u001e\u000b\u0005YZ\u0012B\u0001\u001f;\u0005\r\u0011F\t\u0012\t\u0003}}b\u0001\u0001B\u0005A\u0005\u0005\u0005\t\u0011!B\u0001\u0003\n\u0019q\fJ\u0019\u0012\u0005\t+\u0005CA\u0013D\u0013\t!eEA\u0004O_RD\u0017N\\4\u0011\t\u00152\u0005jT\u0005\u0003\u000f\u001a\u0012\u0001\u0002\u0015:pIV\u001cGO\r\t\u0003}%#QA\u0013\u0001C\u0002-\u0013\u0011aS\t\u0003\u00052\u0003\"!J'\n\u000593#aA!osB\u0011a\b\u0015\u0003\u0006#\u0002\u0011\ra\u0013\u0002\u0002-\u00061\u0011m]2f]\u0012,\u0012\u0001\u0016\t\u0003KUK!A\u0016\u0014\u0003\u000f\t{w\u000e\\3b]\u0006Q\u0011m]2f]\u0012|F%Z9\u0015\u0005ec\u0006CA\u0013[\u0013\tYfE\u0001\u0003V]&$\bbB/\u0005\u0003\u0003\u0005\r\u0001V\u0001\u0004q\u0012\n\u0014aB1tG\u0016tG\rI\u0001\u001dg\u0006l\u0007\u000f\\3Q_&tGo\u001d)feB\u000b'\u000f^5uS>t\u0007*\u001b8u+\u0005\u0019\u0014!H:b[BdW\rU8j]R\u001c\b+\u001a:QCJ$\u0018\u000e^5p]\"Kg\u000e\u001e\u0011\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$\u0013\u0007E\u0002eO\"k\u0011!\u001a\u0006\u0003M\u001a\nqA]3gY\u0016\u001cG/\u0003\u0002iK\nA1\t\\1tgR\u000bw-\u0001\u0004=S:LGO\u0010\u000b\u0006W>\u0004XO\u001e\u000b\u0003Y:\u0004B!\u001c\u0001I\u001f6\tQ\u0003C\u0003c\u0013\u0001\u000f1\rC\u00033\u0013\u0001\u00071\u0007C\u00037\u0013\u0001\u0007\u0011\u000f\r\u0002siB\u0019\u0011hO:\u0011\u0005y\"H!\u0003!q\u0003\u0003\u0005\tQ!\u0001B\u0011\u001d\u0011\u0016\u0002%AA\u0002QCqaX\u0005\u0011\u0002\u0003\u00071'\u0001\bhKR\u0014\u0016M\\4f\u0005>,h\u000eZ:\u0015\u0003e\u0004BA_@\u0002\u00045\t1P\u0003\u0002}{\u00069Q.\u001e;bE2,'B\u0001@'\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0004\u0003\u0003Y(aC!se\u0006L()\u001e4gKJ\u0004b!JA\u0003\u0011\u0006%\u0011bAA\u0004M\t1A+\u001e9mKJ\u00022!JA\u0006\u0013\r\tiA\n\u0002\u0006\r2|\u0017\r^\u0001\u000fI\u0016$XM]7j]\u0016\u0014u.\u001e8e+\u0011\t\u0019\"a\b\u0015\u0011\u0005U\u00111IA&\u0003\u001f\"b!a\u0006\u0002\"\u0005u\u0002#B\u0013\u0002\u001a\u0005u\u0011bAA\u000eM\t)\u0011I\u001d:bsB\u0019a(a\b\u0005\u000b)[!\u0019A&\t\u0013\u0005\r2\"!AA\u0004\u0005\u0015\u0012AC3wS\u0012,gnY3%eA1\u0011qEA\u001c\u0003;qA!!\u000b\u000249!\u00111FA\u0019\u001b\t\tiCC\u0002\u00020\u0005\na\u0001\u0010:p_Rt\u0014\"A\u0014\n\u0007\u0005Ub%A\u0004qC\u000e\\\u0017mZ3\n\t\u0005e\u00121\b\u0002\t\u001fJ$WM]5oO*\u0019\u0011Q\u0007\u0014\t\u0013\u0005}2\"!AA\u0004\u0005\u0005\u0013AC3wS\u0012,gnY3%gA!AmZA\u000f\u0011\u001d\t)e\u0003a\u0001\u0003\u000f\n!bY1oI&$\u0017\r^3t!\u0011Qx0!\u0013\u0011\u000f\u0015\n)!!\b\u0002\n!1\u0011QJ\u0006A\u0002M\n!\u0002]1si&$\u0018n\u001c8t\u0011\u001d\t\tf\u0003a\u0001\u0003K\t\u0001b\u001c:eKJLgnZ\u0001\u0013I\u0016$XM]7j]\u0016\u0014vn\u001e\"pk:$7/\u0006\u0003\u0002X\u0005]DCCA-\u0003\u007f\n))a\"\u0002\u0012R1\u00111LA8\u0003s\u0002R!JA\r\u0003;\u0002R!JA\r\u0003?\u0002B!!\u0019\u0002l5\u0011\u00111\r\u0006\u0005\u0003K\n9'A\u0006fqB\u0014Xm]:j_:\u001c(bAA53\u0005A1-\u0019;bYf\u001cH/\u0003\u0003\u0002n\u0005\r$!C+og\u00064WMU8x\u0011%\t\t\bDA\u0001\u0002\b\t\u0019(\u0001\u0006fm&$WM\\2fIQ\u0002b!a\n\u00028\u0005U\u0004c\u0001 \u0002x\u0011)!\n\u0004b\u0001\u0017\"I\u00111\u0010\u0007\u0002\u0002\u0003\u000f\u0011QP\u0001\u000bKZLG-\u001a8dK\u0012*\u0004\u0003\u00023h\u0003kBq!!\u0012\r\u0001\u0004\t\t\t\u0005\u0003{\u007f\u0006\r\u0005cB\u0013\u0002\u0006\u0005U\u0014\u0011\u0002\u0005\u0007\u0003\u001bb\u0001\u0019A\u001a\t\u000f\u0005%E\u00021\u0001\u0002\f\u0006IqN\u001d3fe&twm\u001d\t\u0007\u0003O\ti)a\u001d\n\t\u0005=\u00151\b\u0002\u0004'\u0016\f\bbBAJ\u0019\u0001\u0007\u0011QS\u0001\u000bCR$(/\u001b2vi\u0016\u001c\bCBA\u0014\u0003\u001b\u000b9\n\u0005\u0003\u0002b\u0005e\u0015\u0002BAN\u0003G\u0012\u0011\"\u0011;ue&\u0014W\u000f^3\u0002\rM\\W\r^2i+\u0011\t\t+!/\u0015\r\u0005\r\u0016\u0011YAc)\u0011\t)+a/\u0011\u000f\u0015\n)!a*\u0002.B\u0019Q%!+\n\u0007\u0005-fE\u0001\u0003M_:<\u0007#B\u0013\u0002\u001a\u0005=\u0006\u0003C\u0013\u00022N\n9+!.\n\u0007\u0005MfE\u0001\u0004UkBdWm\r\t\u0006K\u0005e\u0011q\u0017\t\u0004}\u0005eF!\u0002&\u000e\u0005\u0004Y\u0005\"CA_\u001b\u0005\u0005\t9AA`\u0003))g/\u001b3f]\u000e,GE\u000e\t\u0005I\u001e\f9\f\u0003\u00047\u001b\u0001\u0007\u00111\u0019\t\u0005sm\n9\f\u0003\u0004\u0002H6\u0001\raM\u0001\u0017g\u0006l\u0007\u000f\\3TSj,\u0007+\u001a:QCJ$\u0018\u000e^5p]\u0006Y!+\u00198hKN\u000bW\u000e\u001d7f!\tiwbE\u0002\u0010I)\"\"!a3\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00134+\u0019\t).a;\u0002nV\u0011\u0011q\u001b\u0016\u0004)\u0006e7FAAn!\u0011\ti.a:\u000e\u0005\u0005}'\u0002BAq\u0003G\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\u0015h%\u0001\u0006b]:|G/\u0019;j_:LA!!;\u0002`\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0005\u000b)\u000b\"\u0019A&\u0005\u000bE\u000b\"\u0019A&\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00135+\u0019\t\u00190a>\u0002zV\u0011\u0011Q\u001f\u0016\u0004g\u0005eG!\u0002&\u0013\u0005\u0004YE!B)\u0013\u0005\u0004Y\u0015a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!a@\u0011\t\t\u0005!1B\u0007\u0003\u0005\u0007QAA!\u0002\u0003\b\u0005!A.\u00198h\u0015\t\u0011I!\u0001\u0003kCZ\f\u0017\u0002\u0002B\u0007\u0005\u0007\u0011aa\u00142kK\u000e$\b")
public class RangeSample<K, V>
implements scala.Serializable,
SparkAdapterSupport {
    private final int zEncodeNum;
    private final RDD<? extends Product2<K, V>> rdd;
    private boolean ascend;
    private final int samplePointsPerPartitionHint;
    private final ClassTag<K> evidence$1;
    private SparkAdapter sparkAdapter;
    private volatile boolean bitmap$0;

    public static <K, V> int $lessinit$greater$default$4() {
        return RangeSample$.MODULE$.$lessinit$greater$default$4();
    }

    public static <K, V> boolean $lessinit$greater$default$3() {
        return RangeSample$.MODULE$.$lessinit$greater$default$3();
    }

    private SparkAdapter sparkAdapter$lzycompute() {
        RangeSample rangeSample = this;
        synchronized (rangeSample) {
            if (!this.bitmap$0) {
                this.sparkAdapter = SparkAdapterSupport.sparkAdapter$(this);
                this.bitmap$0 = true;
            }
        }
        return this.sparkAdapter;
    }

    @Override
    public SparkAdapter sparkAdapter() {
        if (!this.bitmap$0) {
            return this.sparkAdapter$lzycompute();
        }
        return this.sparkAdapter;
    }

    private boolean ascend() {
        return this.ascend;
    }

    private void ascend_$eq(boolean x$1) {
        this.ascend = x$1;
    }

    public int samplePointsPerPartitionHint() {
        return this.samplePointsPerPartitionHint;
    }

    public ArrayBuffer<Tuple2<K, Object>> getRangeBounds() {
        BoxedUnit boxedUnit;
        if (this.zEncodeNum <= 1) {
            return (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        }
        double sampleSize = scala.math.package$.MODULE$.min((double)this.samplePointsPerPartitionHint() * (double)this.zEncodeNum, 1000000.0);
        int sampleSizePerPartition = (int)scala.math.package$.MODULE$.ceil(3.0 * sampleSize / (double)this.rdd.partitions().length);
        Tuple2<Object, Tuple3<Object, Object, Object>[]> tuple2 = this.sketch(this.rdd.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1._1(), this.evidence$1), sampleSizePerPartition, this.evidence$1);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        long numItems = tuple2._1$mcJ$sp();
        Tuple3[] sketched = (Tuple3[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToLong((long)numItems), (Object)sketched);
        long numItems2 = tuple22._1$mcJ$sp();
        Tuple3[] sketched2 = (Tuple3[])tuple22._2();
        if (numItems2 == 0L) {
            return (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        }
        double fraction = scala.math.package$.MODULE$.min(sampleSize / (double)scala.math.package$.MODULE$.max(numItems2, 1L), 1.0);
        ArrayBuffer candidates = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        Set imbalancedPartitions = Set$.MODULE$.empty();
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sketched2)).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple3 tuple3 = x0$1;
            if (tuple3 != null) {
                int idx = BoxesRunTime.unboxToInt((Object)tuple3._1());
                long n = BoxesRunTime.unboxToLong((Object)tuple3._2());
                Object sample = tuple3._3();
                if (fraction * (double)n > (double)sampleSizePerPartition) {
                    return imbalancedPartitions.$plus$eq((Object)BoxesRunTime.boxToInteger((int)idx));
                }
                float weight = (float)((double)n / (double)ScalaRunTime$.MODULE$.array_length(sample));
                Predef$.MODULE$.genericArrayOps(sample).foreach((Function1 & Serializable & scala.Serializable)key -> candidates.$plus$eq((Object)new Tuple2(key, (Object)BoxesRunTime.boxToFloat((float)weight))));
                return BoxedUnit.UNIT;
            }
            throw new MatchError((Object)tuple3);
        });
        if (imbalancedPartitions.nonEmpty()) {
            PartitionPruningRDD imbalanced = new PartitionPruningRDD(this.rdd.map((Function1 & Serializable & scala.Serializable)x$3 -> x$3._1(), this.evidence$1), (Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)elem -> imbalancedPartitions.contains((Object)BoxesRunTime.boxToInteger((int)elem)), this.evidence$1);
            int seed = scala.util.hashing.package$.MODULE$.byteswap32(-this.rdd.id() - 1);
            Object reSampled = imbalanced.sample(false, fraction, (long)seed).collect();
            float weight = (float)(1.0 / fraction);
            boxedUnit = candidates.$plus$plus$eq((TraversableOnce)Predef$.MODULE$.genericArrayOps(reSampled).map((Function1 & Serializable & scala.Serializable)x -> new Tuple2(x, (Object)BoxesRunTime.boxToFloat((float)weight)), Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit())));
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return candidates;
    }

    public <K> Object determineBound(ArrayBuffer<Tuple2<K, Object>> candidates, int partitions, Ordering<K> ordering, Ordering<K> evidence$2, ClassTag<K> evidence$3) {
        ArrayBuffer ordered = (ArrayBuffer)candidates.sortBy((Function1 & Serializable & scala.Serializable)x$4 -> x$4._1(), ordering);
        int numCandidates = ordered.size();
        double sumWeights = BoxesRunTime.unboxToDouble((Object)((TraversableOnce)ordered.map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToDouble((double)RangeSample.$anonfun$determineBound$2(x$5)), ArrayBuffer$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
        double step = sumWeights / (double)partitions;
        double cumWeight = 0.0;
        double target = step;
        ArrayBuffer bounds = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        int j = 0;
        Option previousBound = Option$.MODULE$.empty();
        for (int i = 0; i < numCandidates && j < partitions - 1; ++i) {
            Tuple2 tuple2 = (Tuple2)ordered.apply(i);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Object key = tuple2._1();
            float weight = BoxesRunTime.unboxToFloat((Object)tuple2._2());
            Tuple2 tuple22 = new Tuple2(key, (Object)BoxesRunTime.boxToFloat((float)weight));
            Object key2 = tuple22._1();
            float weight2 = BoxesRunTime.unboxToFloat((Object)tuple22._2());
            cumWeight += (double)weight2;
            if (!(cumWeight >= target) || !previousBound.isEmpty() && !ordering.gt(key2, previousBound.get())) continue;
            bounds.$plus$eq(key2);
            target += step;
            ++j;
            previousBound = new Some(key2);
        }
        return bounds.toArray(evidence$3);
    }

    public <K> UnsafeRow[][] determineRowBounds(ArrayBuffer<Tuple2<K, Object>> candidates, int partitions, Seq<Ordering<K>> orderings, Seq<Attribute> attributes, Ordering<K> evidence$4, ClassTag<K> evidence$5) {
        return (UnsafeRow[][])((TraversableOnce)((TraversableLike)orderings.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Ordering ordering = (Ordering)tuple2._1();
                int index = tuple2._2$mcI$sp();
                ArrayBuffer ordered = (ArrayBuffer)candidates.sortBy((Function1 & Serializable & scala.Serializable)x$7 -> x$7._1(), ordering);
                int numCandidates = ordered.size();
                double sumWeights = BoxesRunTime.unboxToDouble((Object)((TraversableOnce)ordered.map((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToDouble((double)RangeSample.$anonfun$determineRowBounds$3(x$8)), ArrayBuffer$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
                double step = sumWeights / (double)partitions;
                double cumWeight = 0.0;
                double target = step;
                ArrayBuffer bounds = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
                int j = 0;
                Option previousBound = Option$.MODULE$.empty();
                for (int i = 0; i < numCandidates && j < partitions - 1; ++i) {
                    Tuple2 tuple22 = (Tuple2)ordered.apply(i);
                    if (tuple22 == null) {
                        throw new MatchError((Object)tuple22);
                    }
                    Object key = tuple22._1();
                    float weight = BoxesRunTime.unboxToFloat((Object)tuple22._2());
                    Tuple2 tuple23 = new Tuple2(key, (Object)BoxesRunTime.boxToFloat((float)weight));
                    Object key2 = tuple23._1();
                    float weight2 = BoxesRunTime.unboxToFloat((Object)tuple23._2());
                    cumWeight += (double)weight2;
                    if (!(cumWeight >= target) || !previousBound.isEmpty() && !ordering.gt(key2, previousBound.get())) continue;
                    bounds.$plus$eq(key2);
                    target += step;
                    ++j;
                    previousBound = new Some(key2);
                }
                UnsafeProjection project = UnsafeProjection$.MODULE$.create((Seq)new .colon.colon((Object)((Attribute)attributes.apply(index)), (List)Nil$.MODULE$), attributes);
                return (UnsafeRow[])((TraversableOnce)bounds.map((Function1 & Serializable & scala.Serializable)bound -> {
                    UnsafeRow row = (UnsafeRow)bound;
                    return project.apply((InternalRow)row).copy();
                }, ArrayBuffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(UnsafeRow.class));
            }
            throw new MatchError((Object)tuple2);
        }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(UnsafeRow.class)));
    }

    public <K> Tuple2<Object, Tuple3<Object, Object, Object>[]> sketch(RDD<K> rdd, int sampleSizePerPartition, ClassTag<K> evidence$6) {
        int shift = rdd.id();
        Tuple3[] sketched = (Tuple3[])rdd.mapPartitionsWithIndex((Function2 & Serializable & scala.Serializable)(idx, iter) -> RangeSample.$anonfun$sketch$1(shift, sampleSizePerPartition, evidence$6, BoxesRunTime.unboxToInt((Object)idx), iter), rdd.mapPartitionsWithIndex$default$2(), ClassTag$.MODULE$.apply(Tuple3.class)).collect();
        long numItems = BoxesRunTime.unboxToLong((Object)new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps((long[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sketched)).map((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToLong((long)RangeSample.$anonfun$sketch$2(x$11)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long())))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        return new Tuple2((Object)BoxesRunTime.boxToLong((long)numItems), (Object)sketched);
    }

    public static final /* synthetic */ double $anonfun$determineBound$2(Tuple2 x$5) {
        return BoxesRunTime.unboxToFloat((Object)x$5._2());
    }

    public static final /* synthetic */ double $anonfun$determineRowBounds$3(Tuple2 x$8) {
        return BoxesRunTime.unboxToFloat((Object)x$8._2());
    }

    public static final /* synthetic */ Iterator $anonfun$sketch$1(int shift$1, int sampleSizePerPartition$2, ClassTag evidence$6$1, int idx, Iterator iter) {
        int seed = scala.util.hashing.package$.MODULE$.byteswap32(idx ^ shift$1 << 16);
        Tuple2 tuple2 = SamplingUtils$.MODULE$.reservoirSampleAndCount(iter, sampleSizePerPartition$2, (long)seed, evidence$6$1);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Object sample = tuple2._1();
        long n = tuple2._2$mcJ$sp();
        Tuple2 tuple22 = new Tuple2(sample, (Object)BoxesRunTime.boxToLong((long)n));
        Object sample2 = tuple22._1();
        long n2 = tuple22._2$mcJ$sp();
        return package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)BoxesRunTime.boxToInteger((int)idx), (Object)BoxesRunTime.boxToLong((long)n2), sample2)}));
    }

    public static final /* synthetic */ long $anonfun$sketch$2(Tuple3 x$11) {
        return BoxesRunTime.unboxToLong((Object)x$11._2());
    }

    public RangeSample(int zEncodeNum, RDD<? extends Product2<K, V>> rdd, boolean ascend, int samplePointsPerPartitionHint, ClassTag<K> evidence$1) {
        this.zEncodeNum = zEncodeNum;
        this.rdd = rdd;
        this.ascend = ascend;
        this.samplePointsPerPartitionHint = samplePointsPerPartitionHint;
        this.evidence$1 = evidence$1;
        SparkAdapterSupport.$init$(this);
        Predef$.MODULE$.require(zEncodeNum >= 0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(51).append("Number of zEncodeNum cannot be negative but found ").append($this.zEncodeNum).append(".").toString());
        Predef$.MODULE$.require(samplePointsPerPartitionHint > 0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(61).append("Sample points per partition must be greater than 0 but found ").append(this.samplePointsPerPartitionHint()).toString());
    }
}

