/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi;

import java.nio.ByteBuffer;
import org.apache.avro.Conversions;
import org.apache.avro.LogicalType;
import org.apache.avro.generic.GenericData;
import org.apache.hudi.AvroConversionUtils$;
import org.apache.hudi.avro.model.BooleanWrapper;
import org.apache.hudi.avro.model.BytesWrapper;
import org.apache.hudi.avro.model.DateWrapper;
import org.apache.hudi.avro.model.DecimalWrapper;
import org.apache.hudi.avro.model.DoubleWrapper;
import org.apache.hudi.avro.model.FloatWrapper;
import org.apache.hudi.avro.model.HoodieMetadataColumnStats;
import org.apache.hudi.avro.model.IntWrapper;
import org.apache.hudi.avro.model.LongWrapper;
import org.apache.hudi.avro.model.StringWrapper;
import org.apache.hudi.avro.model.TimeMicrosWrapper;
import org.apache.hudi.avro.model.TimestampMicrosWrapper;
import org.apache.hudi.common.util.BinaryUtil;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.Metadata$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampType$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Set;
import scala.runtime.BoxesRunTime;

public final class ColumnStatsIndexSupport$ {
    public static final ColumnStatsIndexSupport$ MODULE$;
    private final Set<String> expectedAvroSchemaValues;
    private final Seq<String> org$apache$hudi$ColumnStatsIndexSupport$$targetColumnStatsIndexColumns;
    private final StructType org$apache$hudi$ColumnStatsIndexSupport$$columnStatsRecordStructType;
    private final Conversions.DecimalConversion decConv;

    static {
        new ColumnStatsIndexSupport$();
    }

    private Set<String> expectedAvroSchemaValues() {
        return this.expectedAvroSchemaValues;
    }

    public Seq<String> org$apache$hudi$ColumnStatsIndexSupport$$targetColumnStatsIndexColumns() {
        return this.org$apache$hudi$ColumnStatsIndexSupport$$targetColumnStatsIndexColumns;
    }

    public StructType org$apache$hudi$ColumnStatsIndexSupport$$columnStatsRecordStructType() {
        return this.org$apache$hudi$ColumnStatsIndexSupport$$columnStatsRecordStructType;
    }

    public StructType composeIndexSchema(Seq<String> targetColumnNames, StructType tableSchema) {
        StructField fileNameField = new StructField("fileName", (DataType)StringType$.MODULE$, true, Metadata$.MODULE$.empty());
        StructField valueCountField = new StructField("valueCount", (DataType)LongType$.MODULE$, true, Metadata$.MODULE$.empty());
        Seq targetFields = (Seq)targetColumnNames.map((Function1)new Serializable(tableSchema){
            public static final long serialVersionUID = 0L;
            private final StructType tableSchema$1;

            public final StructField apply(String colName) {
                return (StructField)Predef$.MODULE$.refArrayOps((Object[])this.tableSchema$1.fields()).find((Function1)new Serializable(this, colName){
                    public static final long serialVersionUID = 0L;
                    private final String colName$1;

                    public final boolean apply(StructField f) {
                        String string = f.name();
                        String string2 = this.colName$1;
                        return !(string != null ? !string.equals(string2) : string2 != null);
                    }
                    {
                        this.colName$1 = colName$1;
                    }
                }).get();
            }
            {
                this.tableSchema$1 = tableSchema$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
        return StructType$.MODULE$.apply((Seq)targetFields.foldLeft((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{fileNameField, valueCountField})), (Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Seq<StructField> apply(Seq<StructField> x0$3, StructField x1$2) {
                Tuple2 tuple2 = new Tuple2(x0$3, (Object)x1$2);
                if (tuple2 != null) {
                    Seq acc = (Seq)tuple2._1();
                    StructField field = (StructField)tuple2._2();
                    Seq seq = (Seq)acc.$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{ColumnStatsIndexSupport$.MODULE$.org$apache$hudi$ColumnStatsIndexSupport$$composeColumnStatStructType(field.name(), "minValue", field.dataType()), ColumnStatsIndexSupport$.MODULE$.org$apache$hudi$ColumnStatsIndexSupport$$composeColumnStatStructType(field.name(), "maxValue", field.dataType()), ColumnStatsIndexSupport$.MODULE$.org$apache$hudi$ColumnStatsIndexSupport$$composeColumnStatStructType(field.name(), "nullCount", (DataType)LongType$.MODULE$)})), Seq$.MODULE$.canBuildFrom());
                    return seq;
                }
                throw new MatchError((Object)tuple2);
            }
        }));
    }

    public String getMinColumnNameFor(String colName) {
        return this.org$apache$hudi$ColumnStatsIndexSupport$$formatColName(colName, "minValue");
    }

    public String getMaxColumnNameFor(String colName) {
        return this.org$apache$hudi$ColumnStatsIndexSupport$$formatColName(colName, "maxValue");
    }

    public String getNullCountColumnNameFor(String colName) {
        return this.org$apache$hudi$ColumnStatsIndexSupport$$formatColName(colName, "nullCount");
    }

    public String getValueCountColumnNameFor() {
        return "valueCount";
    }

    public String org$apache$hudi$ColumnStatsIndexSupport$$formatColName(String col, String statName) {
        return String.format("%s_%s", col, statName);
    }

    public StructField org$apache$hudi$ColumnStatsIndexSupport$$composeColumnStatStructType(String col, String statName, DataType dataType) {
        return new StructField(this.org$apache$hudi$ColumnStatsIndexSupport$$formatColName(col, statName), dataType, true, Metadata$.MODULE$.empty());
    }

    public Object org$apache$hudi$ColumnStatsIndexSupport$$tryUnpackValueWrapper(Object valueWrapper) {
        block14: {
            Object object;
            block3: {
                Object object2;
                block13: {
                    block12: {
                        block11: {
                            block10: {
                                block9: {
                                    block8: {
                                        block7: {
                                            block6: {
                                                block5: {
                                                    block4: {
                                                        block2: {
                                                            object2 = valueWrapper;
                                                            if (!(object2 instanceof BooleanWrapper)) break block2;
                                                            BooleanWrapper booleanWrapper = (BooleanWrapper)object2;
                                                            object = booleanWrapper.getValue();
                                                            break block3;
                                                        }
                                                        if (!(object2 instanceof IntWrapper)) break block4;
                                                        IntWrapper intWrapper = (IntWrapper)object2;
                                                        object = intWrapper.getValue();
                                                        break block3;
                                                    }
                                                    if (!(object2 instanceof LongWrapper)) break block5;
                                                    LongWrapper longWrapper = (LongWrapper)object2;
                                                    object = longWrapper.getValue();
                                                    break block3;
                                                }
                                                if (!(object2 instanceof FloatWrapper)) break block6;
                                                FloatWrapper floatWrapper = (FloatWrapper)object2;
                                                object = floatWrapper.getValue();
                                                break block3;
                                            }
                                            if (!(object2 instanceof DoubleWrapper)) break block7;
                                            DoubleWrapper doubleWrapper = (DoubleWrapper)object2;
                                            object = doubleWrapper.getValue();
                                            break block3;
                                        }
                                        if (!(object2 instanceof BytesWrapper)) break block8;
                                        BytesWrapper bytesWrapper = (BytesWrapper)object2;
                                        object = bytesWrapper.getValue();
                                        break block3;
                                    }
                                    if (!(object2 instanceof StringWrapper)) break block9;
                                    StringWrapper stringWrapper = (StringWrapper)object2;
                                    object = stringWrapper.getValue();
                                    break block3;
                                }
                                if (!(object2 instanceof DateWrapper)) break block10;
                                DateWrapper dateWrapper = (DateWrapper)object2;
                                object = dateWrapper.getValue();
                                break block3;
                            }
                            if (!(object2 instanceof DecimalWrapper)) break block11;
                            DecimalWrapper decimalWrapper = (DecimalWrapper)object2;
                            object = decimalWrapper.getValue();
                            break block3;
                        }
                        if (!(object2 instanceof TimeMicrosWrapper)) break block12;
                        TimeMicrosWrapper timeMicrosWrapper = (TimeMicrosWrapper)object2;
                        object = timeMicrosWrapper.getValue();
                        break block3;
                    }
                    if (!(object2 instanceof TimestampMicrosWrapper)) break block13;
                    TimestampMicrosWrapper timestampMicrosWrapper = (TimestampMicrosWrapper)object2;
                    object = timestampMicrosWrapper.getValue();
                    break block3;
                }
                if (!(object2 instanceof GenericData.Record)) break block14;
                GenericData.Record record = (GenericData.Record)object2;
                if (!this.expectedAvroSchemaValues().contains((Object)record.getSchema().getName())) break block14;
                object = record.get("value");
            }
            return object;
        }
        throw new UnsupportedOperationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Not recognized value wrapper type (", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{valueWrapper.getClass().getSimpleName()})));
    }

    public Conversions.DecimalConversion decConv() {
        return this.decConv;
    }

    public Object org$apache$hudi$ColumnStatsIndexSupport$$deserialize(Object value, DataType dataType) {
        block19: {
            Object object;
            block8: {
                Object object2;
                DataType dataType2;
                block18: {
                    Object object3;
                    block17: {
                        block16: {
                            block15: {
                                block14: {
                                    block13: {
                                        block12: {
                                            block11: {
                                                block10: {
                                                    block9: {
                                                        block7: {
                                                            dataType2 = dataType;
                                                            if (!TimestampType$.MODULE$.equals(dataType2)) break block7;
                                                            object = DateTimeUtils$.MODULE$.toJavaTimestamp(BoxesRunTime.unboxToLong((Object)value));
                                                            break block8;
                                                        }
                                                        if (!DateType$.MODULE$.equals(dataType2)) break block9;
                                                        object = DateTimeUtils$.MODULE$.toJavaDate(BoxesRunTime.unboxToInt((Object)value));
                                                        break block8;
                                                    }
                                                    if (!StringType$.MODULE$.equals(dataType2)) break block10;
                                                    object = value;
                                                    break block8;
                                                }
                                                if (!BooleanType$.MODULE$.equals(dataType2)) break block11;
                                                object = value;
                                                break block8;
                                            }
                                            if (!FloatType$.MODULE$.equals(dataType2)) break block12;
                                            object = value;
                                            break block8;
                                        }
                                        if (!DoubleType$.MODULE$.equals(dataType2)) break block13;
                                        object = value;
                                        break block8;
                                    }
                                    if (!LongType$.MODULE$.equals(dataType2)) break block14;
                                    object = value;
                                    break block8;
                                }
                                if (!IntegerType$.MODULE$.equals(dataType2)) break block15;
                                object = value;
                                break block8;
                            }
                            if (!ShortType$.MODULE$.equals(dataType2)) break block16;
                            object = BoxesRunTime.boxToShort((short)((short)BoxesRunTime.unboxToInt((Object)value)));
                            break block8;
                        }
                        if (!ByteType$.MODULE$.equals(dataType2)) break block17;
                        object = BoxesRunTime.boxToByte((byte)((byte)BoxesRunTime.unboxToInt((Object)value)));
                        break block8;
                    }
                    if (!(dataType2 instanceof DecimalType)) break block18;
                    Object object4 = value;
                    if (object4 instanceof ByteBuffer) {
                        ByteBuffer byteBuffer = (ByteBuffer)object4;
                        LogicalType logicalType = DecimalWrapper.SCHEMA$.getField("value").schema().getLogicalType();
                        object3 = this.decConv().fromBytes(byteBuffer, null, logicalType);
                    } else {
                        object3 = value;
                    }
                    object = object3;
                    break block8;
                }
                if (!BinaryType$.MODULE$.equals(dataType2)) break block19;
                Object object5 = value;
                if (object5 instanceof ByteBuffer) {
                    ByteBuffer byteBuffer = (ByteBuffer)object5;
                    object2 = BinaryUtil.toBytes((ByteBuffer)byteBuffer);
                } else {
                    object2 = object5;
                }
                object = object2;
            }
            return object;
        }
        throw new UnsupportedOperationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Data type for the statistic value is not recognized ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dataType})));
    }

    public boolean $lessinit$greater$default$5() {
        return false;
    }

    private ColumnStatsIndexSupport$() {
        MODULE$ = this;
        this.expectedAvroSchemaValues = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"BooleanWrapper", "IntWrapper", "LongWrapper", "FloatWrapper", "DoubleWrapper", "BytesWrapper", "StringWrapper", "DateWrapper", "DecimalWrapper", "TimeMicrosWrapper", "TimestampMicrosWrapper"}));
        this.org$apache$hudi$ColumnStatsIndexSupport$$targetColumnStatsIndexColumns = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"fileName", "minValue", "maxValue", "nullCount", "valueCount", "columnName"}));
        this.org$apache$hudi$ColumnStatsIndexSupport$$columnStatsRecordStructType = AvroConversionUtils$.MODULE$.convertAvroSchemaToStructType(HoodieMetadataColumnStats.SCHEMA$);
        this.decConv = new Conversions.DecimalConversion();
    }
}

