/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.avro.generic.GenericRecord;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.DataSourceWriteOptions;
import org.apache.hudi.HoodieSparkSqlWriter;
import org.apache.hudi.HoodieStreamingSink;
import org.apache.hudi.client.HoodieWriteResult;
import org.apache.hudi.client.SparkRDDReadClient;
import org.apache.hudi.client.SparkRDDWriteClient;
import org.apache.hudi.client.common.HoodieSparkEngineContext;
import org.apache.hudi.common.config.HoodieStorageConfig;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieAvroRecord;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.util.CommitUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ReflectionUtils;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.TablePathUtils;
import org.apache.hudi.config.HoodieCompactionConfig;
import org.apache.hudi.config.HoodiePayloadConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieNotSupportedException;
import org.apache.hudi.exception.TableNotFoundException;
import org.apache.hudi.table.BulkInsertPartitioner;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.HoodieDataTypeUtils;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;

public class DataSourceUtils {
    private static final Logger LOG = LogManager.getLogger(DataSourceUtils.class);

    public static String getTablePath(FileSystem fs, Path[] userProvidedPaths) throws IOException {
        LOG.info((Object)"Getting table path..");
        for (Path path : userProvidedPaths) {
            try {
                Option tablePath = TablePathUtils.getTablePath((FileSystem)fs, (Path)path);
                if (!tablePath.isPresent()) continue;
                return ((Path)tablePath.get()).toString();
            }
            catch (HoodieException he) {
                LOG.warn((Object)("Error trying to get table path from " + path.toString()), (Throwable)he);
            }
        }
        throw new TableNotFoundException("Unable to find a hudi table for the user provided paths.");
    }

    private static Option<BulkInsertPartitioner> createUserDefinedBulkInsertPartitioner(HoodieWriteConfig config) throws HoodieException {
        String bulkInsertPartitionerClass = config.getUserDefinedBulkInsertPartitionerClass();
        try {
            return StringUtils.isNullOrEmpty((String)bulkInsertPartitionerClass) ? Option.empty() : Option.of((Object)((BulkInsertPartitioner)ReflectionUtils.loadClass((String)bulkInsertPartitionerClass, (Object[])new Object[]{config})));
        }
        catch (Throwable e) {
            throw new HoodieException("Could not create UserDefinedBulkInsertPartitioner class " + bulkInsertPartitionerClass, e);
        }
    }

    public static Option<BulkInsertPartitioner<Dataset<Row>>> createUserDefinedBulkInsertPartitionerWithRows(HoodieWriteConfig config) throws HoodieException {
        String bulkInsertPartitionerClass = config.getUserDefinedBulkInsertPartitionerClass();
        try {
            return StringUtils.isNullOrEmpty((String)bulkInsertPartitionerClass) ? Option.empty() : Option.of((Object)((BulkInsertPartitioner)ReflectionUtils.loadClass((String)bulkInsertPartitionerClass, (Object[])new Object[]{config})));
        }
        catch (Throwable e) {
            throw new HoodieException("Could not create UserDefinedBulkInsertPartitionerRows class " + bulkInsertPartitionerClass, e);
        }
    }

    public static HoodieRecordPayload createPayload(String payloadClass, GenericRecord record, Comparable orderingVal) throws IOException {
        try {
            return (HoodieRecordPayload)ReflectionUtils.loadClass((String)payloadClass, (Class[])new Class[]{GenericRecord.class, Comparable.class}, (Object[])new Object[]{record, orderingVal});
        }
        catch (Throwable e) {
            throw new IOException("Could not create payload for class: " + payloadClass, e);
        }
    }

    public static Map<String, String> getExtraMetadata(Map<String, String> properties) {
        HashMap<String, String> extraMetadataMap = new HashMap<String, String>();
        if (properties.containsKey(DataSourceWriteOptions.COMMIT_METADATA_KEYPREFIX().key())) {
            properties.entrySet().forEach(entry -> {
                if (((String)entry.getKey()).startsWith((String)properties.get(DataSourceWriteOptions.COMMIT_METADATA_KEYPREFIX().key()))) {
                    extraMetadataMap.put((String)entry.getKey(), (String)entry.getValue());
                }
            });
        }
        if (properties.containsKey(HoodieSparkSqlWriter.SPARK_STREAMING_BATCH_ID())) {
            extraMetadataMap.put(HoodieStreamingSink.SINK_CHECKPOINT_KEY(), CommitUtils.getCheckpointValueAsString((String)properties.getOrDefault(DataSourceWriteOptions.STREAMING_CHECKPOINT_IDENTIFIER().key(), (String)DataSourceWriteOptions.STREAMING_CHECKPOINT_IDENTIFIER().defaultValue()), (String)properties.get(HoodieSparkSqlWriter.SPARK_STREAMING_BATCH_ID())));
        }
        return extraMetadataMap;
    }

    public static HoodieRecordPayload createPayload(String payloadClass, GenericRecord record) throws IOException {
        try {
            return (HoodieRecordPayload)ReflectionUtils.loadClass((String)payloadClass, (Class[])new Class[]{Option.class}, (Object[])new Object[]{Option.of((Object)record)});
        }
        catch (Throwable e) {
            throw new IOException("Could not create payload for class: " + payloadClass, e);
        }
    }

    public static void checkRequiredProperties(TypedProperties props, List<String> checkPropNames) {
        checkPropNames.forEach(prop -> {
            if (!props.containsKey(prop)) {
                throw new HoodieNotSupportedException("Required property " + prop + " is missing");
            }
        });
    }

    public static HoodieWriteConfig createHoodieConfig(String schemaStr, String basePath, String tblName, Map<String, String> parameters) {
        boolean asyncCompact = Boolean.parseBoolean(parameters.get(DataSourceWriteOptions.ASYNC_COMPACT_ENABLE().key()));
        boolean inlineCompact = !asyncCompact && parameters.get(DataSourceWriteOptions.TABLE_TYPE().key()).equals(DataSourceWriteOptions.MOR_TABLE_TYPE_OPT_VAL());
        boolean combineInserts = Boolean.parseBoolean(parameters.get(DataSourceWriteOptions.INSERT_DROP_DUPS().key()));
        HoodieWriteConfig.Builder builder = HoodieWriteConfig.newBuilder().withPath(basePath).withAutoCommit(false).combineInput(combineInserts, true);
        if (schemaStr != null) {
            builder = builder.withSchema(schemaStr);
        }
        return builder.forTable(tblName).withCompactionConfig(HoodieCompactionConfig.newBuilder().withInlineCompaction(Boolean.valueOf(inlineCompact)).build()).withPayloadConfig(HoodiePayloadConfig.newBuilder().withPayloadClass(parameters.get(DataSourceWriteOptions.PAYLOAD_CLASS_NAME().key())).withPayloadOrderingField(parameters.get(DataSourceWriteOptions.PRECOMBINE_FIELD().key())).build()).withProps(parameters).build();
    }

    public static SparkRDDWriteClient createHoodieClient(JavaSparkContext jssc, String schemaStr, String basePath, String tblName, Map<String, String> parameters) {
        return new SparkRDDWriteClient((HoodieEngineContext)new HoodieSparkEngineContext(jssc), DataSourceUtils.createHoodieConfig(schemaStr, basePath, tblName, parameters));
    }

    public static HoodieWriteResult doWriteOperation(SparkRDDWriteClient client, JavaRDD<HoodieRecord> hoodieRecords, String instantTime, WriteOperationType operation) throws HoodieException {
        switch (operation) {
            case BULK_INSERT: {
                Option<BulkInsertPartitioner> userDefinedBulkInsertPartitioner = DataSourceUtils.createUserDefinedBulkInsertPartitioner(client.getConfig());
                return new HoodieWriteResult(client.bulkInsert(hoodieRecords, instantTime, userDefinedBulkInsertPartitioner));
            }
            case INSERT: {
                return new HoodieWriteResult(client.insert(hoodieRecords, instantTime));
            }
            case UPSERT: {
                return new HoodieWriteResult(client.upsert(hoodieRecords, instantTime));
            }
            case INSERT_OVERWRITE: {
                return client.insertOverwrite(hoodieRecords, instantTime);
            }
            case INSERT_OVERWRITE_TABLE: {
                return client.insertOverwriteTable(hoodieRecords, instantTime);
            }
        }
        throw new HoodieException("Not a valid operation type for doWriteOperation: " + operation.toString());
    }

    public static HoodieWriteResult doDeleteOperation(SparkRDDWriteClient client, JavaRDD<HoodieKey> hoodieKeys, String instantTime) {
        return new HoodieWriteResult(client.delete(hoodieKeys, instantTime));
    }

    public static HoodieWriteResult doDeletePartitionsOperation(SparkRDDWriteClient client, List<String> partitionsToDelete, String instantTime) {
        return client.deletePartitions(partitionsToDelete, instantTime);
    }

    public static HoodieRecord createHoodieRecord(GenericRecord gr, Comparable orderingVal, HoodieKey hKey, String payloadClass) throws IOException {
        HoodieRecordPayload payload = DataSourceUtils.createPayload(payloadClass, gr, orderingVal);
        return new HoodieAvroRecord(hKey, payload);
    }

    public static HoodieRecord createHoodieRecord(GenericRecord gr, HoodieKey hKey, String payloadClass) throws IOException {
        HoodieRecordPayload payload = DataSourceUtils.createPayload(payloadClass, gr);
        return new HoodieAvroRecord(hKey, payload);
    }

    public static JavaRDD<HoodieRecord> dropDuplicates(JavaSparkContext jssc, JavaRDD<HoodieRecord> incomingHoodieRecords, HoodieWriteConfig writeConfig) {
        try {
            SparkRDDReadClient client = new SparkRDDReadClient(new HoodieSparkEngineContext(jssc), writeConfig);
            return client.tagLocation(incomingHoodieRecords).filter((Function & Serializable)r -> !((HoodieRecord)r).isCurrentLocationKnown());
        }
        catch (TableNotFoundException e) {
            return incomingHoodieRecords;
        }
    }

    public static JavaRDD<HoodieRecord> dropDuplicates(JavaSparkContext jssc, JavaRDD<HoodieRecord> incomingHoodieRecords, Map<String, String> parameters) {
        HoodieWriteConfig writeConfig = HoodieWriteConfig.newBuilder().withPath(parameters.get("path")).withProps(parameters).build();
        return DataSourceUtils.dropDuplicates(jssc, incomingHoodieRecords, writeConfig);
    }

    public static void tryOverrideParquetWriteLegacyFormatProperty(Map<String, String> properties, StructType schema2) {
        if (HoodieDataTypeUtils.hasSmallPrecisionDecimalType((DataType)schema2) && properties.get(HoodieStorageConfig.PARQUET_WRITE_LEGACY_FORMAT_ENABLED.key()) == null) {
            LOG.warn((Object)"Small Decimal Type found in the persisted schema, reverting default value of 'hoodie.parquet.writelegacyformat.enabled' to true");
            properties.put(HoodieStorageConfig.PARQUET_WRITE_LEGACY_FORMAT_ENABLED.key(), "true");
        }
    }
}

