/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi;

import java.io.Closeable;
import java.util.Properties;
import org.apache.avro.Schema;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.HoodieConversionUtils$;
import org.apache.hudi.HoodieMergeOnReadFileSplit;
import org.apache.hudi.HoodieTableState;
import org.apache.hudi.common.config.HoodieCommonConfig;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.engine.EngineType;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.engine.HoodieLocalEngineContext;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.table.log.HoodieMergedLogRecordScanner;
import org.apache.hudi.common.util.HoodieRecordUtils;
import org.apache.hudi.common.util.collection.ExternalSpillableMap;
import org.apache.hudi.internal.schema.InternalSchema;
import org.apache.hudi.metadata.HoodieBackedTableMetadata;
import org.apache.hudi.metadata.HoodieMetadataLogRecordReader;
import org.apache.hudi.metadata.HoodieMetadataPayload;
import org.apache.hudi.metadata.HoodieTableMetadata;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.Map;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Try$;

public final class LogFileIterator$ {
    public static final LogFileIterator$ MODULE$;

    static {
        new LogFileIterator$();
    }

    public Map<String, HoodieRecord<?>> scanLog(List<HoodieLogFile> logFiles, Path partitionPath, Schema logSchema, HoodieTableState tableState, long maxCompactionMemoryInBytes, Configuration hadoopConf, InternalSchema internalSchema) {
        Map map;
        String tablePath = tableState.tablePath();
        FileSystem fs = FSUtils.getFs((String)tablePath, (Configuration)hadoopConf);
        if (HoodieTableMetadata.isMetadataTable((String)tablePath)) {
            HoodieMetadataConfig metadataConfig = HoodieMetadataConfig.newBuilder().fromProperties((Properties)tableState.metadataConfig().getProps()).enable(true).build();
            String dataTableBasePath = HoodieTableMetadata.getDataTableBasePathFromMetadataTable((String)tablePath);
            HoodieBackedTableMetadata metadataTable = new HoodieBackedTableMetadata((HoodieEngineContext)new HoodieLocalEngineContext(hadoopConf), metadataConfig, dataTableBasePath, hadoopConf.get("hoodie.memory.spillable.map.path", "/tmp/"));
            boolean forceFullScan = true;
            String relativePartitionPath = FSUtils.getRelativePartitionPath((Path)new Path(tablePath), (Path)partitionPath);
            HoodieMetadataLogRecordReader logRecordReader = (HoodieMetadataLogRecordReader)metadataTable.getLogRecordScanner((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(logFiles).asJava(), relativePartitionPath, HoodieConversionUtils$.MODULE$.toJavaOption((Option)new Some((Object)Predef$.MODULE$.boolean2Boolean(forceFullScan)))).getLeft();
            java.util.List recordList = (java.util.List)this.closing((Closeable)logRecordReader, (Function0)new Serializable(logRecordReader){
                public static final long serialVersionUID = 0L;
                private final HoodieMetadataLogRecordReader logRecordReader$1;

                public final java.util.List<HoodieRecord<HoodieMetadataPayload>> apply() {
                    return this.logRecordReader$1.getRecords();
                }
                {
                    this.logRecordReader$1 = logRecordReader$1;
                }
            });
            map = (Map)HashMap$.MODULE$.apply((Seq)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(recordList).asScala()).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Tuple2<String, HoodieRecord<HoodieMetadataPayload>> apply(HoodieRecord<HoodieMetadataPayload> r) {
                    return new Tuple2((Object)r.getRecordKey(), r);
                }
            }, Buffer$.MODULE$.canBuildFrom()));
        } else {
            HoodieMergedLogRecordScanner.Builder logRecordScannerBuilder = HoodieMergedLogRecordScanner.newBuilder().withFileSystem(fs).withBasePath(tablePath).withLogFilePaths((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)logFiles.map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(HoodieLogFile logFile) {
                    return logFile.getPath().toString();
                }
            }, List$.MODULE$.canBuildFrom())).asJava()).withReaderSchema(logSchema).withLatestInstantTime((String)tableState.latestCommitTimestamp().get()).withReadBlocksLazily(BoxesRunTime.unboxToBoolean((Object)Try$.MODULE$.apply((Function0)new Serializable(hadoopConf){
                public static final long serialVersionUID = 0L;
                private final Configuration hadoopConf$1;

                public final boolean apply() {
                    return this.apply$mcZ$sp();
                }

                public boolean apply$mcZ$sp() {
                    return new StringOps(Predef$.MODULE$.augmentString(this.hadoopConf$1.get("compaction.lazy.block.read.enabled", "true"))).toBoolean();
                }
                {
                    this.hadoopConf$1 = hadoopConf$1;
                }
            }).getOrElse((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply() {
                    return this.apply$mcZ$sp();
                }

                public boolean apply$mcZ$sp() {
                    return false;
                }
            }))).withReverseReader(false).withInternalSchema(internalSchema).withBufferSize(hadoopConf.getInt("hoodie.memory.dfs.buffer.max.size", 0x100000)).withMaxMemorySizeInBytes(Predef$.MODULE$.long2Long(maxCompactionMemoryInBytes)).withSpillableMapBasePath(hadoopConf.get("hoodie.memory.spillable.map.path", "/tmp/")).withDiskMapType((ExternalSpillableMap.DiskMapType)hadoopConf.getEnum(HoodieCommonConfig.SPILLABLE_DISK_MAP_TYPE.key(), (Enum)HoodieCommonConfig.SPILLABLE_DISK_MAP_TYPE.defaultValue())).withBitCaskDiskMapCompressionEnabled(hadoopConf.getBoolean(HoodieCommonConfig.DISK_MAP_BITCASK_COMPRESSION_ENABLED.key(), Predef$.MODULE$.Boolean2boolean((Boolean)HoodieCommonConfig.DISK_MAP_BITCASK_COMPRESSION_ENABLED.defaultValue())));
            Object object = logFiles.nonEmpty() ? logRecordScannerBuilder.withPartition(FSUtils.getRelativePartitionPath((Path)new Path(tableState.tablePath()), (Path)((HoodieLogFile)logFiles.head()).getPath().getParent())) : BoxedUnit.UNIT;
            logRecordScannerBuilder.withRecordMerger(HoodieRecordUtils.createRecordMerger((String)tableState.tablePath(), (EngineType)EngineType.SPARK, (java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(tableState.recordMergerImpls()).asJava()), (String)tableState.recordMergerStrategy()));
            HoodieMergedLogRecordScanner scanner = logRecordScannerBuilder.build();
            map = (Map)this.closing((Closeable)scanner, (Function0)new Serializable(scanner){
                public static final long serialVersionUID = 0L;
                private final HoodieMergedLogRecordScanner scanner$1;

                public final HashMap<String, HoodieRecord<?>> apply() {
                    return (HashMap)HashMap$.MODULE$.apply(((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(this.scanner$1.getRecords()).asScala()).toSeq());
                }
                {
                    this.scanner$1 = scanner$1;
                }
            });
        }
        return map;
    }

    public InternalSchema scanLog$default$7() {
        return InternalSchema.getEmptyInternalSchema();
    }

    public <T> T closing(Closeable c, Function0<T> f) {
        try {
            return (T)f.apply();
        }
        finally {
            c.close();
        }
    }

    public Path getPartitionPath(HoodieMergeOnReadFileSplit split) {
        return ((Path)split.dataFile().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Path apply(PartitionedFile baseFile) {
                return new Path(baseFile.filePath());
            }
        }).getOrElse((Function0)new Serializable(split){
            public static final long serialVersionUID = 0L;
            private final HoodieMergeOnReadFileSplit split$1;

            public final Path apply() {
                return ((HoodieLogFile)this.split$1.logFiles().head()).getPath();
            }
            {
                this.split$1 = split$1;
            }
        })).getParent();
    }

    private LogFileIterator$() {
        MODULE$ = this;
    }
}

