/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.cdc;

import org.apache.hudi.DataSourceReadOptions$;
import org.apache.hudi.cdc.CDCRelation;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.cdc.HoodieCDCOperation;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.exception.HoodieException;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.runtime.Nothing$;

public final class CDCRelation$ {
    public static final CDCRelation$ MODULE$;
    private final UTF8String CDC_OPERATION_DELETE;
    private final UTF8String CDC_OPERATION_INSERT;
    private final UTF8String CDC_OPERATION_UPDATE;
    private final StructType FULL_CDC_SPARK_SCHEMA;
    private final StructType MIN_CDC_SPARK_SCHEMA;
    private final StructType CDC_WITH_BEFORE_SPARK_SCHEMA;

    static {
        new CDCRelation$();
    }

    public UTF8String CDC_OPERATION_DELETE() {
        return this.CDC_OPERATION_DELETE;
    }

    public UTF8String CDC_OPERATION_INSERT() {
        return this.CDC_OPERATION_INSERT;
    }

    public UTF8String CDC_OPERATION_UPDATE() {
        return this.CDC_OPERATION_UPDATE;
    }

    public StructType FULL_CDC_SPARK_SCHEMA() {
        return this.FULL_CDC_SPARK_SCHEMA;
    }

    public StructType MIN_CDC_SPARK_SCHEMA() {
        return this.MIN_CDC_SPARK_SCHEMA;
    }

    public StructType CDC_WITH_BEFORE_SPARK_SCHEMA() {
        return this.CDC_WITH_BEFORE_SPARK_SCHEMA;
    }

    public boolean isCDCEnabled(HoodieTableMetaClient metaClient) {
        return metaClient.getTableConfig().isCDCEnabled();
    }

    public CDCRelation getCDCRelation(SQLContext sqlContext, HoodieTableMetaClient metaClient, Map<String, String> options) {
        if (this.isCDCEnabled(metaClient)) {
            String startingInstant = (String)options.getOrElse((Object)DataSourceReadOptions$.MODULE$.BEGIN_INSTANTTIME().key(), (Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Nothing$ apply() {
                    throw new HoodieException("CDC Query should provide the valid start version or timestamp");
                }
            });
            String endingInstant = (String)options.getOrElse((Object)DataSourceReadOptions$.MODULE$.END_INSTANTTIME().key(), (Function0)new Serializable(metaClient){
                public static final long serialVersionUID = 0L;
                private final HoodieTableMetaClient metaClient$1;

                public final String apply() {
                    return CDCRelation$.MODULE$.getTimestampOfLatestInstant(this.metaClient$1);
                }
                {
                    this.metaClient$1 = metaClient$1;
                }
            });
            if (new StringOps(Predef$.MODULE$.augmentString(startingInstant)).$greater((Object)endingInstant)) {
                throw new HoodieException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"This is not a valid range between ", " and ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{startingInstant, endingInstant})));
            }
            return new CDCRelation(sqlContext, metaClient, startingInstant, endingInstant, options);
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"It isn't a CDC hudi table on ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{metaClient.getBasePathV2().toString()})));
    }

    public String getTimestampOfLatestInstant(HoodieTableMetaClient metaClient) {
        Option latestInstant = metaClient.getActiveTimeline().lastInstant();
        if (latestInstant.isPresent()) {
            return ((HoodieInstant)latestInstant.get()).getTimestamp();
        }
        throw new HoodieException("No valid instant in Active Timeline.");
    }

    private CDCRelation$() {
        MODULE$ = this;
        this.CDC_OPERATION_DELETE = UTF8String.fromString((String)HoodieCDCOperation.DELETE.getValue());
        this.CDC_OPERATION_INSERT = UTF8String.fromString((String)HoodieCDCOperation.INSERT.getValue());
        this.CDC_OPERATION_UPDATE = UTF8String.fromString((String)HoodieCDCOperation.UPDATE.getValue());
        this.FULL_CDC_SPARK_SCHEMA = StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("op", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("ts_ms", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("before", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("after", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())})));
        this.MIN_CDC_SPARK_SCHEMA = StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("op", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("record_key", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())})));
        this.CDC_WITH_BEFORE_SPARK_SCHEMA = StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("op", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("record_key", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("before", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())})));
    }
}

