/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.parquet;

import java.util.HashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.parquet.hadoop.metadata.FileMetaData;
import org.apache.spark.sql.execution.datasources.parquet.ParquetToSparkSchemaConverter;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.GenSeq;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;

public final class HoodieParquetFileFormatHelper$ {
    public static final HoodieParquetFileFormatHelper$ MODULE$;

    static {
        new HoodieParquetFileFormatHelper$();
    }

    public Tuple2<java.util.Map<Integer, Pair<DataType, DataType>>, StructType> buildImplicitSchemaChangeInfo(Configuration hadoopConf, FileMetaData parquetFileMetaData, StructType requiredSchema) {
        HashMap implicitTypeChangeInfo = new HashMap();
        ParquetToSparkSchemaConverter convert = new ParquetToSparkSchemaConverter(hadoopConf);
        StructType fileStruct = convert.convert(parquetFileMetaData.getSchema());
        Map fileStructMap = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])fileStruct.fields()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, DataType> apply(StructField f) {
                return new Tuple2((Object)f.name(), (Object)f.dataType());
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).toMap(Predef$.MODULE$.$conforms());
        Seq sparkRequestStructFields = (Seq)requiredSchema.map((Function1)new Serializable(requiredSchema, implicitTypeChangeInfo, fileStructMap){
            public static final long serialVersionUID = 0L;
            private final StructType requiredSchema$1;
            private final java.util.Map implicitTypeChangeInfo$1;
            private final Map fileStructMap$1;

            public final StructField apply(StructField f) {
                StructField structField;
                DataType requiredType = f.dataType();
                if (this.fileStructMap$1.contains((Object)f.name()) && !HoodieParquetFileFormatHelper$.MODULE$.isDataTypeEqual(requiredType, (DataType)this.fileStructMap$1.apply((Object)f.name()))) {
                    this.implicitTypeChangeInfo$1.put(new Integer(this.requiredSchema$1.fieldIndex(f.name())), Pair.of((Object)requiredType, (Object)this.fileStructMap$1.apply((Object)f.name())));
                    structField = new StructField(f.name(), (DataType)this.fileStructMap$1.apply((Object)f.name()), f.nullable(), StructField$.MODULE$.apply$default$4());
                } else {
                    structField = f;
                }
                return structField;
            }
            {
                this.requiredSchema$1 = requiredSchema$1;
                this.implicitTypeChangeInfo$1 = implicitTypeChangeInfo$1;
                this.fileStructMap$1 = fileStructMap$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
        return new Tuple2(implicitTypeChangeInfo, (Object)StructType$.MODULE$.apply(sparkRequestStructFields));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isDataTypeEqual(DataType requiredType, DataType fileType) {
        Tuple2 tuple2;
        while (true) {
            if ((tuple2 = new Tuple2((Object)requiredType, (Object)fileType)) != null) {
                DataType requiredType2 = (DataType)tuple2._1();
                DataType fileType2 = (DataType)tuple2._2();
                DataType dataType = requiredType2;
                DataType dataType2 = fileType2;
                if (dataType == null) {
                    if (dataType2 == null) return true;
                } else if (dataType.equals(dataType2)) {
                    return true;
                }
            }
            if (tuple2 != null) {
                DataType dataType = (DataType)tuple2._1();
                DataType dataType3 = (DataType)tuple2._2();
                if (dataType instanceof ArrayType) {
                    ArrayType arrayType = (ArrayType)dataType;
                    DataType rt = arrayType.elementType();
                    if (dataType3 instanceof ArrayType) {
                        DataType ft;
                        ArrayType arrayType2 = (ArrayType)dataType3;
                        fileType = ft = arrayType2.elementType();
                        requiredType = rt;
                        continue;
                    }
                }
            }
            if (tuple2 == null) break;
            DataType dataType = (DataType)tuple2._1();
            DataType dataType4 = (DataType)tuple2._2();
            if (!(dataType instanceof MapType)) break;
            MapType mapType = (MapType)dataType;
            DataType requiredKey = mapType.keyType();
            DataType requiredValue = mapType.valueType();
            if (!(dataType4 instanceof MapType)) break;
            MapType mapType2 = (MapType)dataType4;
            DataType fileKey = mapType2.keyType();
            DataType fileValue = mapType2.valueType();
            if (!this.isDataTypeEqual(requiredKey, fileKey)) return false;
            fileType = fileValue;
            requiredType = requiredValue;
        }
        if (tuple2 == null) return false;
        DataType dataType = (DataType)tuple2._1();
        DataType dataType5 = (DataType)tuple2._2();
        if (!(dataType instanceof StructType)) return false;
        StructType structType = (StructType)dataType;
        StructField[] requiredFields = structType.fields();
        if (!(dataType5 instanceof StructType)) return false;
        StructType structType2 = (StructType)dataType5;
        StructField[] fileFields = structType2.fields();
        String[] commonFieldNames = (String[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])requiredFields).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(StructField x$1) {
                return x$1.name();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).intersect((GenSeq)Predef$.MODULE$.wrapRefArray((Object[])Predef$.MODULE$.refArrayOps((Object[])fileFields).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(StructField x$2) {
                return x$2.name();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))));
        StructField[] fileFilteredFields = (StructField[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])fileFields).filter((Function1)new Serializable(commonFieldNames){
            public static final long serialVersionUID = 0L;
            private final String[] commonFieldNames$1;

            public final boolean apply(StructField f) {
                return Predef$.MODULE$.refArrayOps((Object[])this.commonFieldNames$1).contains((Object)f.name());
            }
            {
                this.commonFieldNames$1 = commonFieldNames$1;
            }
        })).sortWith((Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(StructField x$3, StructField x$4) {
                return new StringOps(Predef$.MODULE$.augmentString(x$3.name())).$less((Object)x$4.name());
            }
        });
        StructField[] requiredFilteredFields = (StructField[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])requiredFields).filter((Function1)new Serializable(commonFieldNames){
            public static final long serialVersionUID = 0L;
            private final String[] commonFieldNames$1;

            public final boolean apply(StructField f) {
                return Predef$.MODULE$.refArrayOps((Object[])this.commonFieldNames$1).contains((Object)f.name());
            }
            {
                this.commonFieldNames$1 = commonFieldNames$1;
            }
        })).sortWith((Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(StructField x$5, StructField x$6) {
                return new StringOps(Predef$.MODULE$.augmentString(x$5.name())).$less((Object)x$6.name());
            }
        });
        return Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])requiredFilteredFields).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])fileFilteredFields), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).forall((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<StructField, StructField> x0$1) {
                Tuple2<StructField, StructField> tuple2 = x0$1;
                if (tuple2 != null) {
                    StructField requiredField = (StructField)tuple2._1();
                    StructField fileFilteredField = (StructField)tuple2._2();
                    boolean bl = HoodieParquetFileFormatHelper$.MODULE$.isDataTypeEqual(requiredField.dataType(), fileFilteredField.dataType());
                    return bl;
                }
                throw new MatchError(tuple2);
            }
        });
    }

    private HoodieParquetFileFormatHelper$() {
        MODULE$ = this;
    }
}

