/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.command;

import org.apache.avro.Schema;
import org.apache.hudi.AvroConversionUtils$;
import org.apache.hudi.avro.AvroSchemaUtils;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.TableSchemaResolver;
import org.apache.hudi.exception.HoodieException;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.HoodieCatalogTable;
import org.apache.spark.sql.catalyst.catalog.HoodieCatalogTable$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.plans.logical.Command;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.trees.HoodieLeafLike$class;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.execution.command.RunnableCommand;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.hudi.HoodieSqlCommonUtils$;
import org.apache.spark.sql.hudi.command.AlterHoodieTableAddColumnsCommand$;
import org.apache.spark.sql.hudi.command.AlterHoodieTableChangeColumnCommand$;
import org.apache.spark.sql.hudi.command.HoodieLeafRunnableCommand;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IndexedSeq;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005mg\u0001B\u0001\u0003\u0001>\u00111%\u00117uKJDun\u001c3jKR\u000b'\r\\3DQ\u0006tw-Z\"pYVlgnQ8n[\u0006tGM\u0003\u0002\u0004\t\u000591m\\7nC:$'BA\u0003\u0007\u0003\u0011AW\u000fZ5\u000b\u0005\u001dA\u0011aA:rY*\u0011\u0011BC\u0001\u0006gB\f'o\u001b\u0006\u0003\u00171\ta!\u00199bG\",'\"A\u0007\u0002\u0007=\u0014xm\u0001\u0001\u0014\u000b\u0001\u0001\"D\b\u0013\u0011\u0005EAR\"\u0001\n\u000b\u0005M!\u0012a\u00027pO&\u001c\u0017\r\u001c\u0006\u0003+Y\tQ\u0001\u001d7b]NT!a\u0006\u0004\u0002\u0011\r\fG/\u00197zgRL!!\u0007\n\u0003\u00171{w-[2bYBc\u0017M\u001c\t\u00037qi\u0011AA\u0005\u0003;\t\u0011\u0011\u0004S8pI&,G*Z1g%Vtg.\u00192mK\u000e{W.\\1oIB\u0011qDI\u0007\u0002A)\t\u0011%A\u0003tG\u0006d\u0017-\u0003\u0002$A\t9\u0001K]8ek\u000e$\bCA\u0010&\u0013\t1\u0003E\u0001\u0007TKJL\u0017\r\\5{C\ndW\r\u0003\u0005)\u0001\tU\r\u0011\"\u0001*\u0003=!\u0018M\u00197f\u0013\u0012,g\u000e^5gS\u0016\u0014X#\u0001\u0016\u0011\u0005-bS\"\u0001\f\n\u000552\"a\u0004+bE2,\u0017\nZ3oi&4\u0017.\u001a:\t\u0011=\u0002!\u0011#Q\u0001\n)\n\u0001\u0003^1cY\u0016LE-\u001a8uS\u001aLWM\u001d\u0011\t\u0011E\u0002!Q3A\u0005\u0002I\n!bY8mk6tg*Y7f+\u0005\u0019\u0004C\u0001\u001b8\u001d\tyR'\u0003\u00027A\u00051\u0001K]3eK\u001aL!\u0001O\u001d\u0003\rM#(/\u001b8h\u0015\t1\u0004\u0005\u0003\u0005<\u0001\tE\t\u0015!\u00034\u0003-\u0019w\u000e\\;n]:\u000bW.\u001a\u0011\t\u0011u\u0002!Q3A\u0005\u0002y\n\u0011B\\3x\u0007>dW/\u001c8\u0016\u0003}\u0002\"\u0001Q\"\u000e\u0003\u0005S!A\u0011\u0004\u0002\u000bQL\b/Z:\n\u0005\u0011\u000b%aC*ueV\u001cGOR5fY\u0012D\u0001B\u0012\u0001\u0003\u0012\u0003\u0006IaP\u0001\u000b]\u0016<8i\u001c7v[:\u0004\u0003\"\u0002%\u0001\t\u0003I\u0015A\u0002\u001fj]&$h\b\u0006\u0003K\u00172k\u0005CA\u000e\u0001\u0011\u0015As\t1\u0001+\u0011\u0015\tt\t1\u00014\u0011\u0015it\t1\u0001@\u0011\u0015y\u0005\u0001\"\u0011Q\u0003\r\u0011XO\u001c\u000b\u0003#\u0006\u00042A\u0015.^\u001d\t\u0019\u0006L\u0004\u0002U/6\tQK\u0003\u0002W\u001d\u00051AH]8pizJ\u0011!I\u0005\u00033\u0002\nq\u0001]1dW\u0006<W-\u0003\u0002\\9\n\u00191+Z9\u000b\u0005e\u0003\u0003C\u00010`\u001b\u00051\u0011B\u00011\u0007\u0005\r\u0011vn\u001e\u0005\u0006E:\u0003\raY\u0001\rgB\f'o[*fgNLwN\u001c\t\u0003=\u0012L!!\u001a\u0004\u0003\u0019M\u0003\u0018M]6TKN\u001c\u0018n\u001c8\t\u000b\u001d\u0004A\u0011\u00025\u0002\u001dY\fG.\u001b3bi\u0016\u001c6\r[3nCR\u0019\u0011\u000e\u001c;\u0011\u0005}Q\u0017BA6!\u0005\u0011)f.\u001b;\t\u000b54\u0007\u0019\u00018\u0002\u00139,woU2iK6\f\u0007CA8s\u001b\u0005\u0001(BA9\u000b\u0003\u0011\tgO]8\n\u0005M\u0004(AB*dQ\u0016l\u0017\rC\u0003vM\u0002\u0007a/\u0001\u0006nKR\f7\t\\5f]R\u0004\"a^?\u000e\u0003aT!!\u001f>\u0002\u000bQ\f'\r\\3\u000b\u0005md\u0018AB2p[6|gN\u0003\u0002\u0006\u0015%\u0011a\u0010\u001f\u0002\u0016\u0011>|G-[3UC\ndW-T3uC\u000ec\u0017.\u001a8u\u0011%\t\t\u0001AA\u0001\n\u0003\t\u0019!\u0001\u0003d_BLHc\u0002&\u0002\u0006\u0005\u001d\u0011\u0011\u0002\u0005\bQ}\u0004\n\u00111\u0001+\u0011\u001d\tt\u0010%AA\u0002MBq!P@\u0011\u0002\u0003\u0007q\bC\u0005\u0002\u000e\u0001\t\n\u0011\"\u0001\u0002\u0010\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAA\tU\rQ\u00131C\u0016\u0003\u0003+\u0001B!a\u0006\u0002\"5\u0011\u0011\u0011\u0004\u0006\u0005\u00037\ti\"A\u0005v]\u000eDWmY6fI*\u0019\u0011q\u0004\u0011\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002$\u0005e!!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"I\u0011q\u0005\u0001\u0012\u0002\u0013\u0005\u0011\u0011F\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\tYCK\u00024\u0003'A\u0011\"a\f\u0001#\u0003%\t!!\r\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u00111\u0007\u0016\u0004\u007f\u0005M\u0001\"CA\u001c\u0001\u0005\u0005I\u0011IA\u001d\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u00111\b\t\u0005\u0003{\t9%\u0004\u0002\u0002@)!\u0011\u0011IA\"\u0003\u0011a\u0017M\\4\u000b\u0005\u0005\u0015\u0013\u0001\u00026bm\u0006L1\u0001OA \u0011%\tY\u0005AA\u0001\n\u0003\ti%\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002PA\u0019q$!\u0015\n\u0007\u0005M\u0003EA\u0002J]RD\u0011\"a\u0016\u0001\u0003\u0003%\t!!\u0017\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u00111LA1!\ry\u0012QL\u0005\u0004\u0003?\u0002#aA!os\"Q\u00111MA+\u0003\u0003\u0005\r!a\u0014\u0002\u0007a$\u0013\u0007C\u0005\u0002h\u0001\t\t\u0011\"\u0011\u0002j\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002lA1\u0011QNA:\u00037j!!a\u001c\u000b\u0007\u0005E\u0004%\u0001\u0006d_2dWm\u0019;j_:LA!!\u001e\u0002p\tA\u0011\n^3sCR|'\u000fC\u0005\u0002z\u0001\t\t\u0011\"\u0001\u0002|\u0005A1-\u00198FcV\fG\u000e\u0006\u0003\u0002~\u0005\r\u0005cA\u0010\u0002\u0000%\u0019\u0011\u0011\u0011\u0011\u0003\u000f\t{w\u000e\\3b]\"Q\u00111MA<\u0003\u0003\u0005\r!a\u0017\t\u0013\u0005\u001d\u0005!!A\u0005B\u0005%\u0015AB3rk\u0006d7\u000f\u0006\u0003\u0002~\u0005-\u0005BCA2\u0003\u000b\u000b\t\u00111\u0001\u0002\\\u001dI\u0011q\u0012\u0002\u0002\u0002#\u0005\u0011\u0011S\u0001$\u00032$XM\u001d%p_\u0012LW\rV1cY\u0016\u001c\u0005.\u00198hK\u000e{G.^7o\u0007>lW.\u00198e!\rY\u00121\u0013\u0004\t\u0003\t\t\t\u0011#\u0001\u0002\u0016N)\u00111SALIAA\u0011\u0011TAPUMz$*\u0004\u0002\u0002\u001c*\u0019\u0011Q\u0014\u0011\u0002\u000fI,h\u000e^5nK&!\u0011\u0011UAN\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gn\r\u0005\b\u0011\u0006ME\u0011AAS)\t\t\t\n\u0003\u0006\u0002*\u0006M\u0015\u0011!C#\u0003W\u000b\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003wA!\"a,\u0002\u0014\u0006\u0005I\u0011QAY\u0003\u0015\t\u0007\u000f\u001d7z)\u001dQ\u00151WA[\u0003oCa\u0001KAW\u0001\u0004Q\u0003BB\u0019\u0002.\u0002\u00071\u0007\u0003\u0004>\u0003[\u0003\ra\u0010\u0005\u000b\u0003w\u000b\u0019*!A\u0005\u0002\u0006u\u0016aB;oCB\u0004H.\u001f\u000b\u0005\u0003\u007f\u000bY\rE\u0003 \u0003\u0003\f)-C\u0002\u0002D\u0002\u0012aa\u00149uS>t\u0007CB\u0010\u0002H*\u001at(C\u0002\u0002J\u0002\u0012a\u0001V;qY\u0016\u001c\u0004\"CAg\u0003s\u000b\t\u00111\u0001K\u0003\rAH\u0005\r\u0005\u000b\u0003#\f\u0019*!A\u0005\n\u0005M\u0017a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!!6\u0011\t\u0005u\u0012q[\u0005\u0005\u00033\fyD\u0001\u0004PE*,7\r\u001e")
public class AlterHoodieTableChangeColumnCommand
extends LogicalPlan
implements HoodieLeafRunnableCommand,
Serializable {
    private final TableIdentifier tableIdentifier;
    private final String columnName;
    private final StructField newColumn;
    private final Map<String, SQLMetric> metrics;
    private volatile boolean bitmap$0;

    public static Option<Tuple3<TableIdentifier, String, StructField>> unapply(AlterHoodieTableChangeColumnCommand alterHoodieTableChangeColumnCommand) {
        return AlterHoodieTableChangeColumnCommand$.MODULE$.unapply(alterHoodieTableChangeColumnCommand);
    }

    public static Function1<Tuple3<TableIdentifier, String, StructField>, AlterHoodieTableChangeColumnCommand> tupled() {
        return AlterHoodieTableChangeColumnCommand$.MODULE$.tupled();
    }

    public static Function1<TableIdentifier, Function1<String, Function1<StructField, AlterHoodieTableChangeColumnCommand>>> curried() {
        return AlterHoodieTableChangeColumnCommand$.MODULE$.curried();
    }

    @Override
    public final Seq<LogicalPlan> children() {
        return HoodieLeafLike$class.children((TreeNode)this);
    }

    @Override
    public final TreeNode mapChildren(Function1 f) {
        return HoodieLeafLike$class.mapChildren((TreeNode)this, f);
    }

    @Override
    public final TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return HoodieLeafLike$class.withNewChildrenInternal((TreeNode)this, newChildren);
    }

    private Map metrics$lzycompute() {
        AlterHoodieTableChangeColumnCommand alterHoodieTableChangeColumnCommand = this;
        synchronized (alterHoodieTableChangeColumnCommand) {
            if (!this.bitmap$0) {
                this.metrics = RunnableCommand.class.metrics((RunnableCommand)this);
                this.bitmap$0 = true;
            }
            return this.metrics;
        }
    }

    public Map<String, SQLMetric> metrics() {
        return this.bitmap$0 ? this.metrics : this.metrics$lzycompute();
    }

    public Seq<Attribute> output() {
        return Command.class.output((Command)this);
    }

    public TableIdentifier tableIdentifier() {
        return this.tableIdentifier;
    }

    public String columnName() {
        return this.columnName;
    }

    public StructField newColumn() {
        return this.newColumn;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Seq<Row> run(SparkSession sparkSession) {
        Tuple2 tuple2;
        Function2 resolver = sparkSession.sessionState().conf().resolver();
        HoodieCatalogTable hoodieCatalogTable = HoodieCatalogTable$.MODULE$.apply(sparkSession, this.tableIdentifier());
        StructField originColumn = (StructField)HoodieSqlCommonUtils$.MODULE$.findColumnByName(hoodieCatalogTable.dataSchema(), this.columnName(), (Function2<String, String, Object>)resolver).getOrElse((Function0)new Serializable(this, hoodieCatalogTable){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AlterHoodieTableChangeColumnCommand $outer;
            private final HoodieCatalogTable hoodieCatalogTable$1;

            public final Nothing$ apply() {
                throw new AnalysisException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Can't find column `", "` given table data columns "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.columnName()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.refArrayOps((Object[])this.hoodieCatalogTable$1.dataSchema().fieldNames()).mkString("[`", "`, `", "`]")}))).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.hoodieCatalogTable$1 = hoodieCatalogTable$1;
            }
        });
        if (!HoodieSqlCommonUtils$.MODULE$.columnEqual(originColumn, this.newColumn(), (Function2<String, String, Object>)resolver)) throw new AnalysisException(new StringBuilder().append((Object)"ALTER TABLE CHANGE COLUMN is not supported for changing column ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"'", "' with type '", "' to "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{originColumn.name(), originColumn.dataType()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"'", "' with type '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.newColumn().name(), this.newColumn().dataType()}))).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        StructType newTableSchema = new StructType((StructField[])Predef$.MODULE$.refArrayOps((Object[])hoodieCatalogTable.tableSchema().fields()).map((Function1)new Serializable(this, originColumn){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AlterHoodieTableChangeColumnCommand $outer;
            private final StructField originColumn$1;

            public final StructField apply(StructField field) {
                String string = field.name();
                String string2 = this.originColumn$1.name();
                return !(string != null ? !string.equals(string2) : string2 != null) ? this.$outer.newColumn() : field;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.originColumn$1 = originColumn$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class))));
        StructType newDataSchema = new StructType((StructField[])Predef$.MODULE$.refArrayOps((Object[])hoodieCatalogTable.dataSchema().fields()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AlterHoodieTableChangeColumnCommand $outer;

            public final StructField apply(StructField field) {
                String string = field.name();
                String string2 = this.$outer.columnName();
                return !(string != null ? !string.equals(string2) : string2 != null) ? this.$outer.newColumn() : field;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class))));
        Tuple2 tuple22 = AvroConversionUtils$.MODULE$.getAvroRecordNameAndNamespace(this.tableIdentifier().table());
        if (tuple22 == null) throw new MatchError((Object)tuple22);
        String structName = (String)tuple22._1();
        String nameSpace = (String)tuple22._2();
        Tuple2 tuple23 = tuple2 = new Tuple2((Object)structName, (Object)nameSpace);
        String structName2 = (String)tuple23._1();
        String nameSpace2 = (String)tuple23._2();
        Schema newSchema = AvroConversionUtils$.MODULE$.convertStructTypeToAvroSchema((DataType)newTableSchema, structName2, nameSpace2);
        this.validateSchema(newSchema, hoodieCatalogTable.metaClient());
        AlterHoodieTableAddColumnsCommand$.MODULE$.commitWithSchema(newSchema, hoodieCatalogTable, sparkSession);
        try {
            sparkSession.catalog().uncacheTable(this.tableIdentifier().quotedString());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            this.log().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Exception when attempting to uncache table ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tableIdentifier().quotedString()})), e);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        sparkSession.catalog().refreshTable(this.tableIdentifier().unquotedString());
        sparkSession.sessionState().catalog().alterTableDataSchema(this.tableIdentifier(), newDataSchema);
        return (Seq)Seq$.MODULE$.empty();
    }

    private void validateSchema(Schema newSchema, HoodieTableMetaClient metaClient) {
        TableSchemaResolver schemaUtil = new TableSchemaResolver(metaClient);
        Schema tableSchema = HoodieAvroUtils.createHoodieWriteSchema((Schema)schemaUtil.getTableAvroSchema(false));
        if (AvroSchemaUtils.isSchemaCompatible((Schema)tableSchema, (Schema)newSchema)) {
            return;
        }
        throw new HoodieException(new StringBuilder().append((Object)"Failed schema compatibility check for newSchema :").append((Object)newSchema).append((Object)", origin table schema :").append((Object)tableSchema).append((Object)", base path :").append((Object)metaClient.getBasePath()).toString());
    }

    public AlterHoodieTableChangeColumnCommand copy(TableIdentifier tableIdentifier, String columnName, StructField newColumn) {
        return new AlterHoodieTableChangeColumnCommand(tableIdentifier, columnName, newColumn);
    }

    public TableIdentifier copy$default$1() {
        return this.tableIdentifier();
    }

    public String copy$default$2() {
        return this.columnName();
    }

    public StructField copy$default$3() {
        return this.newColumn();
    }

    public String productPrefix() {
        return "AlterHoodieTableChangeColumnCommand";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 2: {
                object = this.newColumn();
                break;
            }
            case 1: {
                object = this.columnName();
                break;
            }
            case 0: {
                object = this.tableIdentifier();
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof AlterHoodieTableChangeColumnCommand;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof AlterHoodieTableChangeColumnCommand)) return false;
        boolean bl = true;
        if (!bl) return false;
        AlterHoodieTableChangeColumnCommand alterHoodieTableChangeColumnCommand = (AlterHoodieTableChangeColumnCommand)x$1;
        TableIdentifier tableIdentifier = this.tableIdentifier();
        TableIdentifier tableIdentifier2 = alterHoodieTableChangeColumnCommand.tableIdentifier();
        if (tableIdentifier == null) {
            if (tableIdentifier2 != null) {
                return false;
            }
        } else if (!tableIdentifier.equals(tableIdentifier2)) return false;
        String string = this.columnName();
        String string2 = alterHoodieTableChangeColumnCommand.columnName();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        StructField structField = this.newColumn();
        StructField structField2 = alterHoodieTableChangeColumnCommand.newColumn();
        if (structField == null) {
            if (structField2 != null) {
                return false;
            }
        } else if (!structField.equals(structField2)) return false;
        if (!alterHoodieTableChangeColumnCommand.canEqual(this)) return false;
        return true;
    }

    public AlterHoodieTableChangeColumnCommand(TableIdentifier tableIdentifier, String columnName, StructField newColumn) {
        this.tableIdentifier = tableIdentifier;
        this.columnName = columnName;
        this.newColumn = newColumn;
        Command.class.$init$((Command)this);
        RunnableCommand.class.$init$((RunnableCommand)this);
        HoodieLeafLike$class.$init$((TreeNode)this);
    }
}

