/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.command;

import java.util.Properties;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.DataSourceWriteOptions$;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.hadoop.HoodieParquetInputFormat;
import org.apache.hudi.hadoop.realtime.HoodieParquetRealtimeInputFormat;
import org.apache.hudi.hadoop.utils.HoodieInputFormatUtils;
import org.apache.spark.SparkConf;
import org.apache.spark.package$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.analysis.NoSuchDatabaseException;
import org.apache.spark.sql.catalyst.catalog.BucketSpec;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.catalyst.catalog.HoodieCatalogTable;
import org.apache.spark.sql.catalyst.catalog.HoodieCatalogTable$;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.hive.HiveClientUtils$;
import org.apache.spark.sql.hive.HiveExternalCatalog$;
import org.apache.spark.sql.hive.client.HiveClient;
import org.apache.spark.sql.hudi.HoodieOptionConfig$;
import org.apache.spark.sql.hudi.HoodieSqlCommonUtils$;
import org.apache.spark.sql.hudi.command.CreateHoodieTableCommand;
import org.apache.spark.sql.internal.StaticSQLConf$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.MapLike;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;

public final class CreateHoodieTableCommand$
implements Serializable {
    public static final CreateHoodieTableCommand$ MODULE$;

    static {
        new CreateHoodieTableCommand$();
    }

    public void validateTblProperties(HoodieCatalogTable hoodieCatalogTable) {
        if (hoodieCatalogTable.hoodieTableExists()) {
            Map originTableConfig = ((TraversableOnce)JavaConverters$.MODULE$.propertiesAsScalaMapConverter((Properties)hoodieCatalogTable.tableConfig().getProps()).asScala()).toMap(Predef$.MODULE$.$conforms());
            Map<String, String> tableOptions = hoodieCatalogTable.catalogProperties();
            this.checkTableConfigEqual((Map<String, String>)originTableConfig, tableOptions, HoodieTableConfig.PRECOMBINE_FIELD.key());
            this.checkTableConfigEqual((Map<String, String>)originTableConfig, tableOptions, HoodieTableConfig.PARTITION_FIELDS.key());
            this.checkTableConfigEqual((Map<String, String>)originTableConfig, tableOptions, HoodieTableConfig.RECORDKEY_FIELDS.key());
            this.checkTableConfigEqual((Map<String, String>)originTableConfig, tableOptions, HoodieTableConfig.KEY_GENERATOR_CLASS_NAME.key());
            this.checkTableConfigEqual((Map<String, String>)originTableConfig, tableOptions, HoodieTableConfig.URL_ENCODE_PARTITIONING.key());
            this.checkTableConfigEqual((Map<String, String>)originTableConfig, tableOptions, HoodieTableConfig.HIVE_STYLE_PARTITIONING_ENABLE.key());
        }
    }

    public void createTableInCatalog(SparkSession sparkSession, HoodieCatalogTable hoodieCatalogTable, boolean ignoreIfExists, Option<String> queryAsProp) {
        String tableType;
        block7: {
            String string;
            Map properties;
            String path;
            SessionCatalog catalog;
            CatalogTable table;
            block6: {
                String string2;
                block5: {
                    table = hoodieCatalogTable.table();
                    CatalogTableType catalogTableType = table.tableType();
                    CatalogTableType catalogTableType2 = CatalogTableType$.MODULE$.VIEW();
                    Predef$.MODULE$.assert(catalogTableType != null ? !catalogTableType.equals(catalogTableType2) : catalogTableType2 != null);
                    catalog = sparkSession.sessionState().catalog();
                    path = hoodieCatalogTable.tableLocation();
                    HoodieTableConfig tableConfig = hoodieCatalogTable.tableConfig();
                    properties = ((TraversableOnce)JavaConverters$.MODULE$.propertiesAsScalaMapConverter((Properties)tableConfig.getProps()).asScala()).toMap(Predef$.MODULE$.$conforms());
                    string2 = tableType = tableConfig.getTableType().name();
                    String string3 = DataSourceWriteOptions$.MODULE$.COW_TABLE_TYPE_OPT_VAL();
                    String string4 = string2;
                    if (string3 != null ? !string3.equals(string4) : string4 != null) break block5;
                    string = HoodieParquetInputFormat.class.getCanonicalName();
                    break block6;
                }
                String string5 = DataSourceWriteOptions$.MODULE$.MOR_TABLE_TYPE_OPT_VAL();
                String string6 = string2;
                if (string5 != null ? !string5.equals(string6) : string6 != null) break block7;
                string = HoodieParquetRealtimeInputFormat.class.getCanonicalName();
            }
            String inputFormat = string;
            String outputFormat = HoodieInputFormatUtils.getOutputFormatClassName((HoodieFileFormat)HoodieFileFormat.PARQUET);
            String serdeFormat = HoodieInputFormatUtils.getSerDeClassName((HoodieFileFormat)HoodieFileFormat.PARQUET);
            Map<String, String> storageProperties = HoodieOptionConfig$.MODULE$.deleteHoodieOptions((Map<String, String>)properties);
            CatalogStorageFormat newStorage = new CatalogStorageFormat((Option)new Some((Object)new Path(path).toUri()), (Option)new Some((Object)inputFormat), (Option)new Some((Object)outputFormat), (Option)new Some((Object)serdeFormat), table.storage().compressed(), storageProperties.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), (Object)path)).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(queryAsProp.map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Tuple2<String, String> apply(String x$1) {
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.query.as.ro.table"), (Object)x$1);
                }
            }))));
            String tableName = HoodieSqlCommonUtils$.MODULE$.formatName(sparkSession, table.identifier().table());
            String newDatabaseName = HoodieSqlCommonUtils$.MODULE$.formatName(sparkSession, (String)table.identifier().database().getOrElse((Function0)new Serializable(catalog){
                public static final long serialVersionUID = 0L;
                private final SessionCatalog catalog$1;

                public final String apply() {
                    return this.catalog$1.getCurrentDatabase();
                }
                {
                    this.catalog$1 = catalog$1;
                }
            }));
            TableIdentifier newTableIdentifier = table.identifier().copy(tableName, (Option)new Some((Object)newDatabaseName));
            Seq partitionColumnNames = (Seq)hoodieCatalogTable.partitionSchema().map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(StructField x$2) {
                    return x$2.name();
                }
            }, Seq$.MODULE$.canBuildFrom());
            Map newTblProperties = ((MapLike)hoodieCatalogTable.catalogProperties().$minus$minus(HoodieCatalogTable$.MODULE$.needFilterProps())).$plus$plus(HoodieOptionConfig$.MODULE$.extractSqlOptions((Map<String, String>)properties));
            TableIdentifier x$4 = newTableIdentifier;
            CatalogStorageFormat x$5 = newStorage;
            StructType x$6 = hoodieCatalogTable.tableSchema();
            Seq x$7 = partitionColumnNames;
            String x$8 = package$.MODULE$.SPARK_VERSION();
            Map x$9 = newTblProperties;
            CatalogTableType x$10 = table.copy$default$2();
            Option x$11 = table.copy$default$5();
            Option x$12 = table.copy$default$7();
            String x$13 = table.copy$default$8();
            long x$14 = table.copy$default$9();
            long x$15 = table.copy$default$10();
            Option x$16 = table.copy$default$13();
            Option x$17 = table.copy$default$14();
            Option x$18 = table.copy$default$15();
            Seq x$19 = table.copy$default$16();
            boolean x$20 = table.copy$default$17();
            boolean x$21 = table.copy$default$18();
            Map x$22 = table.copy$default$19();
            CatalogTable newTable = table.copy(x$4, x$10, x$5, x$6, x$11, x$7, x$12, x$13, x$14, x$15, x$8, x$9, x$16, x$17, x$18, x$19, x$20, x$21, x$22);
            boolean enableHive = HoodieSqlCommonUtils$.MODULE$.isUsingHiveCatalog(sparkSession);
            if (enableHive) {
                this.createHiveDataSourceTable(sparkSession, newTable, ignoreIfExists);
            } else {
                catalog.createTable(newTable, false, false);
            }
            return;
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"UnKnow table type:", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableType})));
    }

    public Option<String> createTableInCatalog$default$4() {
        return None$.MODULE$;
    }

    /*
     * WARNING - void declaration
     */
    private void createHiveDataSourceTable(SparkSession sparkSession, CatalogTable table, boolean ignoreIfExists) {
        void var4_4;
        String dbName = (String)table.identifier().database().get();
        boolean dbExists = sparkSession.sessionState().catalog().databaseExists(dbName);
        if (dbExists) {
            Map<String, String> dataSourceProps = this.tableMetaToTableProps(sparkSession.sparkContext().conf(), table, table.schema());
            Map x$23 = dataSourceProps.$plus$plus((GenTraversableOnce)table.properties());
            TableIdentifier x$24 = table.copy$default$1();
            CatalogTableType x$25 = table.copy$default$2();
            CatalogStorageFormat x$26 = table.copy$default$3();
            StructType x$27 = table.copy$default$4();
            Option x$28 = table.copy$default$5();
            Seq x$29 = table.copy$default$6();
            Option x$30 = table.copy$default$7();
            String x$31 = table.copy$default$8();
            long x$32 = table.copy$default$9();
            long x$33 = table.copy$default$10();
            String x$34 = table.copy$default$11();
            Option x$35 = table.copy$default$13();
            Option x$36 = table.copy$default$14();
            Option x$37 = table.copy$default$15();
            Seq x$38 = table.copy$default$16();
            boolean x$39 = table.copy$default$17();
            boolean x$40 = table.copy$default$18();
            Map x$41 = table.copy$default$19();
            CatalogTable tableWithDataSourceProps = table.copy(x$24, x$25, x$26, x$27, x$28, x$29, x$30, x$31, x$32, x$33, x$34, x$23, x$35, x$36, x$37, x$38, x$39, x$40, x$41);
            HiveClient client = HiveClientUtils$.MODULE$.getSingletonClientForMetadata(sparkSession);
            client.createTable(tableWithDataSourceProps, true);
            return;
        }
        throw new NoSuchDatabaseException((String)var4_4);
    }

    private Map<String, String> tableMetaToTableProps(SparkConf sparkConf, CatalogTable table, StructType schema2) {
        Seq partitionColumns = table.partitionColumnNames();
        Option bucketSpec = table.bucketSpec();
        HashMap properties = new HashMap();
        properties.put((Object)HiveExternalCatalog$.MODULE$.DATASOURCE_PROVIDER(), (Object)"hudi");
        properties.put((Object)HiveExternalCatalog$.MODULE$.CREATED_SPARK_VERSION(), (Object)table.createVersion());
        int threshold = BoxesRunTime.unboxToInt((Object)sparkConf.get(StaticSQLConf$.MODULE$.SCHEMA_STRING_LENGTH_THRESHOLD()));
        String schemaJsonString = schema2.json();
        Seq parts = new StringOps(Predef$.MODULE$.augmentString(schemaJsonString)).grouped(threshold).toSeq();
        properties.put((Object)new StringBuilder().append((Object)HiveExternalCatalog$.MODULE$.DATASOURCE_SCHEMA_PREFIX()).append((Object)"numParts").toString(), (Object)((Object)BoxesRunTime.boxToInteger((int)parts.size())).toString());
        ((IterableLike)parts.zipWithIndex(Seq$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(properties){
            public static final long serialVersionUID = 0L;
            private final HashMap properties$1;

            public final Option<String> apply(Tuple2<String, Object> x0$1) {
                Tuple2<String, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    String part = (String)tuple2._1();
                    int index = tuple2._2$mcI$sp();
                    Option option = this.properties$1.put((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{HiveExternalCatalog$.MODULE$.DATASOURCE_SCHEMA_PART_PREFIX(), BoxesRunTime.boxToInteger((int)index)})), (Object)part);
                    return option;
                }
                throw new MatchError(tuple2);
            }
            {
                this.properties$1 = properties$1;
            }
        });
        if (partitionColumns.nonEmpty()) {
            properties.put((Object)HiveExternalCatalog$.MODULE$.DATASOURCE_SCHEMA_NUMPARTCOLS(), (Object)((Object)BoxesRunTime.boxToInteger((int)partitionColumns.length())).toString());
            ((IterableLike)partitionColumns.zipWithIndex(Seq$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(properties){
                public static final long serialVersionUID = 0L;
                private final HashMap properties$1;

                public final Option<String> apply(Tuple2<String, Object> x0$2) {
                    Tuple2<String, Object> tuple2 = x0$2;
                    if (tuple2 != null) {
                        String partCol = (String)tuple2._1();
                        int index = tuple2._2$mcI$sp();
                        Option option = this.properties$1.put((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{HiveExternalCatalog$.MODULE$.DATASOURCE_SCHEMA_PARTCOL_PREFIX(), BoxesRunTime.boxToInteger((int)index)})), (Object)partCol);
                        return option;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.properties$1 = properties$1;
                }
            });
        }
        if (bucketSpec.isDefined()) {
            BucketSpec bucketSpec2 = (BucketSpec)bucketSpec.get();
            if (bucketSpec2 != null) {
                Tuple3 tuple3;
                int numBuckets = bucketSpec2.numBuckets();
                Seq bucketColumnNames = bucketSpec2.bucketColumnNames();
                Seq sortColumnNames = bucketSpec2.sortColumnNames();
                Tuple3 tuple32 = tuple3 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)numBuckets), (Object)bucketColumnNames, (Object)sortColumnNames);
                int numBuckets2 = BoxesRunTime.unboxToInt((Object)tuple32._1());
                Seq bucketColumnNames2 = (Seq)tuple32._2();
                Seq sortColumnNames2 = (Seq)tuple32._3();
                properties.put((Object)HiveExternalCatalog$.MODULE$.DATASOURCE_SCHEMA_NUMBUCKETS(), (Object)((Object)BoxesRunTime.boxToInteger((int)numBuckets2)).toString());
                properties.put((Object)HiveExternalCatalog$.MODULE$.DATASOURCE_SCHEMA_NUMBUCKETCOLS(), (Object)((Object)BoxesRunTime.boxToInteger((int)bucketColumnNames2.length())).toString());
                ((IterableLike)bucketColumnNames2.zipWithIndex(Seq$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(properties){
                    public static final long serialVersionUID = 0L;
                    private final HashMap properties$1;

                    public final Option<String> apply(Tuple2<String, Object> x0$3) {
                        Tuple2<String, Object> tuple2 = x0$3;
                        if (tuple2 != null) {
                            String bucketCol = (String)tuple2._1();
                            int index = tuple2._2$mcI$sp();
                            Option option = this.properties$1.put((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{HiveExternalCatalog$.MODULE$.DATASOURCE_SCHEMA_BUCKETCOL_PREFIX(), BoxesRunTime.boxToInteger((int)index)})), (Object)bucketCol);
                            return option;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        this.properties$1 = properties$1;
                    }
                });
                if (sortColumnNames2.nonEmpty()) {
                    properties.put((Object)HiveExternalCatalog$.MODULE$.DATASOURCE_SCHEMA_NUMSORTCOLS(), (Object)((Object)BoxesRunTime.boxToInteger((int)sortColumnNames2.length())).toString());
                    ((IterableLike)sortColumnNames2.zipWithIndex(Seq$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(properties){
                        public static final long serialVersionUID = 0L;
                        private final HashMap properties$1;

                        public final Option<String> apply(Tuple2<String, Object> x0$4) {
                            Tuple2<String, Object> tuple2 = x0$4;
                            if (tuple2 != null) {
                                String sortCol = (String)tuple2._1();
                                int index = tuple2._2$mcI$sp();
                                Option option = this.properties$1.put((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{HiveExternalCatalog$.MODULE$.DATASOURCE_SCHEMA_SORTCOL_PREFIX(), BoxesRunTime.boxToInteger((int)index)})), (Object)sortCol);
                                return option;
                            }
                            throw new MatchError(tuple2);
                        }
                        {
                            this.properties$1 = properties$1;
                        }
                    });
                }
            } else {
                throw new MatchError((Object)bucketSpec2);
            }
        }
        return properties.toMap(Predef$.MODULE$.$conforms());
    }

    private void checkTableConfigEqual(Map<String, String> originTableConfig, Map<String, String> newTableConfig, String configKey) {
        if (originTableConfig.contains((Object)configKey) && newTableConfig.contains((Object)configKey)) {
            Predef$.MODULE$.assert(BoxesRunTime.equals((Object)originTableConfig.apply((Object)configKey), (Object)newTableConfig.apply((Object)configKey)), (Function0)new Serializable(originTableConfig, newTableConfig, configKey){
                public static final long serialVersionUID = 0L;
                private final Map originTableConfig$1;
                private final Map newTableConfig$1;
                private final String configKey$1;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Table config: ", " in the create table is: ", ", is not the same with the value in "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.configKey$1, this.newTableConfig$1.apply((Object)this.configKey$1)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hoodie.properties, which is:  ", ". Please keep the same."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.originTableConfig$1.apply((Object)this.configKey$1)}))).toString();
                }
                {
                    this.originTableConfig$1 = originTableConfig$1;
                    this.newTableConfig$1 = newTableConfig$1;
                    this.configKey$1 = configKey$1;
                }
            });
        }
    }

    public CreateHoodieTableCommand apply(CatalogTable table, boolean ignoreIfExists) {
        return new CreateHoodieTableCommand(table, ignoreIfExists);
    }

    public Option<Tuple2<CatalogTable, Object>> unapply(CreateHoodieTableCommand x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple2((Object)x$0.table(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.ignoreIfExists())));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private CreateHoodieTableCommand$() {
        MODULE$ = this;
    }
}

