/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.command;

import java.net.URI;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTablePartition;
import org.apache.spark.sql.catalyst.catalog.CatalogTablePartition$;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.HoodieCatalogTable;
import org.apache.spark.sql.catalyst.catalog.HoodieCatalogTable$;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.plans.logical.Command;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.trees.HoodieLeafLike$class;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.execution.command.PartitionStatistics;
import org.apache.spark.sql.execution.command.RunnableCommand;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.hudi.HoodieSqlCommonUtils$;
import org.apache.spark.sql.hudi.command.HoodieLeafRunnableCommand;
import org.apache.spark.sql.hudi.command.RepairHoodieTableCommand$;
import org.apache.spark.sql.hudi.command.RepairHoodieTableCommand$$anonfun$addPartitions$1$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.ThreadUtils$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.GenIterable;
import scala.collection.IndexedSeq;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\tUc\u0001B\u0001\u0003\u0001>\u0011\u0001DU3qC&\u0014\bj\\8eS\u0016$\u0016M\u00197f\u0007>lW.\u00198e\u0015\t\u0019A!A\u0004d_6l\u0017M\u001c3\u000b\u0005\u00151\u0011\u0001\u00025vI&T!a\u0002\u0005\u0002\u0007M\fHN\u0003\u0002\n\u0015\u0005)1\u000f]1sW*\u00111\u0002D\u0001\u0007CB\f7\r[3\u000b\u00035\t1a\u001c:h\u0007\u0001\u0019R\u0001\u0001\t\u001b=\u0011\u0002\"!\u0005\r\u000e\u0003IQ!a\u0005\u000b\u0002\u000f1|w-[2bY*\u0011QCF\u0001\u0006a2\fgn\u001d\u0006\u0003/\u0019\t\u0001bY1uC2L8\u000f^\u0005\u00033I\u00111\u0002T8hS\u000e\fG\u000e\u00157b]B\u00111\u0004H\u0007\u0002\u0005%\u0011QD\u0001\u0002\u001a\u0011>|G-[3MK\u00064'+\u001e8oC\ndWmQ8n[\u0006tG\r\u0005\u0002 E5\t\u0001EC\u0001\"\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0003EA\u0004Qe>$Wo\u0019;\u0011\u0005})\u0013B\u0001\u0014!\u00051\u0019VM]5bY&T\u0018M\u00197f\u0011!A\u0003A!f\u0001\n\u0003I\u0013!\u0003;bE2,g*Y7f+\u0005Q\u0003CA\u0016-\u001b\u00051\u0012BA\u0017\u0017\u0005=!\u0016M\u00197f\u0013\u0012,g\u000e^5gS\u0016\u0014\b\u0002C\u0018\u0001\u0005#\u0005\u000b\u0011\u0002\u0016\u0002\u0015Q\f'\r\\3OC6,\u0007\u0005\u0003\u00052\u0001\tU\r\u0011\"\u00013\u0003M)g.\u00192mK\u0006#G\rU1si&$\u0018n\u001c8t+\u0005\u0019\u0004CA\u00105\u0013\t)\u0004EA\u0004C_>dW-\u00198\t\u0011]\u0002!\u0011#Q\u0001\nM\nA#\u001a8bE2,\u0017\t\u001a3QCJ$\u0018\u000e^5p]N\u0004\u0003\u0002C\u001d\u0001\u0005+\u0007I\u0011\u0001\u001a\u0002)\u0015t\u0017M\u00197f\tJ|\u0007\u000fU1si&$\u0018n\u001c8t\u0011!Y\u0004A!E!\u0002\u0013\u0019\u0014!F3oC\ndW\r\u0012:paB\u000b'\u000f^5uS>t7\u000f\t\u0005\t{\u0001\u0011)\u001a!C\u0001}\u0005\u00191-\u001c3\u0016\u0003}\u0002\"\u0001Q\"\u000f\u0005}\t\u0015B\u0001\"!\u0003\u0019\u0001&/\u001a3fM&\u0011A)\u0012\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\t\u0003\u0003\u0002C$\u0001\u0005#\u0005\u000b\u0011B \u0002\t\rlG\r\t\u0005\u0006\u0013\u0002!\tAS\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000b-cUJT(\u0011\u0005m\u0001\u0001\"\u0002\u0015I\u0001\u0004Q\u0003\"B\u0019I\u0001\u0004\u0019\u0004\"B\u001dI\u0001\u0004\u0019\u0004bB\u001fI!\u0003\u0005\ra\u0010\u0005\b#\u0002\u0011\r\u0011\"\u0001S\u0003%qU+T0G\u00132+5+F\u0001T!\t!\u0016,D\u0001V\u0015\t1v+\u0001\u0003mC:<'\"\u0001-\u0002\t)\fg/Y\u0005\u0003\tVCaa\u0017\u0001!\u0002\u0013\u0019\u0016A\u0003(V\u001b~3\u0015\nT#TA!9Q\f\u0001b\u0001\n\u0003\u0011\u0016A\u0003+P)\u0006culU%[\u000b\"1q\f\u0001Q\u0001\nM\u000b1\u0002V(U\u00032{6+\u0013.FA!9\u0011\r\u0001b\u0001\n\u0003\u0011\u0016\u0001\u0003#E\u0019~#\u0016*T#\t\r\r\u0004\u0001\u0015!\u0003T\u0003%!E\tT0U\u00136+\u0005\u0005C\u0003f\u0001\u0011\u0005c-A\u0002sk:$\"aZ<\u0011\u0007!\u00048O\u0004\u0002j]:\u0011!.\\\u0007\u0002W*\u0011AND\u0001\u0007yI|w\u000e\u001e \n\u0003\u0005J!a\u001c\u0011\u0002\u000fA\f7m[1hK&\u0011\u0011O\u001d\u0002\u0004'\u0016\f(BA8!!\t!X/D\u0001\u0007\u0013\t1hAA\u0002S_^DQ!\u00033A\u0002a\u0004\"\u0001^=\n\u0005i4!\u0001D*qCJ\\7+Z:tS>t\u0007\"\u0002?\u0001\t\u0013i\u0018!D1eIB\u000b'\u000f^5uS>t7\u000fF\u0005\u007f\u0003\u0007\t)!!\u0006\u0002XA\u0011qd`\u0005\u0004\u0003\u0003\u0001#\u0001B+oSRDQ!C>A\u0002aDq!a\u0002|\u0001\u0004\tI!A\u0003uC\ndW\r\u0005\u0003\u0002\f\u0005EQBAA\u0007\u0015\r\tyAF\u0001\bG\u0006$\u0018\r\\8h\u0013\u0011\t\u0019\"!\u0004\u0003\u0019\r\u000bG/\u00197pOR\u000b'\r\\3\t\u000f\u0005]1\u00101\u0001\u0002\u001a\u0005)\u0002/\u0019:uSRLwN\\*qK\u000e\u001c\u0018I\u001c3M_\u000e\u001c\b\u0003\u00025q\u00037\u0001raHA\u000f\u0003C\t9%C\u0002\u0002 \u0001\u0012a\u0001V;qY\u0016\u0014\u0004\u0003BA\u0012\u0003\u0003rA!!\n\u0002>9!\u0011qEA\u001e\u001d\u0011\tI#!\u000f\u000f\t\u0005-\u0012q\u0007\b\u0005\u0003[\t)D\u0004\u0003\u00020\u0005Mbb\u00016\u00022%\tQ\"\u0003\u0002\f\u0019%\u0011\u0011BC\u0005\u0003\u000f!I!a\u0006\u0004\n\u0007\u0005=a#\u0003\u0003\u0002@\u00055\u0011\u0001D\"bi\u0006dwn\u001a+za\u0016\u001c\u0018\u0002BA\"\u0003\u000b\u0012!\u0003V1cY\u0016\u0004\u0016M\u001d;ji&|gn\u00159fG*!\u0011qHA\u0007!\u0011\tI%a\u0015\u000e\u0005\u0005-#\u0002BA'\u0003\u001f\n!AZ:\u000b\u0007\u0005E#\"\u0001\u0004iC\u0012|w\u000e]\u0005\u0005\u0003+\nYE\u0001\u0003QCRD\u0007bBA-w\u0002\u0007\u00111L\u0001\u000fa\u0006\u0014H/\u001b;j_:\u001cF/\u0019;t!\u0019\u0001\u0015QL \u0002b%\u0019\u0011qL#\u0003\u00075\u000b\u0007\u000f\u0005\u0003\u0002d\u0005-TBAA3\u0015\r\u0019\u0011q\r\u0006\u0004\u0003S2\u0011!C3yK\u000e,H/[8o\u0013\u0011\ti'!\u001a\u0003'A\u000b'\u000f^5uS>t7\u000b^1uSN$\u0018nY:\t\u000f\u0005E\u0004\u0001\"\u0003\u0002t\u0005qAM]8q!\u0006\u0014H/\u001b;j_:\u001cHCBA;\u0003w\n\u0019\tE\u0002 \u0003oJ1!!\u001f!\u0005\rIe\u000e\u001e\u0005\t\u0003\u001f\ty\u00071\u0001\u0002~A!\u00111BA@\u0013\u0011\t\t)!\u0004\u0003\u001dM+7o]5p]\u000e\u000bG/\u00197pO\"A\u0011qCA8\u0001\u0004\tI\u0002C\u0005\u0002\b\u0002\t\t\u0011\"\u0001\u0002\n\u0006!1m\u001c9z)%Y\u00151RAG\u0003\u001f\u000b\t\n\u0003\u0005)\u0003\u000b\u0003\n\u00111\u0001+\u0011!\t\u0014Q\u0011I\u0001\u0002\u0004\u0019\u0004\u0002C\u001d\u0002\u0006B\u0005\t\u0019A\u001a\t\u0011u\n)\t%AA\u0002}B\u0011\"!&\u0001#\u0003%\t!a&\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011\u0011\u0014\u0016\u0004U\u0005m5FAAO!\u0011\ty*!+\u000e\u0005\u0005\u0005&\u0002BAR\u0003K\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\u001d\u0006%\u0001\u0006b]:|G/\u0019;j_:LA!a+\u0002\"\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u0013\u0005=\u0006!%A\u0005\u0002\u0005E\u0016AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0003gS3aMAN\u0011%\t9\fAI\u0001\n\u0003\t\t,\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001a\t\u0013\u0005m\u0006!%A\u0005\u0002\u0005u\u0016AD2paf$C-\u001a4bk2$H\u0005N\u000b\u0003\u0003\u007fS3aPAN\u0011!\t\u0019\rAA\u0001\n\u0003\u0012\u0016!\u00049s_\u0012,8\r\u001e)sK\u001aL\u0007\u0010C\u0005\u0002H\u0002\t\t\u0011\"\u0001\u0002J\u0006a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011Q\u000f\u0005\n\u0003\u001b\u0004\u0011\u0011!C\u0001\u0003\u001f\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002R\u0006]\u0007cA\u0010\u0002T&\u0019\u0011Q\u001b\u0011\u0003\u0007\u0005s\u0017\u0010\u0003\u0006\u0002Z\u0006-\u0017\u0011!a\u0001\u0003k\n1\u0001\u001f\u00132\u0011%\ti\u000eAA\u0001\n\u0003\ny.A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\t\t\u000f\u0005\u0004\u0002d\u0006%\u0018\u0011[\u0007\u0003\u0003KT1!a:!\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003W\f)O\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0011%\ty\u000fAA\u0001\n\u0003\t\t0\u0001\u0005dC:,\u0015/^1m)\r\u0019\u00141\u001f\u0005\u000b\u00033\fi/!AA\u0002\u0005E\u0007\"CA|\u0001\u0005\u0005I\u0011IA}\u0003\u0019)\u0017/^1mgR\u00191'a?\t\u0015\u0005e\u0017Q_A\u0001\u0002\u0004\t\tnB\u0005\u0002\u0000\n\t\t\u0011#\u0001\u0003\u0002\u0005A\"+\u001a9bSJDun\u001c3jKR\u000b'\r\\3D_6l\u0017M\u001c3\u0011\u0007m\u0011\u0019A\u0002\u0005\u0002\u0005\u0005\u0005\t\u0012\u0001B\u0003'\u0015\u0011\u0019Aa\u0002%!%\u0011IAa\u0004+gMz4*\u0004\u0002\u0003\f)\u0019!Q\u0002\u0011\u0002\u000fI,h\u000e^5nK&!!\u0011\u0003B\u0006\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|g\u000e\u000e\u0005\b\u0013\n\rA\u0011\u0001B\u000b)\t\u0011\t\u0001\u0003\u0006\u0003\u001a\t\r\u0011\u0011!C#\u00057\t\u0001\u0002^8TiJLgn\u001a\u000b\u0002'\"Q!q\u0004B\u0002\u0003\u0003%\tI!\t\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0013-\u0013\u0019C!\n\u0003(\t%\u0002B\u0002\u0015\u0003\u001e\u0001\u0007!\u0006\u0003\u00042\u0005;\u0001\ra\r\u0005\u0007s\tu\u0001\u0019A\u001a\t\u0011u\u0012i\u0002%AA\u0002}B!B!\f\u0003\u0004\u0005\u0005I\u0011\u0011B\u0018\u0003\u001d)h.\u00199qYf$BA!\r\u0003>A)qDa\r\u00038%\u0019!Q\u0007\u0011\u0003\r=\u0003H/[8o!\u001dy\"\u0011\b\u00164g}J1Aa\u000f!\u0005\u0019!V\u000f\u001d7fi!I!q\bB\u0016\u0003\u0003\u0005\raS\u0001\u0004q\u0012\u0002\u0004B\u0003B\"\u0005\u0007\t\n\u0011\"\u0001\u0002>\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIQB!Ba\u0012\u0003\u0004E\u0005I\u0011AA_\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012\"\u0004B\u0003B&\u0005\u0007\t\t\u0011\"\u0003\u0003N\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\u0011y\u0005E\u0002U\u0005#J1Aa\u0015V\u0005\u0019y%M[3di\u0002")
public class RepairHoodieTableCommand
extends LogicalPlan
implements HoodieLeafRunnableCommand,
Serializable {
    private final TableIdentifier tableName;
    private final boolean enableAddPartitions;
    private final boolean enableDropPartitions;
    private final String cmd;
    private final String NUM_FILES;
    private final String TOTAL_SIZE;
    private final String DDL_TIME;
    private final Map<String, SQLMetric> metrics;
    private volatile boolean bitmap$0;

    public static String apply$default$4() {
        return RepairHoodieTableCommand$.MODULE$.apply$default$4();
    }

    public static String $lessinit$greater$default$4() {
        return RepairHoodieTableCommand$.MODULE$.$lessinit$greater$default$4();
    }

    public static Option<Tuple4<TableIdentifier, Object, Object, String>> unapply(RepairHoodieTableCommand repairHoodieTableCommand) {
        return RepairHoodieTableCommand$.MODULE$.unapply(repairHoodieTableCommand);
    }

    public static Function1<Tuple4<TableIdentifier, Object, Object, String>, RepairHoodieTableCommand> tupled() {
        return RepairHoodieTableCommand$.MODULE$.tupled();
    }

    public static Function1<TableIdentifier, Function1<Object, Function1<Object, Function1<String, RepairHoodieTableCommand>>>> curried() {
        return RepairHoodieTableCommand$.MODULE$.curried();
    }

    @Override
    public final Seq<LogicalPlan> children() {
        return HoodieLeafLike$class.children((TreeNode)this);
    }

    @Override
    public final TreeNode mapChildren(Function1 f) {
        return HoodieLeafLike$class.mapChildren((TreeNode)this, f);
    }

    @Override
    public final TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return HoodieLeafLike$class.withNewChildrenInternal((TreeNode)this, newChildren);
    }

    private Map metrics$lzycompute() {
        RepairHoodieTableCommand repairHoodieTableCommand = this;
        synchronized (repairHoodieTableCommand) {
            if (!this.bitmap$0) {
                this.metrics = RunnableCommand.class.metrics((RunnableCommand)this);
                this.bitmap$0 = true;
            }
            return this.metrics;
        }
    }

    public Map<String, SQLMetric> metrics() {
        return this.bitmap$0 ? this.metrics : this.metrics$lzycompute();
    }

    public Seq<Attribute> output() {
        return Command.class.output((Command)this);
    }

    public TableIdentifier tableName() {
        return this.tableName;
    }

    public boolean enableAddPartitions() {
        return this.enableAddPartitions;
    }

    public boolean enableDropPartitions() {
        return this.enableDropPartitions;
    }

    public String cmd() {
        return this.cmd;
    }

    public String NUM_FILES() {
        return this.NUM_FILES;
    }

    public String TOTAL_SIZE() {
        return this.TOTAL_SIZE;
    }

    public String DDL_TIME() {
        return this.DDL_TIME;
    }

    public Seq<Row> run(SparkSession spark) {
        int n;
        int droppedAmount;
        SessionCatalog catalog = spark.sessionState().catalog();
        CatalogTable table = catalog.getTableMetadata(this.tableName());
        String tableIdentWithDB = table.identifier().quotedString();
        if (table.partitionColumnNames().isEmpty()) {
            throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Operation not allowed: ", " only works on partitioned tables: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.cmd(), tableIdentWithDB})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        if (table.storage().locationUri().isEmpty()) {
            throw new AnalysisException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Operation not allowed: ", " only works on table with "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.cmd()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"location provided: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableIdentWithDB}))).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        Path root = new Path(table.location());
        this.logInfo((Function0)new Serializable(this, root){
            public static final long serialVersionUID = 0L;
            private final Path root$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Recover all the partitions in ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.root$1}));
            }
            {
                this.root$1 = root$1;
            }
        });
        HoodieCatalogTable hoodieCatalogTable = HoodieCatalogTable$.MODULE$.apply(spark, table.identifier());
        boolean isHiveStyledPartitioning = new StringOps(Predef$.MODULE$.augmentString(hoodieCatalogTable.tableConfig().getHiveStylePartitioningEnable())).toBoolean();
        Seq partitionSpecsAndLocs = (Seq)hoodieCatalogTable.getPartitionPaths().map((Function1)new Serializable(this, table, root, isHiveStyledPartitioning){
            public static final long serialVersionUID = 0L;
            private final CatalogTable table$1;
            private final Path root$1;
            private final boolean isHiveStyledPartitioning$1;

            public final Tuple2<Map<String, String>, Path> apply(String partitionPath) {
                String[] values = new StringOps(Predef$.MODULE$.augmentString(partitionPath)).split('/');
                if (this.isHiveStyledPartitioning$1) {
                    values = (String[])Predef$.MODULE$.refArrayOps((Object[])values).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply(String x$1) {
                            return new StringOps(Predef$.MODULE$.augmentString(x$1)).split('=')[1];
                        }
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
                }
                return new Tuple2((Object)((TraversableOnce)this.table$1.partitionColumnNames().zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])values), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()), (Object)new Path(this.root$1, partitionPath));
            }
            {
                this.table$1 = table$1;
                this.root$1 = root$1;
                this.isHiveStyledPartitioning$1 = isHiveStyledPartitioning$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
        int n2 = droppedAmount = this.enableDropPartitions() ? this.dropPartitions(catalog, (Seq<Tuple2<Map<String, String>, Path>>)partitionSpecsAndLocs) : 0;
        if (this.enableAddPartitions()) {
            int total = partitionSpecsAndLocs.length();
            Map partitionStats = spark.sqlContext().conf().gatherFastStats() ? HoodieSqlCommonUtils$.MODULE$.getFilesInPartitions(spark, table, (Seq<String>)((Seq)partitionSpecsAndLocs.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(Tuple2<Map<String, String>, Path> x$2) {
                    return ((Path)x$2._2()).toString();
                }
            }, Seq$.MODULE$.canBuildFrom()))).mapValues((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final PartitionStatistics apply(FileStatus[] statuses) {
                    return new PartitionStatistics(statuses.length, BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.longArrayOps((long[])Predef$.MODULE$.refArrayOps((Object[])statuses).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final long apply(FileStatus x$3) {
                            return x$3.getLen();
                        }
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long()))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)));
                }
            }) : Predef$.MODULE$.Map().empty();
            this.logInfo((Function0)new Serializable(this, total){
                public static final long serialVersionUID = 0L;
                private final int total$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Finished to gather the fast stats for all ", " partitions."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.total$1)}));
                }
                {
                    this.total$1 = total$1;
                }
            });
            this.addPartitions(spark, table, (Seq<Tuple2<Map<String, String>, Path>>)partitionSpecsAndLocs, (Map<String, PartitionStatistics>)partitionStats);
            n = total;
        } else {
            n = 0;
        }
        int addedAmount = n;
        boolean x$5 = true;
        TableIdentifier x$6 = table.copy$default$1();
        CatalogTableType x$7 = table.copy$default$2();
        CatalogStorageFormat x$8 = table.copy$default$3();
        StructType x$9 = table.copy$default$4();
        Option x$10 = table.copy$default$5();
        Seq x$11 = table.copy$default$6();
        Option x$12 = table.copy$default$7();
        String x$13 = table.copy$default$8();
        long x$14 = table.copy$default$9();
        long x$15 = table.copy$default$10();
        String x$16 = table.copy$default$11();
        Map x$17 = table.copy$default$12();
        Option x$18 = table.copy$default$13();
        Option x$19 = table.copy$default$14();
        Option x$20 = table.copy$default$15();
        Seq x$21 = table.copy$default$16();
        boolean x$22 = table.copy$default$18();
        Map x$23 = table.copy$default$19();
        spark.sessionState().catalog().alterTable(table.copy(x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20, x$21, x$5, x$22, x$23));
        try {
            spark.catalog().refreshTable(tableIdentWithDB);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            this.logError((Function0)new Serializable(this, tableIdentWithDB){
                public static final long serialVersionUID = 0L;
                private final String tableIdentWithDB$1;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot refresh the table '", "'. A query of the table "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tableIdentWithDB$1}))).append((Object)"might return wrong result if the table was cached. To avoid such issue, you should ").append((Object)"uncache the table manually via the UNCACHE TABLE command after table recovering will ").append((Object)"complete fully.").toString();
                }
                {
                    this.tableIdentWithDB$1 = tableIdentWithDB$1;
                }
            }, e);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        this.logInfo((Function0)new Serializable(this, droppedAmount, addedAmount){
            public static final long serialVersionUID = 0L;
            private final int droppedAmount$1;
            private final int addedAmount$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Recovered all partitions: added (", "), dropped (", ")."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.addedAmount$1), BoxesRunTime.boxToInteger((int)this.droppedAmount$1)}));
            }
            {
                this.droppedAmount$1 = droppedAmount$1;
                this.addedAmount$1 = addedAmount$1;
            }
        });
        return (Seq)Seq$.MODULE$.empty();
    }

    private void addPartitions(SparkSession spark, CatalogTable table, Seq<Tuple2<Map<String, String>, Path>> partitionSpecsAndLocs, Map<String, PartitionStatistics> partitionStats) {
        int total = partitionSpecsAndLocs.length();
        LongRef done = LongRef.create((long)0L);
        int batchSize = spark.sparkContext().conf().getInt("spark.sql.addPartitionInBatch.size", 100);
        partitionSpecsAndLocs.iterator().grouped(batchSize).foreach((Function1)new Serializable(this, spark, table, partitionStats, total, done){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RepairHoodieTableCommand $outer;
            private final SparkSession spark$1;
            public final CatalogTable table$2;
            public final Map partitionStats$1;
            public final int total$2;
            public final LongRef done$1;

            public final void apply(Seq<Tuple2<Map<String, String>, Path>> batch) {
                long now = TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis());
                Seq parts = (Seq)batch.map((Function1)new Serializable(this, now){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$addPartitions$1 $outer;
                    public final long now$1;

                    public final CatalogTablePartition apply(Tuple2<Map<String, String>, Path> x0$1) {
                        Tuple2<Map<String, String>, Path> tuple2 = x0$1;
                        if (tuple2 != null) {
                            Map spec = (Map)tuple2._1();
                            Path location = (Path)tuple2._2();
                            Map params = (Map)this.$outer.partitionStats$1.get((Object)location.toString()).map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$addPartitions$1$$anonfun$5 $outer;

                                public final Map<String, String> apply(PartitionStatistics x0$2) {
                                    PartitionStatistics partitionStatistics = x0$2;
                                    if (partitionStatistics != null) {
                                        int numFiles = partitionStatistics.numFiles();
                                        long totalSize = partitionStatistics.totalSize();
                                        Map map = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.$outer.org$apache$spark$sql$hudi$command$RepairHoodieTableCommand$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$command$RepairHoodieTableCommand$$anonfun$$$outer().NUM_FILES()), (Object)((Object)BoxesRunTime.boxToInteger((int)numFiles)).toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.$outer.org$apache$spark$sql$hudi$command$RepairHoodieTableCommand$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$command$RepairHoodieTableCommand$$anonfun$$$outer().TOTAL_SIZE()), (Object)((Object)BoxesRunTime.boxToLong((long)totalSize)).toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.$outer.org$apache$spark$sql$hudi$command$RepairHoodieTableCommand$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$command$RepairHoodieTableCommand$$anonfun$$$outer().DDL_TIME()), (Object)((Object)BoxesRunTime.boxToLong((long)this.$outer.now$1)).toString())}));
                                        return map;
                                    }
                                    throw new MatchError((Object)partitionStatistics);
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            }).getOrElse((Function0)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final Map<String, Nothing$> apply() {
                                    return Predef$.MODULE$.Map().empty();
                                }
                            });
                            CatalogTablePartition catalogTablePartition = new CatalogTablePartition(spec, this.$outer.table$2.storage().copy((Option)new Some((Object)location.toUri()), this.$outer.table$2.storage().copy$default$2(), this.$outer.table$2.storage().copy$default$3(), this.$outer.table$2.storage().copy$default$4(), this.$outer.table$2.storage().copy$default$5(), this.$outer.table$2.storage().copy$default$6()), params, CatalogTablePartition$.MODULE$.apply$default$4(), CatalogTablePartition$.MODULE$.apply$default$5(), CatalogTablePartition$.MODULE$.apply$default$6());
                            return catalogTablePartition;
                        }
                        throw new MatchError(tuple2);
                    }

                    public /* synthetic */ $anonfun$addPartitions$1 org$apache$spark$sql$hudi$command$RepairHoodieTableCommand$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.now$1 = now$1;
                    }
                }, Seq$.MODULE$.canBuildFrom());
                this.spark$1.sessionState().catalog().createPartitions(this.$outer.tableName(), parts, true);
                this.done$1.elem += (long)parts.length();
                this.$outer.logDebug((Function0)new Serializable(this, parts){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$addPartitions$1 $outer;
                    private final Seq parts$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Recovered ", " partitions (", "/", " so far)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.parts$1.length()), BoxesRunTime.boxToLong((long)this.$outer.done$1.elem), BoxesRunTime.boxToInteger((int)this.$outer.total$2)}));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.parts$1 = parts$1;
                    }
                });
            }

            public /* synthetic */ RepairHoodieTableCommand org$apache$spark$sql$hudi$command$RepairHoodieTableCommand$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.spark$1 = spark$1;
                this.table$2 = table$2;
                this.partitionStats$1 = partitionStats$1;
                this.total$2 = total$2;
                this.done$1 = done$1;
            }
        });
    }

    private int dropPartitions(SessionCatalog catalog, Seq<Tuple2<Map<String, String>, Path>> partitionSpecsAndLocs) {
        Seq dropPartSpecs = (Seq)((GenericTraversableTemplate)ThreadUtils$.MODULE$.parmap((TraversableLike)catalog.listPartitions(this.tableName(), catalog.listPartitions$default$2()), "RepairTableCommand: non-existing partitions", 8, (Function1)new Serializable(this, partitionSpecsAndLocs){
            public static final long serialVersionUID = 0L;
            public final Seq partitionSpecsAndLocs$1;

            public final Option<Map<String, String>> apply(CatalogTablePartition partition) {
                return partition.storage().locationUri().flatMap((Function1)new Serializable(this, partition){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$8 $outer;
                    private final CatalogTablePartition partition$1;

                    public final Option<Map<String, String>> apply(URI uri) {
                        return ((SeqLike)this.$outer.partitionSpecsAndLocs$1.map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Path apply(Tuple2<Map<String, String>, Path> x$4) {
                                return (Path)x$4._2();
                            }
                        }, Seq$.MODULE$.canBuildFrom())).contains((Object)new Path(uri)) ? None$.MODULE$ : new Some((Object)this.partition$1.spec());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.partition$1 = partition$1;
                    }
                });
            }
            {
                this.partitionSpecsAndLocs$1 = partitionSpecsAndLocs$1;
            }
        }, Seq$.MODULE$.canBuildFrom(), Seq$.MODULE$.canBuildFrom())).flatten((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Iterable<Map<String, String>> apply(Option<Map<String, String>> xo) {
                return Option$.MODULE$.option2Iterable(xo);
            }
        });
        catalog.dropPartitions(this.tableName(), dropPartSpecs, true, false, true);
        return dropPartSpecs.length();
    }

    public RepairHoodieTableCommand copy(TableIdentifier tableName, boolean enableAddPartitions, boolean enableDropPartitions, String cmd) {
        return new RepairHoodieTableCommand(tableName, enableAddPartitions, enableDropPartitions, cmd);
    }

    public TableIdentifier copy$default$1() {
        return this.tableName();
    }

    public boolean copy$default$2() {
        return this.enableAddPartitions();
    }

    public boolean copy$default$3() {
        return this.enableDropPartitions();
    }

    public String copy$default$4() {
        return this.cmd();
    }

    public String productPrefix() {
        return "RepairHoodieTableCommand";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 3: {
                object = this.cmd();
                break;
            }
            case 2: {
                object = BoxesRunTime.boxToBoolean((boolean)this.enableDropPartitions());
                break;
            }
            case 1: {
                object = BoxesRunTime.boxToBoolean((boolean)this.enableAddPartitions());
                break;
            }
            case 0: {
                object = this.tableName();
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof RepairHoodieTableCommand;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof RepairHoodieTableCommand)) return false;
        boolean bl = true;
        if (!bl) return false;
        RepairHoodieTableCommand repairHoodieTableCommand = (RepairHoodieTableCommand)x$1;
        TableIdentifier tableIdentifier = this.tableName();
        TableIdentifier tableIdentifier2 = repairHoodieTableCommand.tableName();
        if (tableIdentifier == null) {
            if (tableIdentifier2 != null) {
                return false;
            }
        } else if (!tableIdentifier.equals(tableIdentifier2)) return false;
        if (this.enableAddPartitions() != repairHoodieTableCommand.enableAddPartitions()) return false;
        if (this.enableDropPartitions() != repairHoodieTableCommand.enableDropPartitions()) return false;
        String string = this.cmd();
        String string2 = repairHoodieTableCommand.cmd();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        if (!repairHoodieTableCommand.canEqual(this)) return false;
        return true;
    }

    public RepairHoodieTableCommand(TableIdentifier tableName, boolean enableAddPartitions, boolean enableDropPartitions, String cmd) {
        this.tableName = tableName;
        this.enableAddPartitions = enableAddPartitions;
        this.enableDropPartitions = enableDropPartitions;
        this.cmd = cmd;
        Command.class.$init$((Command)this);
        RunnableCommand.class.$init$((RunnableCommand)this);
        HoodieLeafLike$class.$init$((TreeNode)this);
        this.NUM_FILES = "numFiles";
        this.TOTAL_SIZE = "totalSize";
        this.DDL_TIME = "transient_lastDdlTime";
    }
}

