/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.streaming;

import java.io.BufferedWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import org.apache.hudi.common.util.FileIOUtils;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.execution.streaming.HDFSMetadataLog;
import org.apache.spark.sql.hudi.streaming.HoodieSourceOffset;
import org.apache.spark.sql.hudi.streaming.HoodieSourceOffset$;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001i3A!\u0001\u0002\u0001\u001f\t\t\u0002j\\8eS\u0016lU\r^1eCR\fGj\\4\u000b\u0005\r!\u0011!C:ue\u0016\fW.\u001b8h\u0015\t)a!\u0001\u0003ik\u0012L'BA\u0004\t\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u0013)\tQa\u001d9be.T!a\u0003\u0007\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0011aA8sO\u000e\u00011C\u0001\u0001\u0011!\r\tRcF\u0007\u0002%)\u00111a\u0005\u0006\u0003)\u0019\t\u0011\"\u001a=fGV$\u0018n\u001c8\n\u0005Y\u0011\"a\u0004%E\rNkU\r^1eCR\fGj\\4\u0011\u0005aIR\"\u0001\u0002\n\u0005i\u0011!A\u0005%p_\u0012LWmU8ve\u000e,wJ\u001a4tKRD\u0001\u0002\b\u0001\u0003\u0002\u0003\u0006I!H\u0001\rgB\f'o[*fgNLwN\u001c\t\u0003=}i\u0011AB\u0005\u0003A\u0019\u0011Ab\u00159be.\u001cVm]:j_:D\u0001B\t\u0001\u0003\u0002\u0003\u0006IaI\u0001\r[\u0016$\u0018\rZ1uCB\u000bG\u000f\u001b\t\u0003I)r!!\n\u0015\u000e\u0003\u0019R\u0011aJ\u0001\u0006g\u000e\fG.Y\u0005\u0003S\u0019\na\u0001\u0015:fI\u00164\u0017BA\u0016-\u0005\u0019\u0019FO]5oO*\u0011\u0011F\n\u0005\u0006]\u0001!\taL\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007A\n$\u0007\u0005\u0002\u0019\u0001!)A$\fa\u0001;!)!%\fa\u0001G!9A\u0007\u0001b\u0001\n\u0013)\u0014a\u0002,F%NKuJT\u000b\u0002mA\u0011QeN\u0005\u0003q\u0019\u00121!\u00138u\u0011\u0019Q\u0004\u0001)A\u0005m\u0005Aa+\u0012*T\u0013>s\u0005\u0005C\u0003=\u0001\u0011\u0005S(A\u0005tKJL\u0017\r\\5{KR\u0019a(Q\"\u0011\u0005\u0015z\u0014B\u0001!'\u0005\u0011)f.\u001b;\t\u000b\t[\u0004\u0019A\f\u0002\u00115,G/\u00193bi\u0006DQ\u0001R\u001eA\u0002\u0015\u000b1a\\;u!\t15*D\u0001H\u0015\tA\u0015*\u0001\u0002j_*\t!*\u0001\u0003kCZ\f\u0017B\u0001'H\u00051yU\u000f\u001e9viN#(/Z1n\u0011\u0015q\u0005\u0001\"\u0011P\u0003-!Wm]3sS\u0006d\u0017N_3\u0015\u0005]\u0001\u0006\"B)N\u0001\u0004\u0011\u0016AA5o!\t15+\u0003\u0002U\u000f\nY\u0011J\u001c9viN#(/Z1n\u0011\u00151\u0006\u0001\"\u0003X\u0003)9W\r\u001e,feNLwN\u001c\u000b\u0003maCQ!W+A\u0002\r\n1B^3sg&|g\u000eT5oK\u0002")
public class HoodieMetadataLog
extends HDFSMetadataLog<HoodieSourceOffset> {
    private final int VERSION;

    private int VERSION() {
        return this.VERSION;
    }

    public void serialize(HoodieSourceOffset metadata, OutputStream out) {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out, StandardCharsets.UTF_8));
        writer.write(new StringBuilder().append((Object)"v").append((Object)BoxesRunTime.boxToInteger((int)this.VERSION())).append((Object)"\n").toString());
        writer.write(metadata.json());
        writer.flush();
    }

    public HoodieSourceOffset deserialize(InputStream in) {
        String content = FileIOUtils.readAsUTFString((InputStream)in);
        int firstLineEnd = content.indexOf("\n");
        if (firstLineEnd > 0) {
            int version = this.getVersion(content.substring(0, firstLineEnd));
            if (version > this.VERSION()) {
                throw new IllegalStateException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"UnSupportVersion: max support version is: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.VERSION())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" current version is: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)version)}))).toString());
            }
            return HoodieSourceOffset$.MODULE$.fromJson(content.substring(firstLineEnd + 1));
        }
        throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Bad metadata format, failed to find the version line."})).s((Seq)Nil$.MODULE$));
    }

    private int getVersion(String versionLine) {
        if (versionLine.startsWith("v")) {
            return new StringOps(Predef$.MODULE$.augmentString(versionLine.substring(1))).toInt();
        }
        throw new IllegalStateException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Illegal version line: ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{versionLine}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"in the streaming metadata path"})).s((Seq)Nil$.MODULE$)).toString());
    }

    public HoodieMetadataLog(SparkSession sparkSession, String metadataPath) {
        super(sparkSession, metadataPath, ClassTag$.MODULE$.apply(HoodieSourceOffset.class));
        this.VERSION = 1;
    }
}

