/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi;

import java.util.Arrays;
import java.util.HashMap;
import org.apache.avro.Schema;
import org.apache.hudi.HoodieSchemaUtils;
import org.apache.hudi.common.config.HoodieCommonConfig;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.exception.HoodieNullSchemaTypeException;
import org.apache.hudi.exception.MissingSchemaFieldException;
import org.apache.hudi.exception.SchemaBackwardsCompatibilityException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public class TestHoodieSchemaUtils {
    private static final TypedProperties TYPED_PROPERTIES = new TypedProperties();

    @Test
    void testSchemaWithNullField() {
        Schema withNullfield = TestHoodieSchemaUtils.createRecord("nullRecord", TestHoodieSchemaUtils.createPrimitiveField("nullField", Schema.Type.NULL));
        Assertions.assertThrows(HoodieNullSchemaTypeException.class, () -> TestHoodieSchemaUtils.deduceWriterSchema(withNullfield, null));
    }

    @Test
    void testSimplePromotionWithComplexFields() {
        Schema start = TestHoodieSchemaUtils.createRecord("simple", TestHoodieSchemaUtils.createPrimitiveField("f", Schema.Type.INT));
        Schema end = TestHoodieSchemaUtils.createRecord("simple", TestHoodieSchemaUtils.createPrimitiveField("f", Schema.Type.LONG));
        Assertions.assertEquals((Object)end, (Object)TestHoodieSchemaUtils.deduceWriterSchema(end, start));
        start = TestHoodieSchemaUtils.createRecord("nested", TestHoodieSchemaUtils.createNestedField("f", Schema.Type.INT));
        end = TestHoodieSchemaUtils.createRecord("nested", TestHoodieSchemaUtils.createNestedField("f", Schema.Type.LONG));
        Assertions.assertEquals((Object)end, (Object)TestHoodieSchemaUtils.deduceWriterSchema(end, start));
        start = TestHoodieSchemaUtils.createRecord("arrayRec", TestHoodieSchemaUtils.createArrayField("f", Schema.Type.INT));
        end = TestHoodieSchemaUtils.createRecord("arrayRec", TestHoodieSchemaUtils.createArrayField("f", Schema.Type.LONG));
        Assertions.assertEquals((Object)end, (Object)TestHoodieSchemaUtils.deduceWriterSchema(end, start));
        start = TestHoodieSchemaUtils.createRecord("mapRec", TestHoodieSchemaUtils.createMapField("f", Schema.Type.INT));
        end = TestHoodieSchemaUtils.createRecord("mapRec", TestHoodieSchemaUtils.createMapField("f", Schema.Type.LONG));
        Assertions.assertEquals((Object)end, (Object)TestHoodieSchemaUtils.deduceWriterSchema(end, start));
    }

    @Test
    void testAllowedTypePromotions() {
        Schema.Type[] promotionTypes = new Schema.Type[]{Schema.Type.INT, Schema.Type.LONG, Schema.Type.FLOAT, Schema.Type.DOUBLE, Schema.Type.STRING, Schema.Type.BYTES};
        HashMap<Schema.Type, Pair> allowedPromotions = new HashMap<Schema.Type, Pair>();
        allowedPromotions.put(Schema.Type.INT, Pair.of((Object)0, (Object)4));
        allowedPromotions.put(Schema.Type.LONG, Pair.of((Object)1, (Object)4));
        allowedPromotions.put(Schema.Type.FLOAT, Pair.of((Object)2, (Object)4));
        allowedPromotions.put(Schema.Type.DOUBLE, Pair.of((Object)3, (Object)4));
        allowedPromotions.put(Schema.Type.STRING, Pair.of((Object)4, (Object)4));
        allowedPromotions.put(Schema.Type.BYTES, Pair.of((Object)5, (Object)5));
        HashMap<Schema.Type, Schema> schemaMap = new HashMap<Schema.Type, Schema>();
        for (Schema.Type type : promotionTypes) {
            schemaMap.put(type, TestHoodieSchemaUtils.createRecord("rec", TestHoodieSchemaUtils.createPrimitiveField("simpleField", type), TestHoodieSchemaUtils.createArrayField("arrayField", type), TestHoodieSchemaUtils.createMapField("mapField", type), TestHoodieSchemaUtils.createNestedField("nestedField", type)));
        }
        for (int i = 0; i < promotionTypes.length; ++i) {
            Schema startSchema = (Schema)schemaMap.get(promotionTypes[i]);
            Pair minMax = (Pair)allowedPromotions.get(promotionTypes[i]);
            for (int j = ((Integer)minMax.getLeft()).intValue(); j <= (Integer)minMax.getRight(); ++j) {
                Schema endSchema = (Schema)schemaMap.get(promotionTypes[j]);
                Assertions.assertEquals((Object)endSchema, (Object)TestHoodieSchemaUtils.deduceWriterSchema(endSchema, startSchema));
            }
        }
    }

    @Test
    void testReversePromotions() {
        Schema.Type[] promotionTypes = new Schema.Type[]{Schema.Type.INT, Schema.Type.LONG, Schema.Type.FLOAT, Schema.Type.DOUBLE, Schema.Type.STRING, Schema.Type.BYTES};
        HashMap<Schema.Type, Pair> reversePromotions = new HashMap<Schema.Type, Pair>();
        reversePromotions.put(Schema.Type.INT, Pair.of((Object)0, (Object)0));
        reversePromotions.put(Schema.Type.LONG, Pair.of((Object)0, (Object)1));
        reversePromotions.put(Schema.Type.FLOAT, Pair.of((Object)0, (Object)2));
        reversePromotions.put(Schema.Type.DOUBLE, Pair.of((Object)0, (Object)3));
        reversePromotions.put(Schema.Type.STRING, Pair.of((Object)0, (Object)5));
        reversePromotions.put(Schema.Type.BYTES, Pair.of((Object)4, (Object)5));
        HashMap<Schema.Type, Schema> schemaMap = new HashMap<Schema.Type, Schema>();
        for (Schema.Type type : promotionTypes) {
            schemaMap.put(type, TestHoodieSchemaUtils.createRecord("rec", TestHoodieSchemaUtils.createPrimitiveField("simpleField", type), TestHoodieSchemaUtils.createArrayField("arrayField", type), TestHoodieSchemaUtils.createMapField("mapField", type), TestHoodieSchemaUtils.createNestedField("nestedField", type)));
        }
        for (int i = 0; i < promotionTypes.length; ++i) {
            Schema startSchema = (Schema)schemaMap.get(promotionTypes[i]);
            Pair minMax = (Pair)reversePromotions.get(promotionTypes[i]);
            for (int j = ((Integer)minMax.getLeft()).intValue(); j <= (Integer)minMax.getRight(); ++j) {
                Schema endSchema = (Schema)schemaMap.get(promotionTypes[j]);
                Assertions.assertEquals((Object)startSchema, (Object)TestHoodieSchemaUtils.deduceWriterSchema(endSchema, startSchema));
            }
        }
    }

    @Test
    void testIllegalPromotionsBetweenPrimitives() {
        Schema.Type[] promotionTypes = new Schema.Type[]{Schema.Type.INT, Schema.Type.LONG, Schema.Type.FLOAT, Schema.Type.DOUBLE, Schema.Type.BYTES};
        HashMap<Schema.Type, Schema> schemaMap = new HashMap<Schema.Type, Schema>();
        for (Schema.Type type : promotionTypes) {
            schemaMap.put(type, TestHoodieSchemaUtils.createRecord("rec", TestHoodieSchemaUtils.createPrimitiveField("simpleField", type), TestHoodieSchemaUtils.createArrayField("arrayField", type), TestHoodieSchemaUtils.createMapField("mapField", type), TestHoodieSchemaUtils.createNestedField("nestedField", type)));
        }
        String[] fieldNames = new String[]{"rec.simpleField", "rec.arrayField.element", "rec.mapField.value", "rec.nestedField.nested"};
        for (int i = 0; i < 4; ++i) {
            Schema startSchema = (Schema)schemaMap.get(promotionTypes[i]);
            Schema endSchema = (Schema)schemaMap.get(Schema.Type.BYTES);
            Throwable t = Assertions.assertThrows(SchemaBackwardsCompatibilityException.class, () -> TestHoodieSchemaUtils.deduceWriterSchema(endSchema, startSchema));
            String baseString = String.format("TYPE_MISMATCH: reader type 'BYTES' not compatible with writer type '%s' for field '%%s'", promotionTypes[i].getName().toUpperCase());
            for (String fieldName : fieldNames) {
                Assertions.assertTrue((boolean)t.getMessage().contains(String.format(baseString, fieldName)));
            }
        }
    }

    @Test
    void testIllegalPromotionsBetweenComplexFields() {
        String[] typeNames = new String[]{"INT", "ARRAY", "MAP", "RECORD"};
        Schema[] fieldTypes = new Schema[]{TestHoodieSchemaUtils.createRecord("rec", TestHoodieSchemaUtils.createPrimitiveField("testField", Schema.Type.INT)), TestHoodieSchemaUtils.createRecord("rec", TestHoodieSchemaUtils.createArrayField("testField", Schema.Type.INT)), TestHoodieSchemaUtils.createRecord("rec", TestHoodieSchemaUtils.createMapField("testField", Schema.Type.INT)), TestHoodieSchemaUtils.createRecord("rec", TestHoodieSchemaUtils.createNestedField("testField", Schema.Type.INT))};
        for (int i = 0; i < fieldTypes.length; ++i) {
            for (int j = 0; j < fieldTypes.length; ++j) {
                if (i == j) continue;
                Schema startSchema = fieldTypes[i];
                Schema endSchema = fieldTypes[j];
                Throwable t = Assertions.assertThrows(SchemaBackwardsCompatibilityException.class, () -> TestHoodieSchemaUtils.deduceWriterSchema(startSchema, endSchema));
                String errorMessage = String.format("Schema validation backwards compatibility check failed with the following issues: {TYPE_MISMATCH: reader type '%s' not compatible with writer type '%s' for field 'rec.testField'}", typeNames[i], typeNames[j]);
                Assertions.assertTrue((boolean)t.getMessage().startsWith(errorMessage));
            }
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void testMissingColumn(boolean allowDroppedColumns) {
        Schema start = TestHoodieSchemaUtils.createRecord("missingSimpleField", TestHoodieSchemaUtils.createPrimitiveField("field1", Schema.Type.INT), TestHoodieSchemaUtils.createPrimitiveField("field2", Schema.Type.INT), TestHoodieSchemaUtils.createPrimitiveField("field3", Schema.Type.INT));
        Schema end = TestHoodieSchemaUtils.createRecord("missingSimpleField", TestHoodieSchemaUtils.createPrimitiveField("field1", Schema.Type.INT), TestHoodieSchemaUtils.createPrimitiveField("field3", Schema.Type.INT));
        try {
            Assertions.assertEquals((Object)start, (Object)TestHoodieSchemaUtils.deduceWriterSchema(end, start, allowDroppedColumns));
            Assertions.assertTrue((boolean)allowDroppedColumns);
        }
        catch (MissingSchemaFieldException e) {
            Assertions.assertFalse((boolean)allowDroppedColumns);
            Assertions.assertTrue((boolean)e.getMessage().contains("missingSimpleField.field2"));
        }
        start = TestHoodieSchemaUtils.createRecord("missingComplexField", TestHoodieSchemaUtils.createPrimitiveField("field1", Schema.Type.INT), TestHoodieSchemaUtils.createPrimitiveField("field2", Schema.Type.INT), TestHoodieSchemaUtils.createArrayField("field3", TestHoodieSchemaUtils.createRecord("nestedRecord", TestHoodieSchemaUtils.createPrimitiveField("nestedField1", Schema.Type.INT), TestHoodieSchemaUtils.createPrimitiveField("nestedField2", Schema.Type.INT), TestHoodieSchemaUtils.createPrimitiveField("nestedField3", Schema.Type.INT))), TestHoodieSchemaUtils.createPrimitiveField("field4", Schema.Type.INT));
        end = TestHoodieSchemaUtils.createRecord("missingComplexField", TestHoodieSchemaUtils.createPrimitiveField("field1", Schema.Type.INT), TestHoodieSchemaUtils.createPrimitiveField("field2", Schema.Type.INT), TestHoodieSchemaUtils.createPrimitiveField("field4", Schema.Type.INT));
        try {
            Assertions.assertEquals((Object)start, (Object)TestHoodieSchemaUtils.deduceWriterSchema(end, start, allowDroppedColumns));
            Assertions.assertTrue((boolean)allowDroppedColumns);
        }
        catch (MissingSchemaFieldException e) {
            Assertions.assertFalse((boolean)allowDroppedColumns);
            Assertions.assertTrue((boolean)e.getMessage().contains("missingComplexField.field3"));
        }
        end = TestHoodieSchemaUtils.createRecord("missingComplexField", TestHoodieSchemaUtils.createPrimitiveField("field1", Schema.Type.INT), TestHoodieSchemaUtils.createArrayField("field3", TestHoodieSchemaUtils.createRecord("nestedRecord", TestHoodieSchemaUtils.createPrimitiveField("nestedField2", Schema.Type.INT), TestHoodieSchemaUtils.createPrimitiveField("nestedField3", Schema.Type.INT))), TestHoodieSchemaUtils.createPrimitiveField("field4", Schema.Type.INT));
        try {
            Assertions.assertEquals((Object)start, (Object)TestHoodieSchemaUtils.deduceWriterSchema(end, start, allowDroppedColumns));
            Assertions.assertTrue((boolean)allowDroppedColumns);
        }
        catch (MissingSchemaFieldException e) {
            Assertions.assertFalse((boolean)allowDroppedColumns);
            Assertions.assertTrue((boolean)e.getMessage().contains("missingComplexField.field3.element.nestedRecord.nestedField1"));
            Assertions.assertTrue((boolean)e.getMessage().contains("missingComplexField.field2"));
        }
    }

    private static Schema deduceWriterSchema(Schema incomingSchema, Schema latestTableSchema) {
        return TestHoodieSchemaUtils.deduceWriterSchema(incomingSchema, latestTableSchema, false);
    }

    private static Schema deduceWriterSchema(Schema incomingSchema, Schema latestTableSchema, Boolean addNull) {
        TYPED_PROPERTIES.setProperty(HoodieCommonConfig.SET_NULL_FOR_MISSING_COLUMNS.key(), addNull.toString());
        return HoodieSchemaUtils.deduceWriterSchema((Schema)incomingSchema, (Option)Option.ofNullable((Object)latestTableSchema), (Option)Option.empty(), (TypedProperties)TYPED_PROPERTIES);
    }

    private static Schema.Field createNestedField(String name, Schema.Type type) {
        return TestHoodieSchemaUtils.createNestedField(name, Schema.create((Schema.Type)type));
    }

    private static Schema.Field createNestedField(String name, Schema schema) {
        return new Schema.Field(name, TestHoodieSchemaUtils.createRecord(name, new Schema.Field("nested", schema, null, null)), null, null);
    }

    private static Schema.Field createArrayField(String name, Schema.Type type) {
        return TestHoodieSchemaUtils.createArrayField(name, Schema.create((Schema.Type)type));
    }

    private static Schema.Field createArrayField(String name, Schema schema) {
        return new Schema.Field(name, Schema.createArray((Schema)schema), null, null);
    }

    private static Schema.Field createMapField(String name, Schema.Type type) {
        return TestHoodieSchemaUtils.createMapField(name, Schema.create((Schema.Type)type));
    }

    private static Schema.Field createMapField(String name, Schema schema) {
        return new Schema.Field(name, Schema.createMap((Schema)schema), null, null);
    }

    private static Schema.Field createPrimitiveField(String name, Schema.Type type) {
        return new Schema.Field(name, Schema.create((Schema.Type)type), null, null);
    }

    private static Schema createRecord(String name, Schema.Field ... fields) {
        return Schema.createRecord((String)name, null, null, (boolean)false, Arrays.asList(fields));
    }
}

