/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.cdc;

import org.apache.hudi.HoodieTableSchema;
import org.apache.hudi.cdc.InternalRowToJsonStringConverter;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.unsafe.types.UTF8String;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Option$;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t3AAC\u0006\u0001)!)1\u0004\u0001C\u00019!9q\u0004\u0001b\u0001\n\u0013\u0001\u0003B\u0002\u0013\u0001A\u0003%\u0011\u0005C\u0003&\u0001\u0011\u0005a\u0005C\u00036\u0001\u0011\u0005a\u0005C\u00038\u0001\u0011\u0005a\u0005C\u0003:\u0001\u0011\u0005a\u0005C\u0003<\u0001\u0011%A\bC\u0003B\u0001\u0011%AH\u0001\u0013UKN$\u0018J\u001c;fe:\fGNU8x)>T5o\u001c8TiJLgnZ\"p]Z,'\u000f^3s\u0015\taQ\"A\u0002dI\u000eT!AD\b\u0002\t!,H-\u001b\u0006\u0003!E\ta!\u00199bG\",'\"\u0001\n\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001)\u0002C\u0001\f\u001a\u001b\u00059\"\"\u0001\r\u0002\u000bM\u001c\u0017\r\\1\n\u0005i9\"AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002;A\u0011a\u0004A\u0007\u0002\u0017\u0005I1m\u001c8wKJ$XM]\u000b\u0002CA\u0011aDI\u0005\u0003G-\u0011\u0001%\u00138uKJt\u0017\r\u001c*poR{'j]8o'R\u0014\u0018N\\4D_:4XM\u001d;fe\u0006Q1m\u001c8wKJ$XM\u001d\u0011\u0002\u0011\u0015l\u0007\u000f^=S_^$\u0012a\n\t\u0003-!J!!K\f\u0003\tUs\u0017\u000e\u001e\u0015\u0003\t-\u0002\"\u0001L\u001a\u000e\u00035R!AL\u0018\u0002\u0007\u0005\u0004\u0018N\u0003\u00021c\u00059!.\u001e9ji\u0016\u0014(B\u0001\u001a\u0012\u0003\u0015QWO\\5u\u0013\t!TF\u0001\u0003UKN$\u0018a\u00038p]\u0016k\u0007\u000f^=S_^D#!B\u0016\u0002\u0017\u0015l\u0007\u000f^=TiJLgn\u001a\u0015\u0003\r-\n!B\\;mYN#(/\u001b8hQ\t91&A\ti_>$\u0017.\u001a+bE2,7k\u00195f[\u0006,\u0012!\u0010\t\u0003}}j\u0011!D\u0005\u0003\u00016\u0011\u0011\u0003S8pI&,G+\u00192mKN\u001b\u0007.Z7b\u0003Y)W\u000e\u001d;z\u0011>|G-[3UC\ndWmU2iK6\f\u0007")
public class TestInternalRowToJsonStringConverter {
    private final InternalRowToJsonStringConverter converter = new InternalRowToJsonStringConverter(this.hoodieTableSchema());

    private InternalRowToJsonStringConverter converter() {
        return this.converter;
    }

    @Test
    public void emptyRow() {
        InternalRowToJsonStringConverter converter = new InternalRowToJsonStringConverter(this.emptyHoodieTableSchema());
        InternalRow row = InternalRow$.MODULE$.empty();
        UTF8String converted = converter.convert(row);
        Assertions.assertEquals((Object)"{}", (Object)converted.toString());
    }

    @Test
    public void nonEmptyRow() {
        InternalRow row = InternalRow$.MODULE$.fromSeq((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), UTF8String.fromString((String)"foo")})));
        UTF8String converted = this.converter().convert(row);
        Assertions.assertEquals((Object)"{\"name\":\"foo\",\"uuid\":1}", (Object)converted.toString());
    }

    @Test
    public void emptyString() {
        InternalRow row = InternalRow$.MODULE$.fromSeq((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), UTF8String.EMPTY_UTF8})));
        UTF8String converted = this.converter().convert(row);
        Assertions.assertEquals((Object)"{\"name\":\"\",\"uuid\":1}", (Object)converted.toString());
    }

    @Test
    public void nullString() {
        InternalRow row = InternalRow$.MODULE$.fromSeq((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), null})));
        UTF8String converted = this.converter().convert(row);
        Assertions.assertTrue((converted.toString().equals("{\"uuid\":1}") || converted.toString().equals("{\"name\":null,\"uuid\":1}") ? 1 : 0) != 0);
    }

    private HoodieTableSchema hoodieTableSchema() {
        StructType structTypeSchema = new StructType((StructField[])((Object[])new StructField[]{new StructField("uuid", DataTypes.IntegerType, false, Metadata$.MODULE$.empty()), new StructField("name", DataTypes.StringType, true, Metadata$.MODULE$.empty())}));
        String avroSchemaStr = new StringOps(Predef$.MODULE$.augmentString("{\"type\": \"record\", \"name\": \"test\", \"fields\": [\n        |{\"name\": \"uuid\", \"type\": \"int\"},\n        |{\"name\": \"name\", \"type\": \"string\"}\n        |]}")).stripMargin();
        return new HoodieTableSchema(structTypeSchema, avroSchemaStr, Option$.MODULE$.empty());
    }

    private HoodieTableSchema emptyHoodieTableSchema() {
        StructType structTypeSchema = new StructType();
        String avroSchemaStr = "{\"type\": \"record\", \"name\": \"test\", \"fields\": []}";
        return new HoodieTableSchema(structTypeSchema, avroSchemaStr, Option$.MODULE$.empty());
    }
}

