/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.testutils;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.hudi.SparkAdapterSupport$;
import org.apache.hudi.common.config.HoodieStorageConfig;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.table.view.FileSystemViewStorageConfig;
import org.apache.hudi.common.testutils.FileSystemTestUtils;
import org.apache.hudi.config.HoodieCompactionConfig;
import org.apache.hudi.config.HoodieIndexConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.index.HoodieIndex;
import org.apache.spark.package$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.encoders.ExpressionEncoder;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.catalyst.expressions.GenericRow;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;

public class SparkDatasetTestUtils {
    public static final String RECORD_KEY_FIELD_NAME = "record_key";
    public static final String PARTITION_PATH_FIELD_NAME = "partition_path";
    public static final StructType STRUCT_TYPE = new StructType(new StructField[]{new StructField(HoodieRecord.COMMIT_TIME_METADATA_FIELD, DataTypes.StringType, false, Metadata.empty()), new StructField(HoodieRecord.COMMIT_SEQNO_METADATA_FIELD, DataTypes.StringType, false, Metadata.empty()), new StructField(HoodieRecord.RECORD_KEY_METADATA_FIELD, DataTypes.StringType, false, Metadata.empty()), new StructField(HoodieRecord.PARTITION_PATH_METADATA_FIELD, DataTypes.StringType, false, Metadata.empty()), new StructField(HoodieRecord.FILENAME_METADATA_FIELD, DataTypes.StringType, false, Metadata.empty()), new StructField("record_key", DataTypes.StringType, false, Metadata.empty()), new StructField("partition_path", DataTypes.StringType, false, Metadata.empty()), new StructField("randomInt", DataTypes.IntegerType, false, Metadata.empty()), new StructField("randomLong", DataTypes.LongType, false, Metadata.empty())});
    public static final StructType ERROR_STRUCT_TYPE = new StructType(new StructField[]{new StructField(HoodieRecord.COMMIT_TIME_METADATA_FIELD, DataTypes.StringType, false, Metadata.empty()), new StructField(HoodieRecord.COMMIT_SEQNO_METADATA_FIELD, DataTypes.LongType, false, Metadata.empty()), new StructField(HoodieRecord.RECORD_KEY_METADATA_FIELD, DataTypes.StringType, false, Metadata.empty()), new StructField(HoodieRecord.PARTITION_PATH_METADATA_FIELD, DataTypes.StringType, false, Metadata.empty()), new StructField(HoodieRecord.FILENAME_METADATA_FIELD, DataTypes.StringType, false, Metadata.empty()), new StructField("record_key", DataTypes.StringType, false, Metadata.empty()), new StructField("partition_path", DataTypes.StringType, false, Metadata.empty()), new StructField("randomInt", DataTypes.IntegerType, false, Metadata.empty()), new StructField("randomStr", DataTypes.StringType, false, Metadata.empty())});
    public static final ExpressionEncoder ENCODER = SparkDatasetTestUtils.getEncoder(STRUCT_TYPE);
    public static final ExpressionEncoder ERROR_ENCODER = SparkDatasetTestUtils.getEncoder(ERROR_STRUCT_TYPE);

    private static ExpressionEncoder getEncoder(StructType schema) {
        return SparkAdapterSupport$.MODULE$.sparkAdapter().getCatalystExpressionUtils().getEncoder(schema);
    }

    public static Dataset<Row> getRandomRows(SQLContext sqlContext, int count, String partitionPath, boolean isError) {
        ArrayList<Row> records = new ArrayList<Row>();
        for (long recordNum = 0L; recordNum < (long)count; ++recordNum) {
            records.add(SparkDatasetTestUtils.getRandomValue(partitionPath, isError));
        }
        return sqlContext.createDataFrame(records, isError ? ERROR_STRUCT_TYPE : STRUCT_TYPE);
    }

    public static Row getRandomValue(String partitionPath, boolean isError) {
        Object[] values = new Object[]{"", !isError ? "" : Long.valueOf(FileSystemTestUtils.RANDOM.nextLong()), UUID.randomUUID().toString(), partitionPath, "", UUID.randomUUID().toString(), partitionPath, FileSystemTestUtils.RANDOM.nextInt(), !isError ? Long.valueOf(FileSystemTestUtils.RANDOM.nextLong()) : UUID.randomUUID().toString()};
        return new GenericRow(values);
    }

    public static List<InternalRow> toInternalRows(Dataset<Row> rows, ExpressionEncoder encoder) throws Exception {
        ArrayList<InternalRow> toReturn = new ArrayList<InternalRow>();
        List rowList = rows.collectAsList();
        for (Row row : rowList) {
            toReturn.add(SparkDatasetTestUtils.serializeRow(encoder, row).copy());
        }
        return toReturn;
    }

    public static InternalRow getInternalRowWithError(String partitionPath) {
        String recordKey = UUID.randomUUID().toString();
        Object[] values = new Object[]{"", "", recordKey, partitionPath, "", recordKey, partitionPath, FileSystemTestUtils.RANDOM.nextInt(), FileSystemTestUtils.RANDOM.nextBoolean()};
        return new GenericInternalRow(values);
    }

    public static HoodieWriteConfig.Builder getConfigBuilder(String basePath, int timelineServicePort) {
        return HoodieWriteConfig.newBuilder().withPath(basePath).withSchema("{\"type\": \"record\",\"name\": \"triprec\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"long\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"partition_path\", \"type\": [\"null\", \"string\"], \"default\": null },{\"name\": \"trip_type\", \"type\": {\"type\": \"enum\", \"name\": \"TripType\", \"symbols\": [\"UNKNOWN\", \"UBERX\", \"BLACK\"], \"default\": \"UNKNOWN\"}},{\"name\": \"rider\", \"type\": \"string\"},{\"name\": \"driver\", \"type\": \"string\"},{\"name\": \"begin_lat\", \"type\": \"double\"},{\"name\": \"begin_lon\", \"type\": \"double\"},{\"name\": \"end_lat\", \"type\": \"double\"},{\"name\": \"end_lon\", \"type\": \"double\"},{\"name\": \"distance_in_meters\", \"type\": \"int\"},{\"name\": \"seconds_since_epoch\", \"type\": \"long\"},{\"name\": \"weight\", \"type\": \"float\"},{\"name\": \"nation\", \"type\": \"bytes\"},{\"name\":\"current_date\",\"type\": {\"type\": \"int\", \"logicalType\": \"date\"}},{\"name\":\"current_ts\",\"type\": {\"type\": \"long\"}},{\"name\":\"height\",\"type\":{\"type\":\"fixed\",\"name\":\"abc\",\"size\":5,\"logicalType\":\"decimal\",\"precision\":10,\"scale\":6}},{\"name\": \"city_to_state\", \"type\": {\"type\": \"map\", \"values\": \"string\"}},{\"name\": \"fare\",\"type\": {\"type\":\"record\", \"name\":\"fare\",\"fields\": [{\"name\": \"amount\",\"type\": \"double\"},{\"name\": \"currency\", \"type\": \"string\"}]}},{\"name\": \"tip_history\", \"default\": [], \"type\": {\"type\": \"array\", \"default\": [], \"items\": {\"type\": \"record\", \"default\": null, \"name\": \"tip_history\", \"fields\": [{\"name\": \"amount\", \"type\": \"double\"}, {\"name\": \"currency\", \"type\": \"string\"}]}}},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false} ]}").withPopulateMetaFields(true).withParallelism(2, 2).withDeleteParallelism(2).withCompactionConfig(HoodieCompactionConfig.newBuilder().compactionSmallFileSize(0x100000L).build()).withStorageConfig(HoodieStorageConfig.newBuilder().hfileMaxFileSize(0x100000L).parquetMaxFileSize(0x100000L).build()).withFileSystemViewConfig(FileSystemViewStorageConfig.newBuilder().withRemoteServerPort(Integer.valueOf(timelineServicePort)).build()).forTable("test-trip-table").withIndexConfig(HoodieIndexConfig.newBuilder().withIndexType(HoodieIndex.IndexType.BLOOM).build()).withBulkInsertParallelism(2);
    }

    private static InternalRow serializeRow(ExpressionEncoder encoder, Row row) throws InvocationTargetException, IllegalAccessException, NoSuchMethodException, ClassNotFoundException {
        if (package$.MODULE$.SPARK_VERSION().startsWith("2.")) {
            Method spark2method = encoder.getClass().getMethod("toRow", Object.class);
            return (InternalRow)spark2method.invoke((Object)encoder, row);
        }
        Class<?> serializerClass = Class.forName("org.apache.spark.sql.catalyst.encoders.ExpressionEncoder$Serializer");
        Object serializer = encoder.getClass().getMethod("createSerializer", new Class[0]).invoke((Object)encoder, new Object[0]);
        Method aboveSpark2method = serializerClass.getMethod("apply", Object.class);
        return (InternalRow)aboveSpark2method.invoke(serializer, row);
    }
}

