/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.execution.datasources;

import java.io.File;
import java.io.Serializable;
import java.nio.file.Paths;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.testutils.HoodieClientTestUtils;
import org.apache.spark.execution.datasources.HoodieInMemoryFileIndex;
import org.apache.spark.execution.datasources.HoodieInMemoryFileIndex$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001i2Aa\u0001\u0003\u0001\u001f!)a\u0003\u0001C\u0001/!)!\u0004\u0001C\u00017\tYB+Z:u\u0011>|G-[3J]6+Wn\u001c:z\r&dW-\u00138eKbT!!\u0002\u0004\u0002\u0017\u0011\fG/Y:pkJ\u001cWm\u001d\u0006\u0003\u000f!\t\u0011\"\u001a=fGV$\u0018n\u001c8\u000b\u0005%Q\u0011!B:qCJ\\'BA\u0006\r\u0003\u0019\t\u0007/Y2iK*\tQ\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001!A\u0011\u0011\u0003F\u0007\u0002%)\t1#A\u0003tG\u0006d\u0017-\u0003\u0002\u0016%\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#\u0001\r\u0011\u0005e\u0001Q\"\u0001\u0003\u0002/Q,7\u000f^\"sK\u0006$X-\u00138NK6|'/_%oI\u0016DHC\u0001\u000f !\t\tR$\u0003\u0002\u001f%\t!QK\\5u\u0011\u0015\u0001#\u00011\u0001\"\u0003\u001d!X-\u001c9ESJ\u0004\"AI\u0014\u000e\u0003\rR!\u0001J\u0013\u0002\u0005%|'\"\u0001\u0014\u0002\t)\fg/Y\u0005\u0003Q\r\u0012AAR5mK\"\u0012qD\u000b\t\u0003WMj\u0011\u0001\f\u0006\u0003I5R!AL\u0018\u0002\u0007\u0005\u0004\u0018N\u0003\u00021c\u00059!.\u001e9ji\u0016\u0014(B\u0001\u001a\r\u0003\u0015QWO\\5u\u0013\t!DFA\u0004UK6\u0004H)\u001b:)\u0005\t1\u0004CA\u001c9\u001b\u0005i\u0013BA\u001d.\u0005\u0011!Vm\u001d;")
public class TestHoodieInMemoryFileIndex {
    @Test
    public void testCreateInMemoryIndex(@TempDir File tempDir) {
        SparkSession spark = SparkSession$.MODULE$.builder().config(HoodieClientTestUtils.getSparkConfForTest((String)"Hoodie Datasource test")).getOrCreate();
        Seq folders = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StoragePath[]{new StoragePath(Paths.get(tempDir.getAbsolutePath(), "folder1").toUri()), new StoragePath(Paths.get(tempDir.getAbsolutePath(), "folder2").toUri())}));
        Seq files = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Path[]{new Path(Paths.get(tempDir.getAbsolutePath(), "folder1", "file1").toUri()), new Path(Paths.get(tempDir.getAbsolutePath(), "folder1", "file2").toUri()), new Path(Paths.get(tempDir.getAbsolutePath(), "folder2", "file3").toUri()), new Path(Paths.get(tempDir.getAbsolutePath(), "folder2", "file4").toUri())}));
        folders.foreach((Function1 & Serializable & scala.Serializable)folder -> BoxesRunTime.boxToBoolean((boolean)TestHoodieInMemoryFileIndex.$anonfun$testCreateInMemoryIndex$1(folder)));
        files.foreach((Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToBoolean((boolean)TestHoodieInMemoryFileIndex.$anonfun$testCreateInMemoryIndex$2(file)));
        HoodieInMemoryFileIndex index = HoodieInMemoryFileIndex$.MODULE$.create(spark, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StoragePath[]{(StoragePath)folders.apply(0), (StoragePath)folders.apply(1)})));
        Seq indexedFilePaths = (Seq)index.allFiles().map((Function1 & Serializable & scala.Serializable)fs -> fs.getPath(), Seq$.MODULE$.canBuildFrom());
        Assertions.assertEquals((Object)files.sortWith((Function2 & Serializable & scala.Serializable)(x$1, x$2) -> BoxesRunTime.boxToBoolean((boolean)TestHoodieInMemoryFileIndex.$anonfun$testCreateInMemoryIndex$4(x$1, x$2))), (Object)indexedFilePaths.sortWith((Function2 & Serializable & scala.Serializable)(x$3, x$4) -> BoxesRunTime.boxToBoolean((boolean)TestHoodieInMemoryFileIndex.$anonfun$testCreateInMemoryIndex$5(x$3, x$4))));
        spark.stop();
    }

    public static final /* synthetic */ boolean $anonfun$testCreateInMemoryIndex$1(StoragePath folder) {
        return new File(folder.toUri()).mkdir();
    }

    public static final /* synthetic */ boolean $anonfun$testCreateInMemoryIndex$2(Path file) {
        return new File(file.toUri()).createNewFile();
    }

    public static final /* synthetic */ boolean $anonfun$testCreateInMemoryIndex$4(Path x$1, Path x$2) {
        return new StringOps(Predef$.MODULE$.augmentString(x$1.toString())).$less((Object)x$2.toString());
    }

    public static final /* synthetic */ boolean $anonfun$testCreateInMemoryIndex$5(Path x$3, Path x$4) {
        return new StringOps(Predef$.MODULE$.augmentString(x$3.toString())).$less((Object)x$4.toString());
    }
}

