/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi;

import java.io.Serializable;
import java.util.Collections;
import org.apache.avro.Schema;
import org.apache.hudi.DataSourceReadOptions$;
import org.apache.hudi.DataSourceWriteOptions$;
import org.apache.hudi.HoodieConversionUtils$;
import org.apache.hudi.HoodieSparkSqlWriter$;
import org.apache.hudi.avro.AvroSchemaUtils;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.common.config.HoodieConfig;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.TableSchemaResolver;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.SchemaCompatibilityException;
import org.apache.hudi.internal.schema.InternalSchema;
import org.apache.hudi.internal.schema.convert.AvroInternalSchemaConverter;
import org.apache.hudi.internal.schema.utils.AvroSchemaEvolutionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;

public final class HoodieSchemaUtils$ {
    public static HoodieSchemaUtils$ MODULE$;
    private final Logger log;

    static {
        new HoodieSchemaUtils$();
    }

    private Logger log() {
        return this.log;
    }

    public scala.Option<InternalSchema> getLatestTableInternalSchema(HoodieConfig config, HoodieTableMetaClient tableMetaClient) {
        None$ none$;
        block5: {
            if (!config.getBooleanOrDefault(DataSourceReadOptions$.MODULE$.SCHEMA_EVOLUTION_ENABLED())) {
                none$ = None$.MODULE$;
            } else {
                try {
                    TableSchemaResolver tableSchemaResolver = new TableSchemaResolver(tableMetaClient);
                    Option internalSchemaOpt = tableSchemaResolver.getTableInternalSchemaFromCommitMetadata();
                    if (internalSchemaOpt.isPresent()) {
                        none$ = new Some(internalSchemaOpt.get());
                        break block5;
                    }
                    none$ = None$.MODULE$;
                }
                catch (Exception exception) {
                    none$ = None$.MODULE$;
                }
            }
        }
        return none$;
    }

    public Schema deduceWriterSchema(Schema sourceSchema, scala.Option<Schema> latestTableSchemaOpt, scala.Option<InternalSchema> internalSchemaOpt, Map<String, String> opts) {
        Schema schema;
        scala.Option<Schema> option = latestTableSchemaOpt;
        if (None$.MODULE$.equals(option)) {
            schema = AvroInternalSchemaConverter.fixNullOrdering((Schema)sourceSchema);
        } else if (option instanceof Some) {
            Some some = (Some)option;
            Schema latestTableSchemaWithMetaFields = (Schema)some.value();
            Schema latestTableSchema = AvroInternalSchemaConverter.fixNullOrdering((Schema)HoodieAvroUtils.removeMetadataFields((Schema)latestTableSchemaWithMetaFields));
            boolean shouldCanonicalizeSchema = new StringOps(Predef$.MODULE$.augmentString((String)opts.getOrElse((Object)HoodieSparkSqlWriter$.MODULE$.CANONICALIZE_SCHEMA().key(), (Function0 & Serializable & scala.Serializable)() -> HoodieSparkSqlWriter$.MODULE$.CANONICALIZE_SCHEMA().defaultValue().toString()))).toBoolean();
            Schema canonicalizedSourceSchema = shouldCanonicalizeSchema ? this.canonicalizeSchema(sourceSchema, latestTableSchema, opts) : AvroInternalSchemaConverter.fixNullOrdering((Schema)sourceSchema);
            boolean shouldReconcileSchema = new StringOps(Predef$.MODULE$.augmentString((String)opts.getOrElse((Object)DataSourceWriteOptions$.MODULE$.RECONCILE_SCHEMA().key(), (Function0 & Serializable & scala.Serializable)() -> ((Boolean)DataSourceWriteOptions$.MODULE$.RECONCILE_SCHEMA().defaultValue()).toString()))).toBoolean();
            schema = shouldReconcileSchema ? this.deduceWriterSchemaWithReconcile(sourceSchema, canonicalizedSourceSchema, latestTableSchema, internalSchemaOpt, opts) : this.deduceWriterSchemaWithoutReconcile(sourceSchema, canonicalizedSourceSchema, latestTableSchema, opts);
        } else {
            throw new MatchError(option);
        }
        return schema;
    }

    private Schema deduceWriterSchemaWithoutReconcile(Schema sourceSchema, Schema canonicalizedSourceSchema, Schema latestTableSchema, Map<String, String> opts) {
        Schema schema;
        boolean mergeIntoWrites = new StringOps(Predef$.MODULE$.augmentString((String)opts.getOrElse((Object)HoodieSparkSqlWriter$.MODULE$.SQL_MERGE_INTO_WRITES().key(), (Function0 & Serializable & scala.Serializable)() -> HoodieSparkSqlWriter$.MODULE$.SQL_MERGE_INTO_WRITES().defaultValue().toString()))).toBoolean();
        boolean shouldValidateSchemasCompatibility = new StringOps(Predef$.MODULE$.augmentString((String)opts.getOrElse((Object)HoodieWriteConfig.AVRO_SCHEMA_VALIDATE_ENABLE.key(), (Function0 & Serializable & scala.Serializable)() -> (String)HoodieWriteConfig.AVRO_SCHEMA_VALIDATE_ENABLE.defaultValue()))).toBoolean();
        boolean allowAutoEvolutionColumnDrop = new StringOps(Predef$.MODULE$.augmentString((String)opts.getOrElse((Object)HoodieWriteConfig.SCHEMA_ALLOW_AUTO_EVOLUTION_COLUMN_DROP.key(), (Function0 & Serializable & scala.Serializable)() -> (String)HoodieWriteConfig.SCHEMA_ALLOW_AUTO_EVOLUTION_COLUMN_DROP.defaultValue()))).toBoolean();
        boolean setNullForMissingColumns = new StringOps(Predef$.MODULE$.augmentString((String)opts.getOrElse((Object)DataSourceWriteOptions$.MODULE$.SET_NULL_FOR_MISSING_COLUMNS().key(), (Function0 & Serializable & scala.Serializable)() -> (String)DataSourceWriteOptions$.MODULE$.SET_NULL_FOR_MISSING_COLUMNS().defaultValue()))).toBoolean();
        if (!(mergeIntoWrites || shouldValidateSchemasCompatibility || allowAutoEvolutionColumnDrop)) {
            Schema reconciledSchema = setNullForMissingColumns ? AvroSchemaEvolutionUtils.reconcileSchema((Schema)canonicalizedSourceSchema, (Schema)latestTableSchema) : canonicalizedSourceSchema;
            AvroSchemaUtils.checkValidEvolution((Schema)reconciledSchema, (Schema)latestTableSchema);
            schema = reconciledSchema;
        } else {
            if (shouldValidateSchemasCompatibility) {
                AvroSchemaUtils.checkSchemaCompatible((Schema)latestTableSchema, (Schema)canonicalizedSourceSchema, (boolean)true, (boolean)allowAutoEvolutionColumnDrop, Collections.emptySet());
            }
            schema = canonicalizedSourceSchema;
        }
        return schema;
    }

    private Schema deduceWriterSchemaWithReconcile(Schema sourceSchema, Schema canonicalizedSourceSchema, Schema latestTableSchema, scala.Option<InternalSchema> internalSchemaOpt, Map<String, String> opts) {
        Schema schema;
        scala.Option<InternalSchema> option = internalSchemaOpt;
        if (option instanceof Some) {
            Some some = (Some)option;
            InternalSchema internalSchema = (InternalSchema)some.value();
            InternalSchema mergedInternalSchema = AvroSchemaEvolutionUtils.reconcileSchema((Schema)canonicalizedSourceSchema, (InternalSchema)internalSchema);
            Schema evolvedSchema = AvroInternalSchemaConverter.convert((InternalSchema)mergedInternalSchema, (String)latestTableSchema.getFullName());
            boolean shouldRemoveMetaDataFromInternalSchema = ((SeqLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(sourceSchema.getFields()).asScala()).filter((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)HoodieSchemaUtils$.$anonfun$deduceWriterSchemaWithReconcile$1(f)))).isEmpty();
            schema = shouldRemoveMetaDataFromInternalSchema ? HoodieAvroUtils.removeMetadataFields((Schema)evolvedSchema) : evolvedSchema;
        } else if (None$.MODULE$.equals(option)) {
            Tuple2<Schema, Object> tuple2 = this.reconcileSchemasLegacy(latestTableSchema, canonicalizedSourceSchema);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            Schema reconciledSchema = (Schema)tuple2._1();
            boolean isCompatible = tuple2._2$mcZ$sp();
            Tuple2 tuple22 = new Tuple2((Object)reconciledSchema, (Object)BoxesRunTime.boxToBoolean((boolean)isCompatible));
            Tuple2 tuple23 = tuple22;
            Schema reconciledSchema2 = (Schema)tuple23._1();
            boolean isCompatible2 = tuple23._2$mcZ$sp();
            boolean shouldValidateSchemasCompatibility = new StringOps(Predef$.MODULE$.augmentString((String)opts.getOrElse((Object)HoodieWriteConfig.AVRO_SCHEMA_VALIDATE_ENABLE.key(), (Function0 & Serializable & scala.Serializable)() -> (String)HoodieWriteConfig.AVRO_SCHEMA_VALIDATE_ENABLE.defaultValue()))).toBoolean();
            if (shouldValidateSchemasCompatibility && !isCompatible2) {
                this.log().error(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(194).append("Failed to reconcile incoming batch schema with the table's one.\n               |Incoming schema ").append(sourceSchema.toString(true)).append("\n               |Incoming schema (canonicalized) ").append(canonicalizedSourceSchema.toString(true)).append("\n               |Table's schema ").append(latestTableSchema.toString(true)).append("\n               |").toString())).stripMargin());
                throw new SchemaCompatibilityException("Failed to reconcile incoming schema with the table's one");
            }
            schema = reconciledSchema2;
        } else {
            throw new MatchError(option);
        }
        return schema;
    }

    public Schema deduceWriterSchema(Schema sourceSchema, Option<Schema> latestTableSchemaOpt, Option<InternalSchema> internalSchemaOpt, TypedProperties props) {
        return this.deduceWriterSchema(sourceSchema, (scala.Option<Schema>)HoodieConversionUtils$.MODULE$.toScalaOption(latestTableSchemaOpt), (scala.Option<InternalSchema>)HoodieConversionUtils$.MODULE$.toScalaOption(internalSchemaOpt), (Map<String, String>)HoodieConversionUtils$.MODULE$.fromProperties(props));
    }

    private Schema canonicalizeSchema(Schema sourceSchema, Schema latestTableSchema, Map<String, String> opts) {
        return AvroSchemaEvolutionUtils.reconcileSchemaRequirements((Schema)sourceSchema, (Schema)latestTableSchema);
    }

    private Tuple2<Schema, Object> reconcileSchemasLegacy(Schema tableSchema, Schema newSchema) {
        return AvroSchemaUtils.isCompatibleProjectionOf((Schema)tableSchema, (Schema)newSchema) ? new Tuple2((Object)tableSchema, (Object)BoxesRunTime.boxToBoolean((boolean)AvroSchemaUtils.isSchemaCompatible((Schema)newSchema, (Schema)tableSchema))) : new Tuple2((Object)newSchema, (Object)BoxesRunTime.boxToBoolean((boolean)AvroSchemaUtils.isSchemaCompatible((Schema)tableSchema, (Schema)newSchema)));
    }

    public static final /* synthetic */ boolean $anonfun$deduceWriterSchemaWithReconcile$1(Schema.Field f) {
        return f.name().equalsIgnoreCase(HoodieRecord.RECORD_KEY_METADATA_FIELD);
    }

    private HoodieSchemaUtils$() {
        MODULE$ = this;
        this.log = LoggerFactory.getLogger(this.getClass());
    }
}

