/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.DataSourceWriteOptions$;
import org.apache.hudi.HoodieSparkSqlWriter;
import org.apache.hudi.HoodieSparkSqlWriter$;
import org.apache.hudi.HoodieStreamingSink$;
import org.apache.hudi.async.AsyncClusteringService;
import org.apache.hudi.async.AsyncCompactService;
import org.apache.hudi.async.SparkStreamingAsyncClusteringService;
import org.apache.hudi.async.SparkStreamingAsyncCompactService;
import org.apache.hudi.client.BaseHoodieWriteClient;
import org.apache.hudi.client.SparkRDDWriteClient;
import org.apache.hudi.client.common.HoodieSparkEngineContext;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.WriteConcurrencyMode;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.marker.MarkerType;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.util.ClusteringUtils;
import org.apache.hudi.common.util.CommitUtils;
import org.apache.hudi.common.util.CompactionUtils;
import org.apache.hudi.common.util.ConfigUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieCorruptedDataException;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.TableNotFoundException;
import org.apache.hudi.hadoop.fs.HadoopFSUtils;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.connector.catalog.TableCapability;
import org.apache.spark.sql.execution.streaming.Sink;
import org.apache.spark.sql.execution.streaming.StreamExecution$;
import org.apache.spark.sql.streaming.OutputMode;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple6;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ObjectRef;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\t\u001dh\u0001\u0002\u001e<\u0001\tC\u0001\"\u0018\u0001\u0003\u0002\u0003\u0006IA\u0018\u0005\tE\u0002\u0011\t\u0011)A\u0005G\"A\u0011\u000f\u0001B\u0001B\u0003%!\u000f\u0003\u0005|\u0001\t\u0005\t\u0015!\u0003}\u0011\u001d\t\u0019\u0001\u0001C\u0001\u0003\u000bA\u0011\"a\u0005\u0001\u0001\u0004%I!!\u0006\t\u0013\u0005u\u0001\u00011A\u0005\n\u0005}\u0001\u0002CA\u0016\u0001\u0001\u0006K!a\u0006\t\u0013\u0005U\u0002A1A\u0005\n\u0005]\u0002\u0002CA#\u0001\u0001\u0006I!!\u000f\t\u0013\u0005\u001d\u0003A1A\u0005\n\u0005%\u0003\u0002CA)\u0001\u0001\u0006I!a\u0013\t\u0013\u0005M\u0003\u00011A\u0005\n\u0005U\u0003\"CA5\u0001\u0001\u0007I\u0011BA6\u0011!\ty\u0007\u0001Q!\n\u0005]\u0003\"CA9\u0001\t\u0007I\u0011BA:\u0011!\tY\b\u0001Q\u0001\n\u0005U\u0004\"CA?\u0001\t\u0007I\u0011BA\u000b\u0011!\ty\b\u0001Q\u0001\n\u0005]\u0001\"CAA\u0001\t\u0007I\u0011BAB\u0011!\tY\t\u0001Q\u0001\n\u0005\u0015\u0005\"CAG\u0001\t\u0007I\u0011BAB\u0011!\ty\t\u0001Q\u0001\n\u0005\u0015\u0005\"CAI\u0001\u0001\u0007I\u0011BAB\u0011%\t\u0019\n\u0001a\u0001\n\u0013\t)\n\u0003\u0005\u0002\u001a\u0002\u0001\u000b\u0015BAC\u0011%\tY\n\u0001a\u0001\n\u0013\t\u0019\tC\u0005\u0002\u001e\u0002\u0001\r\u0011\"\u0003\u0002 \"A\u00111\u0015\u0001!B\u0013\t)\tC\u0005\u0002&\u0002\u0011\r\u0011\"\u0003\u0002(\"A\u0011q\u0016\u0001!\u0002\u0013\tI\u000bC\u0006\u00022\u0002\u0001\r\u00111A\u0005\n\u0005M\u0006bCAa\u0001\u0001\u0007\t\u0019!C\u0005\u0003\u0007D1\"a2\u0001\u0001\u0004\u0005\t\u0015)\u0003\u00026\"Y\u0011\u0011\u001a\u0001A\u0002\u0003\u0007I\u0011BAf\u0011-\t\u0019\u000e\u0001a\u0001\u0002\u0004%I!!6\t\u0017\u0005e\u0007\u00011A\u0001B\u0003&\u0011Q\u001a\u0005\n\u00037\u0004\u0001\u0019!C\u0005\u0003;D\u0011Ba\u0002\u0001\u0001\u0004%IA!\u0003\t\u0011\u0005]\b\u0001)Q\u0005\u0003?D\u0011Ba\u0006\u0001\u0001\u0004%IA!\u0007\t\u0013\t\r\u0002\u00011A\u0005\n\t\u0015\u0002\u0002\u0003B\u0015\u0001\u0001\u0006KAa\u0007\t\u000f\t-\u0002\u0001\"\u0011\u0003.!9!1\u000b\u0001\u0005\n\tU\u0003b\u0002B-\u0001\u0011\u0005#1\f\u0005\b\u0005;\u0002A\u0011\u0002B0\u0011\u001d\u00119\n\u0001C\t\u00053CqAa*\u0001\t#\u0011I\u000bC\u0004\u00038\u0002!IA!/\t\u000f\t}\u0006\u0001\"\u0003\u0003B\u001e9!1Z\u001e\t\u0002\t5gA\u0002\u001e<\u0011\u0003\u0011y\rC\u0004\u0002\u0004U\"\tAa6\t\u0013\teWG1A\u0005\u0002\tm\u0007\u0002\u0003Bqk\u0001\u0006IA!8\t\u0013\t\rX'!A\u0005\n\t\u0015(a\u0005%p_\u0012LWm\u0015;sK\u0006l\u0017N\\4TS:\\'B\u0001\u001f>\u0003\u0011AW\u000fZ5\u000b\u0005yz\u0014AB1qC\u000eDWMC\u0001A\u0003\ry'oZ\u0002\u0001'\u0011\u00011iS,\u0011\u0005\u0011KU\"A#\u000b\u0005\u0019;\u0015\u0001\u00027b]\u001eT\u0011\u0001S\u0001\u0005U\u00064\u0018-\u0003\u0002K\u000b\n1qJ\u00196fGR\u0004\"\u0001T+\u000e\u00035S!AT(\u0002\u0013M$(/Z1nS:<'B\u0001)R\u0003%)\u00070Z2vi&|gN\u0003\u0002S'\u0006\u00191/\u001d7\u000b\u0005Qk\u0014!B:qCJ\\\u0017B\u0001,N\u0005\u0011\u0019\u0016N\\6\u0011\u0005a[V\"A-\u000b\u0003i\u000bQa]2bY\u0006L!\u0001X-\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\u0015M\fHnQ8oi\u0016DH\u000f\u0005\u0002`A6\t\u0011+\u0003\u0002b#\nQ1+\u0015'D_:$X\r\u001f;\u0002\u000f=\u0004H/[8ogB!Am\u001b8o\u001d\t)\u0017\u000e\u0005\u0002g36\tqM\u0003\u0002i\u0003\u00061AH]8pizJ!A[-\u0002\rA\u0013X\rZ3g\u0013\taWNA\u0002NCBT!A[-\u0011\u0005\u0011|\u0017B\u00019n\u0005\u0019\u0019FO]5oO\u0006\u0001\u0002/\u0019:uSRLwN\\\"pYVlgn\u001d\t\u0004gbtgB\u0001;w\u001d\t1W/C\u0001[\u0013\t9\u0018,A\u0004qC\u000e\\\u0017mZ3\n\u0005eT(aA*fc*\u0011q/W\u0001\u000b_V$\b/\u001e;N_\u0012,\u0007CA?\u0000\u001b\u0005q(B\u0001(R\u0013\r\t\tA \u0002\u000b\u001fV$\b/\u001e;N_\u0012,\u0017A\u0002\u001fj]&$h\b\u0006\u0006\u0002\b\u0005-\u0011QBA\b\u0003#\u00012!!\u0003\u0001\u001b\u0005Y\u0004\"B/\u0006\u0001\u0004q\u0006\"\u00022\u0006\u0001\u0004\u0019\u0007\"B9\u0006\u0001\u0004\u0011\b\"B>\u0006\u0001\u0004a\u0018A\u00067bi\u0016\u001cHoQ8n[&$H/\u001a3CCR\u001c\u0007.\u00133\u0016\u0005\u0005]\u0001c\u0001-\u0002\u001a%\u0019\u00111D-\u0003\t1{gnZ\u0001\u001bY\u0006$Xm\u001d;D_6l\u0017\u000e\u001e;fI\n\u000bGo\u00195JI~#S-\u001d\u000b\u0005\u0003C\t9\u0003E\u0002Y\u0003GI1!!\nZ\u0005\u0011)f.\u001b;\t\u0013\u0005%r!!AA\u0002\u0005]\u0011a\u0001=%c\u00059B.\u0019;fgR\u001cu.\\7jiR,GMQ1uG\"LE\r\t\u0015\u0004\u0011\u0005=\u0002c\u0001-\u00022%\u0019\u00111G-\u0003\u0011Y|G.\u0019;jY\u0016\f1\u0001\\8h+\t\tI\u0004\u0005\u0003\u0002<\u0005\u0005SBAA\u001f\u0015\r\tydP\u0001\u0006g24GG[\u0005\u0005\u0003\u0007\niD\u0001\u0004M_\u001e<WM]\u0001\u0005Y><\u0007%A\u0005uC\ndW\rU1uQV\u0011\u00111\n\t\u00051\u00065c.C\u0002\u0002Pe\u0013aa\u00149uS>t\u0017A\u0003;bE2,\u0007+\u0019;iA\u0005QQ.\u001a;b\u00072LWM\u001c;\u0016\u0005\u0005]\u0003#\u0002-\u0002N\u0005e\u0003\u0003BA.\u0003Kj!!!\u0018\u000b\t\u0005}\u0013\u0011M\u0001\u0006i\u0006\u0014G.\u001a\u0006\u0004\u0003GZ\u0014AB2p[6|g.\u0003\u0003\u0002h\u0005u#!\u0006%p_\u0012LW\rV1cY\u0016lU\r^1DY&,g\u000e^\u0001\u000f[\u0016$\u0018m\u00117jK:$x\fJ3r)\u0011\t\t#!\u001c\t\u0013\u0005%b\"!AA\u0002\u0005]\u0013aC7fi\u0006\u001cE.[3oi\u0002\n\u0001B]3uef\u001ce\u000e^\u000b\u0003\u0003k\u00022\u0001WA<\u0013\r\tI(\u0017\u0002\u0004\u0013:$\u0018!\u0003:fiJL8I\u001c;!\u0003=\u0011X\r\u001e:z\u0013:$XM\u001d<bY6\u001b\u0018\u0001\u0005:fiJL\u0018J\u001c;feZ\fG.T:!\u0003EIwM\\8sK\u001a\u000b\u0017\u000e\\3e\u0005\u0006$8\r[\u000b\u0003\u0003\u000b\u00032\u0001WAD\u0013\r\tI)\u0017\u0002\b\u0005>|G.Z1o\u0003IIwM\\8sK\u001a\u000b\u0017\u000e\\3e\u0005\u0006$8\r\u001b\u0011\u0002#\u0011L7/\u00192mK\u000e{W\u000e]1di&|g.\u0001\neSN\f'\r\\3D_6\u0004\u0018m\u0019;j_:\u0004\u0013!K5t\u0003NLhnY\"p[B\f7\r^8s'\u0016\u0014h/[2f'\",H\u000fZ8x]\u0006\u0013gn\u001c:nC2d\u00170A\u0017jg\u0006\u001b\u0018P\\2D_6\u0004\u0018m\u0019;peN+'O^5dKNCW\u000f\u001e3po:\f%M\\8s[\u0006dG._0%KF$B!!\t\u0002\u0018\"I\u0011\u0011F\r\u0002\u0002\u0003\u0007\u0011QQ\u0001+SN\f5/\u001f8d\u0007>l\u0007/Y2u_J\u001cVM\u001d<jG\u0016\u001c\u0006.\u001e;e_^t\u0017I\u00198pe6\fG\u000e\\=!\u0003)J7/Q:z]\u000e\u001cE.^:uKJLgnZ*feZL7-Z*ikR$wn\u001e8BE:|'/\\1mYf\fa&[:Bgft7m\u00117vgR,'/\u001b8h'\u0016\u0014h/[2f'\",H\u000fZ8x]\u0006\u0013gn\u001c:nC2d\u0017p\u0018\u0013fcR!\u0011\u0011EAQ\u0011%\tI\u0003HA\u0001\u0002\u0004\t))A\u0016jg\u0006\u001b\u0018P\\2DYV\u001cH/\u001a:j]\u001e\u001cVM\u001d<jG\u0016\u001c\u0006.\u001e;e_^t\u0017I\u00198pe6\fG\u000e\\=!\u0003\u0011iw\u000eZ3\u0016\u0005\u0005%\u0006cA0\u0002,&\u0019\u0011QV)\u0003\u0011M\u000bg/Z'pI\u0016\fQ!\\8eK\u0002\nQ#Y:z]\u000e\u001cu.\u001c9bGR|'oU3sm&\u001cW-\u0006\u0002\u00026B!\u0011qWA_\u001b\t\tILC\u0002\u0002<n\nQ!Y:z]\u000eLA!a0\u0002:\n\u0019\u0012i]=oG\u000e{W\u000e]1diN+'O^5dK\u0006I\u0012m]=oG\u000e{W\u000e]1di>\u00148+\u001a:wS\u000e,w\fJ3r)\u0011\t\t#!2\t\u0013\u0005%\u0012%!AA\u0002\u0005U\u0016AF1ts:\u001c7i\\7qC\u000e$xN]*feZL7-\u001a\u0011\u0002-\u0005\u001c\u0018P\\2DYV\u001cH/\u001a:j]\u001e\u001cVM\u001d<jG\u0016,\"!!4\u0011\t\u0005]\u0016qZ\u0005\u0005\u0003#\fIL\u0001\fBgft7m\u00117vgR,'/\u001b8h'\u0016\u0014h/[2f\u0003i\t7/\u001f8d\u00072,8\u000f^3sS:<7+\u001a:wS\u000e,w\fJ3r)\u0011\t\t#a6\t\u0013\u0005%B%!AA\u0002\u00055\u0017aF1ts:\u001c7\t\\;ti\u0016\u0014\u0018N\\4TKJ4\u0018nY3!\u0003-9(/\u001b;f\u00072LWM\u001c;\u0016\u0005\u0005}\u0007#\u0002-\u0002N\u0005\u0005\b\u0007BAr\u0003g\u0004b!!:\u0002l\u0006=XBAAt\u0015\r\tIoO\u0001\u0007G2LWM\u001c;\n\t\u00055\u0018q\u001d\u0002\u0014'B\f'o\u001b*E\t^\u0013\u0018\u000e^3DY&,g\u000e\u001e\t\u0005\u0003c\f\u0019\u0010\u0004\u0001\u0005\u0017\u0005U\b&!A\u0001\u0002\u000b\u0005\u0011\u0011 \u0002\u0004?\u0012\n\u0014\u0001D<sSR,7\t\\5f]R\u0004\u0013\u0003BA~\u0005\u0003\u00012\u0001WA\u007f\u0013\r\ty0\u0017\u0002\b\u001d>$\b.\u001b8h!\rA&1A\u0005\u0004\u0005\u000bI&aA!os\u0006yqO]5uK\u000ec\u0017.\u001a8u?\u0012*\u0017\u000f\u0006\u0003\u0002\"\t-\u0001\"CA\u0015O\u0005\u0005\t\u0019\u0001B\u0007!\u0015A\u0016Q\nB\ba\u0011\u0011\tB!\u0006\u0011\r\u0005\u0015\u00181\u001eB\n!\u0011\t\tP!\u0006\u0005\u0019\u0005U(1BA\u0001\u0002\u0003\u0015\t!!?\u0002#!|w\u000eZ5f)\u0006\u0014G.Z\"p]\u001aLw-\u0006\u0002\u0003\u001cA)\u0001,!\u0014\u0003\u001eA!\u00111\fB\u0010\u0013\u0011\u0011\t#!\u0018\u0003#!{w\u000eZ5f)\u0006\u0014G.Z\"p]\u001aLw-A\u000bi_>$\u0017.\u001a+bE2,7i\u001c8gS\u001e|F%Z9\u0015\t\u0005\u0005\"q\u0005\u0005\n\u0003SQ\u0013\u0011!a\u0001\u00057\t!\u0003[8pI&,G+\u00192mK\u000e{gNZ5hA\u0005A\u0011\r\u001a3CCR\u001c\u0007\u000e\u0006\u0004\u0002\"\t=\"1\u0007\u0005\b\u0005ca\u0003\u0019AA\f\u0003\u001d\u0011\u0017\r^2i\u0013\u0012DqA!\u000e-\u0001\u0004\u00119$\u0001\u0003eCR\f\u0007\u0003\u0002B\u001d\u0005\u001brAAa\u000f\u0003L9!!Q\bB%\u001d\u0011\u0011yDa\u0012\u000f\t\t\u0005#Q\t\b\u0004M\n\r\u0013\"\u0001!\n\u0005yz\u0014B\u0001+>\u0013\t\u00116+\u0003\u0002x#&!!q\nB)\u0005%!\u0015\r^1Ge\u0006lWM\u0003\u0002x#\u0006\u0019r-\u001a;TiJ,\u0017-\\%eK:$\u0018NZ5feR!\u00111\nB,\u0011\u0015\u0011W\u00061\u0001d\u0003!!xn\u0015;sS:<G#\u00018\u0002\u000bI,GO]=\u0016\t\t\u0005$1\u000f\u000b\u0007\u0005G\u0012\tI!\"\u0015\t\t\u0015$q\u000f\t\u0007\u0005O\u0012iG!\u001d\u000e\u0005\t%$b\u0001B63\u0006!Q\u000f^5m\u0013\u0011\u0011yG!\u001b\u0003\u0007Q\u0013\u0018\u0010\u0005\u0003\u0002r\nMDa\u0002B;_\t\u0007\u0011\u0011 \u0002\u0002)\"A!\u0011P\u0018\u0005\u0002\u0004\u0011Y(\u0001\u0002g]B)\u0001L! \u0003f%\u0019!qP-\u0003\u0011q\u0012\u0017P\\1nKzBqAa!0\u0001\u0004\t)(A\u0001o\u0011\u001d\u00119i\fa\u0001\u0003/\tAb^1ji&sW*\u001b7mSND3a\fBF!\u0011\u0011iIa%\u000e\u0005\t=%b\u0001BI3\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\tU%q\u0012\u0002\bi\u0006LGN]3d\u0003U!(/[4hKJ\f5/\u001f8d\u0007>l\u0007/Y2u_J$B!!\t\u0003\u001c\"9\u0011\u0011\u001e\u0019A\u0002\tu\u0005\u0007\u0002BP\u0005G\u0003b!!:\u0002l\n\u0005\u0006\u0003BAy\u0005G#AB!*\u0003\u001c\u0006\u0005\t\u0011!B\u0001\u0003s\u00141a\u0018\u00133\u0003Y!(/[4hKJ\f5/\u001f8d\u00072,8\u000f^3sS:<G\u0003BA\u0011\u0005WCq!!;2\u0001\u0004\u0011i\u000b\r\u0003\u00030\nM\u0006CBAs\u0003W\u0014\t\f\u0005\u0003\u0002r\nMF\u0001\u0004B[\u0005W\u000b\t\u0011!A\u0003\u0002\u0005e(aA0%g\u0005)!/Z:fiR!\u0011\u0011\u0005B^\u0011\u001d\u0011iL\ra\u0001\u0003\u000b\u000bQAZ8sG\u0016\fAbY1o'.L\u0007OQ1uG\"$b!!\"\u0003D\n\u001d\u0007b\u0002Bcg\u0001\u0007\u0011qC\u0001\u0010S:\u001cw.\\5oO\n\u000bGo\u00195JI\"1!\u0011Z\u001aA\u00029\fQb\u001c9fe\u0006$\u0018n\u001c8UsB,\u0017a\u0005%p_\u0012LWm\u0015;sK\u0006l\u0017N\\4TS:\\\u0007cAA\u0005kM!QG!5X!\rA&1[\u0005\u0004\u0005+L&AB!osJ+g\r\u0006\u0002\u0003N\u0006\u00192+\u0013(L?\u000eCUiQ&Q\u001f&sEkX&F3V\u0011!Q\u001c\t\u0004\t\n}\u0017B\u00019F\u0003Q\u0019\u0016JT&`\u0007\"+5i\u0013)P\u0013:#vlS#ZA\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\u0005\u0019\u0005")
public class HoodieStreamingSink
implements Sink,
scala.Serializable {
    private final SQLContext sqlContext;
    public final Map<String, String> org$apache$hudi$HoodieStreamingSink$$options;
    private volatile long latestCommittedBatchId;
    private final Logger org$apache$hudi$HoodieStreamingSink$$log;
    private final scala.Option<String> tablePath;
    private scala.Option<HoodieTableMetaClient> metaClient;
    private final int retryCnt;
    private final long retryIntervalMs;
    private final boolean ignoreFailedBatch;
    private final boolean disableCompaction;
    private boolean org$apache$hudi$HoodieStreamingSink$$isAsyncCompactorServiceShutdownAbnormally;
    private boolean org$apache$hudi$HoodieStreamingSink$$isAsyncClusteringServiceShutdownAbnormally;
    private final SaveMode mode;
    private AsyncCompactService asyncCompactorService;
    private AsyncClusteringService asyncClusteringService;
    private scala.Option<SparkRDDWriteClient<?>> writeClient;
    private scala.Option<HoodieTableConfig> hoodieTableConfig;

    public static String SINK_CHECKPOINT_KEY() {
        return HoodieStreamingSink$.MODULE$.SINK_CHECKPOINT_KEY();
    }

    public String name() {
        return Sink.name$((Sink)this);
    }

    public StructType schema() {
        return Sink.schema$((Sink)this);
    }

    public Set<TableCapability> capabilities() {
        return Sink.capabilities$((Sink)this);
    }

    private long latestCommittedBatchId() {
        return this.latestCommittedBatchId;
    }

    private void latestCommittedBatchId_$eq(long x$1) {
        this.latestCommittedBatchId = x$1;
    }

    public Logger org$apache$hudi$HoodieStreamingSink$$log() {
        return this.org$apache$hudi$HoodieStreamingSink$$log;
    }

    private scala.Option<String> tablePath() {
        return this.tablePath;
    }

    private scala.Option<HoodieTableMetaClient> metaClient() {
        return this.metaClient;
    }

    private void metaClient_$eq(scala.Option<HoodieTableMetaClient> x$1) {
        this.metaClient = x$1;
    }

    private int retryCnt() {
        return this.retryCnt;
    }

    private long retryIntervalMs() {
        return this.retryIntervalMs;
    }

    private boolean ignoreFailedBatch() {
        return this.ignoreFailedBatch;
    }

    private boolean disableCompaction() {
        return this.disableCompaction;
    }

    private boolean org$apache$hudi$HoodieStreamingSink$$isAsyncCompactorServiceShutdownAbnormally() {
        return this.org$apache$hudi$HoodieStreamingSink$$isAsyncCompactorServiceShutdownAbnormally;
    }

    public void org$apache$hudi$HoodieStreamingSink$$isAsyncCompactorServiceShutdownAbnormally_$eq(boolean x$1) {
        this.org$apache$hudi$HoodieStreamingSink$$isAsyncCompactorServiceShutdownAbnormally = x$1;
    }

    private boolean org$apache$hudi$HoodieStreamingSink$$isAsyncClusteringServiceShutdownAbnormally() {
        return this.org$apache$hudi$HoodieStreamingSink$$isAsyncClusteringServiceShutdownAbnormally;
    }

    public void org$apache$hudi$HoodieStreamingSink$$isAsyncClusteringServiceShutdownAbnormally_$eq(boolean x$1) {
        this.org$apache$hudi$HoodieStreamingSink$$isAsyncClusteringServiceShutdownAbnormally = x$1;
    }

    private SaveMode mode() {
        return this.mode;
    }

    private AsyncCompactService asyncCompactorService() {
        return this.asyncCompactorService;
    }

    private void asyncCompactorService_$eq(AsyncCompactService x$1) {
        this.asyncCompactorService = x$1;
    }

    private AsyncClusteringService asyncClusteringService() {
        return this.asyncClusteringService;
    }

    private void asyncClusteringService_$eq(AsyncClusteringService x$1) {
        this.asyncClusteringService = x$1;
    }

    private scala.Option<SparkRDDWriteClient<?>> writeClient() {
        return this.writeClient;
    }

    private void writeClient_$eq(scala.Option<SparkRDDWriteClient<?>> x$1) {
        this.writeClient = x$1;
    }

    private scala.Option<HoodieTableConfig> hoodieTableConfig() {
        return this.hoodieTableConfig;
    }

    private void hoodieTableConfig_$eq(scala.Option<HoodieTableConfig> x$1) {
        this.hoodieTableConfig = x$1;
    }

    public synchronized void addBatch(long batchId, Dataset<Row> data) {
        Try try_;
        if (this.org$apache$hudi$HoodieStreamingSink$$isAsyncCompactorServiceShutdownAbnormally()) {
            throw new IllegalStateException("Async Compactor shutdown unexpectedly");
        }
        if (this.org$apache$hudi$HoodieStreamingSink$$isAsyncClusteringServiceShutdownAbnormally()) {
            this.org$apache$hudi$HoodieStreamingSink$$log().error("Async clustering service shutdown unexpectedly");
            throw new IllegalStateException("Async clustering service shutdown unexpectedly");
        }
        String queryId = this.sqlContext.sparkContext().getLocalProperty(StreamExecution$.MODULE$.QUERY_ID_KEY());
        ValidationUtils.checkArgument((queryId != null ? 1 : 0) != 0, (String)"queryId is null");
        if (this.metaClient().isDefined() && this.canSkipBatch(batchId, (String)this.org$apache$hudi$HoodieStreamingSink$$options.getOrElse((Object)DataSourceWriteOptions$.MODULE$.OPERATION().key(), (Function0 & Serializable & scala.Serializable)() -> DataSourceWriteOptions$.MODULE$.UPSERT_OPERATION_OPT_VAL()))) {
            this.org$apache$hudi$HoodieStreamingSink$$log().warn(new StringBuilder(43).append("Skipping already completed batch ").append(batchId).append(" in query ").append(queryId).toString());
            return;
        }
        ObjectRef updatedOptions = ObjectRef.create((Object)this.org$apache$hudi$HoodieStreamingSink$$options.updated((Object)HoodieWriteConfig.MARKERS_TYPE.key(), (Object)MarkerType.DIRECT.name()));
        updatedOptions.elem = ((Map)updatedOptions.elem).updated((Object)HoodieWriteConfig.AUTO_ADJUST_LOCK_CONFIGS.key(), (Object)"true");
        updatedOptions.elem = ((Map)updatedOptions.elem).updated((Object)HoodieSparkSqlWriter$.MODULE$.SPARK_STREAMING_BATCH_ID(), (Object)((Object)BoxesRunTime.boxToLong((long)batchId)).toString());
        if (!this.org$apache$hudi$HoodieStreamingSink$$options.contains((Object)HoodieWriteConfig.EMBEDDED_TIMELINE_SERVER_ENABLE.key())) {
            updatedOptions.elem = ((Map)updatedOptions.elem).updated((Object)HoodieWriteConfig.EMBEDDED_TIMELINE_SERVER_ENABLE.key(), (Object)" false");
        }
        if ((try_ = this.retry(this.retryCnt(), this.retryIntervalMs(), (Function0 & Serializable & scala.Serializable)() -> {
            Failure failure;
            boolean bl = false;
            Success success = null;
            Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> HoodieSparkSqlWriter$.MODULE$.write($this.sqlContext, this.mode(), (Map<String, String>)((Map)updatedOptions$1.elem), data, (scala.Option<HoodieSparkSqlWriter.StreamingWriteParams>)new Some((Object)new HoodieSparkSqlWriter.StreamingWriteParams(this.hoodieTableConfig(), (scala.Option<Function1<SparkRDDWriteClient<?>, BoxedUnit>>)(this.disableCompaction() ? None$.MODULE$ : new Some((Function1 & Serializable & scala.Serializable)client -> {
                this.triggerAsyncCompactor(client);
                return BoxedUnit.UNIT;
            })), (scala.Option<Function1<SparkRDDWriteClient<?>, BoxedUnit>>)new Some((Function1 & Serializable & scala.Serializable)client -> {
                this.triggerAsyncClustering(client);
                return BoxedUnit.UNIT;
            }), (scala.Option<BiConsumer<HoodieTableMetaClient, HoodieCommitMetadata>>)new Some((Object)new BiConsumer<HoodieTableMetaClient, HoodieCommitMetadata>(this, batchId){
                private final /* synthetic */ HoodieStreamingSink $outer;
                private final long batchId$1;

                public BiConsumer<HoodieTableMetaClient, HoodieCommitMetadata> andThen(BiConsumer<? super HoodieTableMetaClient, ? super HoodieCommitMetadata> x$1) {
                    return BiConsumer.super.andThen(x$1);
                }

                public void accept(HoodieTableMetaClient metaClient, HoodieCommitMetadata newCommitMetadata) {
                    String identifier = (String)this.$outer.org$apache$hudi$HoodieStreamingSink$$options.getOrElse((Object)DataSourceWriteOptions$.MODULE$.STREAMING_CHECKPOINT_IDENTIFIER().key(), (Function0 & Serializable & scala.Serializable)() -> (String)DataSourceWriteOptions$.MODULE$.STREAMING_CHECKPOINT_IDENTIFIER().defaultValue());
                    newCommitMetadata.addMetadata(HoodieStreamingSink$.MODULE$.SINK_CHECKPOINT_KEY(), CommitUtils.getCheckpointValueAsString((String)identifier, (String)String.valueOf(this.batchId$1)));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.batchId$1 = batchId$1;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$accept$1()}, serializedLambda);
                }
            }))), this.writeClient()));
            if (try_ instanceof Success) {
                bl = true;
                success = (Success)try_;
                Tuple6 tuple6 = (Tuple6)success.value();
                if (tuple6 != null) {
                    boolean bl2 = BoxesRunTime.unboxToBoolean((Object)tuple6._1());
                    Option commitOps = (Option)tuple6._2();
                    Option compactionInstantOps = (Option)tuple6._3();
                    Option clusteringInstant = (Option)tuple6._4();
                    SparkRDDWriteClient client = (SparkRDDWriteClient)tuple6._5();
                    HoodieTableConfig tableConfig = (HoodieTableConfig)tuple6._6();
                    if (bl2) {
                        boolean bl3 = commitOps.isPresent();
                        String string = true == bl3 ? new StringBuilder(12).append(" for commit=").append(commitOps.get()).toString() : " with no new commits";
                        this.org$apache$hudi$HoodieStreamingSink$$log().info(new StringBuilder(25).append("Micro batch id=").append(batchId).append(" succeeded").append((Object)string).toString());
                        this.org$apache$hudi$HoodieStreamingSink$$log().info(new StringBuilder(86).append("Current value of latestCommittedBatchId: ").append(this.latestCommittedBatchId()).append(". Setting latestCommittedBatchId to batchId ").append(batchId).append(".").toString());
                        this.latestCommittedBatchId_$eq(batchId);
                        this.writeClient_$eq((scala.Option<SparkRDDWriteClient<?>>)new Some((Object)client));
                        this.hoodieTableConfig_$eq((scala.Option<HoodieTableConfig>)new Some((Object)tableConfig));
                        if (client != null) {
                            this.metaClient_$eq((scala.Option<HoodieTableMetaClient>)new Some((Object)HoodieTableMetaClient.builder().setConf(HadoopFSUtils.getStorageConfWithCopy((Configuration)$this.sqlContext.sparkContext().hadoopConfiguration())).setBasePath(client.getConfig().getBasePath()).build()));
                        }
                        if (compactionInstantOps.isPresent()) {
                            this.asyncCompactorService().enqueuePendingAsyncServiceInstant(new HoodieInstant(HoodieInstant.State.REQUESTED, "compaction", (String)compactionInstantOps.get()));
                        }
                        if (!clusteringInstant.isPresent()) return new Success((Object)new Tuple3((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)commitOps, (Object)compactionInstantOps));
                        this.asyncClusteringService().enqueuePendingAsyncServiceInstant(new HoodieInstant(HoodieInstant.State.REQUESTED, "replacecommit", (String)clusteringInstant.get()));
                        return new Success((Object)new Tuple3((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)commitOps, (Object)compactionInstantOps));
                    }
                }
            }
            if (try_ instanceof Failure) {
                Failure failure2;
                Failure failure3 = (Failure)try_;
                Throwable e = failure3.exception();
                data.sparkSession().sparkContext().getPersistentRDDs().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    RDD rDD;
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 != null) {
                        RDD rdd = (RDD)tuple2._2();
                        try {
                            rDD = rdd.unpersist(rdd.unpersist$default$1());
                        }
                        catch (Exception t) {
                            this.org$apache$hudi$HoodieStreamingSink$$log().warn("Got excepting trying to unpersist rdd", (Throwable)t);
                            rDD = BoxedUnit.UNIT;
                        }
                    } else {
                        throw new MatchError((Object)tuple2);
                    }
                    RDD rDD2 = rDD;
                    return rDD2;
                });
                this.org$apache$hudi$HoodieStreamingSink$$log().error(new StringBuilder(43).append("Micro batch id=").append(batchId).append(" threw following exception: ").toString(), e);
                if (this.ignoreFailedBatch()) {
                    this.org$apache$hudi$HoodieStreamingSink$$log().warn(new StringBuilder(64).append("Ignore the exception and move on streaming as per ").append(DataSourceWriteOptions$.MODULE$.STREAMING_IGNORE_FAILED_BATCH().key()).append(" configuration").toString());
                    failure2 = new Success((Object)new Tuple3((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)None$.MODULE$, (Object)None$.MODULE$));
                    return failure2;
                } else {
                    if (this.retryCnt() > 1) {
                        this.org$apache$hudi$HoodieStreamingSink$$log().info(new StringBuilder(39).append("Retrying the failed micro batch id=").append(batchId).append(" ...").toString());
                    }
                    failure2 = new Failure(e);
                }
                return failure2;
            }
            if (!bl) throw new MatchError((Object)try_);
            Tuple6 tuple6 = (Tuple6)success.value();
            if (tuple6 == null) throw new MatchError((Object)try_);
            boolean bl4 = BoxesRunTime.unboxToBoolean((Object)tuple6._1());
            Option commitOps = (Option)tuple6._2();
            if (false != bl4) throw new MatchError((Object)try_);
            boolean bl5 = commitOps.isPresent();
            String string = true == bl5 ? new StringBuilder(12).append(" for commit=").append(commitOps.get()).toString() : "";
            this.org$apache$hudi$HoodieStreamingSink$$log().error(new StringBuilder(36).append("Micro batch id=").append(batchId).append(" ended up with errors").append((Object)string).toString());
            if (this.ignoreFailedBatch()) {
                this.org$apache$hudi$HoodieStreamingSink$$log().info(new StringBuilder(61).append("Ignore the errors and move on streaming as per ").append(DataSourceWriteOptions$.MODULE$.STREAMING_IGNORE_FAILED_BATCH().key()).append(" configuration").toString());
                failure = new Success((Object)new Tuple3((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)None$.MODULE$, (Object)None$.MODULE$));
                return failure;
            } else {
                if (this.retryCnt() > 1) {
                    this.org$apache$hudi$HoodieStreamingSink$$log().warn(new StringBuilder(39).append("Retrying the failed micro batch id=").append(batchId).append(" ...").toString());
                }
                failure = new Failure((Throwable)new HoodieCorruptedDataException(new StringBuilder(36).append("Micro batch id=").append(batchId).append(" ended up with errors").toString()));
            }
            return failure;
        })) instanceof Failure) {
            BoxedUnit boxedUnit;
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            if (!this.ignoreFailedBatch()) {
                this.org$apache$hudi$HoodieStreamingSink$$log().error(new StringBuilder(86).append("Micro batch id=").append(batchId).append(" threw following expections,").append("aborting streaming app to avoid data loss: ").toString(), e);
                this.org$apache$hudi$HoodieStreamingSink$$reset(true);
                System.exit(1);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else if (try_ instanceof Success) {
            this.org$apache$hudi$HoodieStreamingSink$$log().info(new StringBuilder(25).append("Micro batch id=").append(batchId).append(" succeeded").toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(try_);
        }
    }

    private scala.Option<String> getStreamIdentifier(Map<String, String> options) {
        Enum enum_ = ConfigUtils.resolveEnum(WriteConcurrencyMode.class, (String)((String)options.getOrElse((Object)HoodieWriteConfig.WRITE_CONCURRENCY_MODE.key(), (Function0 & Serializable & scala.Serializable)() -> (String)HoodieWriteConfig.WRITE_CONCURRENCY_MODE.defaultValue())));
        WriteConcurrencyMode writeConcurrencyMode = WriteConcurrencyMode.SINGLE_WRITER;
        return !(enum_ != null ? !enum_.equals(writeConcurrencyMode) : writeConcurrencyMode != null) ? new Some(options.getOrElse((Object)DataSourceWriteOptions$.MODULE$.STREAMING_CHECKPOINT_IDENTIFIER().key(), (Function0 & Serializable & scala.Serializable)() -> (String)DataSourceWriteOptions$.MODULE$.STREAMING_CHECKPOINT_IDENTIFIER().defaultValue())) : options.get((Object)DataSourceWriteOptions$.MODULE$.STREAMING_CHECKPOINT_IDENTIFIER().key());
    }

    public String toString() {
        return new StringBuilder(21).append("HoodieStreamingSink[").append(this.org$apache$hudi$HoodieStreamingSink$$options.apply((Object)"path")).append("]").toString();
    }

    private <T> Try<T> retry(int n, long waitInMillis, Function0<Try<T>> fn) {
        Success success;
        block2: {
            Try try_;
            while (true) {
                if ((try_ = (Try)fn.apply()) instanceof Success) {
                    Success success2;
                    success = success2 = (Success)try_;
                    break block2;
                }
                if (n <= 1) break;
                Thread.sleep(waitInMillis);
                waitInMillis *= 2L;
                --n;
            }
            this.org$apache$hudi$HoodieStreamingSink$$reset(false);
            success = try_;
        }
        return success;
    }

    public void triggerAsyncCompactor(SparkRDDWriteClient<?> client) {
        block0: {
            if (this.asyncCompactorService() != null) break block0;
            this.org$apache$hudi$HoodieStreamingSink$$log().info("Triggering Async compaction !!");
            this.asyncCompactorService_$eq(new SparkStreamingAsyncCompactService((HoodieEngineContext)new HoodieSparkEngineContext(new JavaSparkContext(this.sqlContext.sparkContext())), (BaseHoodieWriteClient)client));
            this.asyncCompactorService().start((Function)new Function<Boolean, Boolean>(this){
                private final /* synthetic */ HoodieStreamingSink $outer;

                public <V> Function<V, Boolean> compose(Function<? super V, ? extends Boolean> x$1) {
                    return Function.super.compose(x$1);
                }

                public <V> Function<Boolean, V> andThen(Function<? super Boolean, ? extends V> x$1) {
                    return Function.super.andThen(x$1);
                }

                public Boolean apply(Boolean errored) {
                    this.$outer.org$apache$hudi$HoodieStreamingSink$$log().info(new StringBuilder(36).append("Async Compactor shutdown. Errored ? ").append(errored).toString());
                    this.$outer.org$apache$hudi$HoodieStreamingSink$$isAsyncCompactorServiceShutdownAbnormally_$eq(Predef$.MODULE$.Boolean2boolean(errored));
                    this.$outer.org$apache$hudi$HoodieStreamingSink$$reset(false);
                    this.$outer.org$apache$hudi$HoodieStreamingSink$$log().info("Done resetting write client.");
                    return Predef$.MODULE$.boolean2Boolean(true);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(this){
                private final /* synthetic */ HoodieStreamingSink $outer;

                public void run() {
                    this.$outer.org$apache$hudi$HoodieStreamingSink$$reset(true);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }));
            HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setConf(HadoopFSUtils.getStorageConfWithCopy((Configuration)this.sqlContext.sparkContext().hadoopConfiguration())).setBasePath(client.getConfig().getBasePath()).build();
            List pendingInstants = CompactionUtils.getPendingCompactionInstantTimes((HoodieTableMetaClient)metaClient);
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(pendingInstants).asScala()).foreach((Function1 & Serializable & scala.Serializable)h -> {
                HoodieStreamingSink.$anonfun$triggerAsyncCompactor$1(this, h);
                return BoxedUnit.UNIT;
            });
        }
    }

    public void triggerAsyncClustering(SparkRDDWriteClient<?> client) {
        block0: {
            if (this.asyncClusteringService() != null) break block0;
            this.org$apache$hudi$HoodieStreamingSink$$log().info("Triggering async clustering!");
            this.asyncClusteringService_$eq(new SparkStreamingAsyncClusteringService((HoodieEngineContext)new HoodieSparkEngineContext(new JavaSparkContext(this.sqlContext.sparkContext())), (BaseHoodieWriteClient)client));
            this.asyncClusteringService().start((Function)new Function<Boolean, Boolean>(this){
                private final /* synthetic */ HoodieStreamingSink $outer;

                public <V> Function<V, Boolean> compose(Function<? super V, ? extends Boolean> x$1) {
                    return Function.super.compose(x$1);
                }

                public <V> Function<Boolean, V> andThen(Function<? super Boolean, ? extends V> x$1) {
                    return Function.super.andThen(x$1);
                }

                public Boolean apply(Boolean errored) {
                    this.$outer.org$apache$hudi$HoodieStreamingSink$$log().info(new StringBuilder(45).append("Async clustering service shutdown. Errored ? ").append(errored).toString());
                    this.$outer.org$apache$hudi$HoodieStreamingSink$$isAsyncClusteringServiceShutdownAbnormally_$eq(Predef$.MODULE$.Boolean2boolean(errored));
                    this.$outer.org$apache$hudi$HoodieStreamingSink$$reset(false);
                    return Predef$.MODULE$.boolean2Boolean(true);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(this){
                private final /* synthetic */ HoodieStreamingSink $outer;

                public void run() {
                    this.$outer.org$apache$hudi$HoodieStreamingSink$$reset(true);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }));
            HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setConf(HadoopFSUtils.getStorageConfWithCopy((Configuration)this.sqlContext.sparkContext().hadoopConfiguration())).setBasePath(client.getConfig().getBasePath()).build();
            List pendingInstants = ClusteringUtils.getPendingClusteringInstantTimes((HoodieTableMetaClient)metaClient);
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(pendingInstants).asScala()).foreach((Function1 & Serializable & scala.Serializable)h -> {
                HoodieStreamingSink.$anonfun$triggerAsyncClustering$1(this, h);
                return BoxedUnit.UNIT;
            });
        }
    }

    public synchronized void org$apache$hudi$HoodieStreamingSink$$reset(boolean force) {
        block2: {
            if (this.asyncCompactorService() != null) {
                this.asyncCompactorService().shutdown(force);
                this.asyncCompactorService_$eq(null);
            }
            if (this.asyncClusteringService() != null) {
                this.asyncClusteringService().shutdown(force);
                this.asyncClusteringService_$eq(null);
            }
            if (!this.writeClient().isDefined()) break block2;
            ((BaseHoodieWriteClient)this.writeClient().get()).close();
            this.writeClient_$eq(Option$.MODULE$.empty());
        }
    }

    private boolean canSkipBatch(long incomingBatchId, String operationType) {
        boolean bl;
        if (!DataSourceWriteOptions$.MODULE$.DELETE_OPERATION_OPT_VAL().equals(operationType)) {
            String identifier = (String)this.org$apache$hudi$HoodieStreamingSink$$options.getOrElse((Object)DataSourceWriteOptions$.MODULE$.STREAMING_CHECKPOINT_IDENTIFIER().key(), (Function0 & Serializable & scala.Serializable)() -> (String)DataSourceWriteOptions$.MODULE$.STREAMING_CHECKPOINT_IDENTIFIER().defaultValue());
            Option lastCheckpoint = CommitUtils.getValidCheckpointForCurrentWriter((HoodieTimeline)((HoodieTableMetaClient)this.metaClient().get()).getActiveTimeline().getWriteTimeline(), (String)HoodieStreamingSink$.MODULE$.SINK_CHECKPOINT_KEY(), (String)identifier);
            if (lastCheckpoint.isPresent()) {
                this.latestCommittedBatchId_$eq(new StringOps(Predef$.MODULE$.augmentString((String)lastCheckpoint.get())).toLong());
            }
            bl = this.latestCommittedBatchId() >= incomingBatchId;
        } else {
            bl = false;
        }
        return bl;
    }

    private final scala.Option liftedTree1$1() {
        Some some;
        try {
            some = new Some((Object)HoodieTableMetaClient.builder().setConf(HadoopFSUtils.getStorageConfWithCopy((Configuration)this.sqlContext.sparkContext().hadoopConfiguration())).setBasePath((String)this.tablePath().get()).build());
        }
        catch (TableNotFoundException tableNotFoundException) {
            this.org$apache$hudi$HoodieStreamingSink$$log().warn("Ignore TableNotFoundException as it is first microbatch.");
            some = Option$.MODULE$.empty();
        }
        return some;
    }

    public static final /* synthetic */ void $anonfun$triggerAsyncCompactor$1(HoodieStreamingSink $this, HoodieInstant h) {
        $this.asyncCompactorService().enqueuePendingAsyncServiceInstant(h);
    }

    public static final /* synthetic */ void $anonfun$triggerAsyncClustering$1(HoodieStreamingSink $this, HoodieInstant h) {
        $this.asyncClusteringService().enqueuePendingAsyncServiceInstant(h);
    }

    public HoodieStreamingSink(SQLContext sqlContext, Map<String, String> options, Seq<String> partitionColumns, OutputMode outputMode) {
        this.sqlContext = sqlContext;
        this.org$apache$hudi$HoodieStreamingSink$$options = options;
        Sink.$init$((Sink)this);
        this.latestCommittedBatchId = -1L;
        this.org$apache$hudi$HoodieStreamingSink$$log = LoggerFactory.getLogger(HoodieStreamingSink.class);
        this.tablePath = options.get((Object)"path");
        if (this.tablePath().isEmpty() || this.tablePath().get() == null) {
            throw new HoodieException("'path'  must be specified.");
        }
        this.metaClient = this.liftedTree1$1();
        this.retryCnt = new StringOps(Predef$.MODULE$.augmentString((String)options.getOrElse((Object)DataSourceWriteOptions$.MODULE$.STREAMING_RETRY_CNT().key(), (Function0 & Serializable & scala.Serializable)() -> (String)DataSourceWriteOptions$.MODULE$.STREAMING_RETRY_CNT().defaultValue()))).toInt();
        this.retryIntervalMs = new StringOps(Predef$.MODULE$.augmentString((String)options.getOrElse((Object)DataSourceWriteOptions$.MODULE$.STREAMING_RETRY_INTERVAL_MS().key(), (Function0 & Serializable & scala.Serializable)() -> (String)DataSourceWriteOptions$.MODULE$.STREAMING_RETRY_INTERVAL_MS().defaultValue()))).toLong();
        this.ignoreFailedBatch = new StringOps(Predef$.MODULE$.augmentString((String)options.getOrElse((Object)DataSourceWriteOptions$.MODULE$.STREAMING_IGNORE_FAILED_BATCH().key(), (Function0 & Serializable & scala.Serializable)() -> (String)DataSourceWriteOptions$.MODULE$.STREAMING_IGNORE_FAILED_BATCH().defaultValue()))).toBoolean();
        this.disableCompaction = new StringOps(Predef$.MODULE$.augmentString((String)options.getOrElse((Object)DataSourceWriteOptions$.MODULE$.STREAMING_DISABLE_COMPACTION().key(), (Function0 & Serializable & scala.Serializable)() -> (String)DataSourceWriteOptions$.MODULE$.STREAMING_DISABLE_COMPACTION().defaultValue()))).toBoolean();
        this.org$apache$hudi$HoodieStreamingSink$$isAsyncCompactorServiceShutdownAbnormally = false;
        this.org$apache$hudi$HoodieStreamingSink$$isAsyncClusteringServiceShutdownAbnormally = false;
        OutputMode outputMode2 = outputMode;
        OutputMode outputMode3 = OutputMode.Append();
        this.mode = !(outputMode2 != null ? !outputMode2.equals(outputMode3) : outputMode3 != null) ? SaveMode.Append : SaveMode.Overwrite;
        this.writeClient = Option$.MODULE$.empty();
        this.hoodieTableConfig = Option$.MODULE$.empty();
    }
}

