/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.hudi.BaseHoodieTableFileIndex;
import org.apache.hudi.BucketIndexSupport$;
import org.apache.hudi.HoodieFileIndex;
import org.apache.hudi.SparkBaseIndexSupport;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.FileSlice;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.TableSchemaResolver;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieIndexConfig;
import org.apache.hudi.index.HoodieIndex;
import org.apache.hudi.index.bucket.BucketIdentifier;
import org.apache.hudi.keygen.KeyGenerator;
import org.apache.hudi.keygen.factory.HoodieSparkKeyGeneratorFactory;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.expressions.And;
import org.apache.spark.sql.catalyst.expressions.And$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.BinaryComparison;
import org.apache.spark.sql.catalyst.expressions.Equality$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.In;
import org.apache.spark.sql.catalyst.expressions.InSet;
import org.apache.spark.sql.catalyst.expressions.IsNaN;
import org.apache.spark.sql.catalyst.expressions.IsNull;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Or;
import org.apache.spark.sql.catalyst.expressions.package$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.util.collection.BitSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005uh\u0001\u0002\u000e\u001c\u0001\tB\u0001b\n\u0001\u0003\u0002\u0003\u0006I\u0001\u000b\u0005\t_\u0001\u0011\t\u0011)A\u0005a!A\u0001\b\u0001B\u0001B\u0003%\u0011\bC\u0003@\u0001\u0011\u0005\u0001\tC\u0004F\u0001\t\u0007I\u0011\u0002$\t\r5\u0003\u0001\u0015!\u0003H\u0011!q\u0005\u0001#b\u0001\n\u0013y\u0005\u0002\u0003,\u0001\u0011\u000b\u0007I\u0011B,\t\u000by\u0003A\u0011I0\t\u000b5\u0004A\u0011\u00018\t\u000bM\u0004A\u0011\t;\t\u000ba\u0004A\u0011I=\t\u000f\u0005\u0015\u0004\u0001\"\u0001\u0002h!9\u0011\u0011\u0011\u0001\u0005\u0002\u0005\r\u0005bBAE\u0001\u0011%\u00111\u0012\u0005\b\u0003;\u0003A\u0011BAP\u0011\u001d\tY\f\u0001C\u0005\u0003{C\u0011\"a2\u0001\u0005\u0004%I!!3\t\u0011\u0005m\u0007\u0001)A\u0005\u0003\u0017Da!!8\u0001\t\u0003yuaBAp7!\u0005\u0011\u0011\u001d\u0004\u00075mA\t!a9\t\r}2B\u0011AAv\u0011%\tiO\u0006b\u0001\n\u0003\ty\u000f\u0003\u0005\u0002|Z\u0001\u000b\u0011BAy\u0005I\u0011UoY6fi&sG-\u001a=TkB\u0004xN\u001d;\u000b\u0005qi\u0012\u0001\u00025vI&T!AH\u0010\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0001\u0013aA8sO\u000e\u00011C\u0001\u0001$!\t!S%D\u0001\u001c\u0013\t13DA\u000bTa\u0006\u00148NQ1tK&sG-\u001a=TkB\u0004xN\u001d;\u0002\u000bM\u0004\u0018M]6\u0011\u0005%jS\"\u0001\u0016\u000b\u0005-b\u0013aA:rY*\u0011q%H\u0005\u0003])\u0012Ab\u00159be.\u001cVm]:j_:\fa\"\\3uC\u0012\fG/Y\"p]\u001aLw\r\u0005\u00022m5\t!G\u0003\u00024i\u000511m\u001c8gS\u001eT!!N\u000e\u0002\r\r|W.\\8o\u0013\t9$G\u0001\u000bI_>$\u0017.Z'fi\u0006$\u0017\r^1D_:4\u0017nZ\u0001\u000b[\u0016$\u0018m\u00117jK:$\bC\u0001\u001e>\u001b\u0005Y$B\u0001\u001f5\u0003\u0015!\u0018M\u00197f\u0013\tq4HA\u000bI_>$\u0017.\u001a+bE2,W*\u001a;b\u00072LWM\u001c;\u0002\rqJg.\u001b;?)\u0011\t%i\u0011#\u0011\u0005\u0011\u0002\u0001\"B\u0014\u0005\u0001\u0004A\u0003\"B\u0018\u0005\u0001\u0004\u0001\u0004\"\u0002\u001d\u0005\u0001\u0004I\u0014a\u00017pOV\tq\t\u0005\u0002I\u00176\t\u0011J\u0003\u0002K?\u0005)1\u000f\u001c45U&\u0011A*\u0013\u0002\u0007\u0019><w-\u001a:\u0002\t1|w\rI\u0001\rW\u0016Lx)\u001a8fe\u0006$xN]\u000b\u0002!B\u0011\u0011\u000bV\u0007\u0002%*\u00111kG\u0001\u0007W\u0016Lx-\u001a8\n\u0005U\u0013&\u0001D&fs\u001e+g.\u001a:bi>\u0014\u0018AC1we>\u001c6\r[3nCV\t\u0001\f\u0005\u0002Z96\t!L\u0003\u0002\\;\u0005!\u0011M\u001e:p\u0013\ti&L\u0001\u0004TG\",W.Y\u0001\rO\u0016$\u0018J\u001c3fq:\u000bW.Z\u000b\u0002AB\u0011\u0011M\u001b\b\u0003E\"\u0004\"a\u00194\u000e\u0003\u0011T!!Z\u0011\u0002\rq\u0012xn\u001c;?\u0015\u00059\u0017!B:dC2\f\u0017BA5g\u0003\u0019\u0001&/\u001a3fM&\u00111\u000e\u001c\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005%4\u0017\u0001E5t\u0013:$W\r_!wC&d\u0017M\u00197f+\u0005y\u0007C\u00019r\u001b\u00051\u0017B\u0001:g\u0005\u001d\u0011un\u001c7fC:\f\u0001#\u001b8wC2LG-\u0019;f\u0007\u0006\u001c\u0007.Z:\u0015\u0003U\u0004\"\u0001\u001d<\n\u0005]4'\u0001B+oSR\f\u0011dY8naV$XmQ1oI&$\u0017\r^3GS2,g*Y7fgRY!0!\u0001\u0002\f\u0005E\u0012qGA1!\r\u000180`\u0005\u0003y\u001a\u0014aa\u00149uS>t\u0007cA1\u007fA&\u0011q\u0010\u001c\u0002\u0004'\u0016$\bbBA\u0002\u0019\u0001\u0007\u0011QA\u0001\nM&dW-\u00138eKb\u00042\u0001JA\u0004\u0013\r\tIa\u0007\u0002\u0010\u0011>|G-[3GS2,\u0017J\u001c3fq\"9\u0011Q\u0002\u0007A\u0002\u0005=\u0011\u0001D9vKJLh)\u001b7uKJ\u001c\bCBA\t\u00037\t\tC\u0004\u0003\u0002\u0014\u0005]abA2\u0002\u0016%\tq-C\u0002\u0002\u001a\u0019\fq\u0001]1dW\u0006<W-\u0003\u0003\u0002\u001e\u0005}!aA*fc*\u0019\u0011\u0011\u00044\u0011\t\u0005\r\u0012QF\u0007\u0003\u0003KQA!a\n\u0002*\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\r\tYCK\u0001\tG\u0006$\u0018\r\\=ti&!\u0011qFA\u0013\u0005))\u0005\u0010\u001d:fgNLwN\u001c\u0005\b\u0003ga\u0001\u0019AA\u001b\u0003Y\tX/\u001a:z%\u00164WM]3oG\u0016$7i\u001c7v[:\u001c\b#BA\t\u00037\u0001\u0007bBA\u001d\u0019\u0001\u0007\u00111H\u0001\u001eaJ,h.\u001a3QCJ$\u0018\u000e^5p]N\fe\u000e\u001a$jY\u0016\u001cF.[2fgB1\u0011\u0011CA\u000e\u0003{\u0001r\u0001]A \u0003\u0007\n\u0019&C\u0002\u0002B\u0019\u0014a\u0001V;qY\u0016\u0014\u0004\u0003\u00029|\u0003\u000b\u0002B!a\u0012\u0002N9\u0019A%!\u0013\n\u0007\u0005-3$\u0001\rCCN,\u0007j\\8eS\u0016$\u0016M\u00197f\r&dW-\u00138eKbLA!a\u0014\u0002R\ti\u0001+\u0019:uSRLwN\u001c)bi\"T1!a\u0013\u001c!\u0019\t\t\"a\u0007\u0002VA!\u0011qKA/\u001b\t\tIFC\u0002\u0002\\Q\nQ!\\8eK2LA!a\u0018\u0002Z\tIa)\u001b7f'2L7-\u001a\u0005\u0007\u0003Gb\u0001\u0019A8\u00023MDw.\u001e7e!V\u001c\b\u000eR8x]\u001aKG.Z:GS2$XM]\u0001\u0012O\u0016$8)\u00198eS\u0012\fG/\u001a$jY\u0016\u001cH#B?\u0002j\u00055\u0004BBA6\u001b\u0001\u0007Q0\u0001\u0007bY24\u0015\u000e\\3t\u001d\u0006lW\rC\u0004\u0002p5\u0001\r!!\u001d\u0002\u0013\t,8m[3u\u0013\u0012\u001c\b\u0003BA:\u0003{j!!!\u001e\u000b\t\u0005]\u0014\u0011P\u0001\u000bG>dG.Z2uS>t'bAA>Y\u0005!Q\u000f^5m\u0013\u0011\ty(!\u001e\u0003\r\tKGoU3u\u0003\u00012\u0017\u000e\u001c;feF+XM]5fg^KG\u000f\u001b\"vG.,G\u000fS1tQ\u001aKW\r\u001c3\u0015\t\u0005\u0015\u0015q\u0011\t\u0005an\f\t\bC\u0004\u0002\u000e9\u0001\r!a\u0004\u0002=\u001d,GOQ;dW\u0016$8OQ=Nk2$\u0018\u000e\u001d7f\u0011\u0006\u001c\bNR5fY\u0012\u001cH\u0003CA9\u0003\u001b\u000by)a%\t\u000f\u00055q\u00021\u0001\u0002\u0010!1\u0011\u0011S\bA\u0002u\fQ#\u001b8eKb\u0014UoY6fi\"\u000b7\u000f\u001b$jK2$7\u000fC\u0004\u0002\u0016>\u0001\r!a&\u0002\u00159,XNQ;dW\u0016$8\u000fE\u0002q\u00033K1!a'g\u0005\rIe\u000e^\u0001\u0015O\u0016$X)];bY&$\u0018PR5fY\u0012\u0004\u0016-\u001b:\u0015\r\u0005\u0005\u00161WA\\!\u001d\t\u0019+!+a\u0003[k!!!*\u000b\t\u0005]\u0014q\u0015\u0006\u0004\u0003w\"\u0014\u0002BAV\u0003K\u0013A\u0001U1jeB\u0019\u0001/a,\n\u0007\u0005EfMA\u0002B]fDq!!.\u0011\u0001\u0004\t\t#\u0001\u0003fqB\u0014\bBBA]!\u0001\u0007Q0\u0001\bfcV\fG.\u001b;z\r&,G\u000eZ:\u00029\u001d,GOQ;dW\u0016$8OQ=TS:<G.\u001a%bg\"4\u0015.\u001a7egRA\u0011\u0011OA`\u0003\u0003\f)\rC\u0004\u00026F\u0001\r!!\t\t\r\u0005\r\u0017\u00031\u0001a\u0003A\u0011WoY6fi\u000e{G.^7o\u001d\u0006lW\rC\u0004\u0002\u0016F\u0001\r!a&\u00021%tG-\u001a=Ck\u000e\\W\r\u001e%bg\"4\u0015.\u001a7eg>\u0003H/\u0006\u0002\u0002LB!\u0001o_Ag!\u0015\ty-a6a\u001b\t\t\tN\u0003\u0003\u0002|\u0005M'BAAk\u0003\u0011Q\u0017M^1\n\t\u0005e\u0017\u0011\u001b\u0002\u0005\u0019&\u001cH/A\rj]\u0012,\u0007PQ;dW\u0016$\b*Y:i\r&,G\u000eZ:PaR\u0004\u0013aD4fi.+\u0017pR3oKJ\fGo\u001c:\u0002%\t+8m[3u\u0013:$W\r_*vaB|'\u000f\u001e\t\u0003IY\u00192AFAs!\r\u0001\u0018q]\u0005\u0004\u0003S4'AB!osJ+g\r\u0006\u0002\u0002b\u0006Q\u0011J\u0014#F1~s\u0015)T#\u0016\u0005\u0005E\b\u0003BAz\u0003sl!!!>\u000b\t\u0005]\u00181[\u0001\u0005Y\u0006tw-C\u0002l\u0003k\f1\"\u0013(E\u000bb{f*Q'FA\u0001")
public class BucketIndexSupport
extends SparkBaseIndexSupport {
    private KeyGenerator keyGenerator;
    private Schema avroSchema;
    private final HoodieMetadataConfig metadataConfig;
    private final HoodieTableMetaClient metaClient;
    private final Logger log;
    private final Option<List<String>> indexBucketHashFieldsOpt;
    private volatile byte bitmap$0;

    public static String INDEX_NAME() {
        return BucketIndexSupport$.MODULE$.INDEX_NAME();
    }

    private Logger log() {
        return this.log;
    }

    private KeyGenerator keyGenerator$lzycompute() {
        BucketIndexSupport bucketIndexSupport = this;
        synchronized (bucketIndexSupport) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                TypedProperties props = new TypedProperties((Properties)this.metadataConfig.getProps());
                TypedProperties.putAll((TypedProperties)props, (Map)this.metaClient.getTableConfig().getProps());
                this.keyGenerator = HoodieSparkKeyGeneratorFactory.createKeyGenerator((TypedProperties)props);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.keyGenerator;
    }

    private KeyGenerator keyGenerator() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.keyGenerator$lzycompute();
        }
        return this.keyGenerator;
    }

    private Schema avroSchema$lzycompute() {
        BucketIndexSupport bucketIndexSupport = this;
        synchronized (bucketIndexSupport) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.avroSchema = new TableSchemaResolver(this.metaClient).getTableAvroSchema(false);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.avroSchema;
    }

    private Schema avroSchema() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.avroSchema$lzycompute();
        }
        return this.avroSchema;
    }

    @Override
    public String getIndexName() {
        return BucketIndexSupport$.MODULE$.INDEX_NAME();
    }

    @Override
    public boolean isIndexAvailable() {
        return this.indexBucketHashFieldsOpt().isDefined() && this.metadataConfig.getStringOrDefault(HoodieIndexConfig.INDEX_TYPE, "").equalsIgnoreCase(HoodieIndex.IndexType.BUCKET.name()) && this.metadataConfig.getStringOrDefault(HoodieIndexConfig.BUCKET_INDEX_ENGINE_TYPE).equalsIgnoreCase(HoodieIndex.BucketIndexEngineType.SIMPLE.name()) && this.metadataConfig.getBooleanOrDefault(HoodieIndexConfig.BUCKET_QUERY_INDEX);
    }

    @Override
    public void invalidateCaches() {
    }

    @Override
    public Option<scala.collection.immutable.Set<String>> computeCandidateFileNames(HoodieFileIndex fileIndex, Seq<Expression> queryFilters, Seq<String> queryReferencedColumns, Seq<Tuple2<Option<BaseHoodieTableFileIndex.PartitionPath>, Seq<FileSlice>>> prunedPartitionsAndFileSlices, boolean shouldPushDownFilesFilter) {
        Option<BitSet> bucketIdsBitMapByFilter = this.filterQueriesWithBucketHashField(queryFilters);
        if (bucketIdsBitMapByFilter.isDefined() && ((BitSet)bucketIdsBitMapByFilter.get()).cardinality() > 0) {
            scala.collection.immutable.Set allFilesName = (scala.collection.immutable.Set)this.getPrunedPartitionsAndFileNames(fileIndex, prunedPartitionsAndFileSlices)._2();
            return Option$.MODULE$.apply(this.getCandidateFiles((scala.collection.immutable.Set<String>)allFilesName, (BitSet)bucketIdsBitMapByFilter.get()));
        }
        return Option$.MODULE$.empty();
    }

    public scala.collection.immutable.Set<String> getCandidateFiles(scala.collection.immutable.Set<String> allFilesName, BitSet bucketIds) {
        Set candidateFiles = Set$.MODULE$.empty();
        allFilesName.foreach((Function1 & Serializable & scala.Serializable)fileName -> {
            String fileId = FSUtils.getFileIdFromFileName((String)fileName);
            int fileBucketId = BucketIdentifier.bucketIdFromFileId((String)fileId);
            if (bucketIds.get(fileBucketId)) {
                return candidateFiles.$plus$eq(fileName);
            }
            return BoxedUnit.UNIT;
        });
        return candidateFiles.toSet();
    }

    public Option<BitSet> filterQueriesWithBucketHashField(Seq<Expression> queryFilters) {
        Integer bucketNumber = this.metadataConfig.getIntOrDefault(HoodieIndexConfig.BUCKET_INDEX_NUM_BUCKETS);
        if (this.indexBucketHashFieldsOpt().isEmpty() || queryFilters.isEmpty()) {
            return None$.MODULE$;
        }
        BitSet matchedBuckets = null;
        matchedBuckets = ((List)this.indexBucketHashFieldsOpt().get()).size() == 1 ? this.getBucketsBySingleHashFields((Expression)queryFilters.reduce((Function2)And$.MODULE$), (String)((List)this.indexBucketHashFieldsOpt().get()).get(0), Predef$.MODULE$.Integer2int(bucketNumber)) : this.getBucketsByMultipleHashFields(queryFilters, (scala.collection.immutable.Set<String>)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter((List)this.indexBucketHashFieldsOpt().get()).asScala()).toSet(), Predef$.MODULE$.Integer2int(bucketNumber));
        int numBucketsSelected = matchedBuckets.cardinality();
        if (BoxesRunTime.equals((Object)BoxesRunTime.boxToInteger((int)numBucketsSelected), (Object)bucketNumber)) {
            this.log().info("The query predicates do not include equality expressions for all the hashing fields, fall back to the other indices");
            return None$.MODULE$;
        }
        return new Some((Object)matchedBuckets);
    }

    private BitSet getBucketsByMultipleHashFields(Seq<Expression> queryFilters, scala.collection.immutable.Set<String> indexBucketHashFields, int numBuckets) {
        Seq hashValuePairs = (Seq)((TraversableLike)queryFilters.map((Function1 & Serializable & scala.Serializable)expr -> this.getEqualityFieldPair((Expression)expr, indexBucketHashFields), Seq$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)pair -> BoxesRunTime.boxToBoolean((boolean)BucketIndexSupport.$anonfun$getBucketsByMultipleHashFields$2(pair)));
        BitSet matchedBuckets = new BitSet(numBuckets);
        if (hashValuePairs.size() != indexBucketHashFields.size()) {
            matchedBuckets.setUntil(numBuckets);
        } else {
            GenericData.Record record = new GenericData.Record(this.avroSchema());
            hashValuePairs.foreach((Function1 & Serializable & scala.Serializable)p -> {
                record.put((String)p.getKey(), p.getValue());
                return BoxedUnit.UNIT;
            });
            HoodieKey hoodieKey = this.keyGenerator().getKey((GenericRecord)record);
            matchedBuckets.set(BucketIdentifier.getBucketId((HoodieKey)hoodieKey, (List)((List)this.indexBucketHashFieldsOpt().get()), (int)numBuckets));
        }
        return matchedBuckets;
    }

    private Pair<String, Object> getEqualityFieldPair(Expression expr, scala.collection.immutable.Set<String> equalityFields) {
        BinaryComparison binaryComparison;
        Option option;
        Expression expression = expr;
        if (expression instanceof BinaryComparison && !(option = Equality$.MODULE$.unapply(binaryComparison = (BinaryComparison)expression)).isEmpty()) {
            Expression a = (Expression)((Tuple2)option.get())._1();
            Expression expression2 = (Expression)((Tuple2)option.get())._2();
            if (a instanceof Attribute) {
                Attribute attribute = (Attribute)a;
                if (expression2 instanceof Literal) {
                    Literal literal = (Literal)expression2;
                    Object v = literal.value();
                    if (equalityFields.contains((Object)attribute.name())) {
                        return Pair.of((Object)attribute.name(), (Object)v);
                    }
                }
            }
        }
        return null;
    }

    private BitSet getBucketsBySingleHashFields(Expression expr, String bucketColumnName, int numBuckets) {
        Expression a;
        IsNull isNull;
        Expression a2;
        BinaryComparison binaryComparison;
        Option option;
        boolean bl = false;
        IsNaN isNaN = null;
        Expression expression = expr;
        if (expression instanceof BinaryComparison && !(option = Equality$.MODULE$.unapply(binaryComparison = (BinaryComparison)expression)).isEmpty()) {
            Expression a3 = (Expression)((Tuple2)option.get())._1();
            Expression expression2 = (Expression)((Tuple2)option.get())._2();
            if (a3 instanceof Attribute) {
                Attribute attribute = (Attribute)a3;
                if (expression2 instanceof Literal) {
                    Literal literal = (Literal)expression2;
                    Object v = literal.value();
                    String string = attribute.name();
                    String string2 = bucketColumnName;
                    if (!(string != null ? !string.equals(string2) : string2 != null)) {
                        return this.getBucketSetFromValue$1(attribute, v, numBuckets);
                    }
                }
            }
        }
        if (expression instanceof In) {
            In in = (In)expression;
            Expression a4 = in.value();
            Seq list = in.list();
            if (a4 instanceof Attribute) {
                Attribute attribute = (Attribute)a4;
                if (list.forall((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)BucketIndexSupport.$anonfun$getBucketsBySingleHashFields$3(x$1)))) {
                    String string = attribute.name();
                    String string3 = bucketColumnName;
                    if (!(string != null ? !string.equals(string3) : string3 != null)) {
                        return this.getBucketSetFromIterable$1(attribute, (Iterable)list.map((Function1 & Serializable & scala.Serializable)e -> e.eval(package$.MODULE$.EmptyRow()), Seq$.MODULE$.canBuildFrom()), numBuckets);
                    }
                }
            }
        }
        if (expression instanceof InSet) {
            InSet inSet = (InSet)expression;
            Expression a5 = inSet.child();
            scala.collection.immutable.Set hset = inSet.hset();
            if (a5 instanceof Attribute) {
                Attribute attribute = (Attribute)a5;
                String string = attribute.name();
                String string4 = bucketColumnName;
                if (!(string != null ? !string.equals(string4) : string4 != null)) {
                    return this.getBucketSetFromIterable$1(attribute, (Iterable)hset, numBuckets);
                }
            }
        }
        if (expression instanceof IsNull && (a2 = (isNull = (IsNull)expression).child()) instanceof Attribute) {
            Attribute attribute = (Attribute)a2;
            String string = attribute.name();
            String string5 = bucketColumnName;
            if (!(string != null ? !string.equals(string5) : string5 != null)) {
                return this.getBucketSetFromValue$1(attribute, null, numBuckets);
            }
        }
        if (expression instanceof IsNaN) {
            bl = true;
            isNaN = (IsNaN)expression;
            Expression a6 = isNaN.child();
            if (a6 instanceof Attribute) {
                Attribute attribute = (Attribute)a6;
                String string = attribute.name();
                String string6 = bucketColumnName;
                if (!(string != null ? !string.equals(string6) : string6 != null)) {
                    DataType dataType = attribute.dataType();
                    FloatType$ floatType$ = FloatType$.MODULE$;
                    if (!(dataType != null ? !dataType.equals(floatType$) : floatType$ != null)) {
                        return this.getBucketSetFromValue$1(attribute, BoxesRunTime.boxToFloat((float)Float.NaN), numBuckets);
                    }
                }
            }
        }
        if (bl && (a = isNaN.child()) instanceof Attribute) {
            Attribute attribute = (Attribute)a;
            String string = attribute.name();
            String string7 = bucketColumnName;
            if (!(string != null ? !string.equals(string7) : string7 != null)) {
                DataType dataType = attribute.dataType();
                DoubleType$ doubleType$ = DoubleType$.MODULE$;
                if (!(dataType != null ? !dataType.equals(doubleType$) : doubleType$ != null)) {
                    return this.getBucketSetFromValue$1(attribute, BoxesRunTime.boxToDouble((double)Double.NaN), numBuckets);
                }
            }
        }
        if (expression instanceof And) {
            And and = (And)expression;
            Expression left = and.left();
            Expression right = and.right();
            return this.getBucketsBySingleHashFields(left, bucketColumnName, numBuckets).$amp(this.getBucketsBySingleHashFields(right, bucketColumnName, numBuckets));
        }
        if (expression instanceof Or) {
            Or or = (Or)expression;
            Expression left = or.left();
            Expression right = or.right();
            return this.getBucketsBySingleHashFields(left, bucketColumnName, numBuckets).$bar(this.getBucketsBySingleHashFields(right, bucketColumnName, numBuckets));
        }
        BitSet matchedBuckets = new BitSet(numBuckets);
        matchedBuckets.setUntil(numBuckets);
        return matchedBuckets;
    }

    private Option<List<String>> indexBucketHashFieldsOpt() {
        return this.indexBucketHashFieldsOpt;
    }

    public KeyGenerator getKeyGenerator() {
        return this.keyGenerator();
    }

    public static final /* synthetic */ boolean $anonfun$getBucketsByMultipleHashFields$2(Pair pair) {
        return pair != null;
    }

    private final int getBucketNumber$1(Attribute attr, Object v, int numBuckets$1) {
        GenericData.Record record = new GenericData.Record(this.avroSchema());
        record.put(attr.name(), v);
        HoodieKey hoodieKey = this.keyGenerator().getKey((GenericRecord)record);
        return BucketIdentifier.getBucketId((HoodieKey)hoodieKey, (List)((List)this.indexBucketHashFieldsOpt().get()), (int)numBuckets$1);
    }

    private final BitSet getBucketSetFromIterable$1(Attribute attr, Iterable iter, int numBuckets$1) {
        BitSet matchedBuckets = new BitSet(numBuckets$1);
        ((IterableLike)iter.map((Function1 & Serializable & scala.Serializable)v -> BoxesRunTime.boxToInteger((int)this.getBucketNumber$1(attr, v, numBuckets$1)), Iterable$.MODULE$.canBuildFrom())).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)bucketNum -> matchedBuckets.set(bucketNum));
        return matchedBuckets;
    }

    private final BitSet getBucketSetFromValue$1(Attribute attr, Object v, int numBuckets$1) {
        BitSet matchedBuckets = new BitSet(numBuckets$1);
        matchedBuckets.set(this.getBucketNumber$1(attr, v, numBuckets$1));
        return matchedBuckets;
    }

    public static final /* synthetic */ boolean $anonfun$getBucketsBySingleHashFields$3(Expression x$1) {
        return x$1 instanceof Literal;
    }

    public BucketIndexSupport(SparkSession spark, HoodieMetadataConfig metadataConfig, HoodieTableMetaClient metaClient) {
        this.metadataConfig = metadataConfig;
        this.metaClient = metaClient;
        super(spark, metadataConfig, metaClient);
        this.log = LoggerFactory.getLogger(this.getClass());
        String bucketHashFields = metadataConfig.getStringOrDefault(HoodieIndexConfig.BUCKET_INDEX_HASH_FIELD, metadataConfig.getString(HoodieTableConfig.RECORDKEY_FIELDS));
        this.indexBucketHashFieldsOpt = bucketHashFields == null || bucketHashFields.isEmpty() ? Option$.MODULE$.apply(null) : Option$.MODULE$.apply(JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Predef$.MODULE$.wrapRefArray((Object[])bucketHashFields.split(","))).asJava());
    }
}

