/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi;

import java.io.Serializable;
import java.nio.ByteBuffer;
import org.apache.avro.Conversions;
import org.apache.avro.LogicalType;
import org.apache.avro.generic.GenericData;
import org.apache.hudi.AvroConversionUtils$;
import org.apache.hudi.HoodieSchemaUtils$;
import org.apache.hudi.avro.model.BooleanWrapper;
import org.apache.hudi.avro.model.BytesWrapper;
import org.apache.hudi.avro.model.DateWrapper;
import org.apache.hudi.avro.model.DecimalWrapper;
import org.apache.hudi.avro.model.DoubleWrapper;
import org.apache.hudi.avro.model.FloatWrapper;
import org.apache.hudi.avro.model.HoodieMetadataColumnStats;
import org.apache.hudi.avro.model.IntWrapper;
import org.apache.hudi.avro.model.LongWrapper;
import org.apache.hudi.avro.model.StringWrapper;
import org.apache.hudi.avro.model.TimeMicrosWrapper;
import org.apache.hudi.avro.model.TimestampMicrosWrapper;
import org.apache.hudi.common.util.BinaryUtil;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.Metadata$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampType$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.runtime.BoxesRunTime;

public final class ColumnStatsIndexSupport$ {
    public static ColumnStatsIndexSupport$ MODULE$;
    private final String INDEX_NAME;
    private final Set<String> expectedAvroSchemaValues;
    private final Seq<String> org$apache$hudi$ColumnStatsIndexSupport$$targetColumnStatsIndexColumns;
    private final StructType org$apache$hudi$ColumnStatsIndexSupport$$columnStatsRecordStructType;
    private final Conversions.DecimalConversion decConv;

    static {
        new ColumnStatsIndexSupport$();
    }

    public boolean $lessinit$greater$default$5() {
        return false;
    }

    public String INDEX_NAME() {
        return this.INDEX_NAME;
    }

    private Set<String> expectedAvroSchemaValues() {
        return this.expectedAvroSchemaValues;
    }

    public Seq<String> org$apache$hudi$ColumnStatsIndexSupport$$targetColumnStatsIndexColumns() {
        return this.org$apache$hudi$ColumnStatsIndexSupport$$targetColumnStatsIndexColumns;
    }

    public StructType org$apache$hudi$ColumnStatsIndexSupport$$columnStatsRecordStructType() {
        return this.org$apache$hudi$ColumnStatsIndexSupport$$columnStatsRecordStructType;
    }

    public Tuple2<StructType, Seq<String>> composeIndexSchema(Seq<String> targetColumnNames, Seq<String> indexedColumns, StructType tableSchema) {
        StructField fileNameField = new StructField("fileName", (DataType)StringType$.MODULE$, true, Metadata$.MODULE$.empty());
        StructField valueCountField = new StructField("valueCount", (DataType)LongType$.MODULE$, true, Metadata$.MODULE$.empty());
        Seq targetIndexedColumns = (Seq)targetColumnNames.filter((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)indexedColumns.contains((Object)x$4)));
        Seq targetIndexedFields = (Seq)targetIndexedColumns.map((Function1 & Serializable & scala.Serializable)colName -> HoodieSchemaUtils$.MODULE$.getSchemaForField(tableSchema, (String)colName), Seq$.MODULE$.canBuildFrom());
        return new Tuple2((Object)StructType$.MODULE$.apply((Seq)targetIndexedFields.foldLeft((Object)new .colon.colon((Object)fileNameField, (List)new .colon.colon((Object)valueCountField, (List)Nil$.MODULE$)), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                Seq acc = (Seq)tuple2._1();
                Pair field = (Pair)tuple2._2();
                return (Seq)acc.$plus$plus((GenTraversableOnce)new .colon.colon((Object)MODULE$.composeColumnStatStructType((String)field.getKey(), "minValue", ((StructField)field.getValue()).dataType()), (List)new .colon.colon((Object)MODULE$.composeColumnStatStructType((String)field.getKey(), "maxValue", ((StructField)field.getValue()).dataType()), (List)new .colon.colon((Object)MODULE$.composeColumnStatStructType((String)field.getKey(), "nullCount", (DataType)LongType$.MODULE$), (List)Nil$.MODULE$))), Seq$.MODULE$.canBuildFrom());
            }
            throw new MatchError((Object)tuple2);
        })), (Object)targetIndexedColumns);
    }

    public String getMinColumnNameFor(String colName) {
        return this.org$apache$hudi$ColumnStatsIndexSupport$$formatColName(colName, "minValue");
    }

    public String getMaxColumnNameFor(String colName) {
        return this.org$apache$hudi$ColumnStatsIndexSupport$$formatColName(colName, "maxValue");
    }

    public String getNullCountColumnNameFor(String colName) {
        return this.org$apache$hudi$ColumnStatsIndexSupport$$formatColName(colName, "nullCount");
    }

    public String getValueCountColumnNameFor() {
        return "valueCount";
    }

    public String org$apache$hudi$ColumnStatsIndexSupport$$formatColName(String col, String statName) {
        return String.format("%s_%s", col, statName);
    }

    public StructField composeColumnStatStructType(String col, String statName, DataType dataType) {
        return new StructField(this.org$apache$hudi$ColumnStatsIndexSupport$$formatColName(col, statName), dataType, true, Metadata$.MODULE$.empty());
    }

    public Object tryUnpackValueWrapper(Object valueWrapper) {
        Object object = valueWrapper;
        if (object instanceof BooleanWrapper) {
            BooleanWrapper booleanWrapper = (BooleanWrapper)object;
            return BoxesRunTime.boxToBoolean((boolean)booleanWrapper.getValue());
        }
        if (object instanceof IntWrapper) {
            IntWrapper intWrapper = (IntWrapper)object;
            return BoxesRunTime.boxToInteger((int)intWrapper.getValue());
        }
        if (object instanceof LongWrapper) {
            LongWrapper longWrapper = (LongWrapper)object;
            return BoxesRunTime.boxToLong((long)longWrapper.getValue());
        }
        if (object instanceof FloatWrapper) {
            FloatWrapper floatWrapper = (FloatWrapper)object;
            return BoxesRunTime.boxToFloat((float)floatWrapper.getValue());
        }
        if (object instanceof DoubleWrapper) {
            DoubleWrapper doubleWrapper = (DoubleWrapper)object;
            return BoxesRunTime.boxToDouble((double)doubleWrapper.getValue());
        }
        if (object instanceof BytesWrapper) {
            BytesWrapper bytesWrapper = (BytesWrapper)object;
            return bytesWrapper.getValue();
        }
        if (object instanceof StringWrapper) {
            StringWrapper stringWrapper = (StringWrapper)object;
            return stringWrapper.getValue();
        }
        if (object instanceof DateWrapper) {
            DateWrapper dateWrapper = (DateWrapper)object;
            return BoxesRunTime.boxToInteger((int)dateWrapper.getValue());
        }
        if (object instanceof DecimalWrapper) {
            DecimalWrapper decimalWrapper = (DecimalWrapper)object;
            return decimalWrapper.getValue();
        }
        if (object instanceof TimeMicrosWrapper) {
            TimeMicrosWrapper timeMicrosWrapper = (TimeMicrosWrapper)object;
            return timeMicrosWrapper.getValue();
        }
        if (object instanceof TimestampMicrosWrapper) {
            TimestampMicrosWrapper timestampMicrosWrapper = (TimestampMicrosWrapper)object;
            return BoxesRunTime.boxToLong((long)timestampMicrosWrapper.getValue());
        }
        if (object instanceof GenericData.Record) {
            GenericData.Record record = (GenericData.Record)object;
            if (this.expectedAvroSchemaValues().contains((Object)record.getSchema().getName())) {
                return record.get("value");
            }
        }
        throw new UnsupportedOperationException(new StringBuilder(36).append("Not recognized value wrapper type (").append(valueWrapper.getClass().getSimpleName()).append(")").toString());
    }

    public Conversions.DecimalConversion decConv() {
        return this.decConv;
    }

    public Object deserialize(Object value, DataType dataType) {
        DataType dataType2 = dataType;
        if (TimestampType$.MODULE$.equals(dataType2)) {
            return DateTimeUtils$.MODULE$.toJavaTimestamp(BoxesRunTime.unboxToLong((Object)value));
        }
        if (DateType$.MODULE$.equals(dataType2)) {
            return DateTimeUtils$.MODULE$.toJavaDate(BoxesRunTime.unboxToInt((Object)value));
        }
        if (StringType$.MODULE$.equals(dataType2)) {
            return value;
        }
        if (BooleanType$.MODULE$.equals(dataType2)) {
            return value;
        }
        if (FloatType$.MODULE$.equals(dataType2)) {
            return value;
        }
        if (DoubleType$.MODULE$.equals(dataType2)) {
            return value;
        }
        if (LongType$.MODULE$.equals(dataType2)) {
            return value;
        }
        if (IntegerType$.MODULE$.equals(dataType2)) {
            return value;
        }
        if (ShortType$.MODULE$.equals(dataType2)) {
            return BoxesRunTime.boxToShort((short)((short)BoxesRunTime.unboxToInt((Object)value)));
        }
        if (ByteType$.MODULE$.equals(dataType2)) {
            return BoxesRunTime.boxToByte((byte)((byte)BoxesRunTime.unboxToInt((Object)value)));
        }
        if (dataType2 instanceof DecimalType) {
            Object object = value;
            if (object instanceof ByteBuffer) {
                ByteBuffer byteBuffer = (ByteBuffer)object;
                LogicalType logicalType = DecimalWrapper.SCHEMA$.getField("value").schema().getLogicalType();
                return this.decConv().fromBytes(byteBuffer, null, logicalType);
            }
            return value;
        }
        if (BinaryType$.MODULE$.equals(dataType2)) {
            Object object = value;
            if (object instanceof ByteBuffer) {
                ByteBuffer byteBuffer = (ByteBuffer)object;
                return BinaryUtil.toBytes((ByteBuffer)byteBuffer);
            }
            return object;
        }
        throw new UnsupportedOperationException(new StringBuilder(52).append("Data type for the statistic value is not recognized ").append(dataType).toString());
    }

    private ColumnStatsIndexSupport$() {
        MODULE$ = this;
        this.INDEX_NAME = "COLUMN_STATS";
        this.expectedAvroSchemaValues = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"BooleanWrapper", "IntWrapper", "LongWrapper", "FloatWrapper", "DoubleWrapper", "BytesWrapper", "StringWrapper", "DateWrapper", "DecimalWrapper", "TimeMicrosWrapper", "TimestampMicrosWrapper"}));
        this.org$apache$hudi$ColumnStatsIndexSupport$$targetColumnStatsIndexColumns = (Seq)new .colon.colon((Object)"fileName", (List)new .colon.colon((Object)"minValue", (List)new .colon.colon((Object)"maxValue", (List)new .colon.colon((Object)"nullCount", (List)new .colon.colon((Object)"valueCount", (List)new .colon.colon((Object)"columnName", (List)Nil$.MODULE$))))));
        this.org$apache$hudi$ColumnStatsIndexSupport$$columnStatsRecordStructType = AvroConversionUtils$.MODULE$.convertAvroSchemaToStructType(HoodieMetadataColumnStats.SCHEMA$);
        this.decConv = new Conversions.DecimalConversion();
    }
}

