/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi;

import java.io.Serializable;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Writable;
import org.apache.hudi.AvroConversionUtils$;
import org.apache.hudi.DataSourceReadOptions$;
import org.apache.hudi.HoodieBaseRelation;
import org.apache.hudi.HoodieTableSchema;
import org.apache.hudi.SparkAdapterSupport;
import org.apache.hudi.common.config.HoodieConfig;
import org.apache.hudi.common.config.HoodieReaderConfig;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.hadoop.fs.HadoopFSUtils;
import org.apache.hudi.internal.schema.InternalSchema;
import org.apache.hudi.internal.schema.convert.AvroInternalSchemaConverter;
import org.apache.hudi.internal.schema.utils.InternalSchemaUtils;
import org.apache.hudi.io.storage.HoodieFileReader;
import org.apache.hudi.io.storage.HoodieSparkIOFactory;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.storage.hadoop.HoodieHadoopStorage;
import org.apache.spark.SerializableWritable;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.sql.HoodieCatalystExpressionUtils$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.hudi.ProvidesHoodieConfig$;
import org.apache.spark.sql.hudi.SparkAdapter;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenSet;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class HoodieBaseRelation$
implements SparkAdapterSupport {
    public static HoodieBaseRelation$ MODULE$;
    private Set<String> org$apache$hudi$HoodieBaseRelation$$metaFieldNames;
    private SparkAdapter sparkAdapter;
    private volatile byte bitmap$0;

    static {
        new HoodieBaseRelation$();
    }

    private SparkAdapter sparkAdapter$lzycompute() {
        HoodieBaseRelation$ hoodieBaseRelation$ = this;
        synchronized (hoodieBaseRelation$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.sparkAdapter = SparkAdapterSupport.sparkAdapter$((SparkAdapterSupport)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.sparkAdapter;
    }

    public SparkAdapter sparkAdapter() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.sparkAdapter$lzycompute();
        }
        return this.sparkAdapter;
    }

    private Set<String> metaFieldNames$lzycompute() {
        HoodieBaseRelation$ hoodieBaseRelation$ = this;
        synchronized (hoodieBaseRelation$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.org$apache$hudi$HoodieBaseRelation$$metaFieldNames = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(HoodieRecord.HOODIE_META_COLUMNS).asScala()).toSet();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.org$apache$hudi$HoodieBaseRelation$$metaFieldNames;
    }

    public Set<String> org$apache$hudi$HoodieBaseRelation$$metaFieldNames() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.metaFieldNames$lzycompute();
        }
        return this.org$apache$hudi$HoodieBaseRelation$$metaFieldNames;
    }

    public Schema convertToAvroSchema(StructType structSchema, String tableName) {
        Tuple2 tuple2 = AvroConversionUtils$.MODULE$.getAvroRecordNameAndNamespace(tableName);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String recordName = (String)tuple2._1();
        String namespace = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)recordName, (Object)namespace);
        String recordName2 = (String)tuple22._1();
        String namespace2 = (String)tuple22._2();
        Schema avroSchema = this.sparkAdapter().getAvroSchemaConverters().toAvroType((DataType)structSchema, false, recordName2, namespace2);
        return AvroConversionUtils$.MODULE$.getAvroSchemaWithDefaults(avroSchema, (DataType)structSchema);
    }

    public Path getPartitionPath(FileStatus fileStatus) {
        return fileStatus.getPath().getParent();
    }

    public HoodieBaseRelation.BaseFileReader projectReader(HoodieBaseRelation.BaseFileReader reader, StructType requiredSchema) {
        ValidationUtils.checkState((((TraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])reader.schema().fields())).toSet().intersect((GenSet)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])requiredSchema.fields())).toSet())).size() == requiredSchema.size() ? 1 : 0) != 0);
        StructType structType = reader.schema();
        StructType structType2 = requiredSchema;
        if (!(structType != null ? !structType.equals(structType2) : structType2 != null)) {
            return reader;
        }
        Function1 & Serializable & scala.Serializable read = (Function1 & Serializable & scala.Serializable)x$16 -> reader.apply((PartitionedFile)x$16);
        Function1 & Serializable & scala.Serializable projectedRead = (Function1 & Serializable & scala.Serializable)file -> {
            UnsafeProjection unsafeProjection = HoodieCatalystExpressionUtils$.MODULE$.generateUnsafeProjection(reader.schema(), requiredSchema);
            return ((Iterator)read.apply(file)).map((Function1)unsafeProjection);
        };
        return new HoodieBaseRelation.BaseFileReader((Function1<PartitionedFile, Iterator<InternalRow>>)projectedRead, requiredSchema);
    }

    public Tuple3<Schema, StructType, InternalSchema> projectSchema(Either<Schema, InternalSchema> tableSchema, String[] requiredColumns) {
        Either<Schema, InternalSchema> either = tableSchema;
        if (either instanceof Right) {
            Right right = (Right)either;
            InternalSchema internalSchema = (InternalSchema)right.value();
            ValidationUtils.checkState((!internalSchema.isEmptySchema() ? 1 : 0) != 0);
            InternalSchema prunedInternalSchema = InternalSchemaUtils.pruneInternalSchema((InternalSchema)internalSchema, (java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])requiredColumns)).toList()).asJava()));
            Schema requiredAvroSchema = AvroInternalSchemaConverter.convert((InternalSchema)prunedInternalSchema, (String)"schema");
            StructType requiredStructSchema = AvroConversionUtils$.MODULE$.convertAvroSchemaToStructType(requiredAvroSchema);
            return new Tuple3((Object)requiredAvroSchema, (Object)requiredStructSchema, (Object)prunedInternalSchema);
        }
        if (either instanceof Left) {
            Left left = (Left)either;
            Schema avroSchema = (Schema)left.value();
            Map fieldMap = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(avroSchema.getFields()).asScala()).map((Function1 & Serializable & scala.Serializable)f -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)f.name()), f), Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            List requiredFields = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])requiredColumns)).map((Function1 & Serializable & scala.Serializable)col -> {
                Schema.Field f = (Schema.Field)fieldMap.apply(col);
                return new Schema.Field(f.name(), f.schema(), f.doc(), f.defaultVal(), f.order());
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Schema.Field.class))))).toList();
            Schema requiredAvroSchema = Schema.createRecord((String)avroSchema.getName(), (String)avroSchema.getDoc(), (String)avroSchema.getNamespace(), (boolean)avroSchema.isError(), (java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)requiredFields).asJava()));
            StructType requiredStructSchema = AvroConversionUtils$.MODULE$.convertAvroSchemaToStructType(requiredAvroSchema);
            return new Tuple3((Object)requiredAvroSchema, (Object)requiredStructSchema, (Object)InternalSchema.getEmptyInternalSchema());
        }
        throw new MatchError(either);
    }

    public Function1<PartitionedFile, Iterator<InternalRow>> org$apache$hudi$HoodieBaseRelation$$createHFileReader(SparkSession spark, HoodieTableSchema dataSchema, HoodieTableSchema requiredDataSchema, Seq<Filter> filters, Map<String, String> options, Configuration hadoopConf) {
        Broadcast hadoopConfBroadcast = spark.sparkContext().broadcast((Object)new SerializableWritable((Writable)hadoopConf), ClassTag$.MODULE$.apply(SerializableWritable.class));
        return (Function1 & Serializable & scala.Serializable)partitionedFile -> {
            Configuration hadoopConf = (Configuration)((SerializableWritable)hadoopConfBroadcast.value()).value();
            StoragePath filePath = MODULE$.sparkAdapter().getSparkPartitionedFileUtils().getPathFromPartitionedFile(partitionedFile);
            HoodieConfig hoodieConfig = new HoodieConfig();
            hoodieConfig.setValue(HoodieReaderConfig.USE_NATIVE_HFILE_READER, (String)options.getOrElse((Object)HoodieReaderConfig.USE_NATIVE_HFILE_READER.key(), (Function0 & Serializable & scala.Serializable)() -> ((Boolean)HoodieReaderConfig.USE_NATIVE_HFILE_READER.defaultValue()).toString()));
            HoodieFileReader reader = new HoodieSparkIOFactory((HoodieStorage)new HoodieHadoopStorage(filePath, HadoopFSUtils.getStorageConf((Configuration)hadoopConf))).getReaderFactory(HoodieRecord.HoodieRecordType.AVRO).getFileReader(hoodieConfig, filePath, HoodieFileFormat.HFILE);
            StructType requiredRowSchema = requiredDataSchema.structTypeSchema();
            Schema requiredAvroSchema = new Schema.Parser().parse(requiredDataSchema.avroSchemaStr());
            Function1 avroToRowConverter = AvroConversionUtils$.MODULE$.createAvroToInternalRowConverter(requiredAvroSchema, requiredRowSchema);
            return ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter((java.util.Iterator)reader.getRecordIterator(requiredAvroSchema)).asScala()).map((Function1 & Serializable & scala.Serializable)record -> (InternalRow)((Option)avroToRowConverter.apply((Object)((GenericRecord)record.getData()))).get());
        };
    }

    public boolean isSchemaEvolutionEnabledOnRead(Map<String, String> optParams, SparkSession sparkSession) {
        return new StringOps(Predef$.MODULE$.augmentString((String)optParams.getOrElse((Object)DataSourceReadOptions$.MODULE$.SCHEMA_EVOLUTION_ENABLED().key(), (Function0 & Serializable & scala.Serializable)() -> ((Boolean)DataSourceReadOptions$.MODULE$.SCHEMA_EVOLUTION_ENABLED().defaultValue()).toString()))).toBoolean() || ProvidesHoodieConfig$.MODULE$.isSchemaEvolutionEnabled(sparkSession);
    }

    private HoodieBaseRelation$() {
        MODULE$ = this;
        SparkAdapterSupport.$init$((SparkAdapterSupport)this);
    }
}

