/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi;

import java.io.Closeable;
import java.io.Serializable;
import java.util.Properties;
import org.apache.avro.Schema;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.HoodieConversionUtils$;
import org.apache.hudi.HoodieMergeOnReadFileSplit;
import org.apache.hudi.HoodieTableState;
import org.apache.hudi.SparkAdapterSupport;
import org.apache.hudi.common.config.HoodieCommonConfig;
import org.apache.hudi.common.config.HoodieMemoryConfig;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.engine.EngineType;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.engine.HoodieLocalEngineContext;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.table.log.HoodieMergedLogRecordScanner;
import org.apache.hudi.common.util.FileIOUtils;
import org.apache.hudi.common.util.HoodieRecordUtils;
import org.apache.hudi.common.util.collection.ExternalSpillableMap;
import org.apache.hudi.hadoop.fs.HadoopFSUtils;
import org.apache.hudi.internal.schema.InternalSchema;
import org.apache.hudi.metadata.HoodieBackedTableMetadata;
import org.apache.hudi.metadata.HoodieMetadataLogRecordReader;
import org.apache.hudi.metadata.HoodieTableMetadata;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.HoodieStorageUtils;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.storage.StoragePath;
import org.apache.spark.sql.hudi.SparkAdapter;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.Map;
import scala.collection.mutable.MapLike;
import scala.runtime.BoxedUnit;

public final class LogFileIterator$
implements SparkAdapterSupport {
    public static LogFileIterator$ MODULE$;
    private SparkAdapter sparkAdapter;
    private volatile boolean bitmap$0;

    static {
        new LogFileIterator$();
    }

    private SparkAdapter sparkAdapter$lzycompute() {
        LogFileIterator$ logFileIterator$ = this;
        synchronized (logFileIterator$) {
            if (!this.bitmap$0) {
                this.sparkAdapter = SparkAdapterSupport.sparkAdapter$((SparkAdapterSupport)this);
                this.bitmap$0 = true;
            }
        }
        return this.sparkAdapter;
    }

    public SparkAdapter sparkAdapter() {
        if (!this.bitmap$0) {
            return this.sparkAdapter$lzycompute();
        }
        return this.sparkAdapter;
    }

    public Map<String, HoodieRecord<?>> scanLog(List<HoodieLogFile> logFiles, StoragePath partitionPath, Schema logSchema, HoodieTableState tableState, long maxCompactionMemoryInBytes, Configuration hadoopConf, InternalSchema internalSchema) {
        String tablePath = tableState.tablePath();
        HoodieStorage storage = HoodieStorageUtils.getStorage((String)tablePath, (StorageConfiguration)HadoopFSUtils.getStorageConf((Configuration)hadoopConf));
        if (HoodieTableMetadata.isMetadataTable((String)tablePath)) {
            HoodieMetadataConfig metadataConfig = HoodieMetadataConfig.newBuilder().fromProperties((Properties)tableState.metadataConfig().getProps()).withSpillableMapDir(hadoopConf.get(HoodieMemoryConfig.SPILLABLE_MAP_BASE_PATH.key(), FileIOUtils.getDefaultSpillableMapBasePath())).enable(true).build();
            String dataTableBasePath = HoodieTableMetadata.getDataTableBasePathFromMetadataTable((String)tablePath);
            HoodieBackedTableMetadata metadataTable = new HoodieBackedTableMetadata((HoodieEngineContext)new HoodieLocalEngineContext(HadoopFSUtils.getStorageConf((Configuration)hadoopConf)), storage, metadataConfig, dataTableBasePath);
            boolean forceFullScan = true;
            String relativePartitionPath = FSUtils.getRelativePartitionPath((StoragePath)new StoragePath(tablePath), (StoragePath)partitionPath);
            HoodieMetadataLogRecordReader logRecordReader = (HoodieMetadataLogRecordReader)metadataTable.getLogRecordScanner((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(logFiles).asJava(), relativePartitionPath, HoodieConversionUtils$.MODULE$.toJavaOption((Option)new Some((Object)Predef$.MODULE$.boolean2Boolean(forceFullScan))), HoodieConversionUtils$.MODULE$.toJavaOption((Option)new Some(tableState.latestCommitTimestamp().get()))).getLeft();
            java.util.List recordList = (java.util.List)this.closing((Closeable)logRecordReader, (Function0 & Serializable & scala.Serializable)() -> logRecordReader.getRecords());
            return (Map)HashMap$.MODULE$.apply(((SeqLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(recordList).asScala()).map((Function1 & Serializable & scala.Serializable)r -> new Tuple2((Object)r.getRecordKey(), r), Buffer$.MODULE$.canBuildFrom())).toSeq());
        }
        HoodieMergedLogRecordScanner.Builder logRecordScannerBuilder = HoodieMergedLogRecordScanner.newBuilder().withStorage(storage).withBasePath(tablePath).withLogFilePaths((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)logFiles.map((Function1 & Serializable & scala.Serializable)logFile -> logFile.getPath().toString(), List$.MODULE$.canBuildFrom())).asJava()).withReaderSchema(logSchema).withLatestInstantTime((String)tableState.latestCommitTimestamp().get()).withReverseReader(false).withInternalSchema(internalSchema).withBufferSize(hadoopConf.getInt(HoodieMemoryConfig.MAX_DFS_STREAM_BUFFER_SIZE.key(), 0x100000)).withMaxMemorySizeInBytes(Predef$.MODULE$.long2Long(maxCompactionMemoryInBytes)).withSpillableMapBasePath(hadoopConf.get(HoodieMemoryConfig.SPILLABLE_MAP_BASE_PATH.key(), FileIOUtils.getDefaultSpillableMapBasePath())).withDiskMapType((ExternalSpillableMap.DiskMapType)hadoopConf.getEnum(HoodieCommonConfig.SPILLABLE_DISK_MAP_TYPE.key(), (Enum)HoodieCommonConfig.SPILLABLE_DISK_MAP_TYPE.defaultValue())).withBitCaskDiskMapCompressionEnabled(hadoopConf.getBoolean(HoodieCommonConfig.DISK_MAP_BITCASK_COMPRESSION_ENABLED.key(), Predef$.MODULE$.Boolean2boolean((Boolean)HoodieCommonConfig.DISK_MAP_BITCASK_COMPRESSION_ENABLED.defaultValue())));
        Object object = logFiles.nonEmpty() ? logRecordScannerBuilder.withPartition(FSUtils.getRelativePartitionPath((StoragePath)new StoragePath(tableState.tablePath()), (StoragePath)((HoodieLogFile)logFiles.head()).getPath().getParent())) : BoxedUnit.UNIT;
        logRecordScannerBuilder.withRecordMerger(HoodieRecordUtils.createRecordMerger((String)tableState.tablePath(), (EngineType)EngineType.SPARK, (java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(tableState.recordMergeImplClasses()).asJava()), (String)tableState.recordMergeStrategyId()));
        HoodieMergedLogRecordScanner scanner = logRecordScannerBuilder.build();
        return (Map)this.closing((Closeable)scanner, (Function0 & Serializable & scala.Serializable)() -> (HashMap)HashMap$.MODULE$.apply(((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(scanner.getRecords()).asScala()).toSeq()));
    }

    public InternalSchema scanLog$default$7() {
        return InternalSchema.getEmptyInternalSchema();
    }

    public <T> T closing(Closeable c, Function0<T> f) {
        Object object;
        try {
            object = f.apply();
        }
        finally {
            c.close();
        }
        return (T)object;
    }

    public StoragePath getPartitionPath(HoodieMergeOnReadFileSplit split) {
        return ((StoragePath)split.dataFile().map((Function1 & Serializable & scala.Serializable)baseFile -> MODULE$.sparkAdapter().getSparkPartitionedFileUtils().getPathFromPartitionedFile(baseFile)).getOrElse((Function0 & Serializable & scala.Serializable)() -> ((HoodieLogFile)split.logFiles().head()).getPath())).getParent();
    }

    private LogFileIterator$() {
        MODULE$ = this;
        SparkAdapterSupport.$init$((SparkAdapterSupport)this);
    }
}

