/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi;

import java.io.Serializable;
import java.util.Properties;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.AvroProjection;
import org.apache.hudi.AvroProjection$;
import org.apache.hudi.HoodieBaseRelation;
import org.apache.hudi.HoodieConversionUtils$;
import org.apache.hudi.HoodieMergeOnReadFileSplit;
import org.apache.hudi.HoodieTableSchema;
import org.apache.hudi.HoodieTableState;
import org.apache.hudi.LogFileIterator;
import org.apache.hudi.LogFileIterator$;
import org.apache.hudi.common.engine.EngineType;
import org.apache.hudi.common.model.HoodieAvroIndexedRecord;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordCompatibilityInterface;
import org.apache.hudi.common.model.HoodieRecordMerger;
import org.apache.hudi.common.model.HoodieSparkRecord;
import org.apache.hudi.common.util.HoodieRecordUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.storage.StoragePath;
import org.apache.spark.sql.HoodieCatalystExpressionUtils$;
import org.apache.spark.sql.HoodieInternalRowUtils$;
import org.apache.spark.sql.avro.HoodieAvroSchemaConverters;
import org.apache.spark.sql.avro.HoodieAvroSerializer;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import scala.Function1;
import scala.None$;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.immutable.List;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005]h\u0001B\u000f\u001f\u0001\u0015B\u0001B\u000b\u0001\u0003\u0002\u0003\u0006Ia\u000b\u0005\t\u0003\u0002\u0011\t\u0011)A\u0005\u0005\"A\u0001\n\u0001B\u0001B\u0003%\u0011\n\u0003\u0005W\u0001\t\u0005\t\u0015!\u0003X\u0011!i\u0006A!A!\u0002\u0013q\u0006\u0002C1\u0001\u0005\u0003\u0005\u000b\u0011B,\t\u0011\t\u0004!\u0011!Q\u0001\n\rD\u0001\"\u001b\u0001\u0003\u0002\u0003\u0006IA\u001b\u0005\t[\u0002\u0011\t\u0011)A\u0005]\")a\u000f\u0001C\u0001o\"1a\u000f\u0001C\u0001\u0003\u000bAaA\u001e\u0001\u0005\u0002\u0005e\u0001\"CA&\u0001\t\u0007I\u0011BA'\u0011\u001d\ty\u0005\u0001Q\u0001\n\rD\u0011\"!\u0015\u0001\u0005\u0004%I!a\u0015\t\u0011\u0005}\u0003\u0001)A\u0005\u0003+B\u0011\"!\u0019\u0001\u0005\u0004%I!a\u0019\t\u0011\u00055\u0004\u0001)A\u0005\u0003KB\u0011\"a\u001c\u0001\u0005\u0004%I!!\u001d\t\u0011\u0005}\u0004\u0001)A\u0005\u0003gB\u0011\"!!\u0001\u0005\u0004%I!a!\t\u0011\u0005-\u0005\u0001)A\u0005\u0003\u000bC\u0011\"!$\u0001\u0005\u0004%I!a$\t\u0011\u0005]\u0005\u0001)A\u0005\u0003#Cq!!'\u0001\t\u0003\nY\nC\u0004\u0002$\u0002!I!a'\t\u000f\u0005M\u0006\u0001\"\u0003\u00026\"9\u0011q\u0019\u0001\u0005\n\u0005%'!\u0007*fG>\u0014H-T3sO&twMR5mK&#XM]1u_JT!a\b\u0011\u0002\t!,H-\u001b\u0006\u0003C\t\na!\u00199bG\",'\"A\u0012\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u00011\u0003CA\u0014)\u001b\u0005q\u0012BA\u0015\u001f\u0005=aun\u001a$jY\u0016LE/\u001a:bi>\u0014\u0018\u0001\u00037pO\u001aKG.Z:\u0011\u000712\u0014H\u0004\u0002.g9\u0011a&M\u0007\u0002_)\u0011\u0001\u0007J\u0001\u0007yI|w\u000e\u001e \n\u0003I\nQa]2bY\u0006L!\u0001N\u001b\u0002\u000fA\f7m[1hK*\t!'\u0003\u00028q\t!A*[:u\u0015\t!T\u0007\u0005\u0002;\u007f5\t1H\u0003\u0002={\u0005)Qn\u001c3fY*\u0011aHH\u0001\u0007G>lWn\u001c8\n\u0005\u0001[$!\u0004%p_\u0012LW\rT8h\r&dW-A\u0007qCJ$\u0018\u000e^5p]B\u000bG\u000f\u001b\t\u0003\u0007\u001ak\u0011\u0001\u0012\u0006\u0003\u000bz\tqa\u001d;pe\u0006<W-\u0003\u0002H\t\nY1\u000b^8sC\u001e,\u0007+\u0019;i\u0003A\u0011\u0017m]3GS2,\u0017\n^3sCR|'\u000fE\u0002-\u00152K!a\u0013\u001d\u0003\u0011%#XM]1u_J\u0004\"!\u0014+\u000e\u00039S!a\u0014)\u0002\u0011\r\fG/\u00197zgRT!!\u0015*\u0002\u0007M\fHN\u0003\u0002TA\u0005)1\u000f]1sW&\u0011QK\u0014\u0002\f\u0013:$XM\u001d8bYJ{w/\u0001\u0007sK\u0006$WM]*dQ\u0016l\u0017\r\u0005\u0002Y76\t\u0011L\u0003\u0002[!\u0006)A/\u001f9fg&\u0011A,\u0017\u0002\u000b'R\u0014Xo\u0019;UsB,\u0017A\u00033bi\u0006\u001c6\r[3nCB\u0011qeX\u0005\u0003Az\u0011\u0011\u0003S8pI&,G+\u00192mKN\u001b\u0007.Z7b\u0003a\u0011X-];je\u0016$7\u000b\u001e:vGR$\u0016\u0010]3TG\",W.Y\u0001\u0013e\u0016\fX/\u001b:fI\u00063(o\\*dQ\u0016l\u0017\r\u0005\u0002eO6\tQM\u0003\u0002gA\u0005!\u0011M\u001e:p\u0013\tAWM\u0001\u0004TG\",W.Y\u0001\u000bi\u0006\u0014G.Z*uCR,\u0007CA\u0014l\u0013\tagD\u0001\tI_>$\u0017.\u001a+bE2,7\u000b^1uK\u000611m\u001c8gS\u001e\u0004\"a\u001c;\u000e\u0003AT!!\u001d:\u0002\t\r|gN\u001a\u0006\u0003g\u0002\na\u0001[1e_>\u0004\u0018BA;q\u00055\u0019uN\u001c4jOV\u0014\u0018\r^5p]\u00061A(\u001b8jiz\"B\u0002_={wrlhp`A\u0001\u0003\u0007\u0001\"a\n\u0001\t\u000b)R\u0001\u0019A\u0016\t\u000b\u0005S\u0001\u0019\u0001\"\t\u000b!S\u0001\u0019A%\t\u000bYS\u0001\u0019A,\t\u000buS\u0001\u0019\u00010\t\u000b\u0005T\u0001\u0019A,\t\u000b\tT\u0001\u0019A2\t\u000b%T\u0001\u0019\u00016\t\u000b5T\u0001\u0019\u00018\u0015#a\f9!!\u0003\u0002\f\u00055\u0011qBA\t\u0003+\t9\u0002C\u0003+\u0017\u0001\u00071\u0006C\u0003B\u0017\u0001\u0007!\tC\u0003I\u0017\u0001\u0007\u0011\nC\u0003W\u0017\u0001\u0007q\u000bC\u0003^\u0017\u0001\u0007a\f\u0003\u0004\u0002\u0014-\u0001\rAX\u0001\u000fe\u0016\fX/\u001b:fIN\u001b\u0007.Z7b\u0011\u0015I7\u00021\u0001k\u0011\u0015i7\u00021\u0001o)5A\u00181DA\u0013\u0003\u0007\n)%a\u0012\u0002J!9\u0011Q\u0004\u0007A\u0002\u0005}\u0011!B:qY&$\bcA\u0014\u0002\"%\u0019\u00111\u0005\u0010\u00035!{w\u000eZ5f\u001b\u0016\u0014x-Z(o%\u0016\fGMR5mKN\u0003H.\u001b;\t\u000f\u0005\u001dB\u00021\u0001\u0002*\u0005q!-Y:f\r&dWMU3bI\u0016\u0014\b\u0003BA\u0016\u0003{qA!!\f\u0002:9!\u0011qFA\u001c\u001d\u0011\t\t$!\u000e\u000f\u00079\n\u0019$C\u0001$\u0013\t\t#%\u0003\u0002 A%\u0019\u00111\b\u0010\u0002%!{w\u000eZ5f\u0005\u0006\u001cXMU3mCRLwN\\\u0005\u0005\u0003\u007f\t\tE\u0001\bCCN,g)\u001b7f%\u0016\fG-\u001a:\u000b\u0007\u0005mb\u0004C\u0003^\u0019\u0001\u0007a\f\u0003\u0004\u0002\u00141\u0001\rA\u0018\u0005\u0006S2\u0001\rA\u001b\u0005\u0006[2\u0001\rA\\\u0001\u0019E\u0006\u001cXMR5mKJ+\u0017\rZ3s\u0003Z\u0014xnU2iK6\fW#A2\u00023\t\f7/\u001a$jY\u0016\u0014V-\u00193fe\u00063(o\\*dQ\u0016l\u0017\rI\u0001\u000bg\u0016\u0014\u0018.\u00197ju\u0016\u0014XCAA+!\u0011\t9&a\u0017\u000e\u0005\u0005e#B\u00014Q\u0013\u0011\ti&!\u0017\u0003)!{w\u000eZ5f\u0003Z\u0014xnU3sS\u0006d\u0017N_3s\u0003-\u0019XM]5bY&TXM\u001d\u0011\u0002!I,7m\u001c:e\u0017\u0016LxJ\u001d3j]\u0006dWCAA3!\u0011\t9'!\u001b\u000e\u0003UJ1!a\u001b6\u0005\rIe\u000e^\u0001\u0012e\u0016\u001cwN\u001d3LKf|%\u000fZ5oC2\u0004\u0013\u0001\u0007:fcVL'/\u001a3TG\",W.\u0019)s_*,7\r^5p]V\u0011\u00111\u000f\t\u0005\u0003k\nY(\u0004\u0002\u0002x)\u0019\u0011\u0011\u0010(\u0002\u0017\u0015D\bO]3tg&|gn]\u0005\u0005\u0003{\n9H\u0001\tV]N\fg-\u001a)s_*,7\r^5p]\u0006I\"/Z9vSJ,GmU2iK6\f\u0007K]8kK\u000e$\u0018n\u001c8!\u0003q\u0011X-];je\u0016$7k\u00195f[\u0006\feO]8Qe>TWm\u0019;j_:,\"!!\"\u0011\u0007\u001d\n9)C\u0002\u0002\nz\u0011a\"\u0011<s_B\u0013xN[3di&|g.A\u000fsKF,\u0018N]3e'\u000eDW-\\1BmJ|\u0007K]8kK\u000e$\u0018n\u001c8!\u00031\u0011XmY8sI6+'oZ3s+\t\t\t\nE\u0002;\u0003'K1!!&<\u0005IAun\u001c3jKJ+7m\u001c:e\u001b\u0016\u0014x-\u001a:\u0002\u001bI,7m\u001c:e\u001b\u0016\u0014x-\u001a:!\u0003%!w\u000eS1t\u001d\u0016DH/\u0006\u0002\u0002\u001eB!\u0011qMAP\u0013\r\t\t+\u000e\u0002\b\u0005>|G.Z1o\u0003=A\u0017m\u001d(fqRLe\u000e^3s]\u0006d\u0007f\u0001\u000e\u0002(B!\u0011\u0011VAX\u001b\t\tYKC\u0002\u0002.V\n!\"\u00198o_R\fG/[8o\u0013\u0011\t\t,a+\u0003\u000fQ\f\u0017\u000e\u001c:fG\u0006I1/\u001a:jC2L'0\u001a\u000b\u0005\u0003o\u000b\u0019\r\u0005\u0003\u0002:\u0006}VBAA^\u0015\r\ti,Z\u0001\bO\u0016tWM]5d\u0013\u0011\t\t-a/\u0003\u001b\u001d+g.\u001a:jGJ+7m\u001c:e\u0011\u0019\t)m\u0007a\u0001\u0019\u0006a1-\u001e:S_^\u0014VmY8sI\u0006)Q.\u001a:hKR1\u00111ZAi\u0003+\u0004R!a\u001a\u0002N2K1!a46\u0005\u0019y\u0005\u000f^5p]\"1\u00111\u001b\u000fA\u00021\u000baaY;s%><\bbBAl9\u0001\u0007\u0011\u0011\\\u0001\n]\u0016<(+Z2pe\u0012\u0004D!a7\u0002fB)!(!8\u0002b&\u0019\u0011q\\\u001e\u0003\u0019!{w\u000eZ5f%\u0016\u001cwN\u001d3\u0011\t\u0005\r\u0018Q\u001d\u0007\u0001\t1\t9/!6\u0002\u0002\u0003\u0005)\u0011AAu\u0005\ryF\u0005N\t\u0005\u0003W\f\t\u0010\u0005\u0003\u0002h\u00055\u0018bAAxk\t9aj\u001c;iS:<\u0007\u0003BA4\u0003gL1!!>6\u0005\r\te.\u001f")
public class RecordMergingFileIterator
extends LogFileIterator {
    private final Iterator<InternalRow> baseFileIterator;
    private final StructType readerSchema;
    private final Schema baseFileReaderAvroSchema;
    private final HoodieAvroSerializer serializer;
    private final int recordKeyOrdinal;
    private final UnsafeProjection requiredSchemaProjection;
    private final AvroProjection requiredSchemaAvroProjection;
    private final HoodieRecordMerger recordMerger;

    private Schema baseFileReaderAvroSchema() {
        return this.baseFileReaderAvroSchema;
    }

    private HoodieAvroSerializer serializer() {
        return this.serializer;
    }

    private int recordKeyOrdinal() {
        return this.recordKeyOrdinal;
    }

    private UnsafeProjection requiredSchemaProjection() {
        return this.requiredSchemaProjection;
    }

    private AvroProjection requiredSchemaAvroProjection() {
        return this.requiredSchemaAvroProjection;
    }

    private HoodieRecordMerger recordMerger() {
        return this.recordMerger;
    }

    @Override
    public boolean doHasNext() {
        return this.hasNextInternal();
    }

    private boolean hasNextInternal() {
        while (this.baseFileIterator.hasNext()) {
            InternalRow curRow = (InternalRow)this.baseFileIterator.next();
            String curKey = curRow.getString(this.recordKeyOrdinal());
            scala.Option<HoodieRecord<?>> updatedRecordOpt = this.removeLogRecord(curKey);
            if (updatedRecordOpt.isEmpty()) {
                this.nextRecord_$eq(this.requiredSchemaProjection().apply(curRow));
                return true;
            }
            scala.Option<InternalRow> mergedRecordOpt = this.merge(curRow, (HoodieRecord)updatedRecordOpt.get());
            if (mergedRecordOpt.isEmpty()) continue;
            this.nextRecord_$eq(mergedRecordOpt.get());
            return true;
        }
        return super.doHasNext();
    }

    private GenericRecord serialize(InternalRow curRowRecord) {
        return (GenericRecord)this.serializer().serialize((Object)curRowRecord);
    }

    private scala.Option<InternalRow> merge(InternalRow curRow, HoodieRecord<?> newRecord) {
        HoodieRecord.HoodieRecordType hoodieRecordType = this.recordMerger().getRecordType();
        if (HoodieRecord.HoodieRecordType.SPARK.equals(hoodieRecordType)) {
            HoodieSparkRecord curRecord = new HoodieSparkRecord(curRow, this.readerSchema);
            Option result = this.recordMerger().merge((HoodieRecord)curRecord, this.baseFileReaderAvroSchema(), newRecord, this.logFileReaderAvroSchema(), this.payloadProps());
            return HoodieConversionUtils$.MODULE$.toScalaOption(result).flatMap((Function1 & Serializable & scala.Serializable)r -> {
                InternalRow data = (InternalRow)((HoodieRecord)r.getLeft()).getData();
                if (this.isDeleteOperation(data)) {
                    return None$.MODULE$;
                }
                StructType schema = HoodieInternalRowUtils$.MODULE$.getCachedSchema((Schema)r.getRight());
                UnsafeProjection projection = HoodieInternalRowUtils$.MODULE$.getCachedUnsafeProjection(schema, this.structTypeSchema());
                return new Some((Object)projection.apply(data));
            });
        }
        HoodieAvroIndexedRecord curRecord = new HoodieAvroIndexedRecord((IndexedRecord)this.serialize(curRow));
        Option result = this.recordMerger().merge((HoodieRecord)curRecord, this.baseFileReaderAvroSchema(), newRecord, this.logFileReaderAvroSchema(), this.payloadProps());
        return HoodieConversionUtils$.MODULE$.toScalaOption(result).flatMap((Function1 & Serializable & scala.Serializable)r -> {
            GenericRecord avroRecord = (GenericRecord)((HoodieRecord)((HoodieRecordCompatibilityInterface)r.getLeft()).toIndexedRecord((Schema)r.getRight(), (Properties)this.payloadProps()).get()).getData();
            if (this.isDeleteOperation(avroRecord)) {
                return None$.MODULE$;
            }
            return new Some((Object)this.deserialize((GenericRecord)this.requiredSchemaAvroProjection().apply(avroRecord)));
        });
    }

    public RecordMergingFileIterator(List<HoodieLogFile> logFiles, StoragePath partitionPath, Iterator<InternalRow> baseFileIterator, StructType readerSchema, HoodieTableSchema dataSchema, StructType requiredStructTypeSchema, Schema requiredAvroSchema, HoodieTableState tableState, Configuration config) {
        this.baseFileIterator = baseFileIterator;
        this.readerSchema = readerSchema;
        super(logFiles, partitionPath, dataSchema, requiredStructTypeSchema, requiredAvroSchema, tableState, config);
        HoodieAvroSchemaConverters qual$1 = this.sparkAdapter().getAvroSchemaConverters();
        StructType x$1 = readerSchema;
        boolean x$2 = false;
        String x$3 = "record";
        String x$4 = qual$1.toAvroType$default$4();
        this.baseFileReaderAvroSchema = qual$1.toAvroType((DataType)x$1, x$2, x$3, x$4);
        this.serializer = this.sparkAdapter().createAvroSerializer((DataType)readerSchema, this.baseFileReaderAvroSchema(), false);
        this.recordKeyOrdinal = readerSchema.fieldIndex(tableState.recordKeyField());
        this.requiredSchemaProjection = HoodieCatalystExpressionUtils$.MODULE$.generateUnsafeProjection(readerSchema, this.structTypeSchema());
        this.requiredSchemaAvroProjection = AvroProjection$.MODULE$.create(this.avroSchema());
        this.recordMerger = HoodieRecordUtils.createRecordMerger((String)tableState.tablePath(), (EngineType)EngineType.SPARK, (java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(tableState.recordMergeImplClasses()).asJava()), (String)tableState.recordMergeStrategyId());
    }

    public RecordMergingFileIterator(List<HoodieLogFile> logFiles, StoragePath partitionPath, Iterator<InternalRow> baseFileIterator, StructType readerSchema, HoodieTableSchema dataSchema, HoodieTableSchema requiredSchema, HoodieTableState tableState, Configuration config) {
        this(logFiles, partitionPath, baseFileIterator, readerSchema, dataSchema, requiredSchema.structTypeSchema(), new Schema.Parser().parse(requiredSchema.avroSchemaStr()), tableState, config);
    }

    public RecordMergingFileIterator(HoodieMergeOnReadFileSplit split, HoodieBaseRelation.BaseFileReader baseFileReader, HoodieTableSchema dataSchema, HoodieTableSchema requiredSchema, HoodieTableState tableState, Configuration config) {
        this(split.logFiles(), LogFileIterator$.MODULE$.getPartitionPath(split), baseFileReader.apply((PartitionedFile)split.dataFile().get()), baseFileReader.schema(), dataSchema, requiredSchema, tableState, config);
    }
}

