/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.commit;

import org.apache.hudi.HoodieDatasetBulkInsertHelper;
import org.apache.hudi.client.SparkRDDWriteClient;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.commit.BaseDatasetBulkInsertCommitActionExecutor;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.table.HoodieTable;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;

public class HoodieStreamerDatasetBulkInsertCommitActionExecutor
extends BaseDatasetBulkInsertCommitActionExecutor {
    public HoodieStreamerDatasetBulkInsertCommitActionExecutor(HoodieWriteConfig config, SparkRDDWriteClient writeClient, String instantTime) {
        super(config, writeClient, instantTime);
    }

    @Override
    protected void preExecute() {
        this.table.validateInsertSchema();
        this.writeClient.preWrite(this.instantTime, this.getWriteOperationType(), this.table.getMetaClient());
    }

    @Override
    protected Option<HoodieData<WriteStatus>> doExecute(Dataset<Row> records, boolean arePartitionRecordsSorted) {
        this.table.getActiveTimeline().transitionRequestedToInflight(this.table.getMetaClient().createNewInstant(HoodieInstant.State.REQUESTED, this.getCommitActionType(), this.instantTime), Option.empty());
        return Option.of((Object)HoodieDatasetBulkInsertHelper.bulkInsert(records, (String)this.instantTime, (HoodieTable)this.table, (HoodieWriteConfig)this.writeConfig, (boolean)arePartitionRecordsSorted, (boolean)false));
    }

    @Override
    public WriteOperationType getWriteOperationType() {
        return WriteOperationType.BULK_INSERT;
    }
}

