/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.execution.datasources;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hudi.SparkAdapterSupport;
import org.apache.hudi.storage.StoragePath;
import org.apache.spark.HoodieHadoopFSUtils$;
import org.apache.spark.execution.datasources.HoodieInMemoryFileIndex$;
import org.apache.spark.execution.datasources.PathFilterWrapper;
import org.apache.spark.metrics.source.HiveCatalogMetrics$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.expressions.And$;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.BoundReference;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.InterpretedPredicate;
import org.apache.spark.sql.execution.datasources.FileStatusCache;
import org.apache.spark.sql.execution.datasources.InMemoryFileIndex;
import org.apache.spark.sql.execution.datasources.InMemoryFileIndex$;
import org.apache.spark.sql.execution.datasources.PartitionDirectory;
import org.apache.spark.sql.execution.datasources.PartitionPath;
import org.apache.spark.sql.execution.datasources.PartitionSpec;
import org.apache.spark.sql.hudi.SparkAdapter;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.AbstractIterable;
import scala.collection.GenSet;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.LinkedHashSet;
import scala.collection.mutable.LinkedHashSet$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;

@ScalaSignature(bytes="\u0006\u0001\u0005Uf\u0001B\t\u0013\u0001uA\u0001\u0002\f\u0001\u0003\u0002\u0003\u0006I!\f\u0005\tc\u0001\u0011\t\u0011)A\u0005e!A\u0001\n\u0001B\u0001B\u0003%\u0011\n\u0003\u0005U\u0001\t\u0005\t\u0015!\u0003V\u0011!y\u0006A!A!\u0002\u0013\u0001\u0007\"B2\u0001\t\u0003!\u0007\"\u00027\u0001\t\u0003j\u0007BB@\u0001\t\u0013\t\t\u0001C\u0004\u0002\u000e\u0001!I!a\u0004\t\u000f\u0005\u001d\u0002\u0001\"\u0011\u0002*!9\u0011Q\t\u0001\u0005\u0012\u0005\u001dsaBA<%!\u0005\u0011\u0011\u0010\u0004\u0007#IA\t!a\u001f\t\r\rlA\u0011AAB\u0011\u001d\t))\u0004C\u0001\u0003\u000fC\u0011\"!(\u000e#\u0003%\t!a(\u0003/!{w\u000eZ5f\u0013:lU-\\8ss\u001aKG.Z%oI\u0016D(BA\n\u0015\u0003-!\u0017\r^1t_V\u00148-Z:\u000b\u0005U1\u0012!C3yK\u000e,H/[8o\u0015\t9\u0002$A\u0003ta\u0006\u00148N\u0003\u0002\u001a5\u00051\u0011\r]1dQ\u0016T\u0011aG\u0001\u0004_J<7\u0001A\n\u0004\u0001y1\u0003CA\u0010%\u001b\u0005\u0001#BA\n\"\u0015\t)\"E\u0003\u0002$-\u0005\u00191/\u001d7\n\u0005\u0015\u0002#!E%o\u001b\u0016lwN]=GS2,\u0017J\u001c3fqB\u0011qEK\u0007\u0002Q)\u0011\u0011\u0006G\u0001\u0005QV$\u0017.\u0003\u0002,Q\t\u00192\u000b]1sW\u0006#\u0017\r\u001d;feN+\b\u000f]8si\u0006a1\u000f]1sWN+7o]5p]B\u0011afL\u0007\u0002E%\u0011\u0001G\t\u0002\r'B\f'o[*fgNLwN\\\u0001\u0013e>|G\u000fU1uQN\u001c\u0006/Z2jM&,G\rE\u00024{\u0001s!\u0001\u000e\u001e\u000f\u0005UBT\"\u0001\u001c\u000b\u0005]b\u0012A\u0002\u001fs_>$h(C\u0001:\u0003\u0015\u00198-\u00197b\u0013\tYD(A\u0004qC\u000e\\\u0017mZ3\u000b\u0003eJ!AP \u0003\u0007M+\u0017O\u0003\u0002<yA\u0011\u0011IR\u0007\u0002\u0005*\u00111\tR\u0001\u0003MNT!!\u0012\r\u0002\r!\fGm\\8q\u0013\t9%I\u0001\u0003QCRD\u0017A\u00039be\u0006lW\r^3sgB!!JT)R\u001d\tYE\n\u0005\u00026y%\u0011Q\nP\u0001\u0007!J,G-\u001a4\n\u0005=\u0003&aA'ba*\u0011Q\n\u0010\t\u0003\u0015JK!a\u0015)\u0003\rM#(/\u001b8h\u0003M)8/\u001a:Ta\u0016\u001c\u0017NZ5fIN\u001b\u0007.Z7b!\r1v+W\u0007\u0002y%\u0011\u0001\f\u0010\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005ikV\"A.\u000b\u0005q\u0013\u0013!\u0002;za\u0016\u001c\u0018B\u00010\\\u0005)\u0019FO];diRK\b/Z\u0001\u0010M&dWm\u0015;biV\u001c8)Y2iKB\u0011q$Y\u0005\u0003E\u0002\u0012qBR5mKN#\u0018\r^;t\u0007\u0006\u001c\u0007.Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\r\u0015<\u0007.\u001b6l!\t1\u0007!D\u0001\u0013\u0011\u0015ac\u00011\u0001.\u0011\u0015\td\u00011\u00013\u0011\u0015Ae\u00011\u0001J\u0011\u0015!f\u00011\u0001V\u0011\u001dyf\u0001%AA\u0002\u0001\f\u0011\u0002\\5ti\u001aKG.Z:\u0015\u00079\u0014X\u0010E\u00024{=\u0004\"a\b9\n\u0005E\u0004#A\u0005)beRLG/[8o\t&\u0014Xm\u0019;pefDQa]\u0004A\u0002Q\f\u0001\u0003]1si&$\u0018n\u001c8GS2$XM]:\u0011\u0007MjT\u000f\u0005\u0002ww6\tqO\u0003\u0002ys\u0006YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\tQ(%\u0001\u0005dCR\fG._:u\u0013\taxO\u0001\u0006FqB\u0014Xm]:j_:DQA`\u0004A\u0002Q\f1\u0002Z1uC\u001aKG\u000e^3sg\u0006Q\u0011n\u001d#bi\u0006\u0004\u0016\r\u001e5\u0015\t\u0005\r\u0011\u0011\u0002\t\u0004-\u0006\u0015\u0011bAA\u0004y\t9!i\\8mK\u0006t\u0007BBA\u0006\u0011\u0001\u0007\u0001)\u0001\u0003qCRD\u0017a\u00049sk:,\u0007+\u0019:uSRLwN\\:\u0015\r\u0005E\u0011\u0011DA\u000f!\u0011\u0019T(a\u0005\u0011\u0007}\t)\"C\u0002\u0002\u0018\u0001\u0012Q\u0002U1si&$\u0018n\u001c8QCRD\u0007BBA\u000e\u0013\u0001\u0007A/\u0001\u0006qe\u0016$\u0017nY1uKNDq!a\b\n\u0001\u0004\t\t#A\u0007qCJ$\u0018\u000e^5p]N\u0003Xm\u0019\t\u0004?\u0005\r\u0012bAA\u0013A\ti\u0001+\u0019:uSRLwN\\*qK\u000e\fQ\u0002\\5ti2+\u0017M\u001a$jY\u0016\u001cH\u0003BA\u0016\u0003\u0003\u0002b!!\f\u00028\u0005mRBAA\u0018\u0015\u0011\t\t$a\r\u0002\u000f5,H/\u00192mK*\u0019\u0011Q\u0007\u001f\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002:\u0005=\"!\u0004'j].,G\rS1tQN+G\u000fE\u0002B\u0003{I1!a\u0010C\u0005)1\u0015\u000e\\3Ti\u0006$Xo\u001d\u0005\u0007\u0003\u0007R\u0001\u0019\u0001\u001a\u0002\u000bA\fG\u000f[:\u0002#\t,Hn\u001b'jgRdU-\u00194GS2,7\u000f\u0006\u0006\u0002J\u0005M\u0013QKA/\u0003O\u0002BaM\u001f\u0002LA1a+!\u0014A\u0003#J1!a\u0014=\u0005\u0019!V\u000f\u001d7feA!1'PA\u001e\u0011\u0015a3\u00021\u0001.\u0011\u001d\t\u0019e\u0003a\u0001\u0003/\u0002R!!\f\u0002Z\u0001KA!a\u0017\u00020\tY\u0011I\u001d:bs\n+hMZ3s\u0011\u001d\tyf\u0003a\u0001\u0003C\naAZ5mi\u0016\u0014\bcA!\u0002d%\u0019\u0011Q\r\"\u0003\u0015A\u000bG\u000f\u001b$jYR,'\u000fC\u0004\u0002j-\u0001\r!a\u001b\u0002\u0015!\fGm\\8q\u0007>tg\r\u0005\u0003\u0002n\u0005MTBAA8\u0015\r\t\t\bR\u0001\u0005G>tg-\u0003\u0003\u0002v\u0005=$!D\"p]\u001aLw-\u001e:bi&|g.A\fI_>$\u0017.Z%o\u001b\u0016lwN]=GS2,\u0017J\u001c3fqB\u0011a-D\n\u0004\u001b\u0005u\u0004c\u0001,\u0002\u0000%\u0019\u0011\u0011\u0011\u001f\u0003\r\u0005s\u0017PU3g)\t\tI(\u0001\u0004de\u0016\fG/\u001a\u000b\u0006K\u0006%\u00151\u0012\u0005\u0006Y=\u0001\r!\f\u0005\b\u0003\u001b{\u0001\u0019AAH\u000319Gn\u001c2cK\u0012\u0004\u0016\r\u001e5t!\u0011\u0019T(!%\u0011\t\u0005M\u0015\u0011T\u0007\u0003\u0003+S1!a&)\u0003\u001d\u0019Ho\u001c:bO\u0016LA!a'\u0002\u0016\nY1\u000b^8sC\u001e,\u0007+\u0019;i\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%kU\u0011\u0011\u0011\u0015\u0016\u0004A\u0006\r6FAAS!\u0011\t9+!-\u000e\u0005\u0005%&\u0002BAV\u0003[\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005=F(\u0001\u0006b]:|G/\u0019;j_:LA!a-\u0002*\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3")
public class HoodieInMemoryFileIndex
extends InMemoryFileIndex
implements SparkAdapterSupport {
    private final SparkSession sparkSession;
    private final FileStatusCache fileStatusCache;
    private SparkAdapter sparkAdapter;
    private volatile boolean bitmap$0;

    public static FileStatusCache $lessinit$greater$default$5() {
        return HoodieInMemoryFileIndex$.MODULE$.$lessinit$greater$default$5();
    }

    public static HoodieInMemoryFileIndex create(SparkSession sparkSession, Seq<StoragePath> seq) {
        return HoodieInMemoryFileIndex$.MODULE$.create(sparkSession, seq);
    }

    private SparkAdapter sparkAdapter$lzycompute() {
        HoodieInMemoryFileIndex hoodieInMemoryFileIndex = this;
        synchronized (hoodieInMemoryFileIndex) {
            if (!this.bitmap$0) {
                this.sparkAdapter = SparkAdapterSupport.sparkAdapter$((SparkAdapterSupport)this);
                this.bitmap$0 = true;
            }
        }
        return this.sparkAdapter;
    }

    public SparkAdapter sparkAdapter() {
        if (!this.bitmap$0) {
            return this.sparkAdapter$lzycompute();
        }
        return this.sparkAdapter;
    }

    public Seq<PartitionDirectory> listFiles(Seq<Expression> partitionFilters, Seq<Expression> dataFilters) {
        Seq seq;
        if (this.partitionSpec().partitionColumns().isEmpty()) {
            PartitionDirectory partitionDirectory = this.sparkAdapter().getSparkPartitionedFileUtils().newPartitionDirectory(InternalRow$.MODULE$.empty(), (Seq)this.allFiles().filter((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)this.isDataPath(f.getPath()))));
            seq = Nil$.MODULE$.$colon$colon((Object)partitionDirectory);
        } else {
            seq = (Seq)this.prunePartitions(partitionFilters, this.partitionSpec()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                PartitionPath partitionPath = x0$1;
                if (partitionPath != null) {
                    Nil$ nil$;
                    InternalRow values = partitionPath.values();
                    Path path = partitionPath.path();
                    Option option = this.leafDirToChildrenFiles().get((Object)path);
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        FileStatus[] existingDir = (FileStatus[])some.value();
                        nil$ = Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])existingDir)).filter((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)this.isDataPath(f.getPath()))));
                    } else if (None$.MODULE$.equals(option)) {
                        nil$ = Nil$.MODULE$;
                    } else {
                        throw new MatchError((Object)option);
                    }
                    Nil$ files = nil$;
                    return this.sparkAdapter().getSparkPartitionedFileUtils().newPartitionDirectory(values, (Seq)files);
                }
                throw new MatchError((Object)partitionPath);
            }, Seq$.MODULE$.canBuildFrom());
        }
        Seq selectedPartitions = seq;
        this.logTrace((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Selected files after partition pruning:\n\t").append(selectedPartitions.mkString("\n\t")).toString());
        return selectedPartitions;
    }

    private boolean isDataPath(Path path) {
        String name = path.getName();
        return !name.startsWith("_") || name.contains("=");
    }

    private Seq<PartitionPath> prunePartitions(Seq<Expression> predicates, PartitionSpec partitionSpec) {
        PartitionSpec partitionSpec2 = partitionSpec;
        if (partitionSpec2 == null) {
            throw new MatchError((Object)partitionSpec2);
        }
        StructType partitionColumns = partitionSpec2.partitionColumns();
        Seq partitions = partitionSpec2.partitions();
        Tuple2 tuple2 = new Tuple2((Object)partitionColumns, (Object)partitions);
        StructType partitionColumns2 = (StructType)tuple2._1();
        Seq partitions2 = (Seq)tuple2._2();
        Set partitionColumnNames = ((TraversableOnce)partitionColumns2.map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.name(), Seq$.MODULE$.canBuildFrom())).toSet();
        Seq partitionPruningPredicates = (Seq)predicates.filter((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)HoodieInMemoryFileIndex.$anonfun$prunePartitions$2(partitionColumnNames, x$4)));
        if (partitionPruningPredicates.nonEmpty()) {
            Expression predicate = (Expression)partitionPruningPredicates.reduce((Function2)And$.MODULE$);
            InterpretedPredicate boundPredicate = this.sparkAdapter().createInterpretedPredicate((Expression)predicate.transform((PartialFunction)new scala.Serializable(null, partitionColumns2){
                public static final long serialVersionUID = 0L;
                private final StructType partitionColumns$1;

                public final <A1 extends Expression, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    if (A1 instanceof AttributeReference) {
                        AttributeReference attributeReference = (AttributeReference)A1;
                        int index = this.partitionColumns$1.indexWhere((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)$anonfun$1.$anonfun$applyOrElse$1(attributeReference, x$6)));
                        return (B1)new BoundReference(index, this.partitionColumns$1.apply(index).dataType(), true);
                    }
                    return (B1)function1.apply(x1);
                }

                public final boolean isDefinedAt(Expression x1) {
                    Expression expression = x1;
                    return expression instanceof AttributeReference;
                }

                public static final /* synthetic */ boolean $anonfun$applyOrElse$1(AttributeReference x2$1, StructField x$6) {
                    String string = x2$1.name();
                    String string2 = x$6.name();
                    return !(string != null ? !string.equals(string2) : string2 != null);
                }
                {
                    this.partitionColumns$1 = partitionColumns$1;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1$adapted(org.apache.spark.sql.catalyst.expressions.AttributeReference org.apache.spark.sql.types.StructField )}, serializedLambda);
                }
            }));
            Seq selected = (Seq)partitions2.filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)HoodieInMemoryFileIndex.$anonfun$prunePartitions$4(boundPredicate, x0$1)));
            this.logInfo((Function0 & Serializable & scala.Serializable)() -> {
                int total = partitions2.length();
                int selectedSize = selected.length();
                double percentPruned = (1.0 - (double)selectedSize / (double)total) * (double)100;
                return new StringBuilder(49).append("Selected ").append(selectedSize).append(" partitions out of ").append(total).append(", ").append("pruned ").append((Object)(total == 0 ? "0" : new StringBuilder(1).append(percentPruned).append("%").toString())).append(" partitions.").toString();
            });
            return selected;
        }
        return partitions2;
    }

    public LinkedHashSet<FileStatus> listLeafFiles(Seq<Path> paths) {
        long startTime = System.nanoTime();
        LinkedHashSet output = (LinkedHashSet)LinkedHashSet$.MODULE$.apply((Seq)Nil$.MODULE$);
        ArrayBuffer pathsToFetch = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        paths.foreach((Function1 & Serializable & scala.Serializable)path -> {
            HoodieInMemoryFileIndex.$anonfun$listLeafFiles$1(this, output, pathsToFetch, path);
            return BoxedUnit.UNIT;
        });
        PathFilter filter = FileInputFormat.getInputPathFilter((JobConf)new JobConf(this.hadoopConf(), this.getClass()));
        Seq<Tuple2<Path, Seq<FileStatus>>> discovered = this.bulkListLeafFiles(this.sparkSession, (ArrayBuffer<Path>)pathsToFetch, filter, this.hadoopConf());
        discovered.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Path path = (Path)tuple2._1();
                Seq leafFiles = (Seq)tuple2._2();
                HiveCatalogMetrics$.MODULE$.incrementFilesDiscovered(leafFiles.size());
                $this.fileStatusCache.putLeafFiles(path, (FileStatus[])leafFiles.toArray(ClassTag$.MODULE$.apply(FileStatus.class)));
                return (LinkedHashSet)output.$plus$plus$eq((TraversableOnce)leafFiles);
            }
            throw new MatchError((Object)tuple2);
        });
        this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(42).append("It took ").append((System.nanoTime() - startTime) / 1000000L).append(" ms to list leaf files").append(" for ").append(paths.length()).append(" paths.").toString());
        return output;
    }

    public Seq<Tuple2<Path, Seq<FileStatus>>> bulkListLeafFiles(SparkSession sparkSession, ArrayBuffer<Path> paths, PathFilter filter, Configuration hadoopConf) {
        return HoodieHadoopFSUtils$.MODULE$.parallelListLeafFiles(sparkSession.sparkContext(), (Seq<Path>)paths.toSeq(), hadoopConf, new PathFilterWrapper(filter), sparkSession.sessionState().conf().ignoreMissingFiles(), true, sparkSession.sessionState().conf().parallelPartitionDiscoveryThreshold(), sparkSession.sessionState().conf().parallelPartitionDiscoveryParallelism());
    }

    public static final /* synthetic */ boolean $anonfun$prunePartitions$2(Set partitionColumnNames$1, Expression x$4) {
        return ((TraversableOnce)x$4.references().map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.name(), Iterable$.MODULE$.canBuildFrom())).toSet().subsetOf((GenSet)partitionColumnNames$1);
    }

    public static final /* synthetic */ boolean $anonfun$prunePartitions$4(InterpretedPredicate boundPredicate$1, PartitionPath x0$1) {
        PartitionPath partitionPath = x0$1;
        if (partitionPath != null) {
            InternalRow values = partitionPath.values();
            return boundPredicate$1.eval(values);
        }
        throw new MatchError((Object)partitionPath);
    }

    public static final /* synthetic */ void $anonfun$listLeafFiles$1(HoodieInMemoryFileIndex $this, LinkedHashSet output$1, ArrayBuffer pathsToFetch$1, Path path) {
        Option option = $this.fileStatusCache.getLeafFiles(path);
        if (option instanceof Some) {
            Some some = (Some)option;
            FileStatus[] files = (FileStatus[])some.value();
            HiveCatalogMetrics$.MODULE$.incrementFileCacheHits(files.length);
            AbstractIterable cfr_ignored_0 = (AbstractIterable)output$1.$plus$plus$eq((TraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])files)));
        } else if (None$.MODULE$.equals(option)) {
            pathsToFetch$1.$plus$eq((Object)path);
        } else {
            throw new MatchError((Object)option);
        }
    }

    public HoodieInMemoryFileIndex(SparkSession sparkSession, Seq<Path> rootPathsSpecified, Map<String, String> parameters, Option<StructType> userSpecifiedSchema, FileStatusCache fileStatusCache) {
        this.sparkSession = sparkSession;
        this.fileStatusCache = fileStatusCache;
        super(sparkSession, rootPathsSpecified, parameters, userSpecifiedSchema, fileStatusCache, InMemoryFileIndex$.MODULE$.$lessinit$greater$default$6(), InMemoryFileIndex$.MODULE$.$lessinit$greater$default$7());
        SparkAdapterSupport.$init$((SparkAdapterSupport)this);
    }
}

