/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi;

import java.util.Map;
import org.apache.hudi.DataSourceUtils;
import org.apache.hudi.DataSourceWriteOptions$;
import org.apache.hudi.common.config.HoodieConfig;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import scala.Predef$;
import scala.collection.JavaConverters$;

public final class HoodieSparkSqlWriterInternal$ {
    public static HoodieSparkSqlWriterInternal$ MODULE$;

    static {
        new HoodieSparkSqlWriterInternal$();
    }

    public boolean shouldDropDuplicatesForInserts(HoodieConfig hoodieConfig) {
        return hoodieConfig.contains(DataSourceWriteOptions$.MODULE$.INSERT_DUP_POLICY()) && hoodieConfig.getString(DataSourceWriteOptions$.MODULE$.INSERT_DUP_POLICY()).equalsIgnoreCase(DataSourceWriteOptions$.MODULE$.DROP_INSERT_DUP_POLICY());
    }

    public boolean shouldFailWhenDuplicatesFound(HoodieConfig hoodieConfig) {
        return hoodieConfig.contains(DataSourceWriteOptions$.MODULE$.INSERT_DUP_POLICY()) && hoodieConfig.getString(DataSourceWriteOptions$.MODULE$.INSERT_DUP_POLICY()).equalsIgnoreCase(DataSourceWriteOptions$.MODULE$.FAIL_INSERT_DUP_POLICY());
    }

    public boolean isDeduplicationRequired(HoodieConfig hoodieConfig) {
        return Predef$.MODULE$.Boolean2boolean(hoodieConfig.getBoolean(DataSourceWriteOptions$.MODULE$.INSERT_DROP_DUPS())) || this.shouldFailWhenDuplicatesFound(hoodieConfig) || this.shouldDropDuplicatesForInserts(hoodieConfig);
    }

    public boolean isDeduplicationNeeded(WriteOperationType operation) {
        WriteOperationType writeOperationType = operation;
        WriteOperationType writeOperationType2 = WriteOperationType.INSERT;
        return !(writeOperationType != null ? !writeOperationType.equals(writeOperationType2) : writeOperationType2 != null);
    }

    public JavaRDD<HoodieRecord<?>> handleInsertDuplicates(JavaRDD<HoodieRecord<?>> incomingRecords, HoodieConfig hoodieConfig, WriteOperationType operation, JavaSparkContext jsc, scala.collection.immutable.Map<String, String> parameters) {
        if (!this.isDeduplicationRequired(hoodieConfig) || !this.isDeduplicationNeeded(operation)) {
            return incomingRecords;
        }
        return DataSourceUtils.resolveDuplicates(jsc, incomingRecords, (Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(parameters).asJava(), this.shouldFailWhenDuplicatesFound(hoodieConfig));
    }

    private HoodieSparkSqlWriterInternal$() {
        MODULE$ = this;
    }
}

