/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.cdc;

import java.io.Serializable;
import org.apache.hudi.DataSourceReadOptions$;
import org.apache.hudi.cdc.CDCRelation;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.cdc.HoodieCDCOperation;
import org.apache.hudi.common.table.log.InstantRange;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.exception.HoodieException;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function0;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;

public final class CDCRelation$ {
    public static CDCRelation$ MODULE$;
    private final UTF8String CDC_OPERATION_DELETE;
    private final UTF8String CDC_OPERATION_INSERT;
    private final UTF8String CDC_OPERATION_UPDATE;
    private final StructType FULL_CDC_SPARK_SCHEMA;
    private final StructType MIN_CDC_SPARK_SCHEMA;
    private final StructType CDC_WITH_BEFORE_SPARK_SCHEMA;

    static {
        new CDCRelation$();
    }

    public InstantRange.RangeType $lessinit$greater$default$6() {
        return InstantRange.RangeType.OPEN_CLOSED;
    }

    public UTF8String CDC_OPERATION_DELETE() {
        return this.CDC_OPERATION_DELETE;
    }

    public UTF8String CDC_OPERATION_INSERT() {
        return this.CDC_OPERATION_INSERT;
    }

    public UTF8String CDC_OPERATION_UPDATE() {
        return this.CDC_OPERATION_UPDATE;
    }

    public StructType FULL_CDC_SPARK_SCHEMA() {
        return this.FULL_CDC_SPARK_SCHEMA;
    }

    public StructType MIN_CDC_SPARK_SCHEMA() {
        return this.MIN_CDC_SPARK_SCHEMA;
    }

    public StructType CDC_WITH_BEFORE_SPARK_SCHEMA() {
        return this.CDC_WITH_BEFORE_SPARK_SCHEMA;
    }

    public boolean isCDCEnabled(HoodieTableMetaClient metaClient) {
        return metaClient.getTableConfig().isCDCEnabled();
    }

    public CDCRelation getCDCRelation(SQLContext sqlContext, HoodieTableMetaClient metaClient, Map<String, String> options, InstantRange.RangeType rangeType) {
        if (!this.isCDCEnabled(metaClient)) {
            throw new IllegalArgumentException(new StringBuilder(29).append("It isn't a CDC hudi table on ").append(metaClient.getBasePath()).toString());
        }
        String startCompletionTime = (String)options.getOrElse((Object)DataSourceReadOptions$.MODULE$.START_COMMIT().key(), (Function0 & Serializable & scala.Serializable)() -> {
            throw new HoodieException(new StringBuilder(76).append("CDC Query should provide the valid start completion time ").append("through the option ").append(DataSourceReadOptions$.MODULE$.START_COMMIT().key()).toString());
        });
        String endCompletionTime = (String)options.getOrElse((Object)DataSourceReadOptions$.MODULE$.END_COMMIT().key(), (Function0 & Serializable & scala.Serializable)() -> MODULE$.getTimestampOfLatestInstant(metaClient));
        return new CDCRelation(sqlContext, metaClient, startCompletionTime, endCompletionTime, options, rangeType);
    }

    public InstantRange.RangeType getCDCRelation$default$4() {
        return InstantRange.RangeType.OPEN_CLOSED;
    }

    public String getTimestampOfLatestInstant(HoodieTableMetaClient metaClient) {
        Option latestInstant = metaClient.getActiveTimeline().lastInstant();
        if (latestInstant.isPresent()) {
            return ((HoodieInstant)latestInstant.get()).requestedTime();
        }
        throw new HoodieException("No valid instant in Active Timeline.");
    }

    private CDCRelation$() {
        MODULE$ = this;
        this.CDC_OPERATION_DELETE = UTF8String.fromString((String)HoodieCDCOperation.DELETE.getValue());
        this.CDC_OPERATION_INSERT = UTF8String.fromString((String)HoodieCDCOperation.INSERT.getValue());
        this.CDC_OPERATION_UPDATE = UTF8String.fromString((String)HoodieCDCOperation.UPDATE.getValue());
        this.FULL_CDC_SPARK_SCHEMA = StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("op", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("ts_ms", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("before", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("after", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)))));
        this.MIN_CDC_SPARK_SCHEMA = StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("op", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("record_key", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)));
        this.CDC_WITH_BEFORE_SPARK_SCHEMA = StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("op", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("record_key", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("before", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$))));
    }
}

