/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark;

import java.io.FileNotFoundException;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.viewfs.ViewFileSystem;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.spark.HoodieHadoopFSUtils;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkContext$;
import org.apache.spark.internal.Logging;
import org.apache.spark.metrics.source.HiveCatalogMetrics$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.util.SerializableConfiguration;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.BufferedIterator;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Traversable;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Vector;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

public final class HoodieHadoopFSUtils$
implements Logging {
    public static HoodieHadoopFSUtils$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new HoodieHadoopFSUtils$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Seq<Tuple2<Path, Seq<FileStatus>>> parallelListLeafFiles(SparkContext sc, Seq<Path> paths, Configuration hadoopConf, PathFilter filter, boolean ignoreMissingFiles, boolean ignoreLocality, int parallelismThreshold, int parallelismMax) {
        return this.parallelListLeafFilesInternal(sc, paths, hadoopConf, filter, true, ignoreMissingFiles, ignoreLocality, parallelismThreshold, parallelismMax);
    }

    private Seq<Tuple2<Path, Seq<FileStatus>>> parallelListLeafFilesInternal(SparkContext sc, Seq<Path> paths, Configuration hadoopConf, PathFilter filter, boolean isRootLevel, boolean ignoreMissingFiles, boolean ignoreLocality, int parallelismThreshold, int parallelismMax) {
        Tuple2[] tuple2Array;
        if (paths.size() <= parallelismThreshold) {
            return (Seq)paths.map((Function1 & Serializable & scala.Serializable)path -> {
                Seq<FileStatus> leafFiles = MODULE$.listLeafFiles((Path)path, hadoopConf, filter, (Option<SparkContext>)new Some((Object)sc), ignoreMissingFiles, ignoreLocality, isRootLevel, parallelismThreshold, parallelismMax);
                return new Tuple2(path, leafFiles);
            }, Seq$.MODULE$.canBuildFrom());
        }
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(91).append("Listing leaf files and directories in parallel under ").append(paths.length()).append(" paths.").append(" The first several paths are: ").append(((TraversableOnce)paths.take(10)).mkString(", ")).append(".").toString());
        HiveCatalogMetrics$.MODULE$.incrementParallelListingJobCount(1);
        SerializableConfiguration serializableConfiguration = new SerializableConfiguration(hadoopConf);
        Seq serializedPaths = (Seq)paths.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.toString(), Seq$.MODULE$.canBuildFrom());
        int numParallelism = Math.min(paths.size(), parallelismMax);
        String previousJobDescription = sc.getLocalProperty(SparkContext$.MODULE$.SPARK_JOB_DESCRIPTION());
        try {
            String string;
            int n = paths.size();
            switch (n) {
                case 0: {
                    string = "Listing leaf files and directories 0 paths";
                    break;
                }
                case 1: {
                    string = new java.lang.StringBuilder(51).append("Listing leaf files and directories for 1 path:<br/>").append(paths.apply(0)).toString();
                    break;
                }
                default: {
                    string = new java.lang.StringBuilder(56).append("Listing leaf files and directories for ").append(n).append(" paths:<br/>").append(paths.apply(0)).append(", ...").toString();
                    break;
                }
            }
            String description = string;
            sc.setJobDescription(description);
            RDD qual$1 = sc.parallelize(serializedPaths, numParallelism, ClassTag$.MODULE$.apply(String.class));
            Function1 & Serializable & scala.Serializable x$12 = (Function1 & Serializable & scala.Serializable)pathStrings -> {
                Configuration hadoopConf = serializableConfiguration.value();
                return ((IterableLike)pathStrings.map((Function1 & Serializable & scala.Serializable)x$2 -> new Path(x$2)).toSeq().map((Function1 & Serializable & scala.Serializable)path -> {
                    Seq<FileStatus> leafFiles = MODULE$.listLeafFiles((Path)path, hadoopConf, filter, (Option<SparkContext>)None$.MODULE$, ignoreMissingFiles, ignoreLocality, isRootLevel, Integer.MAX_VALUE, 0);
                    return new Tuple2(path, leafFiles);
                }, Seq$.MODULE$.canBuildFrom())).iterator();
            };
            boolean x$2 = qual$1.mapPartitions$default$2();
            tuple2Array = (Tuple2[])qual$1.mapPartitions((Function1)x$12, x$2, ClassTag$.MODULE$.apply(Tuple2.class)).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    Path path = (Path)tuple2._1();
                    Seq statuses = (Seq)tuple2._2();
                    Seq serializableStatuses = (Seq)statuses.map((Function1 & Serializable & scala.Serializable)status -> {
                        HoodieHadoopFSUtils.SerializableBlockLocation[] serializableBlockLocationArray;
                        FileStatus fileStatus = status;
                        if (fileStatus instanceof LocatedFileStatus) {
                            LocatedFileStatus locatedFileStatus = (LocatedFileStatus)fileStatus;
                            serializableBlockLocationArray = (HoodieHadoopFSUtils.SerializableBlockLocation[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])locatedFileStatus.getBlockLocations())).map((Function1 & Serializable & scala.Serializable)loc -> new HoodieHadoopFSUtils.SerializableBlockLocation(loc.getNames(), loc.getHosts(), loc.getOffset(), loc.getLength()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(HoodieHadoopFSUtils.SerializableBlockLocation.class)));
                        } else {
                            serializableBlockLocationArray = (HoodieHadoopFSUtils.SerializableBlockLocation[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(HoodieHadoopFSUtils.SerializableBlockLocation.class));
                        }
                        HoodieHadoopFSUtils.SerializableBlockLocation[] blockLocations = serializableBlockLocationArray;
                        return new HoodieHadoopFSUtils.SerializableFileStatus(status.getPath().toString(), status.getLen(), status.isDirectory(), status.getReplication(), status.getBlockSize(), status.getModificationTime(), status.getAccessTime(), blockLocations);
                    }, Seq$.MODULE$.canBuildFrom());
                    return new Tuple2((Object)path.toString(), (Object)serializableStatuses);
                }
                throw new MatchError((Object)tuple2);
            }, ClassTag$.MODULE$.apply(Tuple2.class)).collect();
        }
        finally {
            sc.setJobDescription(previousJobDescription);
        }
        Tuple2[] statusMap = tuple2Array;
        return (Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])statusMap)).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                String path = (String)tuple2._1();
                Seq serializableStatuses = (Seq)tuple2._2();
                Seq statuses = (Seq)serializableStatuses.map((Function1 & Serializable & scala.Serializable)f -> {
                    BlockLocation[] blockLocations = (BlockLocation[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])f.blockLocations())).map((Function1 & Serializable & scala.Serializable)loc -> new BlockLocation(loc.names(), loc.hosts(), loc.offset(), loc.length()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(BlockLocation.class)));
                    return new LocatedFileStatus(new FileStatus(f.length(), f.isDir(), (int)f.blockReplication(), f.blockSize(), f.modificationTime(), new Path(f.path())), blockLocations);
                }, Seq$.MODULE$.canBuildFrom());
                return new Tuple2((Object)new Path(path), (Object)statuses);
            }
            throw new MatchError((Object)tuple2);
        }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
    }

    /*
     * Unable to fully structure code
     */
    private Seq<FileStatus> listLeafFiles(Path path, Configuration hadoopConf, PathFilter filter, Option<SparkContext> contextOpt, boolean ignoreMissingFiles, boolean ignoreLocality, boolean isRootPath, int parallelismThreshold, int parallelismMax) {
        block8: {
            this.logTrace((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$listLeafFiles$1(org.apache.hadoop.fs.Path ), ()Ljava/lang/String;)((Path)path));
            fs = path.getFileSystem(hadoopConf);
            try {
                var17_11 = fs;
                if ((var17_11 instanceof DistributedFileSystem != false ? true : var17_11 instanceof ViewFileSystem != false) && !ignoreLocality) {
                    remoteIter = fs.listLocatedStatus(path);
                    v0 = (FileStatus[])new Iterator<LocatedFileStatus>(remoteIter){
                        private final RemoteIterator remoteIter$1;

                        public Iterator<LocatedFileStatus> seq() {
                            return Iterator.seq$((Iterator)this);
                        }

                        public boolean isEmpty() {
                            return Iterator.isEmpty$((Iterator)this);
                        }

                        public boolean isTraversableAgain() {
                            return Iterator.isTraversableAgain$((Iterator)this);
                        }

                        public boolean hasDefiniteSize() {
                            return Iterator.hasDefiniteSize$((Iterator)this);
                        }

                        public Iterator<LocatedFileStatus> take(int n) {
                            return Iterator.take$((Iterator)this, (int)n);
                        }

                        public Iterator<LocatedFileStatus> drop(int n) {
                            return Iterator.drop$((Iterator)this, (int)n);
                        }

                        public Iterator<LocatedFileStatus> slice(int from, int until) {
                            return Iterator.slice$((Iterator)this, (int)from, (int)until);
                        }

                        public Iterator<LocatedFileStatus> sliceIterator(int from, int until) {
                            return Iterator.sliceIterator$((Iterator)this, (int)from, (int)until);
                        }

                        public <B> Iterator<B> map(Function1<LocatedFileStatus, B> f) {
                            return Iterator.map$((Iterator)this, f);
                        }

                        public <B> Iterator<B> $plus$plus(Function0<GenTraversableOnce<B>> that) {
                            return Iterator.$plus$plus$((Iterator)this, that);
                        }

                        public <B> Iterator<B> flatMap(Function1<LocatedFileStatus, GenTraversableOnce<B>> f) {
                            return Iterator.flatMap$((Iterator)this, f);
                        }

                        public Iterator<LocatedFileStatus> filter(Function1<LocatedFileStatus, Object> p) {
                            return Iterator.filter$((Iterator)this, p);
                        }

                        public <B> boolean corresponds(GenTraversableOnce<B> that, Function2<LocatedFileStatus, B, Object> p) {
                            return Iterator.corresponds$((Iterator)this, that, p);
                        }

                        public Iterator<LocatedFileStatus> withFilter(Function1<LocatedFileStatus, Object> p) {
                            return Iterator.withFilter$((Iterator)this, p);
                        }

                        public Iterator<LocatedFileStatus> filterNot(Function1<LocatedFileStatus, Object> p) {
                            return Iterator.filterNot$((Iterator)this, p);
                        }

                        public <B> Iterator<B> collect(PartialFunction<LocatedFileStatus, B> pf) {
                            return Iterator.collect$((Iterator)this, pf);
                        }

                        public <B> Iterator<B> scanLeft(B z, Function2<B, LocatedFileStatus, B> op) {
                            return Iterator.scanLeft$((Iterator)this, z, op);
                        }

                        public <B> Iterator<B> scanRight(B z, Function2<LocatedFileStatus, B, B> op) {
                            return Iterator.scanRight$((Iterator)this, z, op);
                        }

                        public Iterator<LocatedFileStatus> takeWhile(Function1<LocatedFileStatus, Object> p) {
                            return Iterator.takeWhile$((Iterator)this, p);
                        }

                        public Tuple2<Iterator<LocatedFileStatus>, Iterator<LocatedFileStatus>> partition(Function1<LocatedFileStatus, Object> p) {
                            return Iterator.partition$((Iterator)this, p);
                        }

                        public Tuple2<Iterator<LocatedFileStatus>, Iterator<LocatedFileStatus>> span(Function1<LocatedFileStatus, Object> p) {
                            return Iterator.span$((Iterator)this, p);
                        }

                        public Iterator<LocatedFileStatus> dropWhile(Function1<LocatedFileStatus, Object> p) {
                            return Iterator.dropWhile$((Iterator)this, p);
                        }

                        public <B> Iterator<Tuple2<LocatedFileStatus, B>> zip(Iterator<B> that) {
                            return Iterator.zip$((Iterator)this, that);
                        }

                        public <A1> Iterator<A1> padTo(int len, A1 elem) {
                            return Iterator.padTo$((Iterator)this, (int)len, elem);
                        }

                        public Iterator<Tuple2<LocatedFileStatus, Object>> zipWithIndex() {
                            return Iterator.zipWithIndex$((Iterator)this);
                        }

                        public <B, A1, B1> Iterator<Tuple2<A1, B1>> zipAll(Iterator<B> that, A1 thisElem, B1 thatElem) {
                            return Iterator.zipAll$((Iterator)this, that, thisElem, thatElem);
                        }

                        public <U> void foreach(Function1<LocatedFileStatus, U> f) {
                            Iterator.foreach$((Iterator)this, f);
                        }

                        public boolean forall(Function1<LocatedFileStatus, Object> p) {
                            return Iterator.forall$((Iterator)this, p);
                        }

                        public boolean exists(Function1<LocatedFileStatus, Object> p) {
                            return Iterator.exists$((Iterator)this, p);
                        }

                        public boolean contains(Object elem) {
                            return Iterator.contains$((Iterator)this, (Object)elem);
                        }

                        public Option<LocatedFileStatus> find(Function1<LocatedFileStatus, Object> p) {
                            return Iterator.find$((Iterator)this, p);
                        }

                        public int indexWhere(Function1<LocatedFileStatus, Object> p) {
                            return Iterator.indexWhere$((Iterator)this, p);
                        }

                        public int indexWhere(Function1<LocatedFileStatus, Object> p, int from) {
                            return Iterator.indexWhere$((Iterator)this, p, (int)from);
                        }

                        public <B> int indexOf(B elem) {
                            return Iterator.indexOf$((Iterator)this, elem);
                        }

                        public <B> int indexOf(B elem, int from) {
                            return Iterator.indexOf$((Iterator)this, elem, (int)from);
                        }

                        public BufferedIterator<LocatedFileStatus> buffered() {
                            return Iterator.buffered$((Iterator)this);
                        }

                        public <B> Iterator.GroupedIterator<B> grouped(int size) {
                            return Iterator.grouped$((Iterator)this, (int)size);
                        }

                        public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
                            return Iterator.sliding$((Iterator)this, (int)size, (int)step);
                        }

                        public <B> int sliding$default$2() {
                            return Iterator.sliding$default$2$((Iterator)this);
                        }

                        public int length() {
                            return Iterator.length$((Iterator)this);
                        }

                        public Tuple2<Iterator<LocatedFileStatus>, Iterator<LocatedFileStatus>> duplicate() {
                            return Iterator.duplicate$((Iterator)this);
                        }

                        public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
                            return Iterator.patch$((Iterator)this, (int)from, patchElems, (int)replaced);
                        }

                        public <B> void copyToArray(Object xs, int start, int len) {
                            Iterator.copyToArray$((Iterator)this, (Object)xs, (int)start, (int)len);
                        }

                        public boolean sameElements(Iterator<?> that) {
                            return Iterator.sameElements$((Iterator)this, that);
                        }

                        public Traversable<LocatedFileStatus> toTraversable() {
                            return Iterator.toTraversable$((Iterator)this);
                        }

                        public Iterator<LocatedFileStatus> toIterator() {
                            return Iterator.toIterator$((Iterator)this);
                        }

                        public Stream<LocatedFileStatus> toStream() {
                            return Iterator.toStream$((Iterator)this);
                        }

                        public String toString() {
                            return Iterator.toString$((Iterator)this);
                        }

                        public List<LocatedFileStatus> reversed() {
                            return TraversableOnce.reversed$((TraversableOnce)this);
                        }

                        public int size() {
                            return TraversableOnce.size$((TraversableOnce)this);
                        }

                        public boolean nonEmpty() {
                            return TraversableOnce.nonEmpty$((TraversableOnce)this);
                        }

                        public int count(Function1<LocatedFileStatus, Object> p) {
                            return TraversableOnce.count$((TraversableOnce)this, p);
                        }

                        public <B> Option<B> collectFirst(PartialFunction<LocatedFileStatus, B> pf) {
                            return TraversableOnce.collectFirst$((TraversableOnce)this, pf);
                        }

                        public <B> B $div$colon(B z, Function2<B, LocatedFileStatus, B> op) {
                            return (B)TraversableOnce.$div$colon$((TraversableOnce)this, z, op);
                        }

                        public <B> B $colon$bslash(B z, Function2<LocatedFileStatus, B, B> op) {
                            return (B)TraversableOnce.$colon$bslash$((TraversableOnce)this, z, op);
                        }

                        public <B> B foldLeft(B z, Function2<B, LocatedFileStatus, B> op) {
                            return (B)TraversableOnce.foldLeft$((TraversableOnce)this, z, op);
                        }

                        public <B> B foldRight(B z, Function2<LocatedFileStatus, B, B> op) {
                            return (B)TraversableOnce.foldRight$((TraversableOnce)this, z, op);
                        }

                        public <B> B reduceLeft(Function2<B, LocatedFileStatus, B> op) {
                            return (B)TraversableOnce.reduceLeft$((TraversableOnce)this, op);
                        }

                        public <B> B reduceRight(Function2<LocatedFileStatus, B, B> op) {
                            return (B)TraversableOnce.reduceRight$((TraversableOnce)this, op);
                        }

                        public <B> Option<B> reduceLeftOption(Function2<B, LocatedFileStatus, B> op) {
                            return TraversableOnce.reduceLeftOption$((TraversableOnce)this, op);
                        }

                        public <B> Option<B> reduceRightOption(Function2<LocatedFileStatus, B, B> op) {
                            return TraversableOnce.reduceRightOption$((TraversableOnce)this, op);
                        }

                        public <A1> A1 reduce(Function2<A1, A1, A1> op) {
                            return (A1)TraversableOnce.reduce$((TraversableOnce)this, op);
                        }

                        public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
                            return TraversableOnce.reduceOption$((TraversableOnce)this, op);
                        }

                        public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                            return (A1)TraversableOnce.fold$((TraversableOnce)this, z, op);
                        }

                        public <B> B aggregate(Function0<B> z, Function2<B, LocatedFileStatus, B> seqop, Function2<B, B, B> combop) {
                            return (B)TraversableOnce.aggregate$((TraversableOnce)this, z, seqop, combop);
                        }

                        public <B> B sum(Numeric<B> num) {
                            return (B)TraversableOnce.sum$((TraversableOnce)this, num);
                        }

                        public <B> B product(Numeric<B> num) {
                            return (B)TraversableOnce.product$((TraversableOnce)this, num);
                        }

                        public Object min(Ordering cmp) {
                            return TraversableOnce.min$((TraversableOnce)this, (Ordering)cmp);
                        }

                        public Object max(Ordering cmp) {
                            return TraversableOnce.max$((TraversableOnce)this, (Ordering)cmp);
                        }

                        public Object maxBy(Function1 f, Ordering cmp) {
                            return TraversableOnce.maxBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
                        }

                        public Object minBy(Function1 f, Ordering cmp) {
                            return TraversableOnce.minBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
                        }

                        public <B> void copyToBuffer(Buffer<B> dest) {
                            TraversableOnce.copyToBuffer$((TraversableOnce)this, dest);
                        }

                        public <B> void copyToArray(Object xs, int start) {
                            TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs, (int)start);
                        }

                        public <B> void copyToArray(Object xs) {
                            TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs);
                        }

                        public <B> Object toArray(ClassTag<B> evidence$1) {
                            return TraversableOnce.toArray$((TraversableOnce)this, evidence$1);
                        }

                        public List<LocatedFileStatus> toList() {
                            return TraversableOnce.toList$((TraversableOnce)this);
                        }

                        public Iterable<LocatedFileStatus> toIterable() {
                            return TraversableOnce.toIterable$((TraversableOnce)this);
                        }

                        public Seq<LocatedFileStatus> toSeq() {
                            return TraversableOnce.toSeq$((TraversableOnce)this);
                        }

                        public IndexedSeq<LocatedFileStatus> toIndexedSeq() {
                            return TraversableOnce.toIndexedSeq$((TraversableOnce)this);
                        }

                        public <B> Buffer<B> toBuffer() {
                            return TraversableOnce.toBuffer$((TraversableOnce)this);
                        }

                        public <B> Set<B> toSet() {
                            return TraversableOnce.toSet$((TraversableOnce)this);
                        }

                        public Vector<LocatedFileStatus> toVector() {
                            return TraversableOnce.toVector$((TraversableOnce)this);
                        }

                        public <Col> Col to(CanBuildFrom<Nothing$, LocatedFileStatus, Col> cbf) {
                            return (Col)TraversableOnce.to$((TraversableOnce)this, cbf);
                        }

                        public <T, U> Map<T, U> toMap(Predef.$less$colon$less<LocatedFileStatus, Tuple2<T, U>> ev) {
                            return TraversableOnce.toMap$((TraversableOnce)this, ev);
                        }

                        public String mkString(String start, String sep, String end) {
                            return TraversableOnce.mkString$((TraversableOnce)this, (String)start, (String)sep, (String)end);
                        }

                        public String mkString(String sep) {
                            return TraversableOnce.mkString$((TraversableOnce)this, (String)sep);
                        }

                        public String mkString() {
                            return TraversableOnce.mkString$((TraversableOnce)this);
                        }

                        public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                            return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
                        }

                        public StringBuilder addString(StringBuilder b, String sep) {
                            return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)sep);
                        }

                        public StringBuilder addString(StringBuilder b) {
                            return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b);
                        }

                        public int sizeHintIfCheap() {
                            return GenTraversableOnce.sizeHintIfCheap$((GenTraversableOnce)this);
                        }

                        public LocatedFileStatus next() {
                            return (LocatedFileStatus)this.remoteIter$1.next();
                        }

                        public boolean hasNext() {
                            return this.remoteIter$1.hasNext();
                        }
                        {
                            this.remoteIter$1 = remoteIter$1;
                            GenTraversableOnce.$init$((GenTraversableOnce)this);
                            TraversableOnce.$init$((TraversableOnce)this);
                            Iterator.$init$((Iterator)this);
                        }
                    }.toArray(ClassTag$.MODULE$.apply(FileStatus.class));
                } else {
                    v0 = fs.listStatus(path);
                }
            }
            catch (Throwable var19_13) {
                var20_14 = var19_13;
                if (var20_14 instanceof FileNotFoundException && (isRootPath || ignoreMissingFiles)) {
                    this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$listLeafFiles$2(org.apache.hadoop.fs.Path ), ()Ljava/lang/String;)((Path)path));
                    v0 = (FileStatus[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(FileStatus.class));
                }
                throw var19_13;
            }
            statuses = v0;
            filteredStatuses = (FileStatus[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])statuses)).filterNot((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$listLeafFiles$3$adapted(org.apache.hadoop.fs.FileStatus ), (Lorg/apache/hadoop/fs/FileStatus;)Ljava/lang/Object;)());
            var24_17 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])filteredStatuses)).partition((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$listLeafFiles$4$adapted(org.apache.hadoop.fs.FileStatus ), (Lorg/apache/hadoop/fs/FileStatus;)Ljava/lang/Object;)());
            if (var24_17 == null) {
                throw new MatchError((Object)var24_17);
            }
            dirs = (FileStatus[])var24_17._1();
            topLevelFiles = (FileStatus[])var24_17._2();
            var23_20 = new Tuple2((Object)dirs, (Object)topLevelFiles);
            dirs = (FileStatus[])var23_20._1();
            topLevelFiles = (FileStatus[])var23_20._2();
            var30_23 = contextOpt;
            if (!(var30_23 instanceof Some)) ** GOTO lbl-1000
            var31_24 = (Some)var30_23;
            context = (SparkContext)var31_24.value();
            if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])dirs)).size() > parallelismThreshold) {
                v1 = (Seq)this.parallelListLeafFilesInternal(context, (Seq<Path>)((Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])dirs)).map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$listLeafFiles$5(org.apache.hadoop.fs.FileStatus ), (Lorg/apache/hadoop/fs/FileStatus;)Lorg/apache/hadoop/fs/Path;)(), Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()))), hadoopConf, filter, false, ignoreMissingFiles, ignoreLocality, parallelismThreshold, parallelismMax).flatMap((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$listLeafFiles$6(scala.Tuple2 ), (Lscala/Tuple2;)Lscala/collection/Seq;)(), Seq$.MODULE$.canBuildFrom());
            } else lbl-1000:
            // 2 sources

            {
                v1 = (Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])dirs)).flatMap((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$listLeafFiles$7(org.apache.hadoop.conf.Configuration org.apache.hadoop.fs.PathFilter scala.Option boolean boolean int int org.apache.hadoop.fs.FileStatus ), (Lorg/apache/hadoop/fs/FileStatus;)Lscala/collection/Seq;)((Configuration)hadoopConf, (PathFilter)filter, contextOpt, (boolean)ignoreMissingFiles, (boolean)ignoreLocality, (int)parallelismThreshold, (int)parallelismMax), Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
            }
            nestedFiles = v1;
            allFiles = (FileStatus[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])topLevelFiles)).$plus$plus((GenTraversableOnce)nestedFiles, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(FileStatus.class)));
            allLeafStatuses = filter != null ? (FileStatus[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])allFiles)).filter((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$listLeafFiles$8$adapted(org.apache.hadoop.fs.PathFilter org.apache.hadoop.fs.FileStatus ), (Lorg/apache/hadoop/fs/FileStatus;)Ljava/lang/Object;)((PathFilter)filter)) : allFiles;
            missingFiles = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
            resolvedLeafStatuses = (FileStatus[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])allLeafStatuses)).flatMap((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$listLeafFiles$9(boolean org.apache.hadoop.fs.FileSystem boolean scala.collection.mutable.ArrayBuffer org.apache.hadoop.fs.FileStatus ), (Lorg/apache/hadoop/fs/FileStatus;)Lscala/collection/Iterable;)((boolean)ignoreLocality, (FileSystem)fs, (boolean)ignoreMissingFiles, (ArrayBuffer)missingFiles), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(FileStatus.class)));
            if (!missingFiles.nonEmpty()) break block8;
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$listLeafFiles$11(scala.collection.mutable.ArrayBuffer ), ()Ljava/lang/String;)((ArrayBuffer)missingFiles));
        }
        return Predef$.MODULE$.wrapRefArray((Object[])resolvedLeafStatuses);
    }

    public boolean shouldFilterOutPathName(String pathName) {
        boolean exclude = pathName.startsWith("_") && !pathName.contains("=") || pathName.endsWith("._COPYING_");
        boolean include = pathName.startsWith("_common_metadata") || pathName.startsWith("_metadata");
        return exclude && !include;
    }

    public static final /* synthetic */ String $anonfun$listLeafFiles$1(Path path$1) {
        return new java.lang.StringBuilder(8).append("Listing ").append(path$1).toString();
    }

    public static final /* synthetic */ String $anonfun$listLeafFiles$2(Path path$1) {
        return new java.lang.StringBuilder(59).append("The directory ").append(path$1).append(" was not found. Was it deleted very recently?").toString();
    }

    public static final /* synthetic */ Path $anonfun$listLeafFiles$5(FileStatus x$5) {
        return x$5.getPath();
    }

    public static final /* synthetic */ Seq $anonfun$listLeafFiles$6(Tuple2 x$6) {
        return (Seq)x$6._2();
    }

    public static final /* synthetic */ Seq $anonfun$listLeafFiles$7(Configuration hadoopConf$3, PathFilter filter$2, Option contextOpt$1, boolean ignoreMissingFiles$2, boolean ignoreLocality$2, int parallelismThreshold$2, int parallelismMax$2, FileStatus dir) {
        return MODULE$.listLeafFiles(dir.getPath(), hadoopConf$3, filter$2, (Option<SparkContext>)contextOpt$1, ignoreMissingFiles$2, ignoreLocality$2, false, parallelismThreshold$2, parallelismMax$2);
    }

    public static final /* synthetic */ Iterable $anonfun$listLeafFiles$9(boolean ignoreLocality$2, FileSystem fs$1, boolean ignoreMissingFiles$2, ArrayBuffer missingFiles$1, FileStatus x0$1) {
        FileStatus fileStatus = x0$1;
        if (fileStatus instanceof LocatedFileStatus) {
            LocatedFileStatus locatedFileStatus = (LocatedFileStatus)fileStatus;
            return Option$.MODULE$.option2Iterable((Option)new Some((Object)locatedFileStatus));
        }
        if (!ignoreLocality$2) {
            Iterable iterable;
            try {
                BlockLocation[] locations = (BlockLocation[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fs$1.getFileBlockLocations(fileStatus, 0L, fileStatus.getLen()))).map((Function1 & Serializable & scala.Serializable)loc -> {
                    Class clazz = loc.getClass();
                    Class<BlockLocation> clazz2 = BlockLocation.class;
                    if (!(clazz != null ? !clazz.equals(clazz2) : clazz2 != null)) {
                        return loc;
                    }
                    return new BlockLocation(loc.getNames(), loc.getHosts(), loc.getOffset(), loc.getLength());
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(BlockLocation.class)));
                LocatedFileStatus lfs = new LocatedFileStatus(fileStatus.getLen(), fileStatus.isDirectory(), (int)fileStatus.getReplication(), fileStatus.getBlockSize(), fileStatus.getModificationTime(), 0L, null, null, null, null, fileStatus.getPath(), locations);
                if (fileStatus.isSymlink()) {
                    lfs.setSymlink(fileStatus.getSymlink());
                }
                iterable = Option$.MODULE$.option2Iterable((Option)new Some((Object)lfs));
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable2 instanceof FileNotFoundException && ignoreMissingFiles$2) {
                    missingFiles$1.$plus$eq((Object)fileStatus.getPath().toString());
                    iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                }
                throw throwable;
            }
            return iterable;
        }
        return Option$.MODULE$.option2Iterable((Option)new Some((Object)fileStatus));
    }

    public static final /* synthetic */ String $anonfun$listLeafFiles$11(ArrayBuffer missingFiles$1) {
        return new java.lang.StringBuilder(53).append("the following files were missing during file scan:\n  ").append(missingFiles$1.mkString("\n  ")).toString();
    }

    private HoodieHadoopFSUtils$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
    }

    public static final /* synthetic */ Object $anonfun$listLeafFiles$3$adapted(FileStatus status) {
        return BoxesRunTime.boxToBoolean((boolean)HoodieHadoopFSUtils$.MODULE$.shouldFilterOutPathName(status.getPath().getName()));
    }

    public static final /* synthetic */ Object $anonfun$listLeafFiles$4$adapted(FileStatus x$3) {
        return BoxesRunTime.boxToBoolean((boolean)x$3.isDirectory());
    }

    public static final /* synthetic */ Object $anonfun$listLeafFiles$8$adapted(PathFilter filter$2, FileStatus f) {
        return BoxesRunTime.boxToBoolean((boolean)filter$2.accept(f.getPath()));
    }
}

