/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.command;

import java.util.Map;
import org.apache.avro.Schema;
import org.apache.hudi.DataSourceUtils;
import org.apache.hudi.HoodieWriterUtils$;
import org.apache.hudi.SparkAdapterSupport;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.client.SparkRDDWriteClient;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieFailedWritesCleaningPolicy;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.util.CommitUtils;
import org.apache.hudi.config.HoodieArchivalConfig;
import org.apache.hudi.config.HoodieCleanConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.table.HoodieSparkTable;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.HoodieCatalogTable;
import org.apache.spark.sql.hudi.HoodieOptionConfig$;
import org.apache.spark.sql.hudi.SparkAdapter;
import org.apache.spark.sql.hudi.command.AlterHoodieTableAddColumnsCommand;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.util.control.NonFatal$;

public final class AlterHoodieTableAddColumnsCommand$
implements SparkAdapterSupport,
Logging,
Serializable {
    public static AlterHoodieTableAddColumnsCommand$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private SparkAdapter sparkAdapter;
    private volatile boolean bitmap$0;

    static {
        new AlterHoodieTableAddColumnsCommand$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private SparkAdapter sparkAdapter$lzycompute() {
        AlterHoodieTableAddColumnsCommand$ alterHoodieTableAddColumnsCommand$ = this;
        synchronized (alterHoodieTableAddColumnsCommand$) {
            if (!this.bitmap$0) {
                this.sparkAdapter = SparkAdapterSupport.sparkAdapter$((SparkAdapterSupport)this);
                this.bitmap$0 = true;
            }
        }
        return this.sparkAdapter;
    }

    public SparkAdapter sparkAdapter() {
        if (!this.bitmap$0) {
            return this.sparkAdapter$lzycompute();
        }
        return this.sparkAdapter;
    }

    public void commitWithSchema(Schema schema, HoodieCatalogTable hoodieCatalogTable, SparkSession sparkSession) {
        Schema writeSchema = HoodieAvroUtils.removeMetadataFields((Schema)schema);
        JavaSparkContext jsc = new JavaSparkContext(sparkSession.sparkContext());
        SparkRDDWriteClient client = DataSourceUtils.createHoodieClient(jsc, writeSchema.toString(), hoodieCatalogTable.tableLocation(), hoodieCatalogTable.tableName(), (Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(HoodieWriterUtils$.MODULE$.parametersWithWriteDefaults((scala.collection.immutable.Map<String, String>)HoodieOptionConfig$.MODULE$.mapSqlOptionsToDataSourceWriteConfigs(hoodieCatalogTable.catalogProperties()).$plus$plus((GenTraversableOnce)sparkSession.sqlContext().conf().getAllConfs()).$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieCleanConfig.AUTO_CLEAN.key()), (Object)"false"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieCleanConfig.FAILED_WRITES_CLEANER_POLICY.key()), (Object)HoodieFailedWritesCleaningPolicy.NEVER.name()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieArchivalConfig.AUTO_ARCHIVE.key()), (Object)"false")}))))).asJava());
        String commitActionType = CommitUtils.getCommitActionType((WriteOperationType)WriteOperationType.ALTER_SCHEMA, (HoodieTableType)hoodieCatalogTable.tableType());
        String instantTime = client.createNewInstantTime();
        client.startCommitWithTime(instantTime, commitActionType);
        client.preWrite(instantTime, WriteOperationType.ALTER_SCHEMA, hoodieCatalogTable.metaClient());
        HoodieSparkTable hoodieTable = HoodieSparkTable.create((HoodieWriteConfig)client.getConfig(), (HoodieEngineContext)client.getEngineContext());
        HoodieActiveTimeline timeLine = hoodieTable.getActiveTimeline();
        HoodieInstant requested = hoodieTable.getInstantGenerator().createNewInstant(HoodieInstant.State.REQUESTED, commitActionType, instantTime);
        HoodieCommitMetadata metadata = new HoodieCommitMetadata();
        metadata.setOperationType(WriteOperationType.ALTER_SCHEMA);
        timeLine.transitionRequestedToInflight(requested, org.apache.hudi.common.util.Option.of((Object)metadata));
        client.commit(instantTime, (Object)jsc.emptyRDD());
    }

    public void checkColumnNameDuplication(Seq<String> columnNames, String colType, boolean caseSensitiveAnalysis) {
        this.sparkAdapter().getSchemaUtils().checkColumnNameDuplication(columnNames, colType, caseSensitiveAnalysis);
    }

    public void refreshSchema(SparkSession session, HoodieCatalogTable catalogTable, StructType dataSchema) {
        this.refreshSchemaInMeta(session, catalogTable.table().identifier(), dataSchema);
        HoodieTableType hoodieTableType = catalogTable.tableType();
        HoodieTableType hoodieTableType2 = HoodieTableType.MERGE_ON_READ;
        if (!(hoodieTableType != null ? !hoodieTableType.equals(hoodieTableType2) : hoodieTableType2 != null)) {
            TableIdentifier tableId = catalogTable.table().identifier();
            String tableName = catalogTable.tableName();
            TableIdentifier rtTableId = tableId.copy(new StringBuilder(3).append(tableName).append("_rt").toString(), tableId.copy$default$2(), tableId.copy$default$3());
            if (session.catalog().tableExists(rtTableId.unquotedString())) {
                this.refreshSchemaInMeta(session, rtTableId, dataSchema);
            }
            TableIdentifier roTableId = tableId.copy(new StringBuilder(3).append(tableName).append("_ro").toString(), tableId.copy$default$2(), tableId.copy$default$3());
            if (session.catalog().tableExists(roTableId.unquotedString())) {
                this.refreshSchemaInMeta(session, roTableId, dataSchema);
                return;
            }
            return;
        }
    }

    private void refreshSchemaInMeta(SparkSession session, TableIdentifier tableId, StructType dataSchema) {
        try {
            session.catalog().uncacheTable(tableId.quotedString());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                this.log().warn(new StringBuilder(43).append("Exception when attempting to uncache table ").append(tableId.quotedString()).toString(), e);
            }
            throw throwable;
        }
        session.catalog().refreshTable(tableId.unquotedString());
        session.sessionState().catalog().alterTableDataSchema(tableId, dataSchema);
    }

    public AlterHoodieTableAddColumnsCommand apply(TableIdentifier tableId, Seq<StructField> colsToAdd) {
        return new AlterHoodieTableAddColumnsCommand(tableId, colsToAdd);
    }

    public Option<Tuple2<TableIdentifier, Seq<StructField>>> unapply(AlterHoodieTableAddColumnsCommand x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple2((Object)x$0.tableId(), x$0.colsToAdd()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private AlterHoodieTableAddColumnsCommand$() {
        MODULE$ = this;
        SparkAdapterSupport.$init$((SparkAdapterSupport)this);
        Logging.$init$((Logging)this);
    }
}

