/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Properties;
import org.apache.hudi.DataSourceReadOptions$;
import org.apache.hudi.DataSourceWriteOptions$;
import org.apache.hudi.HoodieConversionUtils$;
import org.apache.hudi.common.config.ConfigProperty;
import org.apache.hudi.common.config.DFSPropertiesConfiguration;
import org.apache.hudi.common.config.HoodieConfig;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.fs.ConsistencyGuardConfig;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.keygen.KeyGenUtils;
import org.apache.hudi.keygen.constant.KeyGeneratorOptions;
import org.apache.hudi.keygen.constant.KeyGeneratorType;
import org.apache.hudi.keygen.factory.HoodieSparkKeyGeneratorFactory;
import org.apache.hudi.util.SparkConfigUtils$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.Growable;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.MapLike;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Map$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;

public final class DataSourceOptionsHelper$ {
    public static DataSourceOptionsHelper$ MODULE$;
    private final Logger log;
    private final List<ConfigProperty<? extends Object>> allConfigsWithAlternatives;
    private final Set<String> allDeprecatedConfigs;
    private final scala.collection.immutable.Map<String, String> allAlternatives;
    private final scala.collection.immutable.Map<String, String> viewTypeValueMap;

    static {
        new DataSourceOptionsHelper$();
    }

    private Logger log() {
        return this.log;
    }

    private List<ConfigProperty<? extends Object>> allConfigsWithAlternatives() {
        return this.allConfigsWithAlternatives;
    }

    public Set<String> allDeprecatedConfigs() {
        return this.allDeprecatedConfigs;
    }

    public scala.collection.immutable.Map<String, String> allAlternatives() {
        return this.allAlternatives;
    }

    public scala.collection.immutable.Map<String, String> viewTypeValueMap() {
        return this.viewTypeValueMap;
    }

    public scala.collection.immutable.Map<String, String> translateConfigurations(scala.collection.immutable.Map<String, String> optParams) {
        scala.collection.mutable.Map translatedOpt = (scala.collection.mutable.Map)((Growable)Map$.MODULE$.apply((Seq)Nil$.MODULE$)).$plus$plus$eq(optParams);
        Object object = !SparkConfigUtils$.MODULE$.containsConfigProperty(optParams, HoodieTableConfig.NAME) && SparkConfigUtils$.MODULE$.containsConfigProperty(optParams, DataSourceWriteOptions$.MODULE$.TABLE_NAME()) ? translatedOpt.put((Object)HoodieTableConfig.NAME.key(), (Object)SparkConfigUtils$.MODULE$.getStringWithAltKeys((Map<String, String>)optParams, DataSourceWriteOptions$.MODULE$.TABLE_NAME())) : BoxedUnit.UNIT;
        optParams.keySet().foreach((Function1 & Serializable & scala.Serializable)opt -> {
            DataSourceOptionsHelper$.$anonfun$translateConfigurations$1(optParams, translatedOpt, opt);
            return BoxedUnit.UNIT;
        });
        return translatedOpt.toMap(Predef$.MODULE$.$conforms());
    }

    public scala.collection.immutable.Map<String, String> fetchMissingWriteConfigsFromTableConfig(HoodieTableConfig tableConfig, scala.collection.immutable.Map<String, String> params) {
        scala.collection.mutable.Map missingWriteConfigs = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        Object object = !params.contains((Object)KeyGeneratorOptions.RECORDKEY_FIELD_NAME.key()) && tableConfig.getRawRecordKeyFieldProp() != null ? missingWriteConfigs.$plus$plus$eq((TraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KeyGeneratorOptions.RECORDKEY_FIELD_NAME.key()), (Object)tableConfig.getRawRecordKeyFieldProp())}))) : BoxedUnit.UNIT;
        Object object2 = !params.contains((Object)KeyGeneratorOptions.PARTITIONPATH_FIELD_NAME.key()) && HoodieTableConfig.getPartitionFieldPropForKeyGenerator((HoodieConfig)tableConfig).isPresent() ? missingWriteConfigs.$plus$plus$eq((TraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KeyGeneratorOptions.PARTITIONPATH_FIELD_NAME.key()), HoodieTableConfig.getPartitionFieldPropForKeyGenerator((HoodieConfig)tableConfig).get())}))) : BoxedUnit.UNIT;
        Object object3 = !params.contains((Object)DataSourceWriteOptions$.MODULE$.KEYGENERATOR_CLASS_NAME().key()) && tableConfig.getKeyGeneratorClassName() != null ? missingWriteConfigs.$plus$plus$eq((TraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.KEYGENERATOR_CLASS_NAME().key()), (Object)tableConfig.getKeyGeneratorClassName())}))) : BoxedUnit.UNIT;
        Object object4 = !params.contains((Object)HoodieWriteConfig.WRITE_PAYLOAD_CLASS_NAME.key()) && tableConfig.getPayloadClass() != null ? missingWriteConfigs.$plus$plus$eq((TraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.WRITE_PAYLOAD_CLASS_NAME.key()), (Object)tableConfig.getPayloadClass())}))) : BoxedUnit.UNIT;
        Object object5 = !params.contains((Object)HoodieWriteConfig.RECORD_MERGE_MODE.key()) && tableConfig.getRecordMergeMode() != null ? missingWriteConfigs.$plus$plus$eq((TraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.RECORD_MERGE_MODE.key()), (Object)tableConfig.getRecordMergeMode().name())}))) : BoxedUnit.UNIT;
        Object object6 = !params.contains((Object)HoodieWriteConfig.RECORD_MERGE_STRATEGY_ID.key()) && tableConfig.getRecordMergeStrategyId() != null ? missingWriteConfigs.$plus$plus$eq((TraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.RECORD_MERGE_STRATEGY_ID.key()), (Object)tableConfig.getRecordMergeStrategyId())}))) : BoxedUnit.UNIT;
        Object object7 = !params.contains((Object)DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key()) ? missingWriteConfigs.$plus$plus$eq((TraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key()), (Object)tableConfig.getTableType().name())}))) : BoxedUnit.UNIT;
        return missingWriteConfigs.toMap(Predef$.MODULE$.$conforms());
    }

    public scala.collection.immutable.Map<String, String> parametersWithReadDefaults(scala.collection.immutable.Map<String, String> parameters) {
        scala.collection.immutable.Map paramsWithGlobalProps = ((TraversableOnce)JavaConverters$.MODULE$.propertiesAsScalaMapConverter((Properties)DFSPropertiesConfiguration.getGlobalProps()).asScala()).toMap(Predef$.MODULE$.$conforms()).$plus$plus(parameters);
        String queryType = (String)paramsWithGlobalProps.get((Object)"hoodie.query.as.ro.table").map((Function1 & Serializable & scala.Serializable)is -> {
            if (new StringOps(Predef$.MODULE$.augmentString(is)).toBoolean()) {
                return DataSourceReadOptions$.MODULE$.QUERY_TYPE_READ_OPTIMIZED_OPT_VAL();
            }
            return DataSourceReadOptions$.MODULE$.QUERY_TYPE_SNAPSHOT_OPT_VAL();
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> (String)paramsWithGlobalProps.getOrElse((Object)DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), (Function0 & Serializable & scala.Serializable)() -> (String)DataSourceReadOptions$.MODULE$.QUERY_TYPE().defaultValue()));
        return ((MapLike)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceReadOptions$.MODULE$.QUERY_TYPE().key()), (Object)queryType)}))).$plus$plus(this.translateConfigurations((scala.collection.immutable.Map<String, String>)paramsWithGlobalProps));
    }

    public String inferKeyGenClazz(TypedProperties props) {
        return HoodieSparkKeyGeneratorFactory.getKeyGeneratorClassNameFromType((KeyGeneratorType)HoodieSparkKeyGeneratorFactory.inferKeyGeneratorTypeFromWriteConfig((TypedProperties)props));
    }

    public String inferKeyGenClazz(String recordsKeyFields, String partitionFields) {
        return HoodieSparkKeyGeneratorFactory.getKeyGeneratorClassNameFromType((KeyGeneratorType)KeyGenUtils.inferKeyGeneratorType((Option)Option.ofNullable((Object)recordsKeyFields), (String)partitionFields));
    }

    public Option<java.util.List<String>> getPreCombineFields(scala.collection.immutable.Map<String, String> params) {
        Some some;
        String f;
        scala.Option option = params.get((Object)DataSourceWriteOptions$.MODULE$.ORDERING_FIELDS().key());
        if (option instanceof Some && !StringUtils.isNullOrEmpty((String)(f = (String)(some = (Some)option).value()))) {
            return Option.of(Arrays.asList((Object[])f.split(",")));
        }
        return Option.empty();
    }

    public <T, U> ConfigProperty<U> convert(ConfigProperty<T> prop, Function1<T, U> converter) {
        ConfigProperty configProperty;
        ConfigProperty configProperty2;
        ValidationUtils.checkState((boolean)prop.hasDefaultValue());
        ConfigProperty newProp = ConfigProperty.key((String)prop.key()).defaultValue(converter.apply(prop.defaultValue())).withDocumentation(prop.doc()).withAlternatives((String[])((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(prop.getAlternatives()).asScala()).toSeq().toArray(ClassTag$.MODULE$.apply(String.class)));
        scala.Option option = HoodieConversionUtils$.MODULE$.toScalaOption(prop.getSinceVersion());
        if (option instanceof Some) {
            Some some = (Some)option;
            String version = (String)some.value();
            configProperty2 = newProp.sinceVersion(version);
        } else if (None$.MODULE$.equals(option)) {
            configProperty2 = newProp;
        } else {
            throw new MatchError((Object)option);
        }
        newProp = configProperty2;
        scala.Option option2 = HoodieConversionUtils$.MODULE$.toScalaOption(prop.getDeprecatedVersion());
        if (option2 instanceof Some) {
            Some some = (Some)option2;
            String version = (String)some.value();
            configProperty = newProp.deprecatedAfter(version);
        } else if (None$.MODULE$.equals(option2)) {
            configProperty = newProp;
        } else {
            throw new MatchError((Object)option2);
        }
        newProp = configProperty;
        return newProp;
    }

    public static final /* synthetic */ void $anonfun$allAlternatives$1(scala.collection.mutable.Map alterMap$1, ConfigProperty cfg) {
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(cfg.getAlternatives()).asScala()).foreach((Function1 & Serializable & scala.Serializable)alternative -> {
            alterMap$1.update((Object)alternative, (Object)cfg.key());
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$translateConfigurations$1(scala.collection.immutable.Map optParams$1, scala.collection.mutable.Map translatedOpt$1, String opt) {
        BoxedUnit boxedUnit;
        if (MODULE$.allAlternatives().contains((Object)opt) && !optParams$1.contains(MODULE$.allAlternatives().apply((Object)opt))) {
            MODULE$.log().warn(new StringBuilder(66).append(opt).append(" is deprecated and will be removed in a later release; Please use ").append(MODULE$.allAlternatives().apply((Object)opt)).toString());
            String string = opt;
            String string2 = DataSourceReadOptions$.MODULE$.VIEW_TYPE_OPT_KEY();
            boxedUnit = !(string != null ? !string.equals(string2) : string2 != null) ? translatedOpt$1.$plus$plus$eq((TraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(MODULE$.allAlternatives().apply((Object)opt)), MODULE$.viewTypeValueMap().apply(optParams$1.apply((Object)opt)))}))) : translatedOpt$1.$plus$plus$eq((TraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(MODULE$.allAlternatives().apply((Object)opt)), optParams$1.apply((Object)opt))})));
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        if (MODULE$.allDeprecatedConfigs().contains((Object)opt)) {
            MODULE$.log().warn(new StringBuilder(47).append(opt).append(" is deprecated and should never be used anymore").toString());
            return;
        }
    }

    private DataSourceOptionsHelper$() {
        MODULE$ = this;
        this.log = LoggerFactory.getLogger(this.getClass());
        this.allConfigsWithAlternatives = new .colon.colon(DataSourceReadOptions$.MODULE$.QUERY_TYPE(), (List)new .colon.colon(DataSourceWriteOptions$.MODULE$.TABLE_TYPE(), (List)new .colon.colon((Object)HoodieTableConfig.BASE_FILE_FORMAT, (List)new .colon.colon((Object)HoodieTableConfig.LOG_FILE_FORMAT, (List)Nil$.MODULE$))));
        this.allDeprecatedConfigs = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{ConsistencyGuardConfig.ENABLE.key()}));
        scala.collection.mutable.Map alterMap = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.allConfigsWithAlternatives().foreach((Function1 & Serializable & scala.Serializable)cfg -> {
            DataSourceOptionsHelper$.$anonfun$allAlternatives$1(alterMap, cfg);
            return BoxedUnit.UNIT;
        });
        this.allAlternatives = alterMap.toMap(Predef$.MODULE$.$conforms());
        this.viewTypeValueMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceReadOptions$.MODULE$.VIEW_TYPE_READ_OPTIMIZED_OPT_VAL()), (Object)DataSourceReadOptions$.MODULE$.QUERY_TYPE_SNAPSHOT_OPT_VAL()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceReadOptions$.MODULE$.VIEW_TYPE_INCREMENTAL_OPT_VAL()), (Object)DataSourceReadOptions$.MODULE$.QUERY_TYPE_INCREMENTAL_OPT_VAL()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceReadOptions$.MODULE$.VIEW_TYPE_REALTIME_OPT_VAL()), (Object)DataSourceReadOptions$.MODULE$.QUERY_TYPE_SNAPSHOT_OPT_VAL())}));
    }
}

