/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.Function;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.hudi.DataSourceWriteOptions$;
import org.apache.hudi.HoodieCreateRecordUtils;
import org.apache.hudi.HoodieSparkUtils$;
import org.apache.hudi.avro.AvroRecordContext;
import org.apache.hudi.avro.AvroSchemaCache;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordLocation;
import org.apache.hudi.common.model.HoodieSparkRecord;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.read.DeleteContext;
import org.apache.hudi.common.util.ConfigUtils;
import org.apache.hudi.common.util.HoodieRecordUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.OrderingValues;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.keygen.BaseKeyGenerator;
import org.apache.hudi.keygen.SparkKeyGeneratorInterface;
import org.apache.hudi.keygen.constant.KeyGeneratorOptions;
import org.apache.hudi.keygen.factory.HoodieSparkKeyGeneratorFactory;
import org.apache.hudi.util.JFunction$;
import org.apache.spark.TaskContext$;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.HoodieInternalRowUtils$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class HoodieCreateRecordUtils$ {
    public static HoodieCreateRecordUtils$ MODULE$;
    private final Logger log;

    static {
        new HoodieCreateRecordUtils$();
    }

    private Logger log() {
        return this.log;
    }

    public JavaRDD<HoodieRecord<?>> createHoodieRecordRdd(HoodieCreateRecordUtils.createHoodieRecordRddArgs args) {
        Dataset<Row> df = args.df();
        HoodieWriteConfig config = args.config();
        scala.collection.immutable.Map<String, String> parameters = args.parameters();
        String recordName = args.recordName();
        String recordNameSpace = args.recordNameSpace();
        Schema writerSchema = args.writerSchema();
        Schema dataFileSchema = args.dataFileSchema();
        WriteOperationType operation = args.operation();
        String instantTime = args.instantTime();
        boolean preppedSparkSqlWrites = args.preppedSparkSqlWrites();
        boolean preppedSparkSqlMergeInto = args.preppedSparkSqlMergeInto();
        boolean preppedWriteOperation = args.preppedWriteOperation();
        List orderingFields = args.tableConfig().getOrderingFields();
        Boolean shouldDropPartitionColumns = config.getBoolean(DataSourceWriteOptions$.MODULE$.DROP_PARTITION_COLUMNS());
        HoodieRecord.HoodieRecordType recordType = config.getRecordMerger().getRecordType();
        boolean autoGenerateRecordKeys = !((Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(parameters).asJava()).containsKey(KeyGeneratorOptions.RECORDKEY_FIELD_NAME.key());
        BooleanRef shouldCombine = BooleanRef.create((boolean)false);
        shouldCombine.elem = preppedWriteOperation && !preppedSparkSqlWrites && !preppedSparkSqlMergeInto ? false : (!preppedSparkSqlWrites && WriteOperationType.isInsert((WriteOperationType)operation) ? new StringOps(Predef$.MODULE$.augmentString((String)parameters.apply((Object)DataSourceWriteOptions$.MODULE$.INSERT_DROP_DUPS().key()))).toBoolean() || new StringOps(Predef$.MODULE$.augmentString((String)parameters.getOrElse((Object)HoodieWriteConfig.COMBINE_BEFORE_INSERT.key(), (Function0 & Serializable & scala.Serializable)() -> (String)HoodieWriteConfig.COMBINE_BEFORE_INSERT.defaultValue()))).toBoolean() : (!preppedSparkSqlWrites && WriteOperationType.isUpsert((WriteOperationType)operation) ? new StringOps(Predef$.MODULE$.augmentString((String)parameters.getOrElse((Object)HoodieWriteConfig.COMBINE_BEFORE_UPSERT.key(), (Function0 & Serializable & scala.Serializable)() -> (String)HoodieWriteConfig.COMBINE_BEFORE_UPSERT.defaultValue()))).toBoolean() : !preppedSparkSqlWrites));
        boolean usePreppedInsteadOfKeyGen = preppedSparkSqlWrites || preppedWriteOperation;
        String dataFileSchemaStr = dataFileSchema.toString();
        this.log().debug(new StringBuilder(28).append("Creating HoodieRecords (as ").append(recordType).append(")").toString());
        HoodieRecord.HoodieRecordType hoodieRecordType = recordType;
        if (HoodieRecord.HoodieRecordType.AVRO.equals(hoodieRecordType)) {
            RDD avroRecords = HoodieSparkUtils$.MODULE$.createRdd(df, recordName, recordNameSpace, (scala.Option)new Some((Object)writerSchema));
            return avroRecords.mapPartitions((Function1 & Serializable & scala.Serializable)it -> {
                Object object;
                int sparkPartitionId = TaskContext$.MODULE$.getPartitionId();
                TypedProperties keyGenProps = TypedProperties.copy((Properties)config.getProps());
                if (autoGenerateRecordKeys) {
                    keyGenProps.setProperty("_hoodie.record.key.gen.partition.id", String.valueOf(sparkPartitionId));
                    object = keyGenProps.setProperty("_hoodie.record.key.gen.instant.time", instantTime);
                } else {
                    object = BoxedUnit.UNIT;
                }
                None$ keyGenerator = usePreppedInsteadOfKeyGen ? None$.MODULE$ : new Some((Object)((BaseKeyGenerator)HoodieSparkKeyGeneratorFactory.createKeyGenerator((TypedProperties)keyGenProps)));
                Schema dataFileSchema = new Schema.Parser().parse(dataFileSchemaStr);
                boolean consistentLogicalTimestampEnabled = new StringOps(Predef$.MODULE$.augmentString((String)parameters.getOrElse((Object)DataSourceWriteOptions$.MODULE$.KEYGENERATOR_CONSISTENT_LOGICAL_TIMESTAMP_ENABLED().key(), (Function0 & Serializable & scala.Serializable)() -> (String)DataSourceWriteOptions$.MODULE$.KEYGENERATOR_CONSISTENT_LOGICAL_TIMESTAMP_ENABLED().defaultValue()))).toBoolean();
                boolean requiresPayload = WriteOperationType.isChangingRecords((WriteOperationType)operation) && !config.isFileGroupReaderBasedMergeHandle();
                TypedProperties mergeProps = ConfigUtils.getMergeProps((TypedProperties)config.getProps(), (HoodieTableConfig)args.tableConfig());
                DeleteContext deleteContext = new DeleteContext((Properties)mergeProps, writerSchema).withReaderSchema(writerSchema);
                return it.map(arg_0 -> HoodieCreateRecordUtils$.$anonfun$createHoodieRecordRdd$5(deleteContext, (scala.Option)keyGenerator, preppedSparkSqlWrites, preppedWriteOperation, preppedSparkSqlMergeInto, dataFileSchema, shouldDropPartitionColumns, shouldCombine, orderingFields, consistentLogicalTimestampEnabled, config, requiresPayload, arg_0));
            }, avroRecords.mapPartitions$default$2(), ClassTag$.MODULE$.apply(HoodieRecord.class)).toJavaRDD();
        }
        if (HoodieRecord.HoodieRecordType.SPARK.equals(hoodieRecordType)) {
            Schema dataFileSchema2 = AvroSchemaCache.intern((Schema)new Schema.Parser().parse(dataFileSchemaStr));
            StructType dataFileStructType = HoodieInternalRowUtils$.MODULE$.getCachedSchema(dataFileSchema2);
            StructType writerStructType = HoodieInternalRowUtils$.MODULE$.getCachedSchema(AvroSchemaCache.intern((Schema)writerSchema));
            StructType sourceStructType = df.schema();
            return df.queryExecution().toRdd().mapPartitions((Function1 & Serializable & scala.Serializable)it -> {
                StructType structType;
                StructType targetStructType;
                Object object;
                int sparkPartitionId = TaskContext$.MODULE$.getPartitionId();
                TypedProperties keyGenProps = TypedProperties.copy((Properties)config.getProps());
                if (autoGenerateRecordKeys) {
                    keyGenProps.setProperty("_hoodie.record.key.gen.partition.id", String.valueOf(sparkPartitionId));
                    object = keyGenProps.setProperty("_hoodie.record.key.gen.instant.time", instantTime);
                } else {
                    object = BoxedUnit.UNIT;
                }
                None$ sparkKeyGenerator = usePreppedInsteadOfKeyGen ? None$.MODULE$ : new Some((Object)((SparkKeyGeneratorInterface)HoodieSparkKeyGeneratorFactory.createKeyGenerator((TypedProperties)keyGenProps)));
                StructType structType2 = targetStructType = Predef$.MODULE$.Boolean2boolean(shouldDropPartitionColumns) ? dataFileStructType : writerStructType;
                if (preppedSparkSqlWrites || preppedWriteOperation) {
                    Object[] fieldsToExclude = HoodieRecord.HOODIE_META_COLUMNS_WITH_OPERATION.toArray();
                    structType = new StructType((StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])targetStructType.fields())).filterNot((Function1 & Serializable & scala.Serializable)field -> BoxesRunTime.boxToBoolean((boolean)HoodieCreateRecordUtils$.$anonfun$createHoodieRecordRdd$8(fieldsToExclude, field))));
                } else {
                    structType = targetStructType;
                }
                StructType finalStructType = structType;
                Function1 finalStructTypeRowWriter = HoodieInternalRowUtils$.MODULE$.getCachedUnsafeRowWriter(sourceStructType, finalStructType, HoodieInternalRowUtils$.MODULE$.getCachedUnsafeRowWriter$default$3(), HoodieInternalRowUtils$.MODULE$.getCachedUnsafeRowWriter$default$4());
                return it.map(arg_0 -> HoodieCreateRecordUtils$.$anonfun$createHoodieRecordRdd$9((scala.Option)sparkKeyGenerator, sourceStructType, preppedSparkSqlWrites, preppedWriteOperation, preppedSparkSqlMergeInto, finalStructTypeRowWriter, dataFileStructType, arg_0));
            }, df.queryExecution().toRdd().mapPartitions$default$2(), ClassTag$.MODULE$.apply(HoodieSparkRecord.class)).toJavaRDD();
        }
        throw new MatchError((Object)hoodieRecordType);
    }

    public Tuple2<HoodieKey, Option<HoodieRecordLocation>> getHoodieKeyAndMaybeLocationFromAvroRecord(scala.Option<BaseKeyGenerator> keyGenerator, GenericRecord avroRec, boolean useMetaFieldsForRecordKeyAndPartition, boolean fetchRecordLocationFromMetaFields) {
        Option option;
        None$ fileName;
        String recordKey = useMetaFieldsForRecordKeyAndPartition ? avroRec.get(HoodieRecord.RECORD_KEY_METADATA_FIELD).toString() : ((BaseKeyGenerator)keyGenerator.get()).getRecordKey(avroRec);
        String partitionPath = useMetaFieldsForRecordKeyAndPartition ? avroRec.get(HoodieRecord.PARTITION_PATH_METADATA_FIELD).toString() : ((BaseKeyGenerator)keyGenerator.get()).getPartitionPath(avroRec);
        HoodieKey hoodieKey = new HoodieKey(recordKey, partitionPath);
        None$ instantTime = fetchRecordLocationFromMetaFields ? Option$.MODULE$.apply(avroRec.get(HoodieRecord.COMMIT_TIME_METADATA_FIELD)).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.toString()) : None$.MODULE$;
        Object object = fileName = fetchRecordLocationFromMetaFields ? Option$.MODULE$.apply(avroRec.get(HoodieRecord.FILENAME_METADATA_FIELD)).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.toString()) : None$.MODULE$;
        if (instantTime.isDefined() && fileName.isDefined()) {
            String fileId = FSUtils.getFileId((String)((String)fileName.get()));
            option = Option.of((Object)new HoodieRecordLocation((String)instantTime.get(), fileId));
        } else {
            option = Option.empty();
        }
        Option recordLocation = option;
        return new Tuple2((Object)hoodieKey, (Object)recordLocation);
    }

    public Tuple2<HoodieKey, scala.Option<HoodieRecordLocation>> getHoodieKeyAndMayBeLocationFromSparkRecord(scala.Option<SparkKeyGeneratorInterface> sparkKeyGenerator, InternalRow sourceRow, StructType schema, boolean useMetaFieldsForRecordKeyAndPartition, boolean fetchRecordLocationFromMetaFields) {
        None$ none$;
        None$ fileName;
        String recordKey = useMetaFieldsForRecordKeyAndPartition ? sourceRow.getString(HoodieRecord.RECORD_KEY_META_FIELD_ORD) : ((SparkKeyGeneratorInterface)sparkKeyGenerator.get()).getRecordKey(sourceRow, schema).toString();
        String partitionPath = useMetaFieldsForRecordKeyAndPartition ? sourceRow.getString(HoodieRecord.PARTITION_PATH_META_FIELD_ORD) : ((SparkKeyGeneratorInterface)sparkKeyGenerator.get()).getPartitionPath(sourceRow, schema).toString();
        None$ instantTime = fetchRecordLocationFromMetaFields ? Option$.MODULE$.apply((Object)sourceRow.getString(HoodieRecord.COMMIT_TIME_METADATA_FIELD_ORD)) : None$.MODULE$;
        Object object = fileName = fetchRecordLocationFromMetaFields ? Option$.MODULE$.apply((Object)sourceRow.getString(HoodieRecord.FILENAME_META_FIELD_ORD)) : None$.MODULE$;
        if (instantTime.isDefined() && fileName.isDefined()) {
            String fileId = FSUtils.getFileId((String)((String)fileName.get()));
            none$ = new Some((Object)new HoodieRecordLocation((String)instantTime.get(), fileId));
        } else {
            none$ = None$.MODULE$;
        }
        None$ recordLocation = none$;
        return new Tuple2((Object)new HoodieKey(recordKey, partitionPath), (Object)recordLocation);
    }

    public static final /* synthetic */ HoodieRecord $anonfun$createHoodieRecordRdd$5(DeleteContext deleteContext$1, scala.Option keyGenerator$1, boolean preppedSparkSqlWrites$1, boolean preppedWriteOperation$1, boolean preppedSparkSqlMergeInto$1, Schema dataFileSchema$1, Boolean shouldDropPartitionColumns$1, BooleanRef shouldCombine$1, List orderingFields$1, boolean consistentLogicalTimestampEnabled$1, HoodieWriteConfig config$1, boolean requiresPayload$1, GenericRecord avroRec) {
        HoodieRecord hoodieRecord;
        GenericRecord processedRecord;
        HoodieKey hoodieKey;
        Option recordLocation;
        boolean isDelete;
        block6: {
            Tuple2<HoodieKey, Option<HoodieRecordLocation>> tuple2;
            block5: {
                isDelete = AvroRecordContext.getFieldAccessorInstance().isDeleteRecord((Object)avroRec, deleteContext$1);
                tuple2 = MODULE$.getHoodieKeyAndMaybeLocationFromAvroRecord((scala.Option<BaseKeyGenerator>)keyGenerator$1, avroRec, preppedSparkSqlWrites$1 || preppedWriteOperation$1, preppedSparkSqlWrites$1 || preppedWriteOperation$1 || preppedSparkSqlMergeInto$1);
                if (tuple2 == null) break block5;
                HoodieKey hoodieKey2 = (HoodieKey)tuple2._1();
                recordLocation = (Option)tuple2._2();
                if (hoodieKey2 == null) break block5;
                hoodieKey = hoodieKey2;
                if (recordLocation != null) break block6;
            }
            throw new MatchError(tuple2);
        }
        Option option = recordLocation;
        Tuple2 tuple2 = new Tuple2((Object)hoodieKey, (Object)option);
        HoodieKey hoodieKey3 = (HoodieKey)tuple2._1();
        Option recordLocation2 = (Option)tuple2._2();
        GenericRecord avroRecWithoutMeta = preppedSparkSqlWrites$1 || preppedSparkSqlMergeInto$1 || preppedWriteOperation$1 ? HoodieAvroUtils.rewriteRecord((GenericRecord)avroRec, (Schema)HoodieAvroUtils.removeMetadataFields((Schema)dataFileSchema$1)) : avroRec;
        GenericRecord genericRecord = processedRecord = Predef$.MODULE$.Boolean2boolean(shouldDropPartitionColumns$1) ? HoodieAvroUtils.rewriteRecord((GenericRecord)avroRecWithoutMeta, (Schema)dataFileSchema$1) : avroRecWithoutMeta;
        if (shouldCombine$1.elem && !orderingFields$1.isEmpty()) {
            Comparable orderingVal = OrderingValues.create((List)orderingFields$1, (Function)JFunction$.MODULE$.toJavaFunction((Function1 & Serializable & scala.Serializable)field -> (Comparable)HoodieAvroUtils.getNestedFieldVal((GenericRecord)avroRec, (String)field, (boolean)false, (boolean)consistentLogicalTimestampEnabled$1)));
            hoodieRecord = HoodieRecordUtils.createHoodieRecord((GenericRecord)processedRecord, (Comparable)orderingVal, (HoodieKey)hoodieKey3, (String)config$1.getPayloadClass(), null, (Option)recordLocation2, (boolean)requiresPayload$1, (Boolean)Predef$.MODULE$.boolean2Boolean(isDelete));
        } else {
            hoodieRecord = HoodieRecordUtils.createHoodieRecord((GenericRecord)processedRecord, (HoodieKey)hoodieKey3, (String)config$1.getPayloadClass(), (Option)recordLocation2, (boolean)requiresPayload$1, (Boolean)Predef$.MODULE$.boolean2Boolean(isDelete));
        }
        HoodieRecord hoodieRecord2 = hoodieRecord;
        return hoodieRecord2;
    }

    public static final /* synthetic */ boolean $anonfun$createHoodieRecordRdd$8(Object[] fieldsToExclude$1, StructField field) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(fieldsToExclude$1)).contains((Object)field.name());
    }

    public static final /* synthetic */ HoodieSparkRecord $anonfun$createHoodieRecordRdd$9(scala.Option sparkKeyGenerator$1, StructType sourceStructType$1, boolean preppedSparkSqlWrites$1, boolean preppedWriteOperation$1, boolean preppedSparkSqlMergeInto$1, Function1 finalStructTypeRowWriter$1, StructType dataFileStructType$1, InternalRow sourceRow) {
        HoodieKey hoodieKey;
        scala.Option recordLocation;
        block3: {
            Tuple2<HoodieKey, scala.Option<HoodieRecordLocation>> tuple2;
            block2: {
                tuple2 = MODULE$.getHoodieKeyAndMayBeLocationFromSparkRecord((scala.Option<SparkKeyGeneratorInterface>)sparkKeyGenerator$1, sourceRow, sourceStructType$1, preppedSparkSqlWrites$1 || preppedWriteOperation$1, preppedSparkSqlWrites$1 || preppedWriteOperation$1 || preppedSparkSqlMergeInto$1);
                if (tuple2 == null) break block2;
                HoodieKey key = (HoodieKey)tuple2._1();
                recordLocation = (scala.Option)tuple2._2();
                if (key == null) break block2;
                hoodieKey = key;
                if (recordLocation != null) break block3;
            }
            throw new MatchError(tuple2);
        }
        scala.Option option = recordLocation;
        Tuple2 tuple2 = new Tuple2((Object)hoodieKey, (Object)option);
        HoodieKey key = (HoodieKey)tuple2._1();
        scala.Option recordLocation2 = (scala.Option)tuple2._2();
        UnsafeRow targetRow = (UnsafeRow)finalStructTypeRowWriter$1.apply((Object)sourceRow);
        HoodieSparkRecord hoodieSparkRecord = new HoodieSparkRecord(key, (InternalRow)targetRow, dataFileStructType$1, false);
        Object object = recordLocation2.isDefined() ? hoodieSparkRecord.setCurrentLocation((HoodieRecordLocation)recordLocation2.get()) : BoxedUnit.UNIT;
        return hoodieSparkRecord;
    }

    private HoodieCreateRecordUtils$() {
        MODULE$ = this;
        this.log = LoggerFactory.getLogger(this.getClass());
    }
}

