/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.DataSourceWriteOptions$;
import org.apache.hudi.HoodieSparkSqlWriter;
import org.apache.hudi.HoodieSparkSqlWriter$;
import org.apache.hudi.HoodieStreamingSink$;
import org.apache.hudi.async.AsyncClusteringService;
import org.apache.hudi.async.AsyncCompactService;
import org.apache.hudi.async.SparkStreamingAsyncClusteringService;
import org.apache.hudi.async.SparkStreamingAsyncCompactService;
import org.apache.hudi.client.BaseHoodieWriteClient;
import org.apache.hudi.client.SparkRDDWriteClient;
import org.apache.hudi.client.common.HoodieSparkEngineContext;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.marker.MarkerType;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.util.ClusteringUtils;
import org.apache.hudi.common.util.CommitUtils;
import org.apache.hudi.common.util.CompactionUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieCorruptedDataException;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.TableNotFoundException;
import org.apache.hudi.hadoop.fs.HadoopFSUtils;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.connector.catalog.TableCapability;
import org.apache.spark.sql.execution.streaming.Sink;
import org.apache.spark.sql.execution.streaming.StreamExecution$;
import org.apache.spark.sql.streaming.OutputMode;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple6;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ObjectRef;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\t}g\u0001B\u001d;\u0001\u0005C\u0001\u0002\u0018\u0001\u0003\u0002\u0003\u0006I!\u0018\u0005\tC\u0002\u0011\t\u0011)A\u0005E\"A\u0001\u000f\u0001B\u0001B\u0003%\u0011\u000f\u0003\u0005{\u0001\t\u0005\t\u0015!\u0003|\u0011\u001d\t\t\u0001\u0001C\u0001\u0003\u0007A\u0011\"!\u0005\u0001\u0001\u0004%I!a\u0005\t\u0013\u0005m\u0001\u00011A\u0005\n\u0005u\u0001\u0002CA\u0015\u0001\u0001\u0006K!!\u0006\t\u0013\u0005M\u0002A1A\u0005\n\u0005U\u0002\u0002CA\"\u0001\u0001\u0006I!a\u000e\t\u0013\u0005\u0015\u0003A1A\u0005\n\u0005\u001d\u0003\u0002CA(\u0001\u0001\u0006I!!\u0013\t\u0013\u0005E\u0003\u00011A\u0005\n\u0005M\u0003\"CA4\u0001\u0001\u0007I\u0011BA5\u0011!\ti\u0007\u0001Q!\n\u0005U\u0003\"CA8\u0001\t\u0007I\u0011BA9\u0011!\tI\b\u0001Q\u0001\n\u0005M\u0004\"CA>\u0001\t\u0007I\u0011BA\n\u0011!\ti\b\u0001Q\u0001\n\u0005U\u0001\"CA@\u0001\t\u0007I\u0011BAA\u0011!\tI\t\u0001Q\u0001\n\u0005\r\u0005\"CAF\u0001\t\u0007I\u0011BAA\u0011!\ti\t\u0001Q\u0001\n\u0005\r\u0005\"CAH\u0001\u0001\u0007I\u0011BAA\u0011%\t\t\n\u0001a\u0001\n\u0013\t\u0019\n\u0003\u0005\u0002\u0018\u0002\u0001\u000b\u0015BAB\u0011%\tI\n\u0001a\u0001\n\u0013\t\t\tC\u0005\u0002\u001c\u0002\u0001\r\u0011\"\u0003\u0002\u001e\"A\u0011\u0011\u0015\u0001!B\u0013\t\u0019\tC\u0005\u0002$\u0002\u0011\r\u0011\"\u0003\u0002&\"A\u0011Q\u0016\u0001!\u0002\u0013\t9\u000bC\u0006\u00020\u0002\u0001\r\u00111A\u0005\n\u0005E\u0006bCA`\u0001\u0001\u0007\t\u0019!C\u0005\u0003\u0003D1\"!2\u0001\u0001\u0004\u0005\t\u0015)\u0003\u00024\"Y\u0011q\u0019\u0001A\u0002\u0003\u0007I\u0011BAe\u0011-\t\t\u000e\u0001a\u0001\u0002\u0004%I!a5\t\u0017\u0005]\u0007\u00011A\u0001B\u0003&\u00111\u001a\u0005\n\u00033\u0004\u0001\u0019!C\u0005\u00037D\u0011B!\u0002\u0001\u0001\u0004%IAa\u0002\t\u0011\u0005U\b\u0001)Q\u0005\u0003;D\u0011B!\u0006\u0001\u0001\u0004%IAa\u0006\t\u0013\t\u0005\u0002\u00011A\u0005\n\t\r\u0002\u0002\u0003B\u0014\u0001\u0001\u0006KA!\u0007\t\u000f\t%\u0002\u0001\"\u0011\u0003,!9!\u0011\u000b\u0001\u0005B\tM\u0003b\u0002B+\u0001\u0011%!q\u000b\u0005\b\u0005\u001f\u0003A\u0011\u0003BI\u0011\u001d\u0011y\n\u0001C\t\u0005CCqAa,\u0001\t\u0013\u0011\t\fC\u0004\u00038\u0002!IA!/\b\u000f\t\r'\b#\u0001\u0003F\u001a1\u0011H\u000fE\u0001\u0005\u000fDq!!\u00015\t\u0003\u0011y\rC\u0005\u0003RR\u0012\r\u0011\"\u0001\u0003T\"A!\u0011\u001c\u001b!\u0002\u0013\u0011)\u000eC\u0005\u0003\\R\n\t\u0011\"\u0003\u0003^\n\u0019\u0002j\\8eS\u0016\u001cFO]3b[&twmU5oW*\u00111\bP\u0001\u0005QV$\u0017N\u0003\u0002>}\u00051\u0011\r]1dQ\u0016T\u0011aP\u0001\u0004_J<7\u0001A\n\u0005\u0001\tSe\u000b\u0005\u0002D\u00116\tAI\u0003\u0002F\r\u0006!A.\u00198h\u0015\u00059\u0015\u0001\u00026bm\u0006L!!\u0013#\u0003\r=\u0013'.Z2u!\tYE+D\u0001M\u0015\tie*A\u0005tiJ,\u0017-\\5oO*\u0011q\nU\u0001\nKb,7-\u001e;j_:T!!\u0015*\u0002\u0007M\fHN\u0003\u0002Ty\u0005)1\u000f]1sW&\u0011Q\u000b\u0014\u0002\u0005'&t7\u000e\u0005\u0002X56\t\u0001LC\u0001Z\u0003\u0015\u00198-\u00197b\u0013\tY\u0006L\u0001\u0007TKJL\u0017\r\\5{C\ndW-\u0001\u0006tc2\u001cuN\u001c;fqR\u0004\"AX0\u000e\u0003AK!\u0001\u0019)\u0003\u0015M\u000bFjQ8oi\u0016DH/A\u0004paRLwN\\:\u0011\t\rTW.\u001c\b\u0003I\"\u0004\"!\u001a-\u000e\u0003\u0019T!a\u001a!\u0002\rq\u0012xn\u001c;?\u0013\tI\u0007,\u0001\u0004Qe\u0016$WMZ\u0005\u0003W2\u00141!T1q\u0015\tI\u0007\f\u0005\u0002d]&\u0011q\u000e\u001c\u0002\u0007'R\u0014\u0018N\\4\u0002!A\f'\u000f^5uS>t7i\u001c7v[:\u001c\bc\u0001:x[:\u00111/\u001e\b\u0003KRL\u0011!W\u0005\u0003mb\u000bq\u0001]1dW\u0006<W-\u0003\u0002ys\n\u00191+Z9\u000b\u0005YD\u0016AC8viB,H/T8eKB\u0011AP`\u0007\u0002{*\u0011Q\nU\u0005\u0003\u007fv\u0014!bT;uaV$Xj\u001c3f\u0003\u0019a\u0014N\\5u}QQ\u0011QAA\u0005\u0003\u0017\ti!a\u0004\u0011\u0007\u0005\u001d\u0001!D\u0001;\u0011\u0015aV\u00011\u0001^\u0011\u0015\tW\u00011\u0001c\u0011\u0015\u0001X\u00011\u0001r\u0011\u0015QX\u00011\u0001|\u0003Ya\u0017\r^3ti\u000e{W.\\5ui\u0016$')\u0019;dQ&#WCAA\u000b!\r9\u0016qC\u0005\u0004\u00033A&\u0001\u0002'p]\u001e\f!\u0004\\1uKN$8i\\7nSR$X\r\u001a\"bi\u000eD\u0017\nZ0%KF$B!a\b\u0002&A\u0019q+!\t\n\u0007\u0005\r\u0002L\u0001\u0003V]&$\b\"CA\u0014\u000f\u0005\u0005\t\u0019AA\u000b\u0003\rAH%M\u0001\u0018Y\u0006$Xm\u001d;D_6l\u0017\u000e\u001e;fI\n\u000bGo\u00195JI\u0002B3\u0001CA\u0017!\r9\u0016qF\u0005\u0004\u0003cA&\u0001\u0003<pY\u0006$\u0018\u000e\\3\u0002\u00071|w-\u0006\u0002\u00028A!\u0011\u0011HA \u001b\t\tYDC\u0002\u0002>y\nQa\u001d7gi)LA!!\u0011\u0002<\t1Aj\\4hKJ\fA\u0001\\8hA\u0005IA/\u00192mKB\u000bG\u000f[\u000b\u0003\u0003\u0013\u0002BaVA&[&\u0019\u0011Q\n-\u0003\r=\u0003H/[8o\u0003)!\u0018M\u00197f!\u0006$\b\u000eI\u0001\u000b[\u0016$\u0018m\u00117jK:$XCAA+!\u00159\u00161JA,!\u0011\tI&a\u0019\u000e\u0005\u0005m#\u0002BA/\u0003?\nQ\u0001^1cY\u0016T1!!\u0019;\u0003\u0019\u0019w.\\7p]&!\u0011QMA.\u0005UAun\u001c3jKR\u000b'\r\\3NKR\f7\t\\5f]R\fa\"\\3uC\u000ec\u0017.\u001a8u?\u0012*\u0017\u000f\u0006\u0003\u0002 \u0005-\u0004\"CA\u0014\u001d\u0005\u0005\t\u0019AA+\u0003-iW\r^1DY&,g\u000e\u001e\u0011\u0002\u0011I,GO]=D]R,\"!a\u001d\u0011\u0007]\u000b)(C\u0002\u0002xa\u00131!\u00138u\u0003%\u0011X\r\u001e:z\u0007:$\b%A\bsKR\u0014\u00180\u00138uKJ4\u0018\r\\'t\u0003A\u0011X\r\u001e:z\u0013:$XM\u001d<bY6\u001b\b%A\tjO:|'/\u001a$bS2,GMQ1uG\",\"!a!\u0011\u0007]\u000b))C\u0002\u0002\bb\u0013qAQ8pY\u0016\fg.\u0001\njO:|'/\u001a$bS2,GMQ1uG\"\u0004\u0013!\u00053jg\u0006\u0014G.Z\"p[B\f7\r^5p]\u0006\u0011B-[:bE2,7i\\7qC\u000e$\u0018n\u001c8!\u0003%J7/Q:z]\u000e\u001cu.\u001c9bGR|'oU3sm&\u001cWm\u00155vi\u0012|wO\\!c]>\u0014X.\u00197ms\u0006i\u0013n]!ts:\u001c7i\\7qC\u000e$xN]*feZL7-Z*ikR$wn\u001e8BE:|'/\\1mYf|F%Z9\u0015\t\u0005}\u0011Q\u0013\u0005\n\u0003OI\u0012\u0011!a\u0001\u0003\u0007\u000b!&[:Bgft7mQ8na\u0006\u001cGo\u001c:TKJ4\u0018nY3TQV$Hm\\<o\u0003\ntwN]7bY2L\b%\u0001\u0016jg\u0006\u001b\u0018P\\2DYV\u001cH/\u001a:j]\u001e\u001cVM\u001d<jG\u0016\u001c\u0006.\u001e;e_^t\u0017I\u00198pe6\fG\u000e\\=\u0002]%\u001c\u0018i]=oG\u000ecWo\u001d;fe&twmU3sm&\u001cWm\u00155vi\u0012|wO\\!c]>\u0014X.\u00197ms~#S-\u001d\u000b\u0005\u0003?\ty\nC\u0005\u0002(q\t\t\u00111\u0001\u0002\u0004\u0006Y\u0013n]!ts:\u001c7\t\\;ti\u0016\u0014\u0018N\\4TKJ4\u0018nY3TQV$Hm\\<o\u0003\ntwN]7bY2L\b%\u0001\u0003n_\u0012,WCAAT!\rq\u0016\u0011V\u0005\u0004\u0003W\u0003&\u0001C*bm\u0016lu\u000eZ3\u0002\u000b5|G-\u001a\u0011\u0002+\u0005\u001c\u0018P\\2D_6\u0004\u0018m\u0019;peN+'O^5dKV\u0011\u00111\u0017\t\u0005\u0003k\u000bY,\u0004\u0002\u00028*\u0019\u0011\u0011\u0018\u001e\u0002\u000b\u0005\u001c\u0018P\\2\n\t\u0005u\u0016q\u0017\u0002\u0014\u0003NLhnY\"p[B\f7\r^*feZL7-Z\u0001\u001aCNLhnY\"p[B\f7\r^8s'\u0016\u0014h/[2f?\u0012*\u0017\u000f\u0006\u0003\u0002 \u0005\r\u0007\"CA\u0014C\u0005\u0005\t\u0019AAZ\u0003Y\t7/\u001f8d\u0007>l\u0007/Y2u_J\u001cVM\u001d<jG\u0016\u0004\u0013AF1ts:\u001c7\t\\;ti\u0016\u0014\u0018N\\4TKJ4\u0018nY3\u0016\u0005\u0005-\u0007\u0003BA[\u0003\u001bLA!a4\u00028\n1\u0012i]=oG\u000ecWo\u001d;fe&twmU3sm&\u001cW-\u0001\u000ebgft7m\u00117vgR,'/\u001b8h'\u0016\u0014h/[2f?\u0012*\u0017\u000f\u0006\u0003\u0002 \u0005U\u0007\"CA\u0014I\u0005\u0005\t\u0019AAf\u0003]\t7/\u001f8d\u00072,8\u000f^3sS:<7+\u001a:wS\u000e,\u0007%A\u0006xe&$Xm\u00117jK:$XCAAo!\u00159\u00161JApa\u0011\t\t/!=\u0011\r\u0005\r\u0018\u0011^Aw\u001b\t\t)OC\u0002\u0002hj\naa\u00197jK:$\u0018\u0002BAv\u0003K\u00141c\u00159be.\u0014F\tR,sSR,7\t\\5f]R\u0004B!a<\u0002r2\u0001AaCAzQ\u0005\u0005\t\u0011!B\u0001\u0003o\u00141a\u0018\u00132\u000319(/\u001b;f\u00072LWM\u001c;!#\u0011\tI0a@\u0011\u0007]\u000bY0C\u0002\u0002~b\u0013qAT8uQ&tw\rE\u0002X\u0005\u0003I1Aa\u0001Y\u0005\r\te._\u0001\u0010oJLG/Z\"mS\u0016tGo\u0018\u0013fcR!\u0011q\u0004B\u0005\u0011%\t9cJA\u0001\u0002\u0004\u0011Y\u0001E\u0003X\u0003\u0017\u0012i\u0001\r\u0003\u0003\u0010\tM\u0001CBAr\u0003S\u0014\t\u0002\u0005\u0003\u0002p\nMA\u0001DAz\u0005\u0013\t\t\u0011!A\u0003\u0002\u0005]\u0018!\u00055p_\u0012LW\rV1cY\u0016\u001cuN\u001c4jOV\u0011!\u0011\u0004\t\u0006/\u0006-#1\u0004\t\u0005\u00033\u0012i\"\u0003\u0003\u0003 \u0005m#!\u0005%p_\u0012LW\rV1cY\u0016\u001cuN\u001c4jO\u0006)\u0002n\\8eS\u0016$\u0016M\u00197f\u0007>tg-[4`I\u0015\fH\u0003BA\u0010\u0005KA\u0011\"a\n+\u0003\u0003\u0005\rA!\u0007\u0002%!|w\u000eZ5f)\u0006\u0014G.Z\"p]\u001aLw\rI\u0001\tC\u0012$')\u0019;dQR1\u0011q\u0004B\u0017\u0005cAqAa\f-\u0001\u0004\t)\"A\u0004cCR\u001c\u0007.\u00133\t\u000f\tMB\u00061\u0001\u00036\u0005!A-\u0019;b!\u0011\u00119Da\u0013\u000f\t\te\"\u0011\n\b\u0005\u0005w\u00119E\u0004\u0003\u0003>\t\u0015c\u0002\u0002B \u0005\u0007r1!\u001aB!\u0013\u0005y\u0014BA\u001f?\u0013\t\u0019F(\u0003\u0002R%&\u0011a\u000fU\u0005\u0005\u0005\u001b\u0012yEA\u0005ECR\fgI]1nK*\u0011a\u000fU\u0001\ti>\u001cFO]5oOR\tQ.A\u0003sKR\u0014\u00180\u0006\u0003\u0003Z\t-DC\u0002B.\u0005s\u0012i\b\u0006\u0003\u0003^\t=\u0004C\u0002B0\u0005K\u0012I'\u0004\u0002\u0003b)\u0019!1\r-\u0002\tU$\u0018\u000e\\\u0005\u0005\u0005O\u0012\tGA\u0002Uef\u0004B!a<\u0003l\u00119!Q\u000e\u0018C\u0002\u0005](!\u0001+\t\u0011\tEd\u0006\"a\u0001\u0005g\n!A\u001a8\u0011\u000b]\u0013)H!\u0018\n\u0007\t]\u0004L\u0001\u0005=Eft\u0017-\\3?\u0011\u001d\u0011YH\fa\u0001\u0003g\n\u0011A\u001c\u0005\b\u0005\u007fr\u0003\u0019AA\u000b\u000319\u0018-\u001b;J]6KG\u000e\\5tQ\rq#1\u0011\t\u0005\u0005\u000b\u0013Y)\u0004\u0002\u0003\b*\u0019!\u0011\u0012-\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003\u000e\n\u001d%a\u0002;bS2\u0014XmY\u0001\u0016iJLwmZ3s\u0003NLhnY\"p[B\f7\r^8s)\u0011\tyBa%\t\u000f\u0005\u001dx\u00061\u0001\u0003\u0016B\"!q\u0013BN!\u0019\t\u0019/!;\u0003\u001aB!\u0011q\u001eBN\t1\u0011iJa%\u0002\u0002\u0003\u0005)\u0011AA|\u0005\ryFEM\u0001\u0017iJLwmZ3s\u0003NLhnY\"mkN$XM]5oOR!\u0011q\u0004BR\u0011\u001d\t9\u000f\ra\u0001\u0005K\u0003DAa*\u0003,B1\u00111]Au\u0005S\u0003B!a<\u0003,\u0012a!Q\u0016BR\u0003\u0003\u0005\tQ!\u0001\u0002x\n\u0019q\fJ\u001a\u0002\u000bI,7/\u001a;\u0015\t\u0005}!1\u0017\u0005\b\u0005k\u000b\u0004\u0019AAB\u0003\u00151wN]2f\u00031\u0019\u0017M\\*lSB\u0014\u0015\r^2i)\u0019\t\u0019Ia/\u0003@\"9!Q\u0018\u001aA\u0002\u0005U\u0011aD5oG>l\u0017N\\4CCR\u001c\u0007.\u00133\t\r\t\u0005'\u00071\u0001n\u00035y\u0007/\u001a:bi&|g\u000eV=qK\u0006\u0019\u0002j\\8eS\u0016\u001cFO]3b[&twmU5oWB\u0019\u0011q\u0001\u001b\u0014\tQ\u0012IM\u0016\t\u0004/\n-\u0017b\u0001Bg1\n1\u0011I\\=SK\u001a$\"A!2\u0002'MKejS0D\u0011\u0016\u001b5\nU(J\u001dR{6*R-\u0016\u0005\tU\u0007cA\"\u0003X&\u0011q\u000eR\u0001\u0015'&s5jX\"I\u000b\u000e[\u0005kT%O)~[U)\u0017\u0011\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0002\u0005\u0002")
public class HoodieStreamingSink
implements Sink,
scala.Serializable {
    private final SQLContext sqlContext;
    public final Map<String, String> org$apache$hudi$HoodieStreamingSink$$options;
    private volatile long latestCommittedBatchId;
    private final Logger org$apache$hudi$HoodieStreamingSink$$log;
    private final scala.Option<String> tablePath;
    private scala.Option<HoodieTableMetaClient> metaClient;
    private final int retryCnt;
    private final long retryIntervalMs;
    private final boolean ignoreFailedBatch;
    private final boolean disableCompaction;
    private boolean org$apache$hudi$HoodieStreamingSink$$isAsyncCompactorServiceShutdownAbnormally;
    private boolean org$apache$hudi$HoodieStreamingSink$$isAsyncClusteringServiceShutdownAbnormally;
    private final SaveMode mode;
    private AsyncCompactService asyncCompactorService;
    private AsyncClusteringService asyncClusteringService;
    private scala.Option<SparkRDDWriteClient<?>> writeClient;
    private scala.Option<HoodieTableConfig> hoodieTableConfig;

    public static String SINK_CHECKPOINT_KEY() {
        return HoodieStreamingSink$.MODULE$.SINK_CHECKPOINT_KEY();
    }

    public String name() {
        return Sink.name$((Sink)this);
    }

    public StructType schema() {
        return Sink.schema$((Sink)this);
    }

    public Set<TableCapability> capabilities() {
        return Sink.capabilities$((Sink)this);
    }

    private long latestCommittedBatchId() {
        return this.latestCommittedBatchId;
    }

    private void latestCommittedBatchId_$eq(long x$1) {
        this.latestCommittedBatchId = x$1;
    }

    public Logger org$apache$hudi$HoodieStreamingSink$$log() {
        return this.org$apache$hudi$HoodieStreamingSink$$log;
    }

    private scala.Option<String> tablePath() {
        return this.tablePath;
    }

    private scala.Option<HoodieTableMetaClient> metaClient() {
        return this.metaClient;
    }

    private void metaClient_$eq(scala.Option<HoodieTableMetaClient> x$1) {
        this.metaClient = x$1;
    }

    private int retryCnt() {
        return this.retryCnt;
    }

    private long retryIntervalMs() {
        return this.retryIntervalMs;
    }

    private boolean ignoreFailedBatch() {
        return this.ignoreFailedBatch;
    }

    private boolean disableCompaction() {
        return this.disableCompaction;
    }

    private boolean org$apache$hudi$HoodieStreamingSink$$isAsyncCompactorServiceShutdownAbnormally() {
        return this.org$apache$hudi$HoodieStreamingSink$$isAsyncCompactorServiceShutdownAbnormally;
    }

    public void org$apache$hudi$HoodieStreamingSink$$isAsyncCompactorServiceShutdownAbnormally_$eq(boolean x$1) {
        this.org$apache$hudi$HoodieStreamingSink$$isAsyncCompactorServiceShutdownAbnormally = x$1;
    }

    private boolean org$apache$hudi$HoodieStreamingSink$$isAsyncClusteringServiceShutdownAbnormally() {
        return this.org$apache$hudi$HoodieStreamingSink$$isAsyncClusteringServiceShutdownAbnormally;
    }

    public void org$apache$hudi$HoodieStreamingSink$$isAsyncClusteringServiceShutdownAbnormally_$eq(boolean x$1) {
        this.org$apache$hudi$HoodieStreamingSink$$isAsyncClusteringServiceShutdownAbnormally = x$1;
    }

    private SaveMode mode() {
        return this.mode;
    }

    private AsyncCompactService asyncCompactorService() {
        return this.asyncCompactorService;
    }

    private void asyncCompactorService_$eq(AsyncCompactService x$1) {
        this.asyncCompactorService = x$1;
    }

    private AsyncClusteringService asyncClusteringService() {
        return this.asyncClusteringService;
    }

    private void asyncClusteringService_$eq(AsyncClusteringService x$1) {
        this.asyncClusteringService = x$1;
    }

    private scala.Option<SparkRDDWriteClient<?>> writeClient() {
        return this.writeClient;
    }

    private void writeClient_$eq(scala.Option<SparkRDDWriteClient<?>> x$1) {
        this.writeClient = x$1;
    }

    private scala.Option<HoodieTableConfig> hoodieTableConfig() {
        return this.hoodieTableConfig;
    }

    private void hoodieTableConfig_$eq(scala.Option<HoodieTableConfig> x$1) {
        this.hoodieTableConfig = x$1;
    }

    public synchronized void addBatch(long batchId, Dataset<Row> data) {
        Try try_;
        if (this.org$apache$hudi$HoodieStreamingSink$$isAsyncCompactorServiceShutdownAbnormally()) {
            throw new IllegalStateException("Async Compactor shutdown unexpectedly");
        }
        if (this.org$apache$hudi$HoodieStreamingSink$$isAsyncClusteringServiceShutdownAbnormally()) {
            this.org$apache$hudi$HoodieStreamingSink$$log().error("Async clustering service shutdown unexpectedly");
            throw new IllegalStateException("Async clustering service shutdown unexpectedly");
        }
        String queryId = this.sqlContext.sparkContext().getLocalProperty(StreamExecution$.MODULE$.QUERY_ID_KEY());
        ValidationUtils.checkArgument((queryId != null ? 1 : 0) != 0, (String)"queryId is null");
        if (this.metaClient().isDefined() && this.canSkipBatch(batchId, (String)this.org$apache$hudi$HoodieStreamingSink$$options.getOrElse((Object)DataSourceWriteOptions$.MODULE$.OPERATION().key(), (Function0 & Serializable & scala.Serializable)() -> DataSourceWriteOptions$.MODULE$.UPSERT_OPERATION_OPT_VAL()))) {
            this.org$apache$hudi$HoodieStreamingSink$$log().info(new StringBuilder(43).append("Skipping already completed batch ").append(batchId).append(" in query ").append(queryId).toString());
            return;
        }
        ObjectRef updatedOptions = ObjectRef.create((Object)this.org$apache$hudi$HoodieStreamingSink$$options.updated((Object)HoodieWriteConfig.MARKERS_TYPE.key(), (Object)MarkerType.DIRECT.name()));
        updatedOptions.elem = ((Map)updatedOptions.elem).updated((Object)HoodieWriteConfig.AUTO_ADJUST_LOCK_CONFIGS.key(), (Object)"true");
        updatedOptions.elem = ((Map)updatedOptions.elem).updated((Object)HoodieSparkSqlWriter$.MODULE$.SPARK_STREAMING_BATCH_ID(), (Object)Long.toString(batchId));
        if (!this.org$apache$hudi$HoodieStreamingSink$$options.contains((Object)HoodieWriteConfig.EMBEDDED_TIMELINE_SERVER_ENABLE.key())) {
            updatedOptions.elem = ((Map)updatedOptions.elem).updated((Object)HoodieWriteConfig.EMBEDDED_TIMELINE_SERVER_ENABLE.key(), (Object)" false");
        }
        if ((try_ = this.retry(this.retryCnt(), this.retryIntervalMs(), (Function0 & Serializable & scala.Serializable)() -> {
            Tuple6 tuple6;
            boolean bl = false;
            Success success = null;
            Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> HoodieSparkSqlWriter$.MODULE$.write($this.sqlContext, this.mode(), (Map<String, String>)((Map)updatedOptions$1.elem), data, (scala.Option<HoodieSparkSqlWriter.StreamingWriteParams>)new Some((Object)new HoodieSparkSqlWriter.StreamingWriteParams(this.hoodieTableConfig(), (scala.Option<Function1<SparkRDDWriteClient<?>, BoxedUnit>>)(this.disableCompaction() ? None$.MODULE$ : new Some((Function1 & Serializable & scala.Serializable)client -> {
                this.triggerAsyncCompactor(client);
                return BoxedUnit.UNIT;
            })), (scala.Option<Function1<SparkRDDWriteClient<?>, BoxedUnit>>)new Some((Function1 & Serializable & scala.Serializable)client -> {
                this.triggerAsyncClustering(client);
                return BoxedUnit.UNIT;
            }), (scala.Option<BiConsumer<HoodieTableMetaClient, HoodieCommitMetadata>>)new Some((Object)new BiConsumer<HoodieTableMetaClient, HoodieCommitMetadata>(this, batchId){
                private final /* synthetic */ HoodieStreamingSink $outer;
                private final long batchId$1;

                public BiConsumer<HoodieTableMetaClient, HoodieCommitMetadata> andThen(BiConsumer<? super HoodieTableMetaClient, ? super HoodieCommitMetadata> x$1) {
                    return BiConsumer.super.andThen(x$1);
                }

                public void accept(HoodieTableMetaClient metaClient, HoodieCommitMetadata newCommitMetadata) {
                    String identifier = (String)this.$outer.org$apache$hudi$HoodieStreamingSink$$options.getOrElse((Object)DataSourceWriteOptions$.MODULE$.STREAMING_CHECKPOINT_IDENTIFIER().key(), (Function0 & Serializable & scala.Serializable)() -> (String)DataSourceWriteOptions$.MODULE$.STREAMING_CHECKPOINT_IDENTIFIER().defaultValue());
                    newCommitMetadata.addMetadata(HoodieStreamingSink$.MODULE$.SINK_CHECKPOINT_KEY(), CommitUtils.getCheckpointValueAsString((String)identifier, (String)String.valueOf(this.batchId$1)));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.batchId$1 = batchId$1;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$accept$1()}, serializedLambda);
                }
            }))), this.writeClient(), HoodieSparkSqlWriter$.MODULE$.write$default$7()));
            if (try_ instanceof Success) {
                bl = true;
                success = (Success)try_;
                Tuple6 tuple62 = (Tuple6)success.value();
                if (tuple62 != null) {
                    boolean bl2 = BoxesRunTime.unboxToBoolean((Object)tuple62._1());
                    Option commitOps = (Option)tuple62._2();
                    Option compactionInstantOps = (Option)tuple62._3();
                    Option clusteringInstant = (Option)tuple62._4();
                    SparkRDDWriteClient client = (SparkRDDWriteClient)tuple62._5();
                    HoodieTableConfig tableConfig = (HoodieTableConfig)tuple62._6();
                    if (bl2) {
                        boolean bl3;
                        this.org$apache$hudi$HoodieStreamingSink$$log().info(new StringBuilder(25).append("Micro batch id=").append(batchId).append(" succeeded").append((Object)(true == (bl3 = commitOps.isPresent()) ? new StringBuilder(12).append(" for commit=").append(commitOps.get()).toString() : " with no new commits")).toString());
                        this.org$apache$hudi$HoodieStreamingSink$$log().info(new StringBuilder(86).append("Current value of latestCommittedBatchId: ").append(this.latestCommittedBatchId()).append(". Setting latestCommittedBatchId to batchId ").append(batchId).append(".").toString());
                        this.latestCommittedBatchId_$eq(batchId);
                        this.writeClient_$eq((scala.Option<SparkRDDWriteClient<?>>)new Some((Object)client));
                        this.hoodieTableConfig_$eq((scala.Option<HoodieTableConfig>)new Some((Object)tableConfig));
                        if (client != null) {
                            this.metaClient_$eq((scala.Option<HoodieTableMetaClient>)new Some((Object)HoodieTableMetaClient.builder().setConf(HadoopFSUtils.getStorageConfWithCopy((Configuration)$this.sqlContext.sparkContext().hadoopConfiguration())).setBasePath(client.getConfig().getBasePath()).build()));
                        }
                        if (compactionInstantOps.isPresent()) {
                            this.asyncCompactorService().enqueuePendingAsyncServiceInstant((String)compactionInstantOps.get());
                        }
                        if (clusteringInstant.isPresent()) {
                            this.asyncClusteringService().enqueuePendingAsyncServiceInstant((String)clusteringInstant.get());
                        }
                        return new Success((Object)new Tuple3((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)commitOps, (Object)compactionInstantOps));
                    }
                }
            }
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable e = failure.exception();
                data.sparkSession().sparkContext().getPersistentRDDs().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 != null) {
                        RDD rDD;
                        RDD rdd = (RDD)tuple2._2();
                        try {
                            rDD = rdd.unpersist(rdd.unpersist$default$1());
                        }
                        catch (Exception t) {
                            this.org$apache$hudi$HoodieStreamingSink$$log().warn("Got excepting trying to unpersist rdd", (Throwable)t);
                            rDD = BoxedUnit.UNIT;
                        }
                        return rDD;
                    }
                    throw new MatchError((Object)tuple2);
                });
                if (this.ignoreFailedBatch()) {
                    this.org$apache$hudi$HoodieStreamingSink$$log().info(new StringBuilder(64).append("Ignore the exception and move on streaming as per ").append(DataSourceWriteOptions$.MODULE$.STREAMING_IGNORE_FAILED_BATCH().key()).append(" configuration").toString());
                    return new Success((Object)new Tuple3((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)None$.MODULE$, (Object)None$.MODULE$));
                }
                this.org$apache$hudi$HoodieStreamingSink$$log().error(new StringBuilder(43).append("Micro batch id=").append(batchId).append(" threw following exception: ").toString(), e);
                if (this.retryCnt() > 1) {
                    this.org$apache$hudi$HoodieStreamingSink$$log().info(new StringBuilder(39).append("Retrying the failed micro batch id=").append(batchId).append(" ...").toString());
                }
                return new Failure(e);
            }
            if (bl && (tuple6 = (Tuple6)success.value()) != null) {
                boolean bl4 = BoxesRunTime.unboxToBoolean((Object)tuple6._1());
                Option commitOps = (Option)tuple6._2();
                if (!bl4) {
                    boolean bl5;
                    this.org$apache$hudi$HoodieStreamingSink$$log().error(new StringBuilder(36).append("Micro batch id=").append(batchId).append(" ended up with errors").append((Object)(true == (bl5 = commitOps.isPresent()) ? new StringBuilder(12).append(" for commit=").append(commitOps.get()).toString() : "")).toString());
                    if (this.ignoreFailedBatch()) {
                        this.org$apache$hudi$HoodieStreamingSink$$log().info(new StringBuilder(61).append("Ignore the errors and move on streaming as per ").append(DataSourceWriteOptions$.MODULE$.STREAMING_IGNORE_FAILED_BATCH().key()).append(" configuration").toString());
                        return new Success((Object)new Tuple3((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)None$.MODULE$, (Object)None$.MODULE$));
                    }
                    if (this.retryCnt() > 1) {
                        this.org$apache$hudi$HoodieStreamingSink$$log().warn(new StringBuilder(39).append("Retrying the failed micro batch id=").append(batchId).append(" ...").toString());
                    }
                    return new Failure((Throwable)new HoodieCorruptedDataException(new StringBuilder(36).append("Micro batch id=").append(batchId).append(" ended up with errors").toString()));
                }
            }
            throw new MatchError((Object)try_);
        })) instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            if (!this.ignoreFailedBatch()) {
                this.org$apache$hudi$HoodieStreamingSink$$log().error(new StringBuilder(86).append("Micro batch id=").append(batchId).append(" threw following expections,").append("aborting streaming app to avoid data loss: ").toString(), e);
                this.org$apache$hudi$HoodieStreamingSink$$reset(true);
                System.exit(1);
                return;
            }
            return;
        }
        if (try_ instanceof Success) {
            this.org$apache$hudi$HoodieStreamingSink$$log().info(new StringBuilder(25).append("Micro batch id=").append(batchId).append(" succeeded").toString());
            return;
        }
        throw new MatchError(try_);
    }

    public String toString() {
        return new StringBuilder(21).append("HoodieStreamingSink[").append(this.org$apache$hudi$HoodieStreamingSink$$options.apply((Object)"path")).append("]").toString();
    }

    private <T> Try<T> retry(int n, long waitInMillis, Function0<Try<T>> fn) {
        Try try_;
        while (true) {
            if ((try_ = (Try)fn.apply()) instanceof Success) {
                Success success = (Success)try_;
                return success;
            }
            if (n <= 1) break;
            Thread.sleep(waitInMillis);
            waitInMillis *= 2L;
            --n;
        }
        this.org$apache$hudi$HoodieStreamingSink$$reset(false);
        return try_;
    }

    public void triggerAsyncCompactor(SparkRDDWriteClient<?> client) {
        if (this.asyncCompactorService() == null) {
            this.org$apache$hudi$HoodieStreamingSink$$log().info("Triggering Async compaction !!");
            this.asyncCompactorService_$eq(new SparkStreamingAsyncCompactService((HoodieEngineContext)new HoodieSparkEngineContext(new JavaSparkContext(this.sqlContext.sparkContext())), (BaseHoodieWriteClient)client));
            this.asyncCompactorService().start((Function)new Function<Boolean, Boolean>(this){
                private final /* synthetic */ HoodieStreamingSink $outer;

                public <V> Function<V, Boolean> compose(Function<? super V, ? extends Boolean> x$1) {
                    return Function.super.compose(x$1);
                }

                public <V> Function<Boolean, V> andThen(Function<? super Boolean, ? extends V> x$1) {
                    return Function.super.andThen(x$1);
                }

                public Boolean apply(Boolean errored) {
                    this.$outer.org$apache$hudi$HoodieStreamingSink$$log().info(new StringBuilder(36).append("Async Compactor shutdown. Errored ? ").append(errored).toString());
                    this.$outer.org$apache$hudi$HoodieStreamingSink$$isAsyncCompactorServiceShutdownAbnormally_$eq(Predef$.MODULE$.Boolean2boolean(errored));
                    this.$outer.org$apache$hudi$HoodieStreamingSink$$reset(false);
                    this.$outer.org$apache$hudi$HoodieStreamingSink$$log().info("Done resetting write client.");
                    return Predef$.MODULE$.boolean2Boolean(true);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(this){
                private final /* synthetic */ HoodieStreamingSink $outer;

                public void run() {
                    this.$outer.org$apache$hudi$HoodieStreamingSink$$reset(true);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }));
            HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setConf(HadoopFSUtils.getStorageConfWithCopy((Configuration)this.sqlContext.sparkContext().hadoopConfiguration())).setBasePath(client.getConfig().getBasePath()).build();
            List pendingInstants = CompactionUtils.getPendingCompactionInstantTimes((HoodieTableMetaClient)metaClient);
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(pendingInstants).asScala()).foreach((Function1 & Serializable & scala.Serializable)h -> {
                HoodieStreamingSink.$anonfun$triggerAsyncCompactor$1(this, h);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public void triggerAsyncClustering(SparkRDDWriteClient<?> client) {
        if (this.asyncClusteringService() == null) {
            this.org$apache$hudi$HoodieStreamingSink$$log().info("Triggering async clustering!");
            this.asyncClusteringService_$eq(new SparkStreamingAsyncClusteringService((HoodieEngineContext)new HoodieSparkEngineContext(new JavaSparkContext(this.sqlContext.sparkContext())), (BaseHoodieWriteClient)client));
            this.asyncClusteringService().start((Function)new Function<Boolean, Boolean>(this){
                private final /* synthetic */ HoodieStreamingSink $outer;

                public <V> Function<V, Boolean> compose(Function<? super V, ? extends Boolean> x$1) {
                    return Function.super.compose(x$1);
                }

                public <V> Function<Boolean, V> andThen(Function<? super Boolean, ? extends V> x$1) {
                    return Function.super.andThen(x$1);
                }

                public Boolean apply(Boolean errored) {
                    this.$outer.org$apache$hudi$HoodieStreamingSink$$log().info(new StringBuilder(45).append("Async clustering service shutdown. Errored ? ").append(errored).toString());
                    this.$outer.org$apache$hudi$HoodieStreamingSink$$isAsyncClusteringServiceShutdownAbnormally_$eq(Predef$.MODULE$.Boolean2boolean(errored));
                    this.$outer.org$apache$hudi$HoodieStreamingSink$$reset(false);
                    return Predef$.MODULE$.boolean2Boolean(true);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(this){
                private final /* synthetic */ HoodieStreamingSink $outer;

                public void run() {
                    this.$outer.org$apache$hudi$HoodieStreamingSink$$reset(true);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }));
            HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setConf(HadoopFSUtils.getStorageConfWithCopy((Configuration)this.sqlContext.sparkContext().hadoopConfiguration())).setBasePath(client.getConfig().getBasePath()).build();
            List pendingInstants = ClusteringUtils.getPendingClusteringInstantTimes((HoodieTableMetaClient)metaClient);
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(pendingInstants).asScala()).foreach((Function1 & Serializable & scala.Serializable)h -> {
                HoodieStreamingSink.$anonfun$triggerAsyncClustering$1(this, h);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public synchronized void org$apache$hudi$HoodieStreamingSink$$reset(boolean force) {
        if (this.asyncCompactorService() != null) {
            this.asyncCompactorService().shutdown(force);
            this.asyncCompactorService_$eq(null);
        }
        if (this.asyncClusteringService() != null) {
            this.asyncClusteringService().shutdown(force);
            this.asyncClusteringService_$eq(null);
        }
        if (this.writeClient().isDefined()) {
            ((BaseHoodieWriteClient)this.writeClient().get()).close();
            this.writeClient_$eq(Option$.MODULE$.empty());
            return;
        }
    }

    private boolean canSkipBatch(long incomingBatchId, String operationType) {
        if (!DataSourceWriteOptions$.MODULE$.DELETE_OPERATION_OPT_VAL().equals(operationType)) {
            String identifier = (String)this.org$apache$hudi$HoodieStreamingSink$$options.getOrElse((Object)DataSourceWriteOptions$.MODULE$.STREAMING_CHECKPOINT_IDENTIFIER().key(), (Function0 & Serializable & scala.Serializable)() -> (String)DataSourceWriteOptions$.MODULE$.STREAMING_CHECKPOINT_IDENTIFIER().defaultValue());
            Option lastCheckpoint = CommitUtils.getValidCheckpointForCurrentWriter((HoodieTimeline)((HoodieTableMetaClient)this.metaClient().get()).getActiveTimeline().getWriteTimeline(), (String)HoodieStreamingSink$.MODULE$.SINK_CHECKPOINT_KEY(), (String)identifier);
            if (lastCheckpoint.isPresent()) {
                this.latestCommittedBatchId_$eq(new StringOps(Predef$.MODULE$.augmentString((String)lastCheckpoint.get())).toLong());
            }
            return this.latestCommittedBatchId() >= incomingBatchId;
        }
        return false;
    }

    private final /* synthetic */ scala.Option liftedTree1$1() {
        Some some;
        try {
            some = new Some((Object)HoodieTableMetaClient.builder().setConf(HadoopFSUtils.getStorageConfWithCopy((Configuration)this.sqlContext.sparkContext().hadoopConfiguration())).setBasePath((String)this.tablePath().get()).build());
        }
        catch (TableNotFoundException tableNotFoundException) {
            this.org$apache$hudi$HoodieStreamingSink$$log().info("Ignore TableNotFoundException as it is first microbatch.");
            some = Option$.MODULE$.empty();
        }
        return some;
    }

    public static final /* synthetic */ void $anonfun$triggerAsyncCompactor$1(HoodieStreamingSink $this, HoodieInstant h) {
        $this.asyncCompactorService().enqueuePendingAsyncServiceInstant(h.requestedTime());
    }

    public static final /* synthetic */ void $anonfun$triggerAsyncClustering$1(HoodieStreamingSink $this, HoodieInstant h) {
        $this.asyncClusteringService().enqueuePendingAsyncServiceInstant(h.requestedTime());
    }

    public HoodieStreamingSink(SQLContext sqlContext, Map<String, String> options, Seq<String> partitionColumns, OutputMode outputMode) {
        this.sqlContext = sqlContext;
        this.org$apache$hudi$HoodieStreamingSink$$options = options;
        Sink.$init$((Sink)this);
        this.latestCommittedBatchId = -1L;
        this.org$apache$hudi$HoodieStreamingSink$$log = LoggerFactory.getLogger(HoodieStreamingSink.class);
        this.tablePath = options.get((Object)"path");
        if (this.tablePath().isEmpty() || this.tablePath().get() == null) {
            throw new HoodieException("'path'  must be specified.");
        }
        this.metaClient = this.liftedTree1$1();
        this.retryCnt = new StringOps(Predef$.MODULE$.augmentString((String)options.getOrElse((Object)DataSourceWriteOptions$.MODULE$.STREAMING_RETRY_CNT().key(), (Function0 & Serializable & scala.Serializable)() -> (String)DataSourceWriteOptions$.MODULE$.STREAMING_RETRY_CNT().defaultValue()))).toInt();
        this.retryIntervalMs = new StringOps(Predef$.MODULE$.augmentString((String)options.getOrElse((Object)DataSourceWriteOptions$.MODULE$.STREAMING_RETRY_INTERVAL_MS().key(), (Function0 & Serializable & scala.Serializable)() -> (String)DataSourceWriteOptions$.MODULE$.STREAMING_RETRY_INTERVAL_MS().defaultValue()))).toLong();
        this.ignoreFailedBatch = new StringOps(Predef$.MODULE$.augmentString((String)options.getOrElse((Object)DataSourceWriteOptions$.MODULE$.STREAMING_IGNORE_FAILED_BATCH().key(), (Function0 & Serializable & scala.Serializable)() -> (String)DataSourceWriteOptions$.MODULE$.STREAMING_IGNORE_FAILED_BATCH().defaultValue()))).toBoolean();
        this.disableCompaction = new StringOps(Predef$.MODULE$.augmentString((String)options.getOrElse((Object)DataSourceWriteOptions$.MODULE$.STREAMING_DISABLE_COMPACTION().key(), (Function0 & Serializable & scala.Serializable)() -> (String)DataSourceWriteOptions$.MODULE$.STREAMING_DISABLE_COMPACTION().defaultValue()))).toBoolean();
        this.org$apache$hudi$HoodieStreamingSink$$isAsyncCompactorServiceShutdownAbnormally = false;
        this.org$apache$hudi$HoodieStreamingSink$$isAsyncClusteringServiceShutdownAbnormally = false;
        OutputMode outputMode2 = outputMode;
        OutputMode outputMode3 = OutputMode.Append();
        this.mode = !(outputMode2 != null ? !outputMode2.equals(outputMode3) : outputMode3 != null) ? SaveMode.Append : SaveMode.Overwrite;
        this.writeClient = Option$.MODULE$.empty();
        this.hoodieTableConfig = Option$.MODULE$.empty();
    }
}

