/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi;

import java.io.Serializable;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.SparkAdapterSupport;
import org.apache.hudi.common.config.HoodieStorageConfig;
import org.apache.hudi.common.model.BaseFile;
import org.apache.hudi.common.model.FileSlice;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.storage.StoragePathInfo;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.execution.datasources.PartitionDirectory;
import org.apache.spark.sql.hudi.SparkAdapter;
import scala.Function0;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;

public final class PartitionDirectoryConverter$
implements SparkAdapterSupport {
    public static PartitionDirectoryConverter$ MODULE$;
    private SparkAdapter sparkAdapter;
    private volatile boolean bitmap$0;

    static {
        new PartitionDirectoryConverter$();
    }

    private SparkAdapter sparkAdapter$lzycompute() {
        PartitionDirectoryConverter$ partitionDirectoryConverter$ = this;
        synchronized (partitionDirectoryConverter$) {
            if (!this.bitmap$0) {
                this.sparkAdapter = SparkAdapterSupport.sparkAdapter$((SparkAdapterSupport)this);
                this.bitmap$0 = true;
            }
        }
        return this.sparkAdapter;
    }

    public SparkAdapter sparkAdapter() {
        if (!this.bitmap$0) {
            return this.sparkAdapter$lzycompute();
        }
        return this.sparkAdapter;
    }

    public PartitionDirectory convertFileSliceToPartitionDirectory(InternalRow partitionValues, FileSlice fileSlice, Map<String, String> options) {
        double logFileEstimationFraction = new StringOps(Predef$.MODULE$.augmentString((String)options.getOrElse((Object)HoodieStorageConfig.LOGFILE_TO_PARQUET_COMPRESSION_RATIO_FRACTION.key(), (Function0 & Serializable & scala.Serializable)() -> (String)HoodieStorageConfig.LOGFILE_TO_PARQUET_COMPRESSION_RATIO_FRACTION.defaultValue()))).toDouble();
        long estimationFileSize = fileSlice.getTotalFileSizeAsParquetFormat(logFileEstimationFraction);
        StoragePathInfo fileInfo = fileSlice.getBaseFile().isPresent() ? ((BaseFile)fileSlice.getBaseFile().get()).getPathInfo() : ((HoodieLogFile)fileSlice.getLogFiles().findAny().get()).getPathInfo();
        FileStatus delegateFile = new FileStatus(estimationFileSize, fileInfo.isDirectory(), 0, fileInfo.getBlockSize(), fileInfo.getModificationTime(), new Path(fileInfo.getPath().toUri()));
        if (fileSlice.hasLogFiles() || fileSlice.hasBootstrapBase()) {
            return this.sparkAdapter().getSparkPartitionedFileUtils().newPartitionDirectory((InternalRow)this.sparkAdapter().createPartitionFileSliceMapping(partitionValues, (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)fileSlice.getFileId()), (Object)fileSlice)}))), (Seq)new .colon.colon((Object)delegateFile, (List)Nil$.MODULE$));
        }
        return this.sparkAdapter().getSparkPartitionedFileUtils().newPartitionDirectory(partitionValues, (Seq)new .colon.colon((Object)delegateFile, (List)Nil$.MODULE$));
    }

    private PartitionDirectoryConverter$() {
        MODULE$ = this;
        SparkAdapterSupport.$init$((SparkAdapterSupport)this);
    }
}

