/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi;

import java.io.Serializable;
import java.util.List;
import java.util.function.Consumer;
import org.apache.hudi.DataSourceReadOptions$;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.InstantFileNameGenerator;
import org.apache.hudi.common.table.timeline.TimelineUtils;
import org.apache.hudi.common.util.CommitUtils;
import org.apache.hudi.common.util.Option;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.sources.TableScan;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Buffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005%b\u0001B\b\u0011\u0001]A\u0001\"\n\u0001\u0003\u0006\u0004%\tA\n\u0005\tW\u0001\u0011\t\u0011)A\u0005O!AA\u0006\u0001BC\u0002\u0013\u0005Q\u0006\u0003\u0005?\u0001\t\u0005\t\u0015!\u0003/\u0011!y\u0004A!b\u0001\n\u0003\u0001\u0005\u0002C%\u0001\u0005\u0003\u0005\u000b\u0011B!\t\u000b)\u0003A\u0011A&\t\u000fE\u0003!\u0019!C\u0005%\"1\u0011\f\u0001Q\u0001\nMCQA\u0017\u0001\u0005BmCqA\u0019\u0001C\u0002\u0013%1\r\u0003\u0004i\u0001\u0001\u0006I\u0001\u001a\u0005\u0006S\u0002!\tE\u001b\u0005\u0006i\u0002!I!\u001e\u0002\u0011)&lW\r\\5oKJ+G.\u0019;j_:T!!\u0005\n\u0002\t!,H-\u001b\u0006\u0003'Q\ta!\u00199bG\",'\"A\u000b\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001A\"\u0005\u0005\u0002\u001aA5\t!D\u0003\u0002\u001c9\u000591o\\;sG\u0016\u001c(BA\u000f\u001f\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003?I\tQa\u001d9be.L!!\t\u000e\u0003\u0019\t\u000b7/\u001a*fY\u0006$\u0018n\u001c8\u0011\u0005e\u0019\u0013B\u0001\u0013\u001b\u0005%!\u0016M\u00197f'\u000e\fg.\u0001\u0006tc2\u001cuN\u001c;fqR,\u0012a\n\t\u0003Q%j\u0011\u0001H\u0005\u0003Uq\u0011!bU)M\u0007>tG/\u001a=u\u0003-\u0019\u0018\u000f\\\"p]R,\u0007\u0010\u001e\u0011\u0002\u0013=\u0004H\u000fU1sC6\u001cX#\u0001\u0018\u0011\t=B4h\u000f\b\u0003aY\u0002\"!\r\u001b\u000e\u0003IR!a\r\f\u0002\rq\u0012xn\u001c;?\u0015\u0005)\u0014!B:dC2\f\u0017BA\u001c5\u0003\u0019\u0001&/\u001a3fM&\u0011\u0011H\u000f\u0002\u0004\u001b\u0006\u0004(BA\u001c5!\tyC(\u0003\u0002>u\t11\u000b\u001e:j]\u001e\f!b\u001c9u!\u0006\u0014\u0018-\\:!\u0003)iW\r^1DY&,g\u000e^\u000b\u0002\u0003B\u0011!iR\u0007\u0002\u0007*\u0011A)R\u0001\u0006i\u0006\u0014G.\u001a\u0006\u0003\rB\taaY8n[>t\u0017B\u0001%D\u0005UAun\u001c3jKR\u000b'\r\\3NKR\f7\t\\5f]R\f1\"\\3uC\u000ec\u0017.\u001a8uA\u00051A(\u001b8jiz\"B\u0001\u0014(P!B\u0011Q\nA\u0007\u0002!!)Qe\u0002a\u0001O!)Af\u0002a\u0001]!)qh\u0002a\u0001\u0003\u0006\u0019An\\4\u0016\u0003M\u0003\"\u0001V,\u000e\u0003US!A\u0016\u000b\u0002\u000bMdg\r\u000e6\n\u0005a+&A\u0002'pO\u001e,'/\u0001\u0003m_\u001e\u0004\u0013AB:dQ\u0016l\u0017-F\u0001]!\ti\u0006-D\u0001_\u0015\tyF$A\u0003usB,7/\u0003\u0002b=\nQ1\u000b\u001e:vGR$\u0016\u0010]3\u0002/%t7\r\\;eK\u0006\u00138\r[5wK\u0012$\u0016.\\3mS:,W#\u00013\u0011\u0005\u00154W\"\u0001\u001b\n\u0005\u001d$$a\u0002\"p_2,\u0017M\\\u0001\u0019S:\u001cG.\u001e3f\u0003J\u001c\u0007.\u001b<fIRKW.\u001a7j]\u0016\u0004\u0013!\u00032vS2$7kY1o)\u0005Y\u0007c\u00017pc6\tQN\u0003\u0002o=\u0005\u0019!\u000f\u001a3\n\u0005Al'a\u0001*E\tB\u0011\u0001F]\u0005\u0003gr\u00111AU8x\u00039!xNS1wC\u000e{gn];nKJ,2A^A\u0004)\r9\u0018\u0011\u0004\t\u0005q~\f\u0019!D\u0001z\u0015\tQ80\u0001\u0005gk:\u001cG/[8o\u0015\taX0\u0001\u0003vi&d'\"\u0001@\u0002\t)\fg/Y\u0005\u0004\u0003\u0003I(\u0001C\"p]N,X.\u001a:\u0011\t\u0005\u0015\u0011q\u0001\u0007\u0001\t\u001d\tIA\u0004b\u0001\u0003\u0017\u0011\u0011\u0001V\t\u0005\u0003\u001b\t\u0019\u0002E\u0002f\u0003\u001fI1!!\u00055\u0005\u001dqu\u000e\u001e5j]\u001e\u00042!ZA\u000b\u0013\r\t9\u0002\u000e\u0002\u0004\u0003:L\bbBA\u000e\u001d\u0001\u0007\u0011QD\u0001\tG>t7/^7feB9Q-a\b\u0002\u0004\u0005\r\u0012bAA\u0011i\tIa)\u001e8di&|g.\r\t\u0004K\u0006\u0015\u0012bAA\u0014i\t!QK\\5u\u0001")
public class TimelineRelation
extends BaseRelation
implements TableScan {
    private final SQLContext sqlContext;
    private final Map<String, String> optParams;
    private final HoodieTableMetaClient metaClient;
    private final Logger log;
    private final boolean includeArchivedTimeline;

    public SQLContext sqlContext() {
        return this.sqlContext;
    }

    public Map<String, String> optParams() {
        return this.optParams;
    }

    public HoodieTableMetaClient metaClient() {
        return this.metaClient;
    }

    private Logger log() {
        return this.log;
    }

    public StructType schema() {
        return new StructType((StructField[])((Object[])new StructField[]{new StructField("Timestamp", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), new StructField("Action", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), new StructField("State", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), new StructField("Completion_Time", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), new StructField("File_Name", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), new StructField("Total_Bytes_Written", (DataType)LongType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), new StructField("Total_Files_Updated", (DataType)LongType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), new StructField("Total_Partitions_Written", (DataType)LongType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), new StructField("Total_Records_Written", (DataType)LongType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), new StructField("Total_Updated_Records_Written", (DataType)LongType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), new StructField("Total_Write_Errors", (DataType)LongType$.MODULE$, true, StructField$.MODULE$.apply$default$4())}));
    }

    private boolean includeArchivedTimeline() {
        return this.includeArchivedTimeline;
    }

    public RDD<Row> buildScan() {
        ArrayBuffer data = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        HoodieTimeline timeline = TimelineUtils.getTimeline((HoodieTableMetaClient)this.metaClient(), (boolean)this.includeArchivedTimeline());
        List instants = timeline.getInstants();
        instants.forEach(this.toJavaConsumer((Function1 & Serializable & scala.Serializable)instant -> {
            TimelineRelation.$anonfun$buildScan$1(this, timeline, data, instant);
            return BoxedUnit.UNIT;
        }));
        return this.sqlContext().createDataFrame((List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)data).asJava(), this.schema()).rdd();
    }

    private <T> Consumer<T> toJavaConsumer(Function1<T, BoxedUnit> consumer) {
        return new Consumer<T>(null, consumer){
            private final Function1 consumer$1;

            public Consumer<T> andThen(Consumer<? super T> x$1) {
                return Consumer.super.andThen(x$1);
            }

            public void accept(T t) {
                this.consumer$1.apply(t);
            }
            {
                this.consumer$1 = consumer$1;
            }
        };
    }

    public static final /* synthetic */ void $anonfun$buildScan$1(TimelineRelation $this, HoodieTimeline timeline$1, ArrayBuffer data$1, HoodieInstant instant) {
        if (timeline$1.getInstantDetails(instant).isPresent()) {
            long totalBytesWritten = -1L;
            long totalFilesUpdated = -1L;
            long totalPartitionsWritten = -1L;
            long totalRecordsWritten = -1L;
            long totalUpdatedRecordsWritten = -1L;
            long totalWriteErrors = -1L;
            InstantFileNameGenerator instantFileNameGenerator = $this.metaClient().getTimelineLayout().getInstantFileNameGenerator();
            Option commitMetadataOpt = CommitUtils.buildMetadataFromInstant((HoodieTimeline)timeline$1, (HoodieInstant)instant);
            if (commitMetadataOpt.isPresent()) {
                HoodieCommitMetadata commitMetadata = (HoodieCommitMetadata)commitMetadataOpt.get();
                totalBytesWritten = commitMetadata.fetchTotalBytesWritten();
                totalFilesUpdated = commitMetadata.fetchTotalFilesUpdated();
                totalPartitionsWritten = commitMetadata.fetchTotalPartitionsWritten();
                totalRecordsWritten = commitMetadata.fetchTotalRecordsWritten();
                totalUpdatedRecordsWritten = commitMetadata.fetchTotalUpdateRecordsWritten();
                totalWriteErrors = commitMetadata.fetchTotalWriteErrors();
            }
            Row r = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{instant.requestedTime(), instant.getAction(), instant.getState().toString(), instant.getCompletionTime(), instantFileNameGenerator.getFileName(instant), BoxesRunTime.boxToLong((long)totalBytesWritten), BoxesRunTime.boxToLong((long)totalFilesUpdated), BoxesRunTime.boxToLong((long)totalPartitionsWritten), BoxesRunTime.boxToLong((long)totalRecordsWritten), BoxesRunTime.boxToLong((long)totalUpdatedRecordsWritten), BoxesRunTime.boxToLong((long)totalWriteErrors)}));
            data$1.$plus$eq((Object)r);
            return;
        }
    }

    public TimelineRelation(SQLContext sqlContext, Map<String, String> optParams, HoodieTableMetaClient metaClient) {
        this.sqlContext = sqlContext;
        this.optParams = optParams;
        this.metaClient = metaClient;
        this.log = LoggerFactory.getLogger(TimelineRelation.class);
        this.includeArchivedTimeline = new StringOps(Predef$.MODULE$.augmentString((String)optParams.getOrElse((Object)DataSourceReadOptions$.MODULE$.TIMELINE_RELATION_ARG_ARCHIVED_TIMELINE().key(), (Function0 & Serializable & scala.Serializable)() -> "false"))).toBoolean();
    }
}

