/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.commit;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.hudi.DataSourceUtils;
import org.apache.hudi.DataSourceWriteOptions;
import org.apache.hudi.HoodieDatasetBulkInsertHelper;
import org.apache.hudi.client.HoodieWriteResult;
import org.apache.hudi.client.SparkRDDWriteClient;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.util.CommitUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.data.HoodieJavaRDD;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.execution.bulkinsert.BucketIndexBulkInsertPartitionerWithRows;
import org.apache.hudi.execution.bulkinsert.BulkInsertInternalPartitionerWithRowsFactory;
import org.apache.hudi.execution.bulkinsert.ConsistentBucketIndexBulkInsertPartitionerWithRows;
import org.apache.hudi.execution.bulkinsert.NonSortPartitionerWithRows;
import org.apache.hudi.index.HoodieIndex;
import org.apache.hudi.table.BulkInsertPartitioner;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.HoodieWriteMetadata;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;

public abstract class BaseDatasetBulkInsertCommitActionExecutor
implements Serializable {
    protected final transient HoodieWriteConfig writeConfig;
    protected final transient SparkRDDWriteClient writeClient;
    protected String instantTime;
    protected HoodieTable table;

    public BaseDatasetBulkInsertCommitActionExecutor(HoodieWriteConfig config, SparkRDDWriteClient writeClient, String instantTime) {
        this.writeConfig = config;
        this.writeClient = writeClient;
        this.instantTime = instantTime;
    }

    protected void preExecute() {
        this.table = this.writeClient.initTable(this.getWriteOperationType(), Option.ofNullable((Object)this.instantTime));
        this.table.validateInsertSchema();
        this.writeClient.preWrite(this.instantTime, this.getWriteOperationType(), this.table.getMetaClient());
    }

    protected Option<HoodieData<WriteStatus>> doExecute(Dataset<Row> records, boolean arePartitionRecordsSorted) {
        this.table.getActiveTimeline().transitionRequestedToInflight(this.table.getMetaClient().createNewInstant(HoodieInstant.State.REQUESTED, this.getCommitActionType(), this.instantTime), Option.empty());
        return Option.of((Object)HoodieDatasetBulkInsertHelper.bulkInsert(records, (String)this.instantTime, (HoodieTable)this.table, (HoodieWriteConfig)this.writeConfig, (boolean)arePartitionRecordsSorted, (boolean)false));
    }

    protected void afterExecute(HoodieWriteMetadata<JavaRDD<WriteStatus>> result) {
        this.writeClient.postWrite(result, this.instantTime, this.table);
    }

    private HoodieWriteMetadata<JavaRDD<WriteStatus>> buildHoodieWriteMetadata(Option<HoodieData<WriteStatus>> writeStatuses) {
        this.table.getMetaClient().reloadActiveTimeline();
        return (HoodieWriteMetadata)writeStatuses.map(statuses -> {
            statuses.persist(this.writeConfig.getString(HoodieWriteConfig.WRITE_STATUS_STORAGE_LEVEL_VALUE), this.writeClient.getEngineContext(), HoodieData.HoodieDataCacheKey.of((String)this.writeConfig.getBasePath(), (String)this.instantTime));
            HoodieWriteMetadata hoodieWriteMetadata = new HoodieWriteMetadata();
            hoodieWriteMetadata.setWriteStatuses((Object)HoodieJavaRDD.getJavaRDD((HoodieData)statuses));
            hoodieWriteMetadata.setPartitionToReplaceFileIds(this.getPartitionToReplacedFileIds((HoodieData<WriteStatus>)statuses));
            return hoodieWriteMetadata;
        }).orElseGet(HoodieWriteMetadata::new);
    }

    public final HoodieWriteResult execute(Dataset<Row> records, boolean isTablePartitioned) {
        if (this.writeConfig.getBoolean(DataSourceWriteOptions.INSERT_DROP_DUPS()).booleanValue()) {
            throw new HoodieException("Dropping duplicates with bulk_insert in row writer path is not supported yet");
        }
        boolean populateMetaFields = this.writeConfig.getBoolean(HoodieTableConfig.POPULATE_META_FIELDS);
        this.preExecute();
        BulkInsertPartitioner<Dataset<Row>> bulkInsertPartitionerRows = this.getPartitioner(populateMetaFields, isTablePartitioned);
        Dataset hoodieDF = HoodieDatasetBulkInsertHelper.prepareForBulkInsert(records, (HoodieWriteConfig)this.writeConfig, (HoodieTableConfig)this.table.getMetaClient().getTableConfig(), bulkInsertPartitionerRows, (String)this.instantTime);
        HoodieWriteMetadata<JavaRDD<WriteStatus>> result = this.buildHoodieWriteMetadata(this.doExecute((Dataset<Row>)hoodieDF, bulkInsertPartitionerRows.arePartitionRecordsSorted()));
        this.afterExecute(result);
        return new HoodieWriteResult((JavaRDD)result.getWriteStatuses(), result.getPartitionToReplaceFileIds());
    }

    public abstract WriteOperationType getWriteOperationType();

    public String getCommitActionType() {
        return CommitUtils.getCommitActionType((WriteOperationType)this.getWriteOperationType(), (HoodieTableType)this.writeClient.getConfig().getTableType());
    }

    protected BulkInsertPartitioner<Dataset<Row>> getPartitioner(boolean populateMetaFields, boolean isTablePartitioned) {
        if (populateMetaFields) {
            if (this.writeConfig.getIndexType() == HoodieIndex.IndexType.BUCKET) {
                if (this.writeConfig.getBucketIndexEngineType() == HoodieIndex.BucketIndexEngineType.SIMPLE) {
                    return new BucketIndexBulkInsertPartitionerWithRows(this.writeConfig.getBucketIndexHashFieldWithDefault(), this.table.getConfig());
                }
                return new ConsistentBucketIndexBulkInsertPartitionerWithRows(this.table, Collections.emptyMap(), true);
            }
            return (BulkInsertPartitioner)DataSourceUtils.createUserDefinedBulkInsertPartitionerWithRows(this.writeConfig).orElseGet(() -> BulkInsertInternalPartitionerWithRowsFactory.get((HoodieWriteConfig)this.writeConfig, (boolean)isTablePartitioned));
        }
        return new NonSortPartitionerWithRows();
    }

    protected abstract Map<String, List<String>> getPartitionToReplacedFileIds(HoodieData<WriteStatus> var1);

    public String getInstantTime() {
        return this.instantTime;
    }
}

