/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.commit;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.hudi.client.SparkRDDWriteClient;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.commit.DatasetBulkInsertOverwriteCommitActionExecutor;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.data.HoodiePairData;
import org.apache.hudi.common.function.SerializableFunction;
import org.apache.hudi.common.function.SerializablePairFunction;
import org.apache.hudi.common.model.PartitionBucketIndexHashingConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.data.HoodieJavaPairRDD;
import org.apache.hudi.execution.bulkinsert.BucketIndexBulkInsertPartitionerWithRows;
import org.apache.hudi.table.BulkInsertPartitioner;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatasetBucketRescaleCommitActionExecutor
extends DatasetBulkInsertOverwriteCommitActionExecutor {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(DatasetBucketRescaleCommitActionExecutor.class);
    private final String expression;
    private final String rule;
    private final int bucketNumber;

    public DatasetBucketRescaleCommitActionExecutor(HoodieWriteConfig config, SparkRDDWriteClient writeClient, String instantTime) {
        super(config, writeClient, instantTime);
        this.expression = config.getBucketIndexPartitionExpression();
        this.rule = config.getBucketIndexPartitionRuleType();
        this.bucketNumber = config.getBucketIndexNumBuckets();
    }

    @Override
    protected BulkInsertPartitioner<Dataset<Row>> getPartitioner(boolean populateMetaFields, boolean isTablePartitioned) {
        return new BucketIndexBulkInsertPartitionerWithRows(this.writeClient.getConfig(), this.expression, this.rule, this.bucketNumber);
    }

    @Override
    protected void preExecute() {
        super.preExecute();
        PartitionBucketIndexHashingConfig hashingConfig = new PartitionBucketIndexHashingConfig(this.expression, this.bucketNumber, this.rule, PartitionBucketIndexHashingConfig.CURRENT_VERSION.intValue(), this.instantTime);
        boolean res = PartitionBucketIndexHashingConfig.saveHashingConfig((PartitionBucketIndexHashingConfig)hashingConfig, (HoodieTableMetaClient)this.table.getMetaClient());
        ValidationUtils.checkArgument((boolean)res);
        LOG.info("Finish to save hashing config {}", (Object)hashingConfig);
    }

    @Override
    protected Map<String, List<String>> getPartitionToReplacedFileIds(HoodieData<WriteStatus> writeStatuses) {
        return HoodieJavaPairRDD.getJavaPairRDD((HoodiePairData)writeStatuses.map((SerializableFunction & Serializable)status -> status.getStat().getPartitionPath()).distinct().mapToPair((SerializablePairFunction & Serializable)partitionPath -> Pair.of((Object)partitionPath, this.getAllExistingFileIds((String)partitionPath)))).collectAsMap();
    }
}

