/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.commit;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hudi.HoodieDatasetBulkInsertHelper;
import org.apache.hudi.client.SparkRDDWriteClient;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.commit.BaseDatasetBulkInsertCommitActionExecutor;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.data.HoodiePairData;
import org.apache.hudi.common.function.SerializableFunction;
import org.apache.hudi.common.function.SerializablePairFunction;
import org.apache.hudi.common.model.FileSlice;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieInternalConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.data.HoodieJavaPairRDD;
import org.apache.hudi.table.HoodieTable;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;

public class DatasetBulkInsertOverwriteCommitActionExecutor
extends BaseDatasetBulkInsertCommitActionExecutor {
    public DatasetBulkInsertOverwriteCommitActionExecutor(HoodieWriteConfig config, SparkRDDWriteClient writeClient, String instantTime) {
        super(config, writeClient, instantTime);
    }

    @Override
    protected Option<HoodieData<WriteStatus>> doExecute(Dataset<Row> records, boolean arePartitionRecordsSorted) {
        this.table.getActiveTimeline().transitionRequestedToInflight(this.table.getMetaClient().createNewInstant(HoodieInstant.State.REQUESTED, this.getCommitActionType(), this.instantTime), Option.empty());
        return Option.of((Object)HoodieDatasetBulkInsertHelper.bulkInsert(records, (String)this.instantTime, (HoodieTable)this.table, (HoodieWriteConfig)this.writeConfig, (boolean)arePartitionRecordsSorted, (boolean)false));
    }

    @Override
    public WriteOperationType getWriteOperationType() {
        return WriteOperationType.INSERT_OVERWRITE;
    }

    @Override
    protected Map<String, List<String>> getPartitionToReplacedFileIds(HoodieData<WriteStatus> writeStatuses) {
        String staticOverwritePartition = this.writeConfig.getStringOrDefault(HoodieInternalConfig.STATIC_OVERWRITE_PARTITION_PATHS);
        if (StringUtils.nonEmpty((String)staticOverwritePartition)) {
            List<String> partitionPaths = Arrays.asList(staticOverwritePartition.split(","));
            this.table.getContext().setJobStatus(this.getClass().getSimpleName(), "Getting ExistingFileIds of matching static partitions");
            return HoodieJavaPairRDD.getJavaPairRDD((HoodiePairData)this.table.getContext().parallelize(partitionPaths, partitionPaths.size()).mapToPair((SerializablePairFunction & Serializable)partitionPath -> Pair.of((Object)partitionPath, this.getAllExistingFileIds((String)partitionPath)))).collectAsMap();
        }
        return HoodieJavaPairRDD.getJavaPairRDD((HoodiePairData)writeStatuses.map((SerializableFunction & Serializable)status -> status.getStat().getPartitionPath()).distinct().mapToPair((SerializablePairFunction & Serializable)partitionPath -> Pair.of((Object)partitionPath, this.getAllExistingFileIds((String)partitionPath)))).collectAsMap();
    }

    protected List<String> getAllExistingFileIds(String partitionPath) {
        return this.table.getSliceView().getLatestFileSlices(partitionPath).map(FileSlice::getFileId).distinct().collect(Collectors.toList());
    }
}

