/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.spark.internal;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hudi.DataSourceUtils;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.internal.DataSourceInternalWriterHelper;
import org.apache.hudi.spark.internal.HoodieBulkInsertDataInternalWriterFactory;
import org.apache.hudi.spark.internal.HoodieWriterCommitMessage;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.connector.write.BatchWrite;
import org.apache.spark.sql.connector.write.DataWriterFactory;
import org.apache.spark.sql.connector.write.PhysicalWriteInfo;
import org.apache.spark.sql.connector.write.WriterCommitMessage;
import org.apache.spark.sql.types.StructType;

public class HoodieDataSourceInternalBatchWrite
implements BatchWrite {
    private final HoodieWriteConfig writeConfig;
    private final StructType structType;
    private final boolean arePartitionRecordsSorted;
    private final boolean populateMetaFields;
    private final DataSourceInternalWriterHelper dataSourceInternalWriterHelper;
    private Map<String, String> extraMetadata = new HashMap<String, String>();

    public HoodieDataSourceInternalBatchWrite(String instantTime, HoodieWriteConfig writeConfig, StructType structType, SparkSession jss, StorageConfiguration<?> storageConf, Map<String, String> properties, boolean populateMetaFields, boolean arePartitionRecordsSorted) {
        this.writeConfig = writeConfig;
        this.structType = structType;
        this.populateMetaFields = populateMetaFields;
        this.arePartitionRecordsSorted = arePartitionRecordsSorted;
        this.extraMetadata = DataSourceUtils.getExtraMetadata(properties);
        this.dataSourceInternalWriterHelper = new DataSourceInternalWriterHelper(instantTime, writeConfig, structType, jss, storageConf, this.extraMetadata);
    }

    public DataWriterFactory createBatchWriterFactory(PhysicalWriteInfo info) {
        String instantTime = this.dataSourceInternalWriterHelper.createInflightCommit();
        if (WriteOperationType.BULK_INSERT == this.dataSourceInternalWriterHelper.getWriteOperationType()) {
            return new HoodieBulkInsertDataInternalWriterFactory(this.dataSourceInternalWriterHelper.getHoodieTable(), this.writeConfig, instantTime, this.structType, this.populateMetaFields, this.arePartitionRecordsSorted);
        }
        throw new IllegalArgumentException("Write Operation Type + " + this.dataSourceInternalWriterHelper.getWriteOperationType() + " not supported ");
    }

    public boolean useCommitCoordinator() {
        return this.dataSourceInternalWriterHelper.useCommitCoordinator();
    }

    public void onDataWriterCommit(WriterCommitMessage message) {
        this.dataSourceInternalWriterHelper.onDataWriterCommit(message.toString());
    }

    public void commit(WriterCommitMessage[] messages) {
        List<WriteStatus> writeStatuses = Arrays.stream(messages).map(m -> (HoodieWriterCommitMessage)m).flatMap(m -> m.getWriteStatuses().stream()).collect(Collectors.toList());
        this.dataSourceInternalWriterHelper.commit(writeStatuses);
    }

    public void abort(WriterCommitMessage[] messages) {
        this.dataSourceInternalWriterHelper.abort();
    }
}

